/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.text.DateFormat;
import java.util.Map;
import java.util.TimeZone;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class JacksonUtils {
    public static final ObjectMapper objectMapper = new ObjectMapper().setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL).setSerializationInclusion(JsonInclude.Include.ALWAYS).configure(SerializationFeature.INDENT_OUTPUT, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setTimeZone(TimeZone.getDefault());
    private static final Log LOG = LogFactory.getLog(JacksonUtils.class);

    public static <T> T fromJson(String content, TypeReference<T> typeReference) {
        return JacksonUtils.fromJson(content, typeReference, null);
    }

    public static <T> T fromJson(String content, TypeReference<T> typeReference, DateFormat format) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        objectMapper.setDateFormat(format);
        try {
            return (T)objectMapper.readValue(content, typeReference);
        }
        catch (Exception e) {
            LOG.error("Parse json string error : " + content, (Throwable)e);
            return null;
        }
    }

    public static <T> T fromJson(String content, Class<T> clazz) {
        return JacksonUtils.fromJson(content, clazz, null);
    }

    public static <T> T fromJson(String content, Class<T> clazz, DateFormat format) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        objectMapper.setDateFormat(format);
        try {
            return (T)objectMapper.readValue(content, clazz);
        }
        catch (Exception e) {
            LOG.warn("Parse json string: " + content + " to object: " + clazz, (Throwable)e);
            throw new KDBizException("Json parse error:" + e.getMessage());
        }
    }

    public static String toJson(Object object) {
        return JacksonUtils.toJson(object, null);
    }

    public static String toJson(Object object, DateFormat format) {
        objectMapper.setDateFormat(format);
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            LOG.warn("Write to json string error : " + object, (Throwable)e);
            return null;
        }
    }

    public static Map<String, Object> toMap(Object object) {
        return JacksonUtils.toMap(object, null);
    }

    public static Map<String, Object> toMap(Object object, DateFormat format) {
        objectMapper.setDateFormat(format);
        try {
            String content = objectMapper.writeValueAsString(object);
            return (Map)objectMapper.readValue(content, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            LOG.warn("Write to map error : " + object, (Throwable)e);
            return null;
        }
    }

    public static String toJsonString(String rawJsonString, boolean isPretty) {
        if (StringUtils.isEmpty((CharSequence)rawJsonString)) {
            return "";
        }
        try {
            Object obj = JacksonUtils.fromJson(rawJsonString, Object.class);
            if (isPretty) {
                return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
            }
            return objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            LOG.warn("Failed to convert raw json string: " + rawJsonString);
            return rawJsonString;
        }
    }
}

