/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.log.oplog;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.form.IFormView;
import kd.bos.log.api.AppLogInfo;
import kd.epm.far.common.common.enums.MultiLangEnumBridge;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperateLogUtil;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;

public class AnalysisOpLogHelper {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(AnalysisOpLogHelper.class);
    private static final Map<OperationCategory, DescriptionBuilder> discriptionBuildMap = new HashMap<OperationCategory, DescriptionBuilder>();

    public static void writeOpLog(OperationCategory category, OperationName opName, OperationResult result, String formId, IFormView view, Object ... params) {
        AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(category).buildOpName(opName).buildFormNumber(formId).buildAppId(view).buildFormatParams(params).appendFormatParams(params).buildOpResult(result);
        if (AnalysisOpLogHelper.checkInvalidLogParam(logParam)) {
            return;
        }
        DescriptionBuilder descriptionBuilder = discriptionBuildMap.get((Object)logParam.getSubject());
        MultiLangEnumBridge bridge = descriptionBuilder.buildDescription(opName, logParam.getResult());
        OperateLogUtil.addLog(opName, bridge, logParam.getAppId(), logParam.getEntityNumber(), logParam.getFormatParams());
    }

    public static void writeOperationLog(AnalysisOpLogParam params) {
        if (AnalysisOpLogHelper.checkInvalidLogParam(params)) {
            return;
        }
        OperationName opName = params.getOpName();
        DescriptionBuilder descriptionBuilder = discriptionBuildMap.get((Object)params.getSubject());
        MultiLangEnumBridge bridge = descriptionBuilder.buildDescription(opName, params.getResult());
        OperateLogUtil.addLog(opName, bridge, params.getAppId(), params.getEntityNumber(), params.getFormatParams());
    }

    public static void batchWriteOperationLog(AnalysisOpLogParam params) {
        if (AnalysisOpLogHelper.checkInvalidLogParam(params)) {
            return;
        }
        List<Object[]> formatParamsList = params.getFormatParamsList();
        if (formatParamsList.isEmpty()) {
            return;
        }
        try {
            OperationName opName = params.getOpName();
            DescriptionBuilder descriptionBuilder = discriptionBuildMap.get((Object)params.getSubject());
            ArrayList appLogInfoList = Lists.newArrayListWithCapacity((int)formatParamsList.size());
            for (Object[] formatParams : formatParamsList) {
                MultiLangEnumBridge bridge = descriptionBuilder.buildDescription(opName, params.getResult());
                AppLogInfo log = OperateLogUtil.buildLogInfo(opName, bridge, params.getAppId(), params.getEntityNumber(), formatParams);
                appLogInfoList.add(log);
            }
            OperateLogUtil.addBatchLog(appLogInfoList);
        }
        catch (Exception ex) {
            logger.error("dm wirtelog error", ex);
        }
    }

    private static boolean checkInvalidLogParam(AnalysisOpLogParam params) {
        if (Objects.isNull((Object)params.getSubject())) {
            return true;
        }
        if (OperationCategory.UNDEFINED == params.getSubject()) {
            return true;
        }
        if (Objects.isNull((Object)params.getOpName())) {
            return true;
        }
        return OperationName.UNSUPPORTED == params.getOpName();
    }

    private static MultiLangEnumBridge permDescriptionBuilder(OperationName opName, OperationResult status) {
        switch (opName) {
            case DELETE_PERM: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("\u6e05\u9664\u6210\u529f", "AnalysisOperationLogHelperEx_284", "epm-far-common");
                }
                return new MultiLangEnumBridge("\u6e05\u9664\u5931\u8d25", "AnalysisOperationLogHelperEx_285", "epm-far-common");
            }
            case DELETE_PERM_CACHE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("\u6e05\u9664\u6743\u9650\u7f13\u5b58\u6210\u529f", "AnalysisOperationLogHelperEx_286", "epm-far-common");
                }
                return new MultiLangEnumBridge("\u6e05\u9664\u6743\u9650\u7f13\u5b58\u5931\u8d25", "AnalysisOperationLogHelperEx_287", "epm-far-common");
            }
        }
        return null;
    }

    private static MultiLangEnumBridge roleDescriptionBuilder(OperationName opName, OperationResult status) {
        switch (opName) {
            case CLICK_IMPORT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("\u70b9\u51fb\u6210\u529f", "AnalysisOperationLogHelperEx_268", "epm-far-common");
                }
                return new MultiLangEnumBridge("\u70b9\u51fb\u5931\u8d25", "AnalysisOperationLogHelperEx_269", "epm-far-common");
            }
            case EXPORT_DATA: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%s\u5f15\u51fa\u6570\u636e\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_270", "epm-far-common");
                }
                return new MultiLangEnumBridge("%s\u5f15\u51fa\u6570\u636e\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_271", "epm-far-common");
            }
            case DISABLE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%s\u7981\u7528\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_272", "epm-far-common");
                }
                return new MultiLangEnumBridge("%s\u7981\u7528\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_273", "epm-far-common");
            }
            case ENABLE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%s\u542f\u7528\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_274", "epm-far-common");
                }
                return new MultiLangEnumBridge("%s\u542f\u7528\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_275", "epm-far-common");
            }
            case DELETE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%s\u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_276", "epm-far-common");
                }
                return new MultiLangEnumBridge("%s\u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_277", "epm-far-common");
            }
            case COPY: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%s\u590d\u5236\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_278", "epm-far-common");
                }
                return new MultiLangEnumBridge("%s\u590d\u5236\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_279", "epm-far-common");
            }
            case LOOK: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%s\u67e5\u770b\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_280", "epm-far-common");
                }
                return new MultiLangEnumBridge("%s\u67e5\u770b\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_281", "epm-far-common");
            }
        }
        return null;
    }

    private static MultiLangEnumBridge modelDescriptionBuilder(OperationName opName, OperationResult status) {
        switch (opName) {
            case CREATE_MODEL: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u65b0\u589e\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_1", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u65b0\u589e\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_2", "epm-far-common");
            }
            case DELETE_MODEL: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_3", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_4", "epm-far-common");
            }
            case ENABLE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u542f\u7528\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_7", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u542f\u7528\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_8", "epm-far-common");
            }
            case DISABLE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7981\u7528\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_9", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7981\u7528\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_10", "epm-far-common");
            }
            case OPER: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("\u201c%1$s\u201d\u7684\u53c2\u6570\u503c\u4fee\u6539\u4e3a\u201c%2$s\u201d,\u4fee\u6539\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_266", "epm-far-common");
                }
                return new MultiLangEnumBridge("\u201c%1$s\u201d\u7684\u53c2\u6570\u503c\u4fee\u6539\u4e3a\u201c%2$s\u201d,\u4fee\u6539\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_267", "epm-far-common");
            }
        }
        return null;
    }

    private static MultiLangEnumBridge globalVarDescriptionBuilder(OperationName opName, OperationResult status) {
        switch (opName) {
            case CREATE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5168\u5c40\u53d8\u91cf%2$s \u65b0\u589e\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_11", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5168\u5c40\u53d8\u91cf%2$s \u65b0\u589e\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_12", "epm-far-common");
            }
            case COPY: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5168\u5c40\u53d8\u91cf%2$s \u590d\u5236\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_13", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5168\u5c40\u53d8\u91cf%2$s \u590d\u5236\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_14", "epm-far-common");
            }
            case MODIFY: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5168\u5c40\u53d8\u91cf%2$s \u4fee\u6539\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_15", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5168\u5c40\u53d8\u91cf%2$s \u4fee\u6539\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_16", "epm-far-common");
            }
            case DELETE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5168\u5c40\u53d8\u91cf%2$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_17", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5168\u5c40\u53d8\u91cf%2$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_18", "epm-far-common");
            }
            case EXPORT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5168\u5c40\u53d8\u91cf\u5217\u8868\u5bfc\u51fa\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_228", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5168\u5c40\u53d8\u91cf\u5217\u8868\u5bfc\u51fa\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_230", "epm-far-common");
            }
        }
        return null;
    }

    private static MultiLangEnumBridge datasetDescriptionBuilder(OperationName opName, OperationResult status) {
        switch (opName) {
            case CREATE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u96c6%2$s \u65b0\u589e\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_19", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u96c6%2$s \u65b0\u589e\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_20", "epm-far-common");
            }
            case COPY: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u96c6%2$s \u590d\u5236\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_21", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u96c6%2$s \u590d\u5236\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_22", "epm-far-common");
            }
            case MODIFY: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u96c6%2$s \u4fee\u6539\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_23", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u96c6%2$s \u4fee\u6539\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_24", "epm-far-common");
            }
            case DELETE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u96c6%2$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_25", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u96c6%2$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_26", "epm-far-common");
            }
            case ENABLE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u96c6%2$s \u542f\u7528\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_27", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u96c6%2$s \u542f\u7528\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_28", "epm-far-common");
            }
            case DISABLE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u96c6%2$s \u7981\u7528\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_29", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u96c6%2$s \u7981\u7528\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_30", "epm-far-common");
            }
            case EXPORT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u96c6\u5217\u8868\u5bfc\u51fa\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_235", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u96c6\u5217\u8868\u5bfc\u51fa\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_236", "epm-far-common");
            }
        }
        return null;
    }

    private static MultiLangEnumBridge analysisDesignDescriptionBuilder(OperationName opName, OperationResult status) {
        switch (opName) {
            case CREATE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f%2$s \u65b0\u589e\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_31", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f%2$s \u65b0\u589e\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_32", "epm-far-common");
            }
            case COPY: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f%2$s \u590d\u5236\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_33", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f%2$s \u590d\u5236\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_34", "epm-far-common");
            }
            case EDIT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f%2$s \u7f16\u8f91\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_35", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f%2$s \u7f16\u8f91\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_36", "epm-far-common");
            }
            case DELETE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f%2$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_37", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f%2$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_38", "epm-far-common");
            }
            case ENABLE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f%2$s \u542f\u7528\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_39", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f%2$s \u542f\u7528\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_40", "epm-far-common");
            }
            case DISABLE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f%2$s \u7981\u7528\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_41", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f%2$s \u7981\u7528\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_42", "epm-far-common");
            }
            case EDIT_BASEINFO: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f%2$s \u57fa\u672c\u4fe1\u606f\u7f16\u8f91\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_43", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f%2$s \u57fa\u672c\u4fe1\u606f\u7f16\u8f91\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_44", "epm-far-common");
            }
            case PUBLISH_MYANALYSIS: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f%2$s \u53d1\u5e03\u6211\u7684\u5206\u6790%3$s\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_45", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f%2$s \u53d1\u5e03\u6211\u7684\u5206\u6790%3$s\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_46", "epm-far-common");
            }
            case PUBLISH_THEMEANALYSIS: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f%2$s \u53d1\u5e03\u4e3b\u9898\u5206\u6790%3$s\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_47", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f%2$s \u53d1\u5e03\u4e3b\u9898\u5206\u6790%3$s\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_48", "epm-far-common");
            }
            case CATALOG_CREATE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f\u5206\u7c7b%2$s \u65b0\u589e\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_49", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f\u5206\u7c7b%2$s \u65b0\u589e\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_50", "epm-far-common");
            }
            case CATALOG_EDIT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f\u5206\u7c7b%2$s \u7f16\u8f91\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_51", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f\u5206\u7c7b%2$s \u7f16\u8f91\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_52", "epm-far-common");
            }
            case CATALOG_DELETE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f\u5206\u7c7b%2$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_53", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f\u5206\u7c7b%2$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_54", "epm-far-common");
            }
            case CATALOG_MOVE_UP: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f\u5206\u7c7b%2$s \u5206\u7c7b\u4e0a\u79fb\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_55", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f\u5206\u7c7b%2$s \u5206\u7c7b\u4e0a\u79fb\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_56", "epm-far-common");
            }
            case CATALOG_MOVE_DOWN: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f\u5206\u7c7b%2$s \u5206\u7c7b\u4e0b\u79fb\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_57", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u5206\u6790\u8bbe\u8ba1\u770b\u677f\u5206\u7c7b%2$s \u5206\u7c7b\u4e0b\u79fb\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_58", "epm-far-common");
            }
        }
        return null;
    }

    private static MultiLangEnumBridge myAnalysisDescriptionBuilder(OperationName opName, OperationResult status) {
        switch (opName) {
            case CATALOG_CREATE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u5206\u6790\u5206\u7c7b%2$s \u65b0\u589e\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_59", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u5206\u6790\u5206\u7c7b%2$s \u65b0\u589e\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_60", "epm-far-common");
            }
            case CATALOG_EDIT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u5206\u6790\u5206\u7c7b%2$s \u7f16\u8f91\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_61", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u5206\u6790\u5206\u7c7b%2$s \u7f16\u8f91\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_62", "epm-far-common");
            }
            case CATALOG_DELETE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u5206\u6790\u5206\u7c7b%2$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_63", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u5206\u6790\u5206\u7c7b%2$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_64", "epm-far-common");
            }
            case CATALOG_MOVE_UP: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u5206\u6790\u5206\u7c7b%2$s \u5206\u7c7b\u4e0a\u79fb\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_65", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u5206\u6790\u5206\u7c7b%2$s \u5206\u7c7b\u4e0a\u79fb\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_66", "epm-far-common");
            }
            case CATALOG_MOVE_DOWN: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u5206\u6790\u5206\u7c7b%2$s \u5206\u7c7b\u4e0b\u79fb\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_67", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u5206\u6790\u5206\u7c7b%2$s \u5206\u7c7b\u4e0b\u79fb\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_68", "epm-far-common");
            }
            case EDIT_BASEINFO: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u5206\u6790%2$s \u57fa\u672c\u4fe1\u606f\u7f16\u8f91\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_69", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u5206\u6790%2$s \u57fa\u672c\u4fe1\u606f\u7f16\u8f91\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_70", "epm-far-common");
            }
            case DELETE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u5206\u6790%2$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_71", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u5206\u6790%2$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_72", "epm-far-common");
            }
        }
        return null;
    }

    private static MultiLangEnumBridge theAnalysisDescriptionBuilder(OperationName opName, OperationResult status) {
        switch (opName) {
            case CREATE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u4e3b\u9898\u5206\u6790%2$s \u65b0\u589e\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_73", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u4e3b\u9898\u5206\u6790%2$s \u65b0\u589e\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_74", "epm-far-common");
            }
            case COPY: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u4e3b\u9898\u5206\u6790\u770b\u677f%2$s \u590d\u5236\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_75", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u4e3b\u9898\u5206\u6790\u770b\u677f%2$s \u590d\u5236\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_76", "epm-far-common");
            }
            case EDIT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u4e3b\u9898\u5206\u6790\u770b\u677f%2$s \u7f16\u8f91\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_77", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u4e3b\u9898\u5206\u6790\u770b\u677f%2$s \u7f16\u8f91\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_78", "epm-far-common");
            }
            case DELETE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u4e3b\u9898\u5206\u6790\u770b\u677f%2$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_79", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u4e3b\u9898\u5206\u6790\u770b\u677f%2$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_80", "epm-far-common");
            }
            case EDIT_BASEINFO: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u4e3b\u9898\u5206\u6790%2$s \u57fa\u672c\u4fe1\u606f\u7f16\u8f91\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_81", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u4e3b\u9898\u5206\u6790%2$s \u57fa\u672c\u4fe1\u606f\u7f16\u8f91\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_82", "epm-far-common");
            }
        }
        return null;
    }

    private static MultiLangEnumBridge componentGalleryDescriptionBuilder(OperationName opName, OperationResult status) {
        switch (opName) {
            case DELETE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93\u7ec4\u4ef6%2$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_83", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93\u7ec4\u4ef6%2$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_84", "epm-far-common");
            }
            case ENABLE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93\u7ec4\u4ef6%2$s \u542f\u7528\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_85", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93\u7ec4\u4ef6%2$s \u542f\u7528\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_86", "epm-far-common");
            }
            case DISABLE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93\u7ec4\u4ef6%2$s \u7981\u7528\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_87", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93\u7ec4\u4ef6%2$s \u7981\u7528\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_88", "epm-far-common");
            }
            case CATALOG_CREATE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93\u5206\u7c7b%2$s \u65b0\u589e\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_89", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93\u5206\u7c7b%2$s \u65b0\u589e\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_90", "epm-far-common");
            }
            case CATALOG_EDIT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93\u5206\u7c7b%2$s \u7f16\u8f91\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_91", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93\u5206\u7c7b%2$s \u7f16\u8f91\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_92", "epm-far-common");
            }
            case CATALOG_DELETE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93\u5206\u7c7b%2$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_93", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93\u5206\u7c7b%2$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_94", "epm-far-common");
            }
            case CATALOG_MOVE_UP: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93\u5206\u7c7b%2$s \u5206\u7c7b\u4e0a\u79fb\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_95", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93\u5206\u7c7b%2$s \u5206\u7c7b\u4e0a\u79fb\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_96", "epm-far-common");
            }
            case CATALOG_MOVE_DOWN: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93\u5206\u7c7b%2$s \u5206\u7c7b\u4e0b\u79fb\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_97", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93\u5206\u7c7b%2$s \u5206\u7c7b\u4e0b\u79fb\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_98", "epm-far-common");
            }
            case CREATE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93%2$s \u65b0\u589e\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_131", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93%2$s \u65b0\u589e\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_132", "epm-far-common");
            }
            case EDIT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93%2$s \u7f16\u8f91\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_133", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6\u5e93%2$s \u7f16\u8f91\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_134", "epm-far-common");
            }
            case SAVE_AS: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6%2$s \u53e6\u5b58\u4e3a\u7ec4\u4ef6\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_245", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ec4\u4ef6%2$s \u53e6\u5b58\u4e3a\u7ec4\u4ef6\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_246", "epm-far-common");
            }
        }
        return null;
    }

    private static MultiLangEnumBridge dimensionDescriptionBuilder(OperationName opName, OperationResult status) {
        switch (opName) {
            case EXPORT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ef4\u5ea6\u5bfc\u51fa\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_107", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ef4\u5ea6\u5bfc\u51fa\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_108", "epm-far-common");
            }
        }
        return null;
    }

    private static MultiLangEnumBridge dimensionDefaultDescriptionBuilder(OperationName opName, OperationResult status) {
        switch (opName) {
            case EDIT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ef4\u5ea6\u9ed8\u8ba4\u503c %2$s \u4fee\u6539\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_109", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ef4\u5ea6\u9ed8\u8ba4\u503c %2$s \u4fee\u6539\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_110", "epm-far-common");
            }
        }
        return null;
    }

    private static MultiLangEnumBridge chapteRepositoryDescriptionBuilder(OperationName opName, OperationResult status) {
        switch (opName) {
            case DELETE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u7ae0\u8282%2$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_111", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u7ae0\u8282%2$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_112", "epm-far-common");
            }
            case ENABLE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u7ae0\u8282%2$s \u542f\u7528\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_113", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u7ae0\u8282%2$s \u542f\u7528\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_114", "epm-far-common");
            }
            case DISABLE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u7ae0\u8282%2$s \u7981\u7528\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_115", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u7ae0\u8282%2$s \u7981\u7528\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_116", "epm-far-common");
            }
            case CATALOG_CREATE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u5206\u7c7b%2$s \u65b0\u589e\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_117", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u5206\u7c7b%2$s \u65b0\u589e\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_118", "epm-far-common");
            }
            case CATALOG_EDIT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u5206\u7c7b%2$s \u7f16\u8f91\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_119", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u5206\u7c7b%2$s \u7f16\u8f91\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_120", "epm-far-common");
            }
            case CATALOG_DELETE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u5206\u7c7b%2$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_121", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u5206\u7c7b%2$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_122", "epm-far-common");
            }
            case CATALOG_MOVE_UP: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u5206\u7c7b%2$s \u5206\u7c7b\u4e0a\u79fb\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_123", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u5206\u7c7b%2$s \u5206\u7c7b\u4e0a\u79fb\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_124", "epm-far-common");
            }
            case CATALOG_MOVE_DOWN: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u5206\u7c7b%2$s \u5206\u7c7b\u4e0b\u79fb\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_125", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u5206\u7c7b%2$s \u5206\u7c7b\u4e0b\u79fb\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_126", "epm-far-common");
            }
            case CREATE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u7ae0\u8282%2$s \u65b0\u589e\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_127", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u7ae0\u8282%2$s \u65b0\u589e\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_128", "epm-far-common");
            }
            case EDIT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u7ae0\u8282%2$s \u7f16\u8f91\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_129", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u7ae0\u8282\u5e93\u7ae0\u8282%2$s \u7f16\u8f91\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_130", "epm-far-common");
            }
        }
        return null;
    }

    private static MultiLangEnumBridge templateDescriptionBuilder(OperationName opName, OperationResult status) {
        switch (opName) {
            case CREATE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u65b0\u589e\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_135", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u65b0\u589e\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_136", "epm-far-common");
            }
            case COPY: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u590d\u5236\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_137", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u590d\u5236\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_138", "epm-far-common");
            }
            case EDIT: 
            case EDIT_BASEINFO: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u57fa\u672c\u4fe1\u606f\u7f16\u8f91\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_147", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u57fa\u672c\u4fe1\u606f\u7f16\u8f91\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_148", "epm-far-common");
            }
            case DELETE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_141", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_142", "epm-far-common");
            }
            case ENABLE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u542f\u7528\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_143", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u542f\u7528\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_144", "epm-far-common");
            }
            case DISABLE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7981\u7528\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_145", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7981\u7528\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_146", "epm-far-common");
            }
            case GENERALMYREPORT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u751f\u6210\u6211\u7684\u62a5\u544a%3$s %4$s %5$s %6$s\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_239", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u751f\u6210\u6211\u7684\u62a5\u544a%3$s %4$s %5$s %6$s\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_240", "epm-far-common");
            }
            case CATALOG_CREATE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f\u5206\u7c7b%2$s \u65b0\u589e\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_151", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f\u5206\u7c7b%2$s \u65b0\u589e\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_152", "epm-far-common");
            }
            case CATALOG_EDIT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f\u5206\u7c7b%2$s \u7f16\u8f91\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_153", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f\u5206\u7c7b%2$s \u7f16\u8f91\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_154", "epm-far-common");
            }
            case CATALOG_DELETE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f\u5206\u7c7b%2$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_155", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f\u5206\u7c7b%2$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_156", "epm-far-common");
            }
            case CATALOG_MOVE_UP: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f\u5206\u7c7b%2$s \u5206\u7c7b\u4e0a\u79fb\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_157", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f\u5206\u7c7b%2$s \u5206\u7c7b\u4e0a\u79fb\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_158", "epm-far-common");
            }
            case CATALOG_MOVE_DOWN: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f\u5206\u7c7b%2$s \u5206\u7c7b\u4e0b\u79fb\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_159", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f\u5206\u7c7b%2$s \u5206\u7c7b\u4e0b\u79fb\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_160", "epm-far-common");
            }
            case UPLOAD: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u4e0a\u4f20\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_221", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u4e0a\u4f20\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_222", "epm-far-common");
            }
        }
        return null;
    }

    private static MultiLangEnumBridge templateChapterDescriptionBuilder(OperationName opName, OperationResult status) {
        switch (opName) {
            case CREATE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u65b0\u589e\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_161", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u65b0\u589e\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_162", "epm-far-common");
            }
            case EDIT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u7f16\u8f91\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_163", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u7f16\u8f91\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_164", "epm-far-common");
            }
            case DELETE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_165", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_166", "epm-far-common");
            }
            case ENABLE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u542f\u7528\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_167", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u542f\u7528\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_168", "epm-far-common");
            }
            case DISABLE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u7981\u7528\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_169", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u7981\u7528\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_170", "epm-far-common");
            }
            case CATALOG_MOVE_UP: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u4e0a\u79fb\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_171", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u4e0a\u79fb\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_172", "epm-far-common");
            }
            case CATALOG_MOVE_DOWN: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u4e0b\u79fb\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_173", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u4e0b\u79fb\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_174", "epm-far-common");
            }
            case SAVE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u6587\u6863\u5185\u5bb9\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_175", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u6587\u6863\u5185\u5bb9\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_176", "epm-far-common");
            }
            case COMMIT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u63d0\u4ea4\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_177", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u63d0\u4ea4\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_178", "epm-far-common");
            }
            case BACKED: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u6253\u56de\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_179", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u6253\u56de\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_180", "epm-far-common");
            }
            case SAVE_AS: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u53e6\u5b58\u4e3a\u7ae0\u8282\u5e93\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_241", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u53e6\u5b58\u4e3a\u7ae0\u8282\u5e93\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_242", "epm-far-common");
            }
            case COPY: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u590d\u5236\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_243", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u62a5\u544a\u6a21\u677f%2$s \u7ae0\u8282%3$s \u590d\u5236\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_244", "epm-far-common");
            }
        }
        return null;
    }

    private static MultiLangEnumBridge reportDescriptionBuilder(OperationName opName, OperationResult status) {
        switch (opName) {
            case DELETE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_181", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_182", "epm-far-common");
            }
            case EDIT_BASEINFO: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s \u57fa\u672c\u4fe1\u606f\u7f16\u8f91\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_183", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s \u57fa\u672c\u4fe1\u606f\u7f16\u8f91\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_184", "epm-far-common");
            }
            case COMMIT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s \u7ae0\u8282%3$s \u7f6e\u4e3a\u5b9a\u7a3f\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_185", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s \u7ae0\u8282%3$s \u7f6e\u4e3a\u5b9a\u7a3f\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_186", "epm-far-common");
            }
            case BACKED: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s \u7ae0\u8282%3$s \u7f6e\u4e3a\u8349\u7a3f\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_187", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s \u7ae0\u8282%3$s \u7f6e\u4e3a\u8349\u7a3f\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_188", "epm-far-common");
            }
            case SAVE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s \u7ae0\u8282%3$s \u6587\u6863\u5185\u5bb9\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_189", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s \u7ae0\u8282%3$s \u6587\u6863\u5185\u5bb9\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_190", "epm-far-common");
            }
            case DATA_UPDATA: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s \u7ae0\u8282%3$s \u6570\u636e\u66f4\u65b0\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_223", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s \u7ae0\u8282%3$s \u6570\u636e\u66f4\u65b0\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_224", "epm-far-common");
            }
            case DATA_FAILUPDATA: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s \u7ae0\u8282%3$s \u5931\u8d25\u7ec4\u4ef6\u5237\u65b0\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_225", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s \u7ae0\u8282%3$s \u5931\u8d25\u7ec4\u4ef6\u5237\u65b0\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_226", "epm-far-common");
            }
            case EXPORT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s \u5bfc\u51fa\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_227", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s \u5bfc\u51fa\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_229", "epm-far-common");
            }
            case EXPORT_REPORT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s \u7ae0\u8282%3$s \u5bfc\u51fa\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_262", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s \u7ae0\u8282%3$s \u5bfc\u51fa\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_263", "epm-far-common");
            }
            case EXPORT_REPORT2: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u5bfc\u51fa\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_290", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u5bfc\u51fa\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_291", "epm-far-common");
            }
            case DELETE_REPORT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_292", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_293", "epm-far-common");
            }
            case COMMIT_REPORT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u63d0\u4ea4\u64cd\u4f5c\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_294", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u63d0\u4ea4\u64cd\u4f5c\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_295", "epm-far-common");
            }
            case BACKED_REPORT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u6253\u56de\u64cd\u4f5c\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_296", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u6253\u56de\u64cd\u4f5c\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_297", "epm-far-common");
            }
            case AUDIT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u5ba1\u6838\u64cd\u4f5c\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_298", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u5ba1\u6838\u64cd\u4f5c\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_299", "epm-far-common");
            }
            case UNAUDIT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u53cd\u5ba1\u6838\u64cd\u4f5c\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_300", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u53cd\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_301", "epm-far-common");
            }
            case ARCHIVE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u5f52\u6863\u64cd\u4f5c\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_302", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u5f52\u6863\u64cd\u4f5c\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_303", "epm-far-common");
            }
            case UNARCHIVE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u53cd\u5f52\u6863\u64cd\u4f5c\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_304", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u53cd\u5f52\u6863\u64cd\u4f5c\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_305", "epm-far-common");
            }
            case UNKNOWN: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u672a\u77e5\u64cd\u4f5c\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_306", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u672a\u77e5\u64cd\u4f5c\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_307", "epm-far-common");
            }
            case EDIT_REPORT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u57fa\u672c\u4fe1\u606f\u7f16\u8f91\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_308", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6211\u7684\u62a5\u544a%2$s %3$s %4$s %5$s \u57fa\u672c\u4fe1\u606f\u7f16\u8f91\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_309", "epm-far-common");
            }
        }
        return null;
    }

    private static MultiLangEnumBridge pivotTableDescriptionBuilder(OperationName opName, OperationResult status) {
        switch (opName) {
            case CREATE_SCHEME: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848%2$s \u65b0\u589e\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_193", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848%2$s \u65b0\u589e\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_194", "epm-far-common");
            }
            case DELETE_SCHEME: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848%2$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_195", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848%2$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_196", "epm-far-common");
            }
            case CREATE_SCHEME_CATALOG: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848\u5206\u7c7b%2$s \u65b0\u589e\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_197", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848\u5206\u7c7b%2$s \u65b0\u589e\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_198", "epm-far-common");
            }
            case DELETE_SCHEME_CATALOG: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848\u5206\u7c7b%2$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_199", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848\u5206\u7c7b%2$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_200", "epm-far-common");
            }
            case EDIT_SCHEME_CATALOG: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848\u5206\u7c7b%2$s \u7f16\u8f91\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_201", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848\u5206\u7c7b%2$s \u7f16\u8f91\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_202", "epm-far-common");
            }
            case CATALOG_MOVE_UP: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848\u5206\u7c7b%2$s \u4e0a\u79fb\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_203", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848\u5206\u7c7b%2$s \u4e0a\u79fb\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_204", "epm-far-common");
            }
            case CATALOG_MOVE_DOWN: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848\u5206\u7c7b%2$s \u4e0b\u79fb\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_205", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848\u5206\u7c7b%2$s \u4e0b\u79fb\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_206", "epm-far-common");
            }
            case SCHEME_SAVE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848%2$s \u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_207", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848%2$s \u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_208", "epm-far-common");
            }
            case SCHEME_SAVE_AS: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848%2$s \u53e6\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_209", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848%2$s \u53e6\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_210", "epm-far-common");
            }
            case SCHEME_EDIT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848%2$s \u7f16\u8f91\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_211", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848%2$s \u7f16\u8f91\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_212", "epm-far-common");
            }
            case SCHEME_MOVE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848%2$s \u79fb\u52a8\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_213", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848%2$s \u79fb\u52a8\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_214", "epm-far-common");
            }
            case SCHEME_CLEAR: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848%2$s \u6e05\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_215", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848%2$s \u6e05\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_216", "epm-far-common");
            }
            case SCHEME_REFRESH: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848%2$s \u6570\u636e\u5237\u65b0\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_217", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u5206\u6790\u65b9\u6848%2$s \u6570\u636e\u5237\u65b0\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_218", "epm-far-common");
            }
        }
        return null;
    }

    private static MultiLangEnumBridge permClassDescriptionBuilder(OperationName opName, OperationResult status) {
        switch (opName) {
            case EXPORT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6743\u9650\u7c7b\u5217\u8868\u5bfc\u51fa\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_231", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6743\u9650\u7c7b\u5217\u8868\u5bfc\u51fa\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_232", "epm-far-common");
            }
            case DELETE: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s \u6743\u9650\u7c7b\u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_264", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s \u6743\u9650\u7c7b\u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_265", "epm-far-common");
            }
        }
        return null;
    }

    private static MultiLangEnumBridge dataPermDescriptionBuilder(OperationName opName, OperationResult status) {
        switch (opName) {
            case EXPORT: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u6743\u9650\u5217\u8868\u5bfc\u51fa\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_233", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s\uff0c\u6570\u636e\u6743\u9650\u5217\u8868\u5bfc\u51fa\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_234", "epm-far-common");
            }
            case DELETE_USER: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s,\u7528\u6237%2$s \u6570\u636e\u6743\u9650%3$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_282", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s,\u7528\u6237%2$s \u6570\u636e\u6743\u9650%3$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_283", "epm-far-common");
            }
            case DELETE_USERGROUP: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s,\u7528\u6237\u7ec4%2$s \u6570\u636e\u6743\u9650%3$s \u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_288", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s,\u7528\u6237\u7ec4%2$s \u6570\u636e\u6743\u9650%3$s \u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_289", "epm-far-common");
            }
        }
        return null;
    }

    private static MultiLangEnumBridge datasetCategoryDescriptionBuilder(OperationName opName, OperationResult status) {
        switch (opName) {
            case ADD_DATASET_CATALOG: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s %2$s\uff0c\u65b0\u589e\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_250", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s %2$s\uff0c\u65b0\u589e\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_251", "epm-far-common");
            }
            case MODIFY_DATASET_CATALOG: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s %2$s\uff0c\u7f16\u8f91\u4fdd\u5b58\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_252", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s %2$s\uff0c\u7f16\u8f91\u4fdd\u5b58\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_253", "epm-far-common");
            }
            case UP_DATASET_CATALOG: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s %2$s\uff0c\u4e0a\u79fb\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_254", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s %2$s\uff0c\u4e0a\u79fb\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_255", "epm-far-common");
            }
            case NEXT_DATASET_CATALOG: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s %2$s\uff0c\u4e0b\u79fb\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_256", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s %2$s\uff0c\u4e0b\u79fb\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_257", "epm-far-common");
            }
            case DELETE_DATASET_CATALOG: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s %2$s\uff0c\u5220\u9664\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_258", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s %2$s\uff0c\u5220\u9664\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_259", "epm-far-common");
            }
            case MOVE_DATASET_CATALOG: {
                if (OperationResult.SUCCESS == status) {
                    return new MultiLangEnumBridge("%1$s %2$s\uff0c\u79fb\u52a8\u6210\u529f\u3002", "AnalysisOperationLogHelperEx_260", "epm-far-common");
                }
                return new MultiLangEnumBridge("%1$s %2$s\uff0c\u79fb\u52a8\u5931\u8d25\u3002", "AnalysisOperationLogHelperEx_261", "epm-far-common");
            }
        }
        return null;
    }

    static {
        discriptionBuildMap.put(OperationCategory.MODEL, AnalysisOpLogHelper::modelDescriptionBuilder);
        discriptionBuildMap.put(OperationCategory.GLOBAL_VAR, AnalysisOpLogHelper::globalVarDescriptionBuilder);
        discriptionBuildMap.put(OperationCategory.DATASET, AnalysisOpLogHelper::datasetDescriptionBuilder);
        discriptionBuildMap.put(OperationCategory.ANALYSIS_DESIGN, AnalysisOpLogHelper::analysisDesignDescriptionBuilder);
        discriptionBuildMap.put(OperationCategory.MYANALYSIS, AnalysisOpLogHelper::myAnalysisDescriptionBuilder);
        discriptionBuildMap.put(OperationCategory.THEMEANLYSIS, AnalysisOpLogHelper::theAnalysisDescriptionBuilder);
        discriptionBuildMap.put(OperationCategory.COMPONENT_GALLERY, AnalysisOpLogHelper::componentGalleryDescriptionBuilder);
        discriptionBuildMap.put(OperationCategory.DIMENSION, AnalysisOpLogHelper::dimensionDescriptionBuilder);
        discriptionBuildMap.put(OperationCategory.DIMENSION_DEFAULT, AnalysisOpLogHelper::dimensionDefaultDescriptionBuilder);
        discriptionBuildMap.put(OperationCategory.CHAPTEREPOSITORY, AnalysisOpLogHelper::chapteRepositoryDescriptionBuilder);
        discriptionBuildMap.put(OperationCategory.TEMPLATE, AnalysisOpLogHelper::templateDescriptionBuilder);
        discriptionBuildMap.put(OperationCategory.TEMPLATECHAPTER, AnalysisOpLogHelper::templateChapterDescriptionBuilder);
        discriptionBuildMap.put(OperationCategory.REPORT, AnalysisOpLogHelper::reportDescriptionBuilder);
        discriptionBuildMap.put(OperationCategory.PIVOT_TABLE, AnalysisOpLogHelper::pivotTableDescriptionBuilder);
        discriptionBuildMap.put(OperationCategory.PERM_CLASS, AnalysisOpLogHelper::permClassDescriptionBuilder);
        discriptionBuildMap.put(OperationCategory.DATA_PERM, AnalysisOpLogHelper::dataPermDescriptionBuilder);
        discriptionBuildMap.put(OperationCategory.DATASETCATEGORY, AnalysisOpLogHelper::datasetCategoryDescriptionBuilder);
        discriptionBuildMap.put(OperationCategory.ROLE, AnalysisOpLogHelper::roleDescriptionBuilder);
        discriptionBuildMap.put(OperationCategory.FUNCTION_PERM, AnalysisOpLogHelper::permDescriptionBuilder);
    }

    private static interface DescriptionBuilder {
        public MultiLangEnumBridge buildDescription(OperationName var1, OperationResult var2);
    }
}

