/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.log.oplog;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.IFormView;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;

public class AnalysisOpLogParam
implements Serializable {
    private OperationCategory subject;
    private OperationName opName;
    private OperationResult result;
    private String entityNumber;
    private String appId;
    private Object[] formatParams;
    private List<Object[]> formatParamsList;

    public AnalysisOpLogParam() {
        this.subject = OperationCategory.UNDEFINED;
        this.opName = OperationName.UNSUPPORTED;
    }

    public AnalysisOpLogParam(int expectedBatchSize) {
        this.formatParamsList = Lists.newArrayListWithExpectedSize((int)expectedBatchSize);
    }

    public AnalysisOpLogParam buildOpCategory(OperationCategory subject) {
        this.subject = subject;
        return this;
    }

    public AnalysisOpLogParam buildOpName(OperationName opName) {
        this.opName = opName;
        return this;
    }

    public AnalysisOpLogParam buildOpResult(OperationResult result) {
        this.result = result;
        return this;
    }

    public AnalysisOpLogParam buildFormNumber(String entityFormNumber) {
        this.entityNumber = entityFormNumber;
        return this;
    }

    public AnalysisOpLogParam buildFormNumber(IFormView view) {
        this.entityNumber = view.getModel().getDataEntityType().getName();
        return this;
    }

    public AnalysisOpLogParam buildAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public AnalysisOpLogParam buildAppId(IFormView view) {
        this.appId = Objects.isNull(view) ? null : AppMetadataCache.getAppInfo((String)view.getFormShowParameter().getAppId()).getId();
        return this;
    }

    public AnalysisOpLogParam buildFormatParams(Object ... formatParams) {
        this.formatParams = formatParams;
        return this;
    }

    public AnalysisOpLogParam appendFormatParams(Object ... formatParams) {
        this.formatParams = ObjectArrays.concat((Object[])this.formatParams, (Object[])formatParams, Object.class);
        return this;
    }

    public AnalysisOpLogParam buildFormatParamsList(List<Object[]> formatParamsList) {
        this.formatParamsList = formatParamsList;
        return this;
    }

    public AnalysisOpLogParam buildBatchFormatParams(Object ... formatParams) {
        if (this.formatParamsList == null) {
            this.formatParamsList = Lists.newArrayListWithCapacity((int)formatParams.length);
        }
        this.formatParamsList.add(formatParams);
        return this;
    }

    public OperationCategory getSubject() {
        return this.subject;
    }

    public OperationName getOpName() {
        return this.opName;
    }

    public OperationResult getResult() {
        return this.result;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public Object[] getFormatParams() {
        return this.formatParams;
    }

    public String getAppId() {
        return this.appId;
    }

    public List<Object[]> getFormatParamsList() {
        return this.formatParamsList;
    }

    public void setSubject(OperationCategory subject) {
        this.subject = subject;
    }

    public void setOpName(OperationName opName) {
        this.opName = opName;
    }

    public void setResult(OperationResult result) {
        this.result = result;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public void setAppId(String appId) {
        this.appId = AppMetadataCache.getAppInfo((String)appId).getId();
    }

    public void setFormatParams(Object[] formatParams) {
        this.formatParams = formatParams;
    }

    public void setFormatParamsList(List<Object[]> formatParamsList) {
        this.formatParamsList = formatParamsList;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }
}

