/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.log.oplog;

import com.alibaba.fastjson.JSON;
import java.util.Objects;
import kd.bos.form.IFormView;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;

public class AnalysisOpLogUtil {
    private AnalysisOpLogUtil() {
    }

    public static OperationName getOpNameByString(String opName) {
        OperationName opNameEnum;
        try {
            opNameEnum = Enum.valueOf(OperationName.class, opName);
        }
        catch (IllegalArgumentException exception) {
            opNameEnum = OperationName.UNSUPPORTED;
        }
        return opNameEnum;
    }

    public static AnalysisOpLogParam getLogParamFromView(IFormView view, String opKey) {
        AnalysisOpLogParam logParam;
        String json = view.getPageCache().get(opKey);
        try {
            logParam = (AnalysisOpLogParam)JSON.parseObject((String)json, AnalysisOpLogParam.class);
        }
        catch (Exception e) {
            logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.UNDEFINED);
        }
        if (Objects.isNull(logParam)) {
            logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.UNDEFINED);
        }
        return logParam;
    }
}

