/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.log.oplog;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.far.common.common.enums.MultiLangEnumBridge;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationVersionEnum;

public class OperateLogUtil {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(OperateLogUtil.class);
    private static final String WEB = "web";
    private static final String API = "api";
    private static OperationVersionEnum versionEnum;
    private static Class<?> logClass;

    public static void addLog(OperationName opName, MultiLangEnumBridge bridge, String appId, String entityNumber, Object[] params) {
        try {
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            AppLogInfo logInfo = OperateLogUtil.buildLogInfo(appId, entityNumber);
            OperateLogUtil.buildByVersion(opName, bridge, params, logInfo);
            logService.addLog(logInfo);
        }
        catch (Exception ex) {
            logger.error("dm wirtelog error", ex);
        }
    }

    public static void buildByVersion(OperationName opName, MultiLangEnumBridge bridge, Object[] params, AppLogInfo logInfo) {
        try {
            if (OperationVersionEnum.V2 == versionEnum) {
                logInfo.setOpName(opName.getMultiLangName());
                logInfo.setOpDescription(OperateLogUtil.getV2Desc(bridge, params));
            } else {
                String[] descParams = new String[]{};
                if (Objects.nonNull(params) && params.length > 0) {
                    descParams = new String[params.length];
                    for (int i = 0; i < params.length; ++i) {
                        descParams[i] = params[i].toString();
                    }
                }
                Method setOpName = logInfo.getClass().getMethod("setOpName", String.class, kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge.class);
                Method setOpDescription = logInfo.getClass().getMethod("setOpDesc", kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge.class, String[].class);
                setOpName.invoke((Object)logInfo, new Object[]{opName.getOpKey(), opName.getBridge()});
                setOpDescription.invoke((Object)logInfo, new Object[]{bridge, descParams});
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addBatchLog(List<AppLogInfo> logList) {
        try {
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            logService.addBatchLog(logList);
        }
        catch (Exception ex) {
            logger.error("dm wirtelog error", ex);
        }
    }

    public static AppLogInfo buildLogInfo(OperationName opName, MultiLangEnumBridge bridge, String appId, String entityNumber, Object[] formatParams) {
        AppLogInfo appLogInfo = OperateLogUtil.buildLogInfo(appId, entityNumber);
        OperateLogUtil.buildByVersion(opName, bridge, formatParams, appLogInfo);
        return appLogInfo;
    }

    private static AppLogInfo buildLogInfo(String appId, String entityNumber) {
        AppLogInfo logInfo;
        RequestContext rc = RequestContext.get();
        if (OperationVersionEnum.V3 == versionEnum) {
            try {
                logInfo = (AppLogInfo)logClass.newInstance();
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        } else {
            logInfo = new AppLogInfo();
        }
        logInfo.setUserID(Long.valueOf(rc.getCurrUserId()));
        logInfo.setOrgID(Long.valueOf(rc.getOrgId()));
        logInfo.setOpTime(TimeServiceHelper.now());
        logInfo.setClientIP(rc.getLoginIP());
        if (API.equals(rc.getClient())) {
            logInfo.setClientType(WEB);
            logInfo.setClientName(ResManager.loadKDString((String)"EPM\u5ba2\u6237\u7aef", (String)"AnalysisOperationLogHelper_247", (String)"epm-far-common", (Object[])new Object[0]));
        } else {
            logInfo.setClientType(rc.getClient());
            logInfo.setClientName(rc.getClient());
        }
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID(entityNumber);
        return logInfo;
    }

    public static String getV2Desc(MultiLangEnumBridge bridge, Object[] params) {
        if (Objects.nonNull(params)) {
            return String.format(bridge.getDescription(), params);
        }
        return ResManager.loadKDString((String)bridge.getDescription(), (String)bridge.getResourceID(), (String)"epm-far-common", (Object[])new Object[0]);
    }

    static {
        try {
            logClass = Class.forName("kd.bos.log.api.OpLogAppInfo");
            versionEnum = OperationVersionEnum.V3;
        }
        catch (Throwable e) {
            versionEnum = OperationVersionEnum.V2;
            logger.error("current version is v2");
            logger.error(e.getMessage(), e);
        }
    }
}

