/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;

public class BCMTreeUtils {
    public static void spreadAllNode(TreeNode treenode) {
        if (treenode == null) {
            return;
        }
        treenode.setIsOpened(true);
        if (null != treenode.getChildren()) {
            List nodes = treenode.getChildren();
            for (TreeNode t : nodes) {
                BCMTreeUtils.spreadAllNode(t);
            }
        }
    }

    public static TreeNode setEntryNode(TreeNode root, List<Map<String, String>> rootNodeList, String headId) {
        HashMap<String, List<Map<String, String>>> nodeMap = new HashMap<String, List<Map<String, String>>>(16);
        for (Map<String, String> node : rootNodeList) {
            String parentId = node.get("parentid");
            ArrayList<Map<String, String>> nodeList = (ArrayList<Map<String, String>>)nodeMap.get(parentId);
            if (nodeList == null) {
                nodeList = new ArrayList<Map<String, String>>(16);
                nodeMap.put(parentId, nodeList);
            }
            nodeList.add(node);
        }
        int maxCount = BCMTreeUtils.getMaxCount(0L);
        String searchText = ThreadCache.get((Object)(CacheKey.PrefixString + "search_text")) != null ? ThreadCache.get((Object)(CacheKey.PrefixString + "search_text")).toString() : null;
        return BCMTreeUtils.createNode(root, nodeMap, headId, maxCount, searchText);
    }

    public static TreeNode setEntryNodeDm(TreeNode root, List<Map<String, String>> rootNodeList, String headId) {
        HashMap<String, List<Map<String, String>>> nodeMap = new HashMap<String, List<Map<String, String>>>();
        for (Map<String, String> node : rootNodeList) {
            String parentId = node.get("parentid");
            ArrayList<Map<String, String>> nodeList = (ArrayList<Map<String, String>>)nodeMap.get(parentId);
            if (nodeList == null) {
                nodeList = new ArrayList<Map<String, String>>();
                nodeMap.put(parentId, nodeList);
            }
            nodeList.add(node);
        }
        return BCMTreeUtils.createNodeDm(root, nodeMap, headId);
    }

    private static TreeNode createNode(TreeNode root, Map<String, List<Map<String, String>>> nodeMap, String headId, int maxCount, String searchText) {
        List<Map<String, String>> list = nodeMap.get(headId);
        if (list != null && !list.isEmpty()) {
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>(list.size());
                root.setChildren(children);
            }
            int i = 0;
            for (Map<String, String> map : list) {
                if (maxCount != 0 && (maxCount <= 0 || ++i > maxCount) && !BCMTreeUtils.containsText(map, searchText)) continue;
                TreeNode entry = new TreeNode();
                entry.setParentid(headId);
                entry.setId(map.get("id"));
                entry.setText(map.get("name"));
                String entryHeadId = map.get("id");
                BCMTreeUtils.createNode(entry, nodeMap, entryHeadId, maxCount, searchText);
                children.add(entry);
            }
        }
        return root;
    }

    private static boolean containsText(Map<String, String> nodeMap, String searchText) {
        if (StringUtils.isEmpty((CharSequence)searchText)) {
            return false;
        }
        return nodeMap.get("number").toLowerCase(Locale.ENGLISH).contains(searchText) || nodeMap.get("name").toLowerCase(Locale.ENGLISH).contains(searchText);
    }

    private static TreeNode createNodeDm(TreeNode root, Map<String, List<Map<String, String>>> nodeMap, String headId) {
        List<Map<String, String>> list = nodeMap.get(headId);
        if (list != null) {
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>(list.size());
                root.setChildren(children);
            }
            int i = 0;
            int maxCount = BCMTreeUtils.getMaxCount(0L);
            for (Map<String, String> map : list) {
                if (maxCount > 0 && ++i > maxCount) {
                    return root;
                }
                TreeNode entry = new TreeNode();
                entry.setParentid(headId);
                entry.setId(map.get("id"));
                entry.setText(map.get("name"));
                String entryHeadId = map.get("id");
                if ("catalog".equals(map.get("type"))) {
                    entry.setIcon("kdfont kdfont-wenjianjia");
                }
                if (StringUtils.isNotEmpty((CharSequence)map.get("icon"))) {
                    entry.setIcon(map.get("icon"));
                }
                BCMTreeUtils.createNodeDm(entry, nodeMap, entryHeadId);
                children.add(entry);
            }
        }
        return root;
    }

    public static int getMaxCount(long modelId) {
        if (modelId == 0L) {
            modelId = LongUtil.toLong(ThreadCache.get((Object)(CacheKey.PrefixString + "getModelId")));
        }
        return BCMTreeUtils.getStringParam(modelId, "dimMaxCount");
    }

    public static int getStringParam(Long modelId, String paramNum) {
        return (Integer)ThreadCache.get((Object)(CacheKey.PrefixString + "BCMTreeUtils_" + modelId + paramNum), () -> {
            QFBuilder qf = new QFBuilder();
            qf.add("model", "=", modelId);
            qf.add("number", "=", paramNum);
            DynamicObject config = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_configsetting", (String)"config", (QFilter[])qf.toArray());
            if (config != null) {
                try {
                    return Integer.parseInt(config.getString("config"));
                }
                catch (NumberFormatException ex) {
                    return 0;
                }
            }
            return 0;
        });
    }

    public static TreeNode createTreeNode(String nodeId, String nodeText, String nodeData, String parentId) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId(nodeId);
        treeNode.setText(nodeText);
        treeNode.setData((Object)nodeData);
        treeNode.setParentid(parentId);
        return treeNode;
    }
}

