/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.util;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.metadata.entity.commonfield.Field;
import kd.epm.far.common.common.util.ClassUtil;

public class BosFieldLoader {
    private Map<String, String> namesmap;

    private BosFieldLoader() {
        this.loadField();
    }

    public static BosFieldLoader getInstance() {
        return BosFieldLoaderHolder.INSTANCE;
    }

    private void loadField() {
        String bos_CommonField_Class_Path = "kd.bos.metadata.entity.commonfield";
        String bos_BusinessField_Class_Path = "kd.bos.metadata.entity.businessfield";
        List<String> classnames = ClassUtil.getClazzName(bos_CommonField_Class_Path, true);
        classnames.addAll(ClassUtil.getClazzName(bos_BusinessField_Class_Path, true));
        this.namesmap = new HashMap<String, String>(classnames.size());
        for (String name : classnames) {
            String[] ss = name.split("\\.");
            String key = ss[ss.length - 1];
            this.namesmap.put(key.toLowerCase(Locale.ENGLISH), name);
        }
    }

    public Field<?> getField(String fieldName) {
        String searchname = fieldName.toLowerCase(Locale.ENGLISH);
        String className = this.namesmap.get(searchname);
        if (className != null) {
            try {
                Field field = (Field)Class.forName(className).newInstance();
                return field;
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("not support bos field type %s.", fieldName), e);
            }
        }
        throw new RuntimeException(String.format("not support bos field type %s.", fieldName));
    }

    private static class BosFieldLoaderHolder {
        private static final BosFieldLoader INSTANCE = new BosFieldLoader();

        private BosFieldLoaderHolder() {
        }
    }
}

