/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kd.bos.util.StringUtils;

public class DateTimeUtils {
    public static String format(Date d, String fmt) {
        return DateTimeUtils.format(d, fmt, null);
    }

    public static String format(Date d, String fmt, TimeZone timezone) {
        return DateTimeUtils.format(d, fmt, timezone, null);
    }

    public static String format(Date d, String fmt, TimeZone timezone, Locale locale) {
        if (fmt == null) {
            fmt = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(fmt, locale);
        if (timezone == null) {
            df.setTimeZone(TimeZone.getDefault());
        } else {
            df.setTimeZone(timezone);
        }
        return df.format(d);
    }

    public static String format(Date d) {
        return DateTimeUtils.format(d, null, null);
    }

    public static String format(Date d, TimeZone timezone) {
        return DateTimeUtils.format(d, null, timezone);
    }

    public static Date parseDate(String s) throws ParseException {
        if (StringUtils.isNotEmpty((String)s)) {
            int length = s.length();
            if (19 == length) {
                if (s.indexOf("-") > 0) {
                    return DateTimeUtils.parseDate(s, "yyyy-MM-dd HH:mm:ss");
                }
                return DateTimeUtils.parseDate(s, "MM/dd/yyyy HH:mm:ss");
            }
            if (8 == length) {
                return DateTimeUtils.parseDate(s, "HH:mm:ss");
            }
            if (10 == length) {
                if (s.indexOf("-") > 0) {
                    return DateTimeUtils.parseDate(s, "yyyy-MM-dd");
                }
                return DateTimeUtils.parseDate(s, "MM/dd/yyyy");
            }
        }
        return DateTimeUtils.parseDate(s, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date parseDate(String s, String fmt) throws ParseException {
        return DateTimeUtils.parseDate(s, fmt, null);
    }

    public static Date parseDate(String s, String fmt, TimeZone timezone) throws ParseException {
        return DateTimeUtils.parseDate(s, fmt, timezone, null);
    }

    public static Date parseDate(String s, String fmt, TimeZone timezone, Locale locale) throws ParseException {
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(fmt, locale);
        if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        df.setTimeZone(timezone);
        df.setLenient(false);
        return df.parse(s);
    }

    public static int getYear(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        int year = cal.get(1);
        int era = cal.get(0);
        if (era == 0) {
            return -1 * year;
        }
        return year;
    }
}

