/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.util;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.far.common.common.util.Point;
import org.apache.commons.lang3.StringUtils;

public class ExcelUtils {
    private static final int ZeroCharValue = 48;

    public static int pos2X(String pos) {
        int colAxisIndex = ExcelUtils.getColAxisIndex(pos);
        return ExcelUtils.pos2X(pos, colAxisIndex);
    }

    private static int pos2X(String pos, int colAxisIndex) {
        int count = -1;
        for (int i = 0; i < colAxisIndex; ++i) {
            char c = pos.charAt(i);
            count = c >= 'a' && c <= 'z' ? (int)((double)count + (double)(c - 96) * Math.pow(26.0, colAxisIndex - 1 - i)) : (int)((double)count + (double)(c - 64) * Math.pow(26.0, colAxisIndex - 1 - i));
        }
        return count;
    }

    public static int pos2Y(String pos) {
        int colAxisIndex = ExcelUtils.getColAxisIndex(pos);
        return ExcelUtils.pos2Y(pos, colAxisIndex);
    }

    private static int pos2Y(String pos, int colAxisIndex) {
        int result = 0;
        int j = 1;
        for (int i = pos.length() - 1; i >= colAxisIndex; --i) {
            char c = pos.charAt(i);
            if (c >= '0' && c <= '9') {
                result += (c - 48) * j;
            } else {
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548\uff1a%s", (String)"ExcelUtils_0", (String)"epm-far-common", (Object[])new Object[0]), pos));
            }
            j *= 10;
        }
        return result - 1;
    }

    private static int getColAxisIndex(String pos) {
        if (pos.length() <= 1) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548\uff1a%s", (String)"ExcelUtils_0", (String)"epm-far-common", (Object[])new Object[0]), pos));
        }
        if (!Character.isLetter(pos.charAt(0))) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548\uff1a%s", (String)"ExcelUtils_0", (String)"epm-far-common", (Object[])new Object[0]), pos));
        }
        if (!Character.isLetter(pos.charAt(1))) {
            return 1;
        }
        for (int index = 2; index < pos.length(); ++index) {
            if (Character.isLetter(pos.charAt(index))) continue;
            return index;
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548\uff1a%s", (String)"ExcelUtils_0", (String)"epm-far-common", (Object[])new Object[0]), pos));
    }

    @Deprecated
    public static int[] pos2XY(String pos) {
        int[] xy = new int[2];
        int colAxisIndex = ExcelUtils.getColAxisIndex(pos);
        xy[0] = ExcelUtils.pos2X(pos, colAxisIndex);
        xy[1] = ExcelUtils.pos2Y(pos, colAxisIndex);
        return xy;
    }

    public static Point pos2Point(String pos) {
        int colAxisIndex = ExcelUtils.getColAxisIndex(pos);
        return new Point(ExcelUtils.pos2X(pos, colAxisIndex), ExcelUtils.pos2Y(pos, colAxisIndex));
    }

    public static String xy2Pos(int x, int y) {
        if (x < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u683c\u5750\u6807\u65e0\u6548!", (String)"ExcelUtils_3", (String)"epm-far-common", (Object[])new Object[0]));
        }
        String xAxis = ExcelUtils.int2pos(x);
        return xAxis + (y + 1);
    }

    public static String int2pos(int intVal) {
        if (intVal < 0) {
            return null;
        }
        ++intVal;
        char[] tmp = new char[30];
        int i = 29;
        while (i >= 0) {
            int q = intVal / 26;
            int r = intVal % 26;
            if (r < 1) {
                r = 26;
                --q;
            }
            tmp[i--] = (char)(65 + r - 1);
            if (q == 0) break;
            intVal = q;
        }
        return new String(tmp, ++i, tmp.length - i);
    }

    public static String checkPosValidata(String startPos, String endPos, String dataPos) {
        int startPosX = ExcelUtils.pos2X(startPos);
        int startPosY = ExcelUtils.pos2Y(startPos);
        int endPosX = ExcelUtils.pos2X(endPos);
        int endPosY = ExcelUtils.pos2Y(endPos);
        int dataPosX = ExcelUtils.pos2X(dataPos);
        int dataPosY = ExcelUtils.pos2Y(dataPos);
        StringBuilder msg = new StringBuilder();
        if (endPosX < startPosX || endPosY < startPosY) {
            msg.append(ResManager.loadKDString((String)"\u533a\u57df\u8303\u56f4\u65e0\u6548,\u7ed3\u675f\u5355\u5143\u683c\u5fc5\u987b\u5728\u5f00\u59cb\u5355\u5143\u683c\u53f3\u4e0b\u65b9", (String)"ExcelUtils_1", (String)"epm-far-common", (Object[])new Object[0]));
        } else if (dataPosX < startPosX || dataPosY < startPosY || dataPosX > endPosX || dataPosY > endPosY) {
            msg.append(ResManager.loadKDString((String)"\u6570\u636e\u5f00\u59cb\u5355\u5143\u683c\u4e0d\u5728\u533a\u57df\u8303\u56f4\u5185!", (String)"ExcelUtils_2", (String)"epm-far-common", (Object[])new Object[0]));
        }
        return msg.toString();
    }

    public static boolean isWithInScope(String areaRange, String startPosition) {
        String[] arrs = areaRange.split(":");
        return StringUtils.isEmpty((CharSequence)ExcelUtils.checkPosValidata(arrs[0], arrs.length == 1 ? arrs[0] : arrs[1], startPosition));
    }
}

