/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.common.common.util;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import kd.epm.far.common.common.util.BcmTransferException;

public class ThrowableHelper {
    public static String toString(Exception exception) {
        Exception cause = exception;
        return ThrowableHelper.toString((Throwable)cause);
    }

    public static String toString(Throwable t) {
        boolean isTransExcept;
        if (null == t) {
            return null;
        }
        StringBuilder upper = new StringBuilder();
        boolean bl = isTransExcept = t instanceof BcmTransferException && (t.getStackTrace() == null || t.getStackTrace().length == 0);
        if (isTransExcept) {
            upper.append(t.getMessage()).append("\n");
        }
        if (null != t.getCause() && null != t.getCause().getStackTrace() && t.getStackTrace() != null) {
            upper.append(ThrowableHelper.toString(t.getCause()) + "\n");
        }
        if (!isTransExcept) {
            try (StringWriter sW = new StringWriter();
                 PrintWriter writer = new PrintWriter(sW);){
                t.printStackTrace(writer);
                upper.append(sW);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return upper.toString();
    }

    public static String[] generatekernelMessage(Throwable throwable, int level) {
        String[] result = new String[]{};
        if (throwable == null) {
            return result;
        }
        ArrayList<String> lines = new ArrayList<String>();
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            pw.flush();
            LineNumberReader reader = new LineNumberReader(new StringReader(sw.toString()));
            String line = reader.readLine();
            boolean foundCased = false;
            while (line != null) {
                if (line.contains("Caused By") || line.contains("Exception") || foundCased) {
                    lines.add(line);
                    foundCased = true;
                }
                if (lines.size() < level) {
                    line = reader.readLine();
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            lines.add(ex.toString());
        }
        return lines.toArray(result);
    }

    public static String generatekernelMessageInfo(Throwable throwable, int level) {
        CharSequence[] msgs = ThrowableHelper.generatekernelMessage(throwable, level);
        return String.join((CharSequence)"\n", msgs);
    }

    public static String generateFirstThreadCauseMessageInfo(Throwable throwable, int level) {
        while (throwable != null && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return ThrowableHelper.generatekernelMessageInfo(throwable, level);
    }
}

