/*
 * Decompiled with CFR 0.152.
 */
package fi.aef.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.ArchivePageEngin;
import kd.fi.aef.common.util.ArchieveBatchUtil;
import kd.fi.aef.common.util.ArchiveUtil;
import kd.fi.aef.common.util.DowJonesVideoImp;
import kd.fi.aef.common.util.ImageServerUtil;
import kd.fi.aef.common.util.JudgeBillType;
import kd.fi.aef.common.util.SplitDataUtil;
import kd.fi.aef.common.util.SysParamConfig;
import kd.fi.aef.entity.ArchiveResult;
import kd.fi.aef.entity.SchemeEntry;
import kd.fi.aef.exception.BillNotExistException;
import kd.fi.aef.exception.CannotConnectToSysException;
import kd.fi.aef.logic.common.LogicUtils;
import kd.fi.aef.logic.output.IDocumentServerHandler;

public class ReverseFilingOpService
extends EntityOperateService {
    private FileService imageService = FileServiceFactory.getAttachmentFileService();
    private static final int threadSize = 5;
    private static ThreadPool threadPoolCash = ThreadPools.newFixedThreadPool((String)"fi/aef/ReverseArchiveEngin", (int)5);
    private static final Log logger = LogFactory.getLog(ReverseFilingOpService.class);
    protected IDocumentServerHandler documentServerHandler;

    public IDocumentServerHandler getDocumentServerHandler() {
        return this.documentServerHandler;
    }

    private void initDocumentServerHandler(String uploadWay) throws Exception {
        this.documentServerHandler = LogicUtils.getDocumentServerByUploadWay((String)uploadWay);
        this.documentServerHandler.initServer();
    }

    public OperationResult excute(Object[] ids) throws Exception {
        super.excute(ids);
        String billType = this.billEntityType.getName();
        if (ids == null) {
            return null;
        }
        DynamicObject imageDynamicObject = ImageServerUtil.getImageDynamicObject();
        if (imageDynamicObject == null) {
            OperationResult result = this.createErrorResult(ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u5f52\u6863\u670d\u52a1\u5668\u3002", (String)"ReverseFilingOpService_1", (String)"fi-aef-opplugin", (Object[])new Object[0]));
            return result;
        }
        String uploadway = imageDynamicObject.getString("uploadway");
        List idLists = ArchieveBatchUtil.splitIds((Object[])ids, (int)1000);
        OperationResult result = new OperationResult();
        boolean isSupport = SysParamConfig.getBoolean((String)"support_fi_archive_new", (boolean)true);
        String message = ArchiveUtil.getServerConfig((OperateOption)this.getOption());
        if (!StringUtils.isEmpty((CharSequence)message)) {
            throw new KDBizException(message);
        }
        if (isSupport) {
            this.initDocumentServerHandler(uploadway);
            for (List idList : idLists) {
                result = this.getDocumentServerHandler().executeReveral(idList, result, this.billEntityType, this.getOption(), threadPoolCash);
                if (!result.isSuccess() || "3".equals(uploadway) || "5".equals(uploadway) || "6".equals(uploadway)) continue;
                result.getSuccessPkIds().addAll(idList);
            }
            return result;
        }
        if ("1".equals(uploadway)) {
            boolean isRpt = "aef_acelre_rpt".equals(billType);
            for (List idList : idLists) {
                result = this.deleteImagesByDowJones(idList, result, isRpt);
                if (!result.isSuccess()) continue;
                result.getSuccessPkIds().addAll(idList);
            }
            if (!result.isSuccess()) {
                return result;
            }
        } else if ("2".equals(uploadway)) {
            for (List idList : idLists) {
                result = this.deleteImagesByFtp(idList, result);
                if (!result.isSuccess()) continue;
                result.getSuccessPkIds().addAll(idList);
            }
            if (!result.isSuccess()) {
                return result;
            }
        } else if ("3".equals(uploadway) || "5".equals(uploadway) || "6".equals(uploadway)) {
            for (List idList : idLists) {
                if ("aef_acelre_rpt".equals(billType)) {
                    result = this.deleteRptByFpy(idList, result, imageDynamicObject);
                    continue;
                }
                if ("aef_acelre_tax".equals(billType)) {
                    result = this.deleteTaxByFpy(idList, result, imageDynamicObject);
                    continue;
                }
                result = this.deleteImagesByFpy(idList, result, imageDynamicObject);
            }
            if (!result.isSuccess()) {
                return result;
            }
        }
        return result;
    }

    private OperationResult deleteImagesByDowJones(List<Long> idList, OperationResult result, boolean isRpt) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])idList.toArray(new Long[0]), (DynamicObjectType)this.billEntityType);
        result.setBillCount(result.getBillCount() + dynamicObjects.length);
        idList.clear();
        for (int i = 0; i < dynamicObjects.length; ++i) {
            OperateErrorInfo error;
            Long billid = dynamicObjects[i].getLong("billid");
            String billType = isRpt ? dynamicObjects[i].getString("billtype") : dynamicObjects[i].getDynamicObject("billtype").getString("number");
            try {
                boolean flag = DowJonesVideoImp.deleteBillInfo((String)billType, (Long)billid);
                if (flag) {
                    idList.add(dynamicObjects[i].getLong("id"));
                    continue;
                }
                result.setSuccess(false);
                error = this.createOperateErrorInfo(dynamicObjects[i].getString("billno"));
                result.addErrorInfo(error);
                DeleteServiceHelper.delete((String)"aef_acelre", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
                continue;
            }
            catch (BillNotExistException be) {
                if (JudgeBillType.isFinaceRpt((String)billType)) {
                    idList.add(dynamicObjects[i].getLong("id"));
                    continue;
                }
                result.setSuccess(false);
                error = this.createOperateErrorInfo(dynamicObjects[i].getString("billno"));
                result.addErrorInfo(error);
                continue;
            }
            catch (CannotConnectToSysException e) {
                result.setSuccess(false);
                error = this.createOperateErrorInfo(dynamicObjects[i].getString("billno"));
                result.addErrorInfo(error);
            }
        }
        DeleteServiceHelper.delete((String)"aef_acelre", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
        return result;
    }

    private OperationResult deleteImagesByFtp(List<Long> idList, OperationResult result) {
        ArrayList<Long> imageList = new ArrayList<Long>();
        result.setBillCount(result.getBillCount() + idList.size());
        QFilter idFilter = new QFilter("id", "in", idList);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ReverseFilingOpService.deleteImagesByFtp", (String)this.billEntityType.getName(), (String)"id,billno,billid,billtype", (QFilter[])new QFilter[]{idFilter}, null);
        HashMap<String, List> map = new HashMap<String, List>();
        for (Row row : dataSet) {
            String billType = row.getString("billtype");
            Long billid = row.getLong("billid");
            if (!map.containsKey(billType)) {
                ArrayList<Long> idlist = new ArrayList<Long>();
                idlist.add(billid);
                map.put(billType, idlist);
                continue;
            }
            List tempList = (List)map.get(billType);
            tempList.add(billid);
            map.put(billType, tempList);
        }
        ArrayList<Long> billidlist = new ArrayList<Long>();
        for (Map.Entry entry : map.entrySet()) {
            try {
                QFilter billidFilter = new QFilter("billid", "in", entry.getValue());
                QFilter billTypeFilter = new QFilter("billtype.id", "=", entry.getKey());
                QFilter[] filters = new QFilter[]{billidFilter, billTypeFilter};
                DynamicObjectCollection dyns = QueryServiceHelper.query((String)"aef_archieve_imagepath", (String)"id,billid,imagepath", (QFilter[])filters);
                for (DynamicObject image : dyns) {
                    this.imageService.delete(image.getString("imagepath"));
                    imageList.add(image.getLong("id"));
                    billidlist.add(image.getLong("billid"));
                }
            }
            catch (Exception e) {
                result.setSuccess(false);
                OperateErrorInfo errorInfo = this.createOperateErrorInfo(null);
                result.addErrorInfo(errorInfo);
            }
        }
        DeleteServiceHelper.delete((String)"aef_archieve_imagepath", (QFilter[])new QFilter[]{new QFilter("id", "in", imageList)});
        DeleteServiceHelper.delete((String)this.billEntityType.getName(), (QFilter[])new QFilter[]{new QFilter("billid", "in", billidlist)});
        return result;
    }

    private OperationResult deleteImagesByFpy(List<Long> idList, OperationResult result, DynamicObject imageConfig) {
        result.setBillCount(result.getBillCount() + idList.size());
        OperateOption option = this.buildOption(imageConfig);
        option.setVariableValue("isReverse", "2");
        option.setVariableValue("batchCode", UUID.randomUUID().toString());
        option.setVariableValue("traceId", TraceIdUtil.getCurrentTraceIdString());
        boolean issplitbookstr = SysParamConfig.getBoolean((String)"issplitbook", (boolean)true);
        option.setVariableValue("issplitbook", Boolean.toString(issplitbookstr));
        boolean isSupportGeneralledgerNew = SysParamConfig.getBoolean((String)"support_gl_rpt_generalledger_new", (boolean)false);
        option.setVariableValue("support_gl_rpt_generalledger_new", Boolean.toString(isSupportGeneralledgerNew));
        List schemes = new ArrayList(100);
        try {
            schemes = SplitDataUtil.splitReverseFilingData(idList, (OperateOption)option);
        }
        catch (Exception e) {
            result.setSuccess(false);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5207\u5206\u53cd\u5f52\u6863\u65b9\u6848\u5931\u8d25\uff1a%s", (String)"ReverseFilingOpService_5", (String)"fi-aef-opplugin", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            OperateErrorInfo errorInfo = this.createOperateErrorInfo(errorMsg);
            result.addErrorInfo(errorInfo);
            logger.error((Throwable)e);
            logger.error(errorMsg);
            return result;
        }
        ArrayList<Future> resultList = new ArrayList<Future>(schemes.size());
        for (SchemeEntry scheme : schemes) {
            Future future = threadPoolCash.submit((Callable)new ArchivePageEngin(scheme, option));
            resultList.add(future);
        }
        result.setSuccess(true);
        for (Future taskResult : resultList) {
            OperateErrorInfo errorInfo;
            try {
                if (!((ArchiveResult)taskResult.get()).getIsSuccess().booleanValue()) {
                    result.setSuccess(false);
                    if (((ArchiveResult)taskResult.get()).getErrorMessages().size() > 0) {
                        for (String errorMessage : ((ArchiveResult)taskResult.get()).getErrorMessages()) {
                            errorInfo = new OperateErrorInfo();
                            errorInfo.setLevel(ErrorLevel.Error);
                            errorInfo.setMessage(errorMessage);
                            result.addErrorInfo(errorInfo);
                        }
                        result.getSuccessPkIds().addAll(((ArchiveResult)taskResult.get()).getSuccessPkIds());
                        continue;
                    }
                    OperateErrorInfo errorInfo2 = new OperateErrorInfo();
                    errorInfo2.setLevel(ErrorLevel.Error);
                    errorInfo2.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u53cd\u5f52\u6863\u5931\u8d25\u3002", (String)"ReverseFilingOpService_2", (String)"fi-aef-opplugin", (Object[])new Object[0]), ((ArchiveResult)taskResult.get()).getBillTypes().toString()));
                    result.addErrorInfo(errorInfo2);
                    continue;
                }
                result.getSuccessPkIds().addAll(((ArchiveResult)taskResult.get()).getSuccessPkIds());
            }
            catch (Exception e) {
                result.setSuccess(false);
                String errorMsg = String.format(ResManager.loadKDString((String)"\u53cd\u5f52\u6863\u5931\u8d25\uff1a%s", (String)"ReverseFilingOpService_4", (String)"fi-aef-opplugin", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                errorInfo = this.createOperateErrorInfo(errorMsg);
                result.addErrorInfo(errorInfo);
                logger.error((Throwable)e);
                logger.error(errorMsg);
                return result;
            }
        }
        return result;
    }

    private OperationResult deleteRptByFpy(List<Long> idList, OperationResult result, DynamicObject imageConfig) {
        result.setBillCount(result.getBillCount() + idList.size());
        OperateOption option = this.buildOption(imageConfig);
        option.setVariableValue("isReverse", "2");
        option.setVariableValue("batchCode", UUID.randomUUID().toString());
        option.setVariableValue("archivetype", "reportform");
        option.setVariableValue("traceId", TraceIdUtil.getCurrentTraceIdString());
        List schemes = new ArrayList(100);
        try {
            schemes = SplitDataUtil.splitReverseRpt(idList);
        }
        catch (Exception e) {
            result.setSuccess(false);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u62a5\u8868\u5207\u5206\u53cd\u5f52\u6863\u65b9\u6848\u5931\u8d25\uff1a%s", (String)"ReverseFilingOpService_6", (String)"fi-aef-opplugin", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            OperateErrorInfo errorInfo = this.createOperateErrorInfo(errorMsg);
            result.addErrorInfo(errorInfo);
            logger.error((Throwable)e);
            logger.error(errorMsg);
            return result;
        }
        ArrayList<Future> resultList = new ArrayList<Future>(schemes.size());
        for (SchemeEntry scheme : schemes) {
            Future future = threadPoolCash.submit((Callable)new ArchivePageEngin(scheme, option));
            resultList.add(future);
        }
        result.setSuccess(true);
        for (Future taskResult : resultList) {
            OperateErrorInfo errorInfo;
            try {
                if (!((ArchiveResult)taskResult.get()).getIsSuccess().booleanValue()) {
                    result.setSuccess(false);
                    if (((ArchiveResult)taskResult.get()).getErrorMessages().size() > 0) {
                        for (String errorMessage : ((ArchiveResult)taskResult.get()).getErrorMessages()) {
                            errorInfo = new OperateErrorInfo();
                            errorInfo.setLevel(ErrorLevel.Error);
                            errorInfo.setMessage(errorMessage);
                            result.addErrorInfo(errorInfo);
                        }
                        result.getSuccessPkIds().addAll(((ArchiveResult)taskResult.get()).getSuccessPkIds());
                        continue;
                    }
                    OperateErrorInfo errorInfo2 = new OperateErrorInfo();
                    errorInfo2.setLevel(ErrorLevel.Error);
                    errorInfo2.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u53cd\u5f52\u6863\u5931\u8d25\u3002", (String)"ReverseFilingOpService_2", (String)"fi-aef-opplugin", (Object[])new Object[0]), ((ArchiveResult)taskResult.get()).getBillTypes().toString()));
                    result.addErrorInfo(errorInfo2);
                    continue;
                }
                result.getSuccessPkIds().addAll(((ArchiveResult)taskResult.get()).getSuccessPkIds());
            }
            catch (Exception e) {
                result.setSuccess(false);
                String errorMsg = String.format(ResManager.loadKDString((String)"\u53cd\u5f52\u6863\u5931\u8d25\uff1a%s", (String)"ReverseFilingOpService_4", (String)"fi-aef-opplugin", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                errorInfo = this.createOperateErrorInfo(errorMsg);
                result.addErrorInfo(errorInfo);
                logger.error((Throwable)e);
                logger.error(errorMsg);
                return result;
            }
        }
        return result;
    }

    private OperationResult deleteTaxByFpy(List<Long> idList, OperationResult result, DynamicObject imageConfig) {
        result.setBillCount(result.getBillCount() + idList.size());
        OperateOption option = this.buildOption(imageConfig);
        option.setVariableValue("isReverse", "2");
        option.setVariableValue("batchCode", UUID.randomUUID().toString());
        option.setVariableValue("archivetype", "tax");
        option.setVariableValue("traceId", TraceIdUtil.getCurrentTraceIdString());
        List schemes = new ArrayList(100);
        try {
            schemes = SplitDataUtil.splitReverseTax(idList);
        }
        catch (Exception e) {
            result.setSuccess(false);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u5207\u5206\u53cd\u5f52\u6863\u65b9\u6848\u5931\u8d25\uff1a%s", (String)"ReverseFilingOpService_7", (String)"fi-aef-opplugin", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            OperateErrorInfo errorInfo = this.createOperateErrorInfo(errorMsg);
            result.addErrorInfo(errorInfo);
            logger.error((Throwable)e);
            logger.error(errorMsg);
            return result;
        }
        ArrayList<Future> resultList = new ArrayList<Future>(schemes.size());
        for (SchemeEntry scheme : schemes) {
            Future future = threadPoolCash.submit((Callable)new ArchivePageEngin(scheme, option));
            resultList.add(future);
        }
        result.setSuccess(true);
        for (Future taskResult : resultList) {
            OperateErrorInfo errorInfo;
            try {
                if (!((ArchiveResult)taskResult.get()).getIsSuccess().booleanValue()) {
                    result.setSuccess(false);
                    if (((ArchiveResult)taskResult.get()).getErrorMessages().size() > 0) {
                        for (String errorMessage : ((ArchiveResult)taskResult.get()).getErrorMessages()) {
                            errorInfo = new OperateErrorInfo();
                            errorInfo.setLevel(ErrorLevel.Error);
                            errorInfo.setMessage(errorMessage);
                            result.addErrorInfo(errorInfo);
                        }
                        result.getSuccessPkIds().addAll(((ArchiveResult)taskResult.get()).getSuccessPkIds());
                        continue;
                    }
                    OperateErrorInfo errorInfo2 = new OperateErrorInfo();
                    errorInfo2.setLevel(ErrorLevel.Error);
                    errorInfo2.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u53cd\u5f52\u6863\u5931\u8d25\u3002", (String)"ReverseFilingOpService_2", (String)"fi-aef-opplugin", (Object[])new Object[0]), ((ArchiveResult)taskResult.get()).getBillTypes().toString()));
                    result.addErrorInfo(errorInfo2);
                    continue;
                }
                result.getSuccessPkIds().addAll(((ArchiveResult)taskResult.get()).getSuccessPkIds());
            }
            catch (Exception e) {
                result.setSuccess(false);
                String errorMsg = String.format(ResManager.loadKDString((String)"\u53cd\u5f52\u6863\u5931\u8d25\uff1a%s", (String)"ReverseFilingOpService_4", (String)"fi-aef-opplugin", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                errorInfo = this.createOperateErrorInfo(errorMsg);
                result.addErrorInfo(errorInfo);
                logger.error((Throwable)e);
                logger.error(errorMsg);
                return result;
            }
        }
        return result;
    }

    private OperateOption buildOption(DynamicObject imageConfig) {
        OperateOption option = this.getOption();
        String uploadway = imageConfig.getString("uploadway");
        String serviceip = imageConfig.getString("serviceip");
        String serviceport = imageConfig.getString("serviceport");
        String requestway = imageConfig.getString("requestway");
        option.setVariableValue("archivesCode", imageConfig.getString("username"));
        option.setVariableValue("uploadway", uploadway);
        return option;
    }

    private OperateErrorInfo createOperateErrorInfo(String billNo) {
        OperateErrorInfo errorInfo = new OperateErrorInfo();
        errorInfo.setLevel(ErrorLevel.Error);
        errorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u53cd\u5f52\u6863\u5931\u8d25\u3002", (String)"ReverseFilingOpService_2", (String)"fi-aef-opplugin", (Object[])new Object[0]), billNo));
        return errorInfo;
    }

    private OperationResult createErrorResult(String errorMsg) {
        OperationResult result = new OperationResult();
        result.setSuccess(false);
        OperateErrorInfo errorInfo = new OperateErrorInfo();
        errorInfo.setLevel(ErrorLevel.FatalError);
        if (errorMsg != null) {
            errorInfo.setMessage(errorMsg);
        }
        result.addErrorInfo(errorInfo);
        result.setShowMessage(true);
        return result;
    }

    protected void executeOperate(DynamicObject[] arg0) {
    }
}

