/*
 * Decompiled with CFR 0.152.
 */
package fi.aef.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class TraceImageView
extends FormOperate {
    private static final String VOUCHERID = "voucherid";

    protected OperationResult invokeOperation() {
        String billType = this.getEntityId();
        HashSet<Long> billIds = this.getSelectedBillIds();
        if (billIds == null || billIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"TraceImageView_0", (String)"bos-ext-fi", (Object[])new Object[0]));
            return null;
        }
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        Long billId = (Long)billIds.iterator().next();
        qfilters.add(new QFilter("billid", "=", (Object)billId));
        qfilters.add(new QFilter("billtype.number", "=", (Object)billType));
        DynamicObject dyns = QueryServiceHelper.queryOne((String)"aef_acelre", (String)"id,uploadway", (QFilter[])qfilters.toArray(new QFilter[0]));
        Map<String, Set<Long>> map = this.showImage(billId, billType);
        if (dyns == null && (map == null || map.isEmpty())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u65e0\u53ef\u67e5\u770b\u5f71\u50cf\u3002", (String)"TraceImageView_1", (String)"bos-ext-fi", (Object[])new Object[0]));
            return null;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("aef_image_imageview");
        showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
        showParameter.setCustomParam("billType", (Object)billType);
        showParameter.setCustomParam("billId", (Object)billId);
        if (dyns != null) {
            showParameter.setCustomParam("uploadway", (Object)dyns.getString("uploadway"));
        }
        showParameter.setCustomParam("bfRowLinkUp", (Object)SerializationUtils.serializeToBase64(map));
        this.getView().showForm(showParameter);
        return null;
    }

    private Map<String, Set<Long>> showImage(Long voucherId, String billType) {
        if ("gl_voucher".equals(billType)) {
            HashSet<Long> ids = new HashSet<Long>();
            ids.add(voucherId);
            Map<Long, Map<String, Set<Long>>> map = this.getLinkUpBills(ids);
            return map.get(voucherId);
        }
        return this.getLinkUpForCommonBills(billType, voucherId);
    }

    private Map<String, Set<Long>> getLinkUpForCommonBills(String billType, Long billId) {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>();
        HashMap<Long, String> typeCache = new HashMap<Long, String>();
        List linkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)billType, (String)"", (Long[])new Long[]{billId});
        this.getChildNodes(map, linkUpNodes, typeCache);
        return map;
    }

    private void getChildNodes(Map<String, Set<Long>> map, List<BFRowLinkUpNode> linkUpNodes, Map<Long, String> typeCache) {
        for (BFRowLinkUpNode node : linkUpNodes) {
            BFRowId rowId = node.getRowId();
            String entityNumber = this.findType(rowId, typeCache);
            if (node.findAllSourceNodes() != null && !node.findAllSourceNodes().isEmpty()) {
                this.putDataToMap(map, entityNumber, node.getRowId());
                this.getChildNodes(map, node.findAllSourceNodes(), typeCache);
                continue;
            }
            this.putDataToMap(map, entityNumber, node.getRowId());
        }
    }

    private Map<Long, Map<String, Set<Long>>> getLinkUpBills(Set<Long> ids) {
        HashMap<Long, String> typeCache = new HashMap<Long, String>();
        HashMap<Long, Map<String, Set<Long>>> map = new HashMap<Long, Map<String, Set<Long>>>();
        HashMap billtypeAndId = new HashMap();
        HashMap<String, Long> voucherBilltypeMap = new HashMap<String, Long>();
        QFilter qFilter = new QFilter(VOUCHERID, "in", ids);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.aef.common.util.AefUtil.getLinkUpBills", (String)"ai_daptracker", (String)"voucherid,billtype,sourcebillid", (QFilter[])qFilter.toArray(), null);){
            for (Row row : dataSet) {
                Long vourcherId = row.getLong(VOUCHERID);
                String billType = row.getString("billtype");
                Long sourcebillid = row.getLong("sourcebillid");
                voucherBilltypeMap.put(billType + sourcebillid, vourcherId);
                if (billtypeAndId.containsKey(billType)) {
                    ((Set)billtypeAndId.get(billType)).add(sourcebillid);
                    continue;
                }
                HashSet<Long> set = new HashSet<Long>();
                set.add(sourcebillid);
                billtypeAndId.put(billType, set);
            }
        }
        for (Map.Entry sourceentry : billtypeAndId.entrySet()) {
            List linkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)((String)sourceentry.getKey()), (String)"", (Long[])((Set)sourceentry.getValue()).toArray(new Long[0]));
            this.getChildNodes(map, (List<BFRowLinkUpNode>)linkUpNodes, voucherBilltypeMap, typeCache);
        }
        return map;
    }

    private void getChildNodes(Map<Long, Map<String, Set<Long>>> map, List<BFRowLinkUpNode> linkUpNodes, Map<String, Long> voucherBilltypeMap, Map<Long, String> typeCache) {
        for (BFRowLinkUpNode node : linkUpNodes) {
            BFRowId rowId = node.getRowId();
            String entityNumber = this.findType(rowId, typeCache);
            Long voucherId = voucherBilltypeMap.get(entityNumber + rowId.getBillId());
            if (node.findAllSourceNodes() != null && !node.findAllSourceNodes().isEmpty()) {
                this.putDataToMap(map, voucherId, entityNumber, node.getRowId());
                this.getChildNodes(map, (List<BFRowLinkUpNode>)node.findAllSourceNodes(), voucherId, typeCache);
                continue;
            }
            this.putDataToMap(map, voucherId, entityNumber, node.getRowId());
        }
    }

    private void getChildNodes(Map<Long, Map<String, Set<Long>>> map, List<BFRowLinkUpNode> findAllSourceNodes, Long voucherId, Map<Long, String> typeCache) {
        for (BFRowLinkUpNode node : findAllSourceNodes) {
            BFRowId rowId = node.getRowId();
            String entityNumber = this.findType(rowId, typeCache);
            if (node.findAllSourceNodes() != null && !node.findAllSourceNodes().isEmpty()) {
                this.putDataToMap(map, voucherId, entityNumber, node.getRowId());
                this.getChildNodes(map, (List<BFRowLinkUpNode>)node.findAllSourceNodes(), voucherId, typeCache);
                continue;
            }
            this.putDataToMap(map, voucherId, entityNumber, node.getRowId());
        }
    }

    private void putDataToMap(Map<String, Set<Long>> map, String entityNumber, BFRowId rowId) {
        if (map.containsKey(entityNumber)) {
            map.get(entityNumber).add(rowId.getBillId());
        } else {
            HashSet<Long> set = new HashSet<Long>();
            set.add(rowId.getBillId());
            map.put(entityNumber, set);
        }
    }

    private void putDataToMap(Map<Long, Map<String, Set<Long>>> map, Long voucherId, String entityNumber, BFRowId bfRowId) {
        if (map.containsKey(voucherId)) {
            Map<String, Set<Long>> dataMap = map.get(voucherId);
            if (dataMap.containsKey(entityNumber)) {
                dataMap.get(entityNumber).add(bfRowId.getBillId());
                map.put(voucherId, dataMap);
            } else {
                HashSet<Long> set = new HashSet<Long>();
                set.add(bfRowId.getBillId());
                dataMap.put(entityNumber, set);
                map.put(voucherId, dataMap);
            }
        } else {
            HashMap dataMap = new HashMap();
            HashSet<Long> set = new HashSet<Long>();
            set.add(bfRowId.getBillId());
            dataMap.put(entityNumber, set);
            map.put(voucherId, dataMap);
        }
    }

    private String findType(BFRowId rowId, Map<Long, String> typeCache) {
        long tableId = 0L;
        if (rowId != null) {
            tableId = rowId.getMainTableId();
        }
        String type = null;
        if (typeCache.containsKey(tableId)) {
            type = typeCache.get(tableId);
        } else {
            TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)tableId);
            type = tableDefine.getEntityNumber();
            typeCache.put(tableId, type);
        }
        return type;
    }

    protected HashSet<Long> getSelectedBillIds() {
        IBillView billView;
        IBillModel billModel;
        HashSet<Long> billIds = new HashSet<Long>();
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            for (ListSelectedRow row : listView.getSelectedRows()) {
                Long billId;
                if (!(row.getPrimaryKeyValue() instanceof Long) || billIds.contains(billId = (Long)row.getPrimaryKeyValue())) continue;
                billIds.add(billId);
            }
        } else if (this.getView() instanceof IBillView && (billModel = (IBillModel)(billView = (IBillView)this.getView()).getModel()).getPKValue() instanceof Long) {
            Long billId = (Long)billModel.getPKValue();
            billIds.add(billId);
        }
        return billIds;
    }
}

