/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.validate;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ArchiveSchemeSaveValidator
extends AbstractValidator {
    public void validate() {
        block12: for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String archivetype = (String)dataEntity.getValue("archivetype");
            DynamicObjectCollection dynObjs = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            if ("reportform".equals(archivetype)) {
                Long id;
                if (dynObjs.size() > 1) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u5f52\u6863\u7c7b\u578b\u201d\u4e3a\u62a5\u8868\u65f6\uff0c\u5f52\u6863\u6570\u636e\u4e0d\u652f\u6301\u914d\u7f6e\u591a\u5206\u5f55\u3002", (String)"ArchiveSchemeSaveValidator_9", (String)"fi-aef-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                if (null != (id = (Long)dataEntity.getBillPkId()) && id > 0L) {
                    QFilter[] qFilters = new QFilter[2];
                    qFilters[0] = new QFilter("wayid", "=", (Object)id);
                    if (QueryServiceHelper.exists((String)"aef_acelre", (QFilter[])qFilters)) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u5b58\u5728\u5bf9\u5e94\u7684\u5f52\u6863\u8bb0\u5f55\uff0c\u4e0d\u80fd\u4fee\u6539\u3002", (String)"ArchiveSchemeSaveValidator_7", (String)"fi-aef-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    }
                }
            }
            HashSet<String> bills = new HashSet<String>(16);
            HashSet<String> appIdSet = new HashSet<String>(16);
            HashSet<String> ticctTypes = new HashSet<String>(16);
            int rowIndex = 0;
            for (DynamicObject dynObj : dynObjs) {
                ++rowIndex;
                String number = dynObj.getString("billtype.number");
                if (bills.contains(number)) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f52\u6863\u6570\u636e\u7684\u201c\u5355\u636e\u7c7b\u578b\u201d\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ArchiveSchemeSaveValidator_8", (String)"fi-aef-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    continue block12;
                }
                switch (archivetype) {
                    case "finance": {
                        this.checkFinanceCrossApp(dataEntity, appIdSet, number);
                        this.commonValidate(dataEntity, dynObj, rowIndex);
                        break;
                    }
                    case "bill": {
                        String content2;
                        this.commonValidate(dataEntity, dynObj, rowIndex);
                        if (StringUtils.isBlank((CharSequence)dynObj.getString("datefield"))) {
                            content2 = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5f52\u6863\u6570\u636e\u201d\u7b2c%s\u884c\uff1a\u201c\u5f52\u6863\u65e5\u671f\u201d\u3002", (String)"ArchiveSchemeSaveValidator_2", (String)"fi-aef-opplugin", (Object[])new Object[0]), rowIndex);
                            this.addMessage(dataEntity, content2, ErrorLevel.Error);
                        }
                        if (!"1".equals(dynObj.getString("isneedattachfile")) || !StringUtils.isBlank((CharSequence)dynObj.getString("attachtab"))) break;
                        String content3 = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5f52\u6863\u6570\u636e\u201d\u7b2c%s\u884c\uff1a\u201c\u9644\u4ef6\u9875\u7b7e\u201d\u3002", (String)"ArchiveSchemeSaveValidator_10", (String)"fi-aef-opplugin", (Object[])new Object[0]), rowIndex);
                        this.addMessage(dataEntity, content3, ErrorLevel.Error);
                        break;
                    }
                    case "reportform": {
                        if (!StringUtils.isBlank((CharSequence)dynObj.getString("archiverangereport"))) break;
                        String content2 = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5f52\u6863\u6570\u636e\u201d\u7b2c%s\u884c\uff1a\u201c\u5f52\u6863\u8303\u56f4\u201d\u3002", (String)"ArchiveSchemeSaveValidator_3", (String)"fi-aef-opplugin", (Object[])new Object[0]), rowIndex);
                        this.addMessage(dataEntity, content2, ErrorLevel.Error);
                        break;
                    }
                    case "tax": {
                        Map rangeMap = (Map)SerializationUtils.fromJsonString((String)dynObj.getString("archiverangereport"), Map.class);
                        String taxticcttype = (String)rangeMap.get("taxticcttype");
                        if (ticctTypes.contains(taxticcttype)) {
                            String content2 = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff1a\u201c\u7533\u62a5\u8868\u7c7b\u578b\u4e0d\u80fd\u91cd\u590d\u201d\u3002", (String)"ArchiveSchemeSaveValidator_13", (String)"fi-aef-opplugin", (Object[])new Object[0]), rowIndex);
                            this.addMessage(dataEntity, content2, ErrorLevel.Error);
                        }
                        this.taxValidate(dataEntity, dynObj, rowIndex);
                        break;
                    }
                }
                if ("tcvat_nsrxx".equals(number)) {
                    String string = dynObj.getString("archiverangereport");
                    if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                    Map rangeMap = (Map)SerializationUtils.fromJsonString((String)string, Map.class);
                    String taxticcttype = (String)rangeMap.get("taxticcttype");
                    ticctTypes.add(taxticcttype);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)number)) continue;
                bills.add(number);
            }
        }
    }

    private void checkFinanceCrossApp(ExtendedDataEntity dataEntity, Set<String> appIdSet, String number) {
        if (StringUtils.isEmpty((CharSequence)number)) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)number);
        String appId = dataEntityType.getAppId();
        appIdSet.add(appId);
        if (appIdSet.size() > 1) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u5f52\u6863\u65b9\u6848\u4e0d\u80fd\u8de8\u5e94\u7528\u5f52\u6863\u6570\u636e\u3002", (String)"ArchiveSchemeSaveValidator_14", (String)"fi-aef-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private void taxValidate(ExtendedDataEntity dataEntity, DynamicObject dynObj, int rowIndex) {
        String content;
        String taxarchivedata = dynObj.getString("taxarchivedata");
        if (StringUtils.isBlank((CharSequence)taxarchivedata)) {
            content = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7b2c%s\u884c\uff1a\u201c\u5f52\u6863\u8d44\u6599\u201d\u3002", (String)"ArchiveSchemeSaveValidator_11", (String)"fi-aef-opplugin", (Object[])new Object[0]), rowIndex);
            this.addMessage(dataEntity, content, ErrorLevel.Error);
        }
        if (StringUtils.isBlank((CharSequence)dynObj.getString("billtype"))) {
            content = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5f52\u6863\u6570\u636e\u201d\u7b2c%s\u884c\uff1a\u201c\u5355\u636e\u7c7b\u578b\u201d\u3002", (String)"ArchiveSchemeSaveValidator_5", (String)"fi-aef-opplugin", (Object[])new Object[0]), rowIndex);
            this.addMessage(dataEntity, content, ErrorLevel.Error);
        }
        if ("tccit".equals(taxarchivedata) && dynObj.get("taxticcttype") == null) {
            content = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7b2c%s\u884c\uff1a\u201c\u7533\u62a5\u8868\u7c7b\u578b\u201d\u3002", (String)"ArchiveSchemeSaveValidator_12", (String)"fi-aef-opplugin", (Object[])new Object[0]), rowIndex);
            this.addMessage(dataEntity, content, ErrorLevel.Error);
        }
        if ("bill".equals(taxarchivedata)) {
            if (StringUtils.isBlank((CharSequence)dynObj.getString("datefield"))) {
                String content2 = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5f52\u6863\u6570\u636e\u201d\u7b2c%s\u884c\uff1a\u201c\u5f52\u6863\u65e5\u671f\u201d\u3002", (String)"ArchiveSchemeSaveValidator_2", (String)"fi-aef-opplugin", (Object[])new Object[0]), rowIndex);
                this.addMessage(dataEntity, content2, ErrorLevel.Error);
            }
            if (StringUtils.isBlank((CharSequence)dynObj.getString("printtemplate_display"))) {
                content = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5f52\u6863\u6570\u636e\u201d\u7b2c%s\u884c\uff1a\u201c\u9002\u7528\u6a21\u677f\u201d\u3002", (String)"ArchiveSchemeSaveValidator_6", (String)"fi-aef-opplugin", (Object[])new Object[0]), rowIndex);
                this.addMessage(dataEntity, content, ErrorLevel.Error);
            }
        }
    }

    private void commonValidate(ExtendedDataEntity dataEntity, DynamicObject dynObj, int rowIndex) {
        String content;
        if (StringUtils.isBlank((CharSequence)dynObj.getString("billtype"))) {
            content = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5f52\u6863\u6570\u636e\u201d\u7b2c%s\u884c\uff1a\u201c\u5355\u636e\u7c7b\u578b\u201d\u3002", (String)"ArchiveSchemeSaveValidator_5", (String)"fi-aef-opplugin", (Object[])new Object[0]), rowIndex);
            this.addMessage(dataEntity, content, ErrorLevel.Error);
        }
        if (StringUtils.isBlank((CharSequence)dynObj.getString("printtemplate_display"))) {
            if (Boolean.TRUE.equals(dataEntity.getValue("isxbrlpilot")) && "bill".equals(dataEntity.getValue("archivetype"))) {
                return;
            }
            content = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5f52\u6863\u6570\u636e\u201d\u7b2c%s\u884c\uff1a\u201c\u9002\u7528\u6a21\u677f\u201d\u3002", (String)"ArchiveSchemeSaveValidator_6", (String)"fi-aef-opplugin", (Object[])new Object[0]), rowIndex);
            this.addMessage(dataEntity, content, ErrorLevel.Error);
        }
    }
}

