/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.common;

import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.impl.RequestContextRunnable;
import kd.fi.aef.cache.CacheHelper;
import kd.fi.aef.cache.CacheModule;
import kd.fi.aef.cache.DistributeCache;
import kd.fi.aef.entity.ArchiveResult;
import kd.fi.aef.entity.SchemeEntry;

public class ArchiveEngin
implements Callable<ArchiveResult> {
    private RequestContext requestCtx;
    private Long orgId;
    private SchemeEntry schemes;
    private OperateOption option;
    private ArchiveResult archiveResult = new ArchiveResult();
    private String taskId;
    private DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.archive);
    private static final Log logger = LogFactory.getLog(ArchiveEngin.class);

    public ArchiveEngin(Long orgId, SchemeEntry scheme, OperateOption option, RequestContext requestCtx) {
        this.requestCtx = requestCtx;
        this.orgId = orgId;
        this.schemes = scheme;
        this.option = option;
        this.taskId = scheme.getPageId();
    }

    @Override
    public ArchiveResult call() throws Exception {
        new RequestContextRunnable(new Runnable(){

            @Override
            public void run() {
            }
        }, this.requestCtx).run();
        return this.archiveResult;
    }

    private void updateHasArchiveCount(String taskId) {
        String key = taskId + "finishedBill";
        int finishedBill = this.cache.get(key) == null ? 0 : Integer.parseInt(this.cache.get(key));
        this.cache.put(key, String.valueOf(++finishedBill));
    }

    private void addErrMsg(String taskId, String errMsg, String logMsg) {
        this.cache.put(taskId + "isSuccess", String.valueOf(false));
        this.cache.put(taskId + "errorMsg", errMsg);
        logger.info(logMsg);
        this.archiveResult.setIsSuccess(Boolean.FALSE);
    }
}

