/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.common.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class AccountUtil {
    public static Map<Long, String> getGlAccountNumberBySubledger(Set<Long> accountIds, Long accountTableId) {
        Serializable parentId;
        HashMap<Long, String> idAndGlAccountName = new HashMap<Long, String>(accountIds.size());
        HashMap<Long, Long> idAndParentId = new HashMap<Long, Long>();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getGlAccountNumberBySubledger", (String)"bd_accountview", (String)"id,parent.id parentid", (QFilter[])new QFilter("accounttable", "=", (Object)accountTableId).toArray(), null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                idAndParentId.put(row.getLong("id"), row.getLong("parentid"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        HashMap<Long, Long> idAndTopId = new HashMap<Long, Long>(100);
        for (Long accountId : accountIds) {
            parentId = AccountUtil.getParentId(accountId, idAndParentId);
            idAndTopId.put(accountId, (Long)parentId);
        }
        HashMap<Long, String> topidAndName = new HashMap<Long, String>();
        DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)"getTopAccountNumberBySubledger", (String)"bd_accountview", (String)"id,name", (QFilter[])new QFilter("id", "in", idAndTopId.values()).toArray(), null);
        parentId = null;
        try {
            for (Row row : dataSet2) {
                topidAndName.put(row.getLong("id"), row.getString("name"));
            }
        }
        catch (Throwable throwable) {
            parentId = throwable;
            throw throwable;
        }
        finally {
            if (dataSet2 != null) {
                if (parentId != null) {
                    try {
                        dataSet2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)parentId).addSuppressed(throwable);
                    }
                } else {
                    dataSet2.close();
                }
            }
        }
        for (Map.Entry entry : idAndTopId.entrySet()) {
            idAndGlAccountName.put((Long)entry.getKey(), (String)topidAndName.get(entry.getValue()));
        }
        return idAndGlAccountName;
    }

    private static Long getParentId(Long accountId, Map<Long, Long> idAndParentId) {
        Long id = idAndParentId.get(accountId);
        if (id == null || id == 0L) {
            return accountId;
        }
        return AccountUtil.getParentId(id, idAndParentId);
    }
}

