/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.common.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class AefUtil {
    public static Map<Long, Map<String, Set<Long>>> getLinkUpBills(Set<Long> ids) {
        QFilter voucherIdf = new QFilter("voucherid", "in", ids);
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)"ai_daptracker", (String)"billtype,sourcebillid,voucherid", (QFilter[])new QFilter[]{voucherIdf});
        HashMap<Long, Map<String, Set<Long>>> map = new HashMap<Long, Map<String, Set<Long>>>(20);
        for (DynamicObject dyo : dyos) {
            Long voucherId = dyo.getLong("voucherid");
            String billType = dyo.getString("billtype");
            Long sourceBillId = dyo.getLong("sourcebillid");
            map.computeIfAbsent(voucherId, value -> new HashMap()).computeIfAbsent(billType, v -> new HashSet()).add(sourceBillId);
            Map sourceTypeBillIdMap = BFTrackerServiceHelper.findSourceBills((String)billType, (Long[])new Long[]{sourceBillId});
            for (Map.Entry sourceEntry : sourceTypeBillIdMap.entrySet()) {
                map.computeIfAbsent(voucherId, value -> new HashMap()).computeIfAbsent(sourceEntry.getKey(), v -> new HashSet()).addAll((Collection)sourceEntry.getValue());
            }
            Map targetTypeBillIdMap = BFTrackerServiceHelper.findTargetBills((String)billType, (Long[])new Long[]{sourceBillId});
            for (Map.Entry targetEntry : targetTypeBillIdMap.entrySet()) {
                map.computeIfAbsent(voucherId, value -> new HashMap()).computeIfAbsent(targetEntry.getKey(), v -> new HashSet()).addAll((Collection)targetEntry.getValue());
            }
        }
        QFilter bankQfilter1 = new QFilter("sourcebilltype", "=", (Object)"gl_voucher");
        QFilter bankQfilter2 = new QFilter("sourcebillid", "in", ids);
        DynamicObjectCollection bankdyos = QueryServiceHelper.query((String)"cas_bankjournal", (String)"sourcebilltype,sourcebillid,id", (QFilter[])new QFilter[]{bankQfilter1, bankQfilter2});
        for (DynamicObject dyo : bankdyos) {
            map.computeIfAbsent(dyo.getLong("sourcebillid"), value -> new HashMap()).computeIfAbsent("cas_bankjournal", v -> new HashSet()).add(dyo.getLong("id"));
        }
        return map;
    }

    public static Map<String, Set<Long>> getMainBills(Set<Long> ids) {
        QFilter voucherIdf = new QFilter("voucherid", "in", ids);
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)"ai_daptracker", (String)"billtype,sourcebillid,voucherid", (QFilter[])new QFilter[]{voucherIdf});
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(20);
        for (DynamicObject dyo : dyos) {
            Long voucherId = dyo.getLong("voucherid");
            String billType = dyo.getString("billtype");
            Long sourceBillId = dyo.getLong("sourcebillid");
            map.computeIfAbsent(billType, v -> new HashSet()).add(sourceBillId);
        }
        return map;
    }

    public static Map<String, Set<Long>> getLinkUpForCommonBills(String billType, Long billId) {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>();
        HashMap<Long, String> typeCache = new HashMap<Long, String>();
        List linkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)billType, (String)"", (Long[])new Long[]{billId});
        AefUtil.getChildNodes(map, linkUpNodes, typeCache);
        return map;
    }

    private static void getChildNodes(Map<String, Set<Long>> map, List<BFRowLinkUpNode> linkUpNodes, Map<Long, String> typeCache) {
        for (BFRowLinkUpNode node : linkUpNodes) {
            BFRowId rowId = node.getRowId();
            String entityNumber = AefUtil.findType(rowId, typeCache);
            if (node.findAllSourceNodes() != null && !node.findAllSourceNodes().isEmpty()) {
                AefUtil.putDataToMap(map, entityNumber, node.getRowId());
                AefUtil.getChildNodes(map, node.findAllSourceNodes(), typeCache);
                continue;
            }
            AefUtil.putDataToMap(map, entityNumber, node.getRowId());
        }
    }

    private static void putDataToMap(Map<String, Set<Long>> map, String entityNumber, BFRowId rowId) {
        if (map.containsKey(entityNumber)) {
            map.get(entityNumber).add(rowId.getBillId());
        } else {
            HashSet<Long> set = new HashSet<Long>();
            set.add(rowId.getBillId());
            map.put(entityNumber, set);
        }
    }

    private static String findType(BFRowId rowId, Map<Long, String> typeCache) {
        long tableId = 0L;
        if (rowId != null) {
            tableId = rowId.getMainTableId();
        }
        String type = null;
        if (typeCache.containsKey(tableId)) {
            type = typeCache.get(tableId);
        } else {
            TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)tableId);
            type = tableDefine.getEntityNumber();
            typeCache.put(tableId, type);
        }
        return type;
    }

    public static Map<String, Set<Long>> getVoucherLinkUpBillsInFast(Set<Long> voucherIds) {
        QFilter voucherIdf = new QFilter("voucherid", "in", voucherIds);
        DynamicObjectCollection dyos = QueryServiceHelper.query((String)"ai_daptracker", (String)"billtype,sourcebillid", (QFilter[])new QFilter[]{voucherIdf});
        Map<String, Set<Long>> groupedBill = AefUtil.groupDirectUpStreamBill(dyos);
        return groupedBill;
    }

    private static Map<String, Set<Long>> groupDirectUpStreamBill(DynamicObjectCollection dyos) {
        HashMap<String, Set<Long>> groupedBill = new HashMap<String, Set<Long>>();
        dyos.forEach(dyo -> {
            String billType = dyo.getString("billtype");
            groupedBill.computeIfAbsent(billType, value -> new HashSet()).add(dyo.getLong("sourcebillid"));
        });
        return groupedBill;
    }
}

