/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.common.util;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.aef.common.util.AccountUtil;
import kd.fi.aef.common.util.BizParamUtils;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.common.util.DowJonesVideoImp;
import kd.fi.aef.common.util.FieldMappingUtil;
import kd.fi.aef.entity.BillInfo;
import kd.fi.aef.helper.QueryFinanceBillHelper;

public class ArchiveUtil {
    public static final String AEF_FIELDMAPPING = "aef_fieldmapping";
    public static final List<String> INVOICELIST = Arrays.asList("er_tripreimbursebill", "er_dailyreimbursebill", "ap_finapbill", "er_publicreimbursebill", "ap_invoice");
    public static final String TEXT = "1";
    public static final String AMOUNT = "2";
    public static final String BASEDATA = "3";
    public static final String BOOL = "4";
    public static final String DATETIME = "5";
    public static final String NUMBER = "1";
    public static final String NAME = "2";
    public static final String NUMBERANDNAME = "3";

    public static void setDefaultJson(JSONObject json, String period) {
        if (!json.containsKey((Object)"WhetherInvoiceHasBeenDeducted")) {
            json.put("WhetherInvoiceHasBeenDeducted", (Object)"true");
        }
        if (!json.containsKey((Object)"TaxPeriodOfInvoiceDeduction")) {
            json.put("TaxPeriodOfInvoiceDeduction", (Object)period);
        }
        if (!json.containsKey((Object)"WhetherInvoiceUsageHasBeenConfirmed")) {
            json.put("WhetherInvoiceUsageHasBeenConfirmed", (Object)"false");
        }
        if (!json.containsKey((Object)"WhetherEinvoiceUsageHasBeenConfirmed")) {
            json.put("WhetherEinvoiceUsageHasBeenConfirmed", (Object)"false");
        }
        if (!json.containsKey((Object)"UsageConfirmation")) {
            json.put("UsageConfirmation", (Object)"");
        }
        if (!json.containsKey((Object)"PeriodOfUsageConfirmation")) {
            json.put("PeriodOfUsageConfirmation", (Object)"");
        }
        if (!json.containsKey((Object)"WhetherInputVatHasBeenTransferredOut")) {
            json.put("WhetherInputVatHasBeenTransferredOut", (Object)"false");
        }
        json.put("TotalTaxAm", json.get((Object)"TotalTaxAmount"));
        json.put("WhetherEinvoiceHasBeenBooked", (Object)"true");
        json.put("WhetherInvoiceHasBeenBooked", (Object)"true");
        json.put("WhetherReceiptHasBeenBooked", (Object)"true");
    }

    public static Map<String, DynamicObject> getTypeWithInvoice() {
        HashMap<String, DynamicObject> returnMap = new HashMap<String, DynamicObject>(16);
        QFilter qFilter2 = new QFilter("isinvoice", "=", (Object)"1");
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"aef_billconfig", (String)"billtype,servicename,appid", (QFilter[])new QFilter[]{qFilter2});
        for (DynamicObject dynamicObject : dyns) {
            returnMap.put(dynamicObject.getString("billtype"), dynamicObject);
        }
        return returnMap;
    }

    public static Map<String, DynamicObject> getTypeWithReceipt() {
        HashMap<String, DynamicObject> returnMap = new HashMap<String, DynamicObject>(16);
        QFilter qFilter2 = new QFilter("isreceipt", "=", (Object)"1");
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"aef_billconfig", (String)"billtype,servicename,appid", (QFilter[])new QFilter[]{qFilter2});
        for (DynamicObject dynamicObject : dyns) {
            returnMap.put(dynamicObject.getString("billtype"), dynamicObject);
        }
        return returnMap;
    }

    public static Map<String, Map<Long, Set<Long>>> getBillAndRefvoucherIds(Set<String> refBillTypes, Map<Long, Map<String, Set<Long>>> linkUpBills) {
        HashMap<String, Map<Long, Set<Long>>> map = new HashMap<String, Map<Long, Set<Long>>>();
        for (Map.Entry<Long, Map<String, Set<Long>>> entry : linkUpBills.entrySet()) {
            Long voucherid = entry.getKey();
            Map<String, Set<Long>> refBillMap = entry.getValue();
            for (Map.Entry<String, Set<Long>> sentry : refBillMap.entrySet()) {
                String billType = sentry.getKey();
                if (refBillTypes == null || !refBillTypes.contains(billType)) continue;
                Set<Long> billIds = sentry.getValue();
                for (Long billId : billIds) {
                    map.computeIfAbsent(billType, value -> new HashMap()).computeIfAbsent(billId, value -> new HashSet()).add(voucherid);
                }
            }
        }
        return map;
    }

    public static Map<String, Set<Long>> getRefBilltypeAndIds(Map<Long, Map<String, Set<Long>>> linkUpBills, Set<String> refBillTypes) {
        HashMap<String, Set<Long>> refBilltypeAndIds = new HashMap<String, Set<Long>>();
        if (refBillTypes == null || refBillTypes.isEmpty()) {
            return refBilltypeAndIds;
        }
        for (Map<String, Set<Long>> map : linkUpBills.values()) {
            for (Map.Entry<String, Set<Long>> m : map.entrySet()) {
                String key = m.getKey();
                if (!refBillTypes.contains(key)) continue;
                refBilltypeAndIds.computeIfAbsent(key, value -> new HashSet()).addAll((Collection)m.getValue());
            }
        }
        return refBilltypeAndIds;
    }

    public static Map<Long, JSONObject> getVoucherJson(Set<Long> buildXbrlVoucherIds, Map<Long, JSONObject> voucherHeadJson) {
        QFilter voucherFilter = new QFilter("id", "in", buildXbrlVoucherIds);
        HashSet<Long> accountIds = new HashSet<Long>(16);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"gl_voucher", (String)"id, entries.id, entries.account.name, entries.account.id, entries.account.accounttable.id", (QFilter[])new QFilter[]{voucherFilter});
        Long accountTableId = ((DynamicObject)dys.get(0)).getLong("entries.account.accounttable.id");
        for (DynamicObject dynamicObject : dys) {
            accountIds.add(dynamicObject.getLong("entries.account.id"));
        }
        Map<Long, String> getGlAccountName = AccountUtil.getGlAccountNumberBySubledger(accountIds, accountTableId);
        HashMap<Long, List> voucherentityJson = new HashMap<Long, List>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ArchiveUtil.getVoucherJson", (String)"gl_voucher", (String)"id, entries.id, entries.account.name, entries.account.id, entries.account.accounttable.id, entries.entrydc,entries.currency.name, entries.debitori, entries.creditori, entries.debitlocal, entries.creditlocal", (QFilter[])new QFilter[]{voucherFilter}, null);){
            for (Row row : dataSet) {
                Long id = row.getLong("id");
                List eneityList = voucherentityJson.computeIfAbsent(id, value -> new ArrayList());
                LinkedHashMap<String, Object> eneityMap = new LinkedHashMap<String, Object>(16);
                eneityMap.put("DebitOrCredit", "1".equals(row.getString("entries.entrydc")) ? ResManager.loadKDString((String)"\u501f", (String)"FPYXmlUtils_5", (String)"fi-aef-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d37", (String)"FPYXmlUtils_6", (String)"fi-aef-common", (Object[])new Object[0]));
                eneityMap.put("NameOfGeneralLedgerSubject", getGlAccountName.get(row.getLong("entries.account.id")));
                eneityMap.put("NameOfSubsidiaryLedgerSubject", row.getString("entries.account.name"));
                if ("1".equals(row.getString("entries.entrydc"))) {
                    eneityMap.put("RecordedAmount", row.getBigDecimal("entries.debitlocal"));
                } else {
                    eneityMap.put("RecordedAmount", row.getBigDecimal("entries.creditlocal"));
                }
                eneityList.add(eneityMap);
            }
        }
        HashMap<Long, JSONObject> voucherJson = new HashMap<Long, JSONObject>(16);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ArchiveUtil.getVoucherJson", (String)"gl_voucher", (String)"id,org.id org,org.uniformsocialcreditcode,org.name,org.city.name,billno,bookeddate,period.number periodnumber,vdescription", (QFilter[])new QFilter[]{voucherFilter}, null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                Long id = row.getLong("id");
                JSONObject jsonObject = new JSONObject(new LinkedHashMap());
                JSONObject mainJson = new JSONObject(new LinkedHashMap());
                jsonObject.put("UnifiedSocialCreditCodeOfAccountingEntity", (Object)row.getString("org.uniformsocialcreditcode"));
                jsonObject.put("NameOfAccountingEntity", (Object)row.getString("org.name"));
                voucherHeadJson.put(id, jsonObject);
                mainJson.put("id", (Object)id);
                mainJson.put("org", (Object)row.getLong("org"));
                mainJson.put("NumberOfAccountingDocuments", (Object)row.getString("billno"));
                mainJson.put("PostingDate", (Object)DateUtil.getTimeStr(row.getDate("bookeddate")));
                mainJson.put("AccountingPeriod", (Object)CreateXmlUtil.dealPeriodNumber(row.getString("periodnumber")));
                mainJson.put("SummaryOfAccountingDocuments", (Object)row.getString("vdescription"));
                mainJson.put("InformationOfDebitAndCreditEntryTuple", voucherentityJson.get(id));
                voucherJson.put(id, mainJson);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        return voucherJson;
    }

    public static Map<Long, JSONObject> getVoucherJson(Set<Long> buildXbrlVoucherIds) {
        QFilter voucherFilter = new QFilter("id", "in", buildXbrlVoucherIds);
        HashSet<Long> accountIds = new HashSet<Long>(16);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"gl_voucher", (String)"id, entries.id, entries.account.name, entries.account.id, entries.account.accounttable.id", (QFilter[])new QFilter[]{voucherFilter});
        Long accountTableId = ((DynamicObject)dys.get(0)).getLong("entries.account.accounttable.id");
        for (DynamicObject dynamicObject : dys) {
            accountIds.add(dynamicObject.getLong("entries.account.id"));
        }
        Map<Long, String> getGlAccountName = AccountUtil.getGlAccountNumberBySubledger(accountIds, accountTableId);
        HashMap<Long, List> voucherentityJson = new HashMap<Long, List>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ArchiveUtil.getVoucherJson", (String)"gl_voucher", (String)"id, entries.id, entries.account.name, entries.account.id, entries.account.accounttable.id, entries.entrydc, entries.currency.name, entries.debitori, entries.creditori, entries.debitlocal, entries.creditlocal", (QFilter[])new QFilter[]{voucherFilter}, null);){
            for (Row row : dataSet) {
                Long id = row.getLong("id");
                List eneityList = voucherentityJson.computeIfAbsent(id, value -> new ArrayList());
                LinkedHashMap<String, Object> eneityMap = new LinkedHashMap<String, Object>(16);
                eneityMap.put("DebitOrCredit", "1".equals(row.getString("entries.entrydc")) ? ResManager.loadKDString((String)"\u501f", (String)"FPYXmlUtils_5", (String)"fi-aef-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d37", (String)"FPYXmlUtils_6", (String)"fi-aef-common", (Object[])new Object[0]));
                eneityMap.put("NameOfGeneralLedgerSubject", getGlAccountName.get(row.getLong("entries.account.id")));
                eneityMap.put("NameOfSubsidiaryLedgerSubject", row.getString("entries.account.name"));
                if ("1".equals(row.getString("entries.entrydc"))) {
                    eneityMap.put("RecordedAmount", row.getBigDecimal("entries.debitlocal"));
                } else {
                    eneityMap.put("RecordedAmount", row.getBigDecimal("entries.creditlocal"));
                }
                eneityList.add(eneityMap);
            }
        }
        HashMap<Long, JSONObject> voucherJson = new HashMap<Long, JSONObject>(16);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ArchiveUtil.getVoucherJson", (String)"gl_voucher", (String)"id,org.id org,org.uniformsocialcreditcode,org.name,org.city.name,billno,bookeddate,period.number periodnumber,vdescription", (QFilter[])new QFilter[]{voucherFilter}, null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                Long id = row.getLong("id");
                JSONObject mainJson = new JSONObject(new LinkedHashMap());
                mainJson.put("id", (Object)id);
                mainJson.put("org", (Object)row.getLong("org"));
                mainJson.put("NumberOfAccountingDocuments", (Object)row.getString("billno"));
                mainJson.put("PostingDate", (Object)DateUtil.getTimeStr(row.getDate("bookeddate")));
                mainJson.put("AccountingPeriod", (Object)CreateXmlUtil.dealPeriodNumber(row.getString("periodnumber")));
                mainJson.put("SummaryOfAccountingDocuments", (Object)row.getString("vdescription"));
                mainJson.put("InformationOfDebitAndCreditEntryTuple", voucherentityJson.get(id));
                voucherJson.put(id, mainJson);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        return voucherJson;
    }

    public static Map<String, Map<Long, String>> getBillNos(Map<String, Set<Long>> refBilltypeAndIds) {
        HashMap<String, Map<Long, String>> map = new HashMap<String, Map<Long, String>>(16);
        String algoKey = "ArchiveUtil.getBillNos";
        for (Map.Entry<String, Set<Long>> refBilltype : refBilltypeAndIds.entrySet()) {
            String billType = refBilltype.getKey();
            DataSet set = QueryServiceHelper.queryDataSet((String)algoKey, (String)billType, (String)"id,billno", (QFilter[])new QFilter("id", "in", refBilltype.getValue()).toArray(), null);
            Throwable throwable = null;
            try {
                if (set == null) continue;
                for (Row row : set) {
                    map.computeIfAbsent(billType, value -> new HashMap()).put(row.getLong("id"), row.getString("billno"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (set == null) continue;
                if (throwable != null) {
                    try {
                        set.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                set.close();
            }
        }
        return map;
    }

    public static Set<Long> getHasArchivedIds(String uploadWay, long orgid, String billtype) {
        HashSet<Long> ids = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("uploadWay", "=", (Object)uploadWay);
        QFilter qFilter1 = new QFilter("type", "=", (Object)"1");
        QFilter qFilter2 = new QFilter("org", "=", (Object)orgid);
        QFilter qFilter3 = new QFilter("billtype", "=", (Object)billtype);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ArchiveTaxByFpyLogicUnit", (String)"aef_acelre_tax", (String)"billid", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2, qFilter3}, null);){
            for (Row row : dataSet) {
                ids.add(row.getLong("billid"));
            }
        }
        return ids;
    }

    public static Map<Long, List<Map<String, String>>> getVoucherentry(Set<Long> voucherIds) {
        QFilter voucherFilter = new QFilter("id", "in", voucherIds);
        HashSet<Long> accountIds = new HashSet<Long>(16);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"gl_voucher", (String)"id, entries.id, entries.account.name, entries.account.id, entries.account.accounttable.id", (QFilter[])new QFilter[]{voucherFilter});
        Long accountTableId = ((DynamicObject)dys.get(0)).getLong("entries.account.accounttable.id");
        for (DynamicObject dynamicObject : dys) {
            accountIds.add(dynamicObject.getLong("entries.account.id"));
        }
        Map<Long, String> getGlAccountName = AccountUtil.getGlAccountNumberBySubledger(accountIds, accountTableId);
        HashMap<Long, List<Map<String, String>>> voucherentity = new HashMap<Long, List<Map<String, String>>>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ArchiveUtil.getVoucherentry", (String)"gl_voucher", (String)"id, entries.id,  entries.edescription, entries.account.name, entries.account.number, entries.account.id,entries.currency.name, entries.debitlocal, entries.creditlocal, entries.entrydc", (QFilter[])new QFilter[]{voucherFilter}, null);){
            for (Row row : dataSet) {
                Long id = row.getLong("id");
                List eneityList = voucherentity.computeIfAbsent(id, value -> new ArrayList());
                LinkedHashMap<String, String> eneityMap = new LinkedHashMap<String, String>(16);
                eneityMap.put("summary", row.getString("entries.edescription"));
                eneityMap.put("accountsubjects", row.getString("entries.account.number"));
                eneityMap.put("cur", row.getString("entries.currency.name"));
                eneityMap.put("debit", row.getBigDecimal("entries.debitlocal").toString());
                eneityMap.put("credit", row.getBigDecimal("entries.creditlocal").toString());
                if ("1".equals(row.getString("entries.entrydc"))) {
                    eneityMap.put("recordedamount", row.getBigDecimal("entries.debitlocal").toString());
                } else {
                    eneityMap.put("recordedamount", row.getBigDecimal("entries.creditlocal").toString());
                }
                eneityMap.put("debitorcredit", "1".equals(row.getString("entries.entrydc")) ? ResManager.loadKDString((String)"\u501f\u65b9", (String)"ArchiveUtil_2", (String)"fi-aef-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d37\u65b9", (String)"ArchiveUtil_3", (String)"fi-aef-common", (Object[])new Object[0]));
                eneityMap.put("ledgername", getGlAccountName.get(row.getLong("entries.account.id")));
                eneityMap.put("detailname", row.getString("entries.account.name"));
                eneityList.add(eneityMap);
            }
        }
        return voucherentity;
    }

    public static String getServerConfig(OperateOption option) {
        String uploadUrl;
        DynamicObject imageConfig = QueryServiceHelper.queryOne((String)"aef_serviceconfig", (String)"id,serviceip,serviceport,username,password,uploadway,requestway", null);
        String message = "";
        if (imageConfig == null) {
            message = ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u5f52\u6863\u670d\u52a1\u5668\u3002", (String)"ArchiveOpService_4", (String)"fi-aef-opplugin", (Object[])new Object[0]);
            return message;
        }
        String uploadway = imageConfig.getString("uploadway");
        String serviceip = imageConfig.getString("serviceip");
        String serviceport = imageConfig.getString("serviceport");
        if ("1".equals(uploadway) && StringUtils.isEmpty((CharSequence)(uploadUrl = DowJonesVideoImp.getServiceUrl("/services/UploadAttachment.ashx", serviceip, serviceport)))) {
            message = ResManager.loadKDString((String)"\u9053\u53ef\u7ef4\u65af\u670d\u52a1\u5668\u8def\u5f84\u4e3a\u7a7a\u3002", (String)"ArchiveOpService_5", (String)"fi-aef-opplugin", (Object[])new Object[0]);
            return message;
        }
        if ("3".equals(uploadway) || DATETIME.equals(uploadway) || "6".equals(uploadway)) {
            option.setVariableValue("fpyUploadUrl", "");
            option.setVariableValue("fpyNoticeUrl", "");
            option.setVariableValue("fpyDeleteUrl", "");
            option.setVariableValue("batchCode", UUID.randomUUID().toString());
        }
        option.setVariableValue("uploadway", uploadway);
        option.setVariableValue("archivesCode", imageConfig.getString("username"));
        option.setVariableValue("password", imageConfig.getString("password"));
        option.setVariableValue("serviceip", serviceip);
        option.setVariableValue("serviceport", serviceport);
        return message;
    }

    public static String getSelectFields(String billtype, String datefiled) {
        String mainOrg;
        Map<String, String> billType2ArchiveOrgCfgFieldMap = BizParamUtils.getBillType2ArchiveOrgCfgFieldMap(Collections.singleton(billtype));
        String periodFiledByBill = FieldMappingUtil.getPeriodFiledByBill(billtype);
        QFilter qFilter = new QFilter("billtype", "=", (Object)billtype);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)AEF_FIELDMAPPING, (QFilter[])qFilter.toArray());
        ArrayList<String> fieldList = new ArrayList<String>(16);
        if (dynamicObject != null) {
            DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                String fieldtype = entry.getString("fieldtype");
                String fieldnumber = entry.getString("fieldnumber");
                String xmlfiled = entry.getString("xmlfiled");
                String displayprop = entry.getString("displayprop");
                String field = ArchiveUtil.getField(fieldnumber, fieldtype, displayprop, xmlfiled);
                fieldList.add(field);
            }
            if ("gl_voucher".equals(billtype)) {
                fieldList.add("org.id org");
                fieldList.add("booktype.id booktypeid");
                fieldList.add("period.id periodid");
            } else {
                String mainOrg2;
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)billtype);
                String string = mainOrg2 = billType2ArchiveOrgCfgFieldMap.get(billtype) == null ? type.getMainOrg() : billType2ArchiveOrgCfgFieldMap.get(billtype);
                if (!StringUtils.isNotBlank((CharSequence)mainOrg2)) {
                    String localeValue = type.getDisplayName().getLocaleValue();
                    String error = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c\u83b7\u53d6\u4e0d\u5230\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"ArchiveUtil_0", (String)"fi-aef-common", (Object[])new Object[0]), localeValue);
                    throw new KDBizException(error);
                }
                fieldList.add(mainOrg2 + ".id org");
                if (StringUtils.isNotBlank((CharSequence)datefiled)) {
                    fieldList.add(datefiled + " xinghanperiod");
                }
                if (StringUtils.isNotEmpty((CharSequence)periodFiledByBill)) {
                    fieldList.add(periodFiledByBill + ".id xinghanperiodid");
                    fieldList.add(periodFiledByBill + ".number xinghanperiodnumber");
                }
            }
            return String.join((CharSequence)",", fieldList);
        }
        if ("gl_voucher".equals(billtype)) {
            return "id,billno,org.id org,org.number orgnumber,org.name orgname,period.id periodid,period.number periodnumber,period.name periodname,attachment,vouchertype.name vouchertypename,localcur.number localcurnumber,vdescription,booktype.id booktypeid, booktype.number booktypenumber,booktype.name booktypename,creator.name creatorname,auditor.name auditorname,debitlocamount,creditlocamount,bookeddate accountdate,posttime posting_date";
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)billtype);
        String string = mainOrg = billType2ArchiveOrgCfgFieldMap.get(billtype) == null ? type.getMainOrg() : billType2ArchiveOrgCfgFieldMap.get(billtype);
        if (StringUtils.isEmpty((CharSequence)mainOrg)) {
            String localeValue = type.getDisplayName().getLocaleValue();
            String error = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c\u83b7\u53d6\u4e0d\u5230\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"ArchiveUtil_0", (String)"fi-aef-common", (Object[])new Object[0]), localeValue);
            throw new KDBizException(error);
        }
        String billNo = QueryFinanceBillHelper.getBillNo(billtype);
        String selectFields = "";
        selectFields = StringUtils.isNotBlank((CharSequence)datefiled) ? selectFields + "id," + datefiled + " xinghanperiod," + mainOrg + ".id org," + mainOrg + ".number orgnumber," + mainOrg + ".name orgname," + billNo + " billno" : selectFields + "id," + mainOrg + ".id org," + mainOrg + ".number orgnumber," + mainOrg + ".name orgname," + billNo + " billno";
        if ("cas_balanceadjust".equals(billtype)) {
            selectFields = selectFields + ",bankaccount.bank.name openingBank, bankaccount.bankaccountnumber bankAccount,bizdate biz_date, period.number xinghanperiodnumber,period.id xinghanperiodid";
        } else if ("cas_bankstatement".equals(billtype)) {
            selectFields = selectFields + ",bizdate biz_date, period.number xinghanperiodnumber,period.id xinghanperiodid";
        }
        return selectFields;
    }

    public static String getFieldName(String billtype, String field) {
        QFilter qFilter = new QFilter("billtype", "=", (Object)billtype);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)AEF_FIELDMAPPING, (QFilter[])qFilter.toArray());
        if (dynamicObject != null) {
            DynamicObjectCollection dyns = (DynamicObjectCollection)dynamicObject.get("entryentity");
            for (DynamicObject dyn : dyns) {
                if (!dyn.getString("fieldnumber").equals(field)) continue;
                return dyn.getString("xmlfiled");
            }
            return field;
        }
        return field;
    }

    public static DynamicObjectCollection getXmlfileds(String billtype) {
        DynamicObjectCollection fieldList = new DynamicObjectCollection();
        QFilter qFilter = new QFilter("billtype", "=", (Object)billtype);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)AEF_FIELDMAPPING, (QFilter[])qFilter.toArray());
        if (dynamicObject != null) {
            fieldList = dynamicObject.getDynamicObjectCollection("entryentity");
        }
        return fieldList;
    }

    public static String getFieldValue(Row row, DynamicObject fieldAttr) {
        String xmlfiled = fieldAttr.getString("xmlfiled");
        String string = "";
        switch (fieldAttr.getString("fieldtype")) {
            case "1": 
            case "2": {
                return row.getString(xmlfiled) == null ? string : row.getString(xmlfiled);
            }
            case "3": {
                return row.getString(xmlfiled) == null ? string : row.getString(xmlfiled);
            }
            case "4": {
                return row.getBoolean(xmlfiled).toString();
            }
            case "5": {
                return row.getDate(xmlfiled) == null ? string : DateUtil.getTimeStr(row.getDate(xmlfiled));
            }
        }
        return string;
    }

    private static String getField(String fieldnumber, String fieldtype, String displayprop, String xmlfiled) {
        String field = fieldnumber + " " + xmlfiled;
        if ("3".equals(fieldtype)) {
            field = fieldnumber + ".name " + xmlfiled;
            switch (displayprop) {
                case "1": {
                    field = fieldnumber + ".number " + xmlfiled;
                    break;
                }
                case "3": {
                    field = String.format("%s as %s", String.format("concat(%s,%s)", fieldnumber + ".name", fieldnumber + ".number"), xmlfiled);
                    break;
                }
            }
        }
        return field;
    }

    public static Map<String, List<BillInfo>> getLinkUpBillInfos(Map<String, Set<Long>> refBilltypeAndIds) {
        HashMap<String, List<BillInfo>> map = new HashMap<String, List<BillInfo>>();
        String algoKey = "ArchiveUtil.getLinkUpBillInfos";
        for (Map.Entry<String, Set<Long>> refBilltype : refBilltypeAndIds.entrySet()) {
            String billType = refBilltype.getKey();
            String selectFields = ArchiveUtil.getSelectFields(billType, null);
            DynamicObjectCollection dyns = ArchiveUtil.getXmlfileds(billType);
            String idField = ArchiveUtil.getFieldName(billType, "id");
            String billnoField = ArchiveUtil.getFieldName(billType, QueryFinanceBillHelper.getBillNo(billType));
            DataSet set = QueryServiceHelper.queryDataSet((String)algoKey, (String)billType, (String)selectFields, (QFilter[])new QFilter("id", "in", refBilltype.getValue()).toArray(), null);
            Throwable throwable = null;
            try {
                if (set == null) continue;
                for (Row row : set) {
                    BillInfo billInfo = new BillInfo();
                    billInfo.setBillId(row.getLong(idField));
                    billInfo.setBillNo(row.getString(billnoField));
                    HashMap<String, String> fieldMap = new HashMap<String, String>(16);
                    for (DynamicObject dyn : dyns) {
                        fieldMap.put(dyn.getString("xmlfiled"), ArchiveUtil.getFieldValue(row, dyn));
                    }
                    billInfo.setFieldMap(fieldMap);
                    map.computeIfAbsent(billType, value -> new ArrayList()).add(billInfo);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (set == null) continue;
                if (throwable != null) {
                    try {
                        set.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                set.close();
            }
        }
        return map;
    }
}

