/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.common.util;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.fi.aef.common.util.DateUtil;

public class ContextUtil {
    public static long getUserId() {
        return Long.parseLong(RequestContext.get().getUserId());
    }

    public static String createXBRLPath(String ticketType, JSONObject json) {
        String date = DateUtil.format(new Date(), "yyyyMMdd");
        switch (ticketType) {
            case "atr_receiver": {
                return ticketType + "_" + date + "_" + json.getString("ElectronicInvoiceAirTransportReceiptNumber");
            }
            case "rai_receiver": {
                return ticketType + "_" + date + "_" + json.getString("ElectronicInvoiceRailwayETicketNumber");
            }
            case "bker_receiver": {
                return ticketType + "_" + date + "_" + json.getString("IdentifyingCode");
            }
            case "bkrs": {
                return ticketType + "_" + date + "_" + json.getString("seqNo");
            }
            case "ntrev_gpm_receiver": {
                return "voucher_receiver_" + date + "_" + json.getString("seqNo");
            }
        }
        return ticketType + "_" + date + "_" + json.getString("seqNo");
    }

    public static String createXBRLFilename(String ticketType, JSONObject json) {
        String date = DateUtil.format(new Date(), "yyyyMMdd");
        switch (ticketType) {
            case "atr_receiver": {
                return ticketType + "_" + date + "_" + json.getString("ElectronicInvoiceAirTransportReceiptNumber") + ".xml";
            }
            case "rai_receiver": {
                return ticketType + "_" + date + "_" + json.getString("ElectronicInvoiceRailwayETicketNumber") + ".xml";
            }
            case "bker_receiver": {
                return ticketType + "_" + date + "_" + json.getString("IdentifyingCode") + ".xml";
            }
            case "bkrs": {
                return ticketType + "_" + date + "_" + json.getString("seqNo") + ".xml";
            }
            case "ntrev_gpm_receiver": {
                return "voucher_receiver.xml";
            }
            case "efi": {
                return "efi_receiver_" + date + "_" + json.getString("seqNo") + ".xml";
            }
        }
        return ticketType + "_" + date + "_" + json.getString("seqNo") + ".xml";
    }
}

