/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.common.util;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.HttpUtils;
import kd.bos.util.StringUtils;
import kd.fi.aef.entity.ArchiveInfo;
import kd.fi.aef.entity.FileInfo;
import kd.fi.aef.exception.BillNotExistException;
import kd.fi.aef.exception.CannotConnectToSysException;

public class DowJonesVideoImp {
    private static final String destroyBillImageService = "/services/IScanWebServiceImplService.asmx?op=destroyBillImage";
    private static final String getAttachFileUrl = "/services/IScanWebServiceImplService.asmx?op=GetBillAttachmentViewUrl";
    public static final String UploadAttachment = "/services/UploadAttachment.ashx";
    private static final String[] aviliableFormat = new String[]{"jpg", "png", "jpeg", "bmp", "doc", "docx", "xlsx", "xls", "pdf"};
    private static final Log logger = LogFactory.getLog(DowJonesVideoImp.class);

    private static String getURl(String serviceip, String serviceport) {
        String url = String.format("http://%s:%s", serviceip, serviceport);
        if ("http://112.74.163.215:8080".equals(url)) {
            return url + "/XSmart.WebService2CQYTest";
        }
        return url + "/XSmart.WebService";
    }

    public static String getServiceUrl(String serviceName, String serviceip, String serviceport) {
        return DowJonesVideoImp.getURl(serviceip, serviceport) + serviceName;
    }

    public static String getServiceUrl(String serviceName) {
        DynamicObject imageConfig = QueryServiceHelper.queryOne((String)"aef_serviceconfig", (String)"serviceip,serviceport,username,password,uploadway", null);
        if (imageConfig == null) {
            return serviceName;
        }
        return DowJonesVideoImp.getURl(imageConfig.getString("serviceip"), imageConfig.getString("serviceport")) + serviceName;
    }

    public static boolean deleteBillInfo(String billType, Long BillId) throws BillNotExistException, CannotConnectToSysException {
        ArrayList<String> attachements = DowJonesVideoImp.getAttachmentFileName(billType, BillId);
        if (attachements != null && attachements.size() > 0) {
            for (int i = 0; i < attachements.size(); ++i) {
                DowJonesVideoImp.deleteBillInfo(billType, BillId, attachements.get(i));
            }
        }
        return DowJonesVideoImp.deleteBillInfo(billType, BillId, billType + BillId + ".pdf");
    }

    private static ArrayList<String> getAttachmentFileName(String billType, Long billId) {
        ArrayList<String> fileInfos = new ArrayList<String>();
        QFilter filter = new QFilter("fbilltype", "=", (Object)billType);
        QFilter filter2 = new QFilter("finterid", "=", (Object)billId.toString());
        QFilter[] filters = new QFilter[]{filter, filter2};
        DynamicObjectCollection data = QueryServiceHelper.query((String)"bos_attachment", (String)"fattachmentname,ffileid,fextname", (QFilter[])filters);
        if (data != null && data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                String type = ((DynamicObject)data.get(i)).getString("fextname");
                if (!Arrays.stream(aviliableFormat).anyMatch(h -> h.equalsIgnoreCase(type))) continue;
                String fileName = ((DynamicObject)data.get(i)).getString("fattachmentname");
                fileInfos.add(fileName);
            }
        }
        return fileInfos;
    }

    public static boolean deleteBillInfo(String billType, Long BillId, String fileName) throws BillNotExistException, CannotConnectToSysException {
        HashMap<String, String> keypair = new HashMap<String, String>();
        keypair.put("Content-Type", "text/xml; charset=utf-8");
        keypair.put("SOAPAction", "http://PaperPark.WebService/services/IScanWebServiceImplService/DestroyBillAttachment");
        String formate = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n  <soap:Body>\n    <DestroyBillAttachment xmlns=\"http://PaperPark.WebService/services/IScanWebServiceImplService\">\n      <billNo>%s</billNo>\n      <filename>%s</filename>\n    </DestroyBillAttachment>\n  </soap:Body>\n</soap:Envelope>";
        String res = HttpUtils.post((String)DowJonesVideoImp.getServiceUrl(destroyBillImageService), keypair, (String)String.format(formate, billType + BillId, fileName), (boolean)true);
        if (StringUtils.isEmpty((String)res)) {
            throw new CannotConnectToSysException();
        }
        try {
            JSONObject obj = (JSONObject)JSONObject.parse((String)res);
            String status = obj.getString("status");
            if ("1".equals(status)) {
                return true;
            }
            if ("0".equals(status)) {
                throw new BillNotExistException(billType, BillId.toString());
            }
            if ("-1".equals(status)) {
                return false;
            }
        }
        catch (JSONException exception) {
            return false;
        }
        throw new RuntimeException("not expected response");
    }

    public static String GetBillIAttachmentViewUrl(String billType, String billId) {
        return DowJonesVideoImp.GetBillIAttachmentViewUrl(billType, billId, billType + billId + ".pdf");
    }

    public static String GetBillIAttachmentViewUrl(String billType, String billId, String fileName) {
        HashMap<String, String> keypair = new HashMap<String, String>();
        keypair.put("Content-Type", "text/xml; charset=utf-8");
        keypair.put("SOAPAction", "http://PaperPark.WebService/services/IScanWebServiceImplService/GetBillAttachmentViewUrl");
        String formate = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n  <soap:Body>\n    <GetBillAttachmentViewUrl xmlns=\"http://PaperPark.WebService/services/IScanWebServiceImplService\">\n      <billNo>%s</billNo>\n      <filename>%s</filename>\n    </GetBillAttachmentViewUrl>\n  </soap:Body>\n</soap:Envelope>";
        String res = HttpUtils.post((String)DowJonesVideoImp.getServiceUrl(getAttachFileUrl), keypair, (String)String.format(formate, billType + billId, fileName), (boolean)true);
        if (StringUtils.isEmpty((String)res)) {
            return "";
        }
        try {
            JSONObject obj = (JSONObject)JSONObject.parse((String)res);
            String status = obj.getString("status");
            if ("1".equals(status)) {
                return obj.getString("description");
            }
            return "";
        }
        catch (JSONException exception) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static boolean PushFileToDowJones(String UploadUrl, ArchiveInfo file) {
        billInfo = new HashMap<String, String>();
        billInfo.put("remarkJsonString", "");
        billInfo.put("billType", file.getBill());
        billInfo.put("billNo", file.getBillDowsId());
        in = null;
        stream = null;
        boundary = "Docuvix";
        end = "\r\n";
        builder = new StringBuilder();
        result = new StringBuilder();
        url = new URL(UploadUrl);
        conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setConnectTimeout(5000);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        conn.setRequestProperty("Expect", "100-continue");
        stream = conn.getOutputStream();
        for (Map.Entry<K, V> item : billInfo.entrySet()) {
            stream.write(("--" + boundary + end).getBytes("UTF-8"));
            stream.write(String.format("Content-Disposition: form-data; name=\"%s\"", new Object[]{item.getKey()}).getBytes("UTF-8"));
            stream.write(end.getBytes("UTF-8"));
            stream.write(end.getBytes("UTF-8"));
            stream.write(((String)item.getValue()).getBytes("UTF-8"));
            stream.write(end.getBytes("UTF-8"));
        }
        all = new ArrayList<FileInfo>();
        all.add(file.getPdfInfo());
        all.addAll(file.getAttachInfo());
        for (FileInfo info : all) {
            builder.append("--");
            builder.append(boundary);
            builder.append(end);
            builder.append(String.format("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"" + end, new Object[]{info.getFileName(), info.getFileName()}));
            builder.append("Content-Type: application/octet-stream\r\n");
            builder.append(end);
            stream.write(builder.toString().getBytes("UTF-8"));
            builder.setLength(0);
            data = info.getData();
            stream.write(data);
            stream.write(end.getBytes("UTF-8"));
        }
        stream.write(("--" + boundary + "--").getBytes("UTF-8"));
        stream.flush();
        in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = in.readLine()) != null) {
            result.append(line);
        }
        obj = (JSONObject)JSONObject.parse((String)result.toString());
        DowJonesVideoImp.logger.error("dowjones : url {} , json {}", (Object)UploadUrl, (Object)obj);
        status = obj.getString("status");
        if (!"1".equals(status)) ** break block12
        var16_20 = true;
        DowJonesVideoImp.closeOutputStream(stream);
        DowJonesVideoImp.closeBufferedReader(in);
        return var16_20;
        {
            var16_21 = false;
            DowJonesVideoImp.closeOutputStream(stream);
        }
        DowJonesVideoImp.closeBufferedReader(in);
        return var16_21;
        {
            catch (JSONException exception) {
                try {
                    DowJonesVideoImp.logger.error("dowjones error: url {} , error {}", (Object)UploadUrl, (Object)exception);
                    var15_19 = false;
                }
                catch (IOException e) {
                    DowJonesVideoImp.logger.error("dowjones error: url {} , error {}", (Object)UploadUrl, (Object)e);
                    var10_12 = false;
                    return var10_12;
                }
                catch (Throwable var17_22) {
                    throw var17_22;
                }
                DowJonesVideoImp.closeOutputStream(stream);
                DowJonesVideoImp.closeBufferedReader(in);
                return var15_19;
            }
        }
        finally {
            DowJonesVideoImp.closeOutputStream(stream);
            DowJonesVideoImp.closeBufferedReader(in);
        }
    }

    public static void closeOutputStream(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeBufferedReader(BufferedReader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

