/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.aef.common.util.LogUtil;
import kd.sdk.fi.aef.extpoint.IThirdInvoiceExtService;
import org.apache.commons.io.FilenameUtils;

public class ElecreceiptUtils {
    private static final Log logger = LogFactory.getLog(ElecreceiptUtils.class);

    public static Map<String, Map<Long, List<String>>> findReceiptUrlByIds(String viewPageId, Map<String, Set<Long>> refBilltypeAndIds) {
        HashMap<String, Map<Long, List<String>>> returnMap = new HashMap<String, Map<Long, List<String>>>(16);
        refBilltypeAndIds.forEach((billtype, billIds) -> {
            Map<Long, List<String>> urlMap = ElecreceiptUtils.invokeUrls(billtype, billIds, viewPageId);
            Map tempMap = returnMap.computeIfAbsent((String)billtype, value -> new HashMap(16));
            tempMap.putAll(urlMap);
        });
        return returnMap;
    }

    public static String getFileName(String url) {
        return FilenameUtils.getName((String)url);
    }

    public static Map<String, Map<Long, Set<Long>>> findReceiptByIds(Map<String, Set<Long>> refBilltypeAndIds) {
        HashMap<String, Map<Long, Set<Long>>> returnMap = new HashMap<String, Map<Long, Set<Long>>>(16);
        refBilltypeAndIds.forEach((billtype, billIds) -> {
            Map<Long, Set<Long>> idMap = ElecreceiptUtils.invokeIds(billtype, billIds);
            Map tempMap = returnMap.computeIfAbsent((String)billtype, value -> new HashMap(2));
            tempMap.putAll(idMap);
        });
        return returnMap;
    }

    private static Map<Long, Set<Long>> invokeIds(String billtype, Set<Long> billIds) {
        HashMap<Long, Set<Long>> returnMap = new HashMap(16);
        returnMap = (Map)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"viewreceipt", (String)"findReceiptIdByids", (Object[])new Object[]{billtype, billIds});
        return returnMap;
    }

    private static Map<Long, List<String>> invokeUrls(String billtype, Set<Long> billIds, String viewPageId) {
        HashMap<Long, List<String>> returnMap = new HashMap(16);
        returnMap = (Map)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"viewreceipt", (String)"findReceiptUrlByIds", (Object[])new Object[]{viewPageId, billtype, billIds});
        return returnMap;
    }

    public static Map<Long, DynamicObject> findReceiptDataSet(Set<Long> keySet) {
        HashMap<Long, DynamicObject> returnMap = new HashMap<Long, DynamicObject>(16);
        QFilter idFilter = new QFilter("id", "in", keySet);
        String fields = "id, recname payeename, recno payeeaccount, recbankname payeebank, accno paymentaccount,accname paymentname, bankname paymentbank,bizdate tradedate, amount, remarks postscript, detailid tradeid, currency.name currency, validcode, receiptno";
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bei_elecreceipt", (String)fields, (QFilter[])new QFilter[]{idFilter}, null);
        for (DynamicObject object : dys) {
            returnMap.put(object.getLong("id"), object);
        }
        return returnMap;
    }

    public static Map<Long, List<JSONObject>> findInvoiceJson(String billType, Set<Long> billIds, Map<String, DynamicObject> invoicePlgins) {
        HashMap<Long, List<JSONObject>> invoiceMap = new HashMap(16);
        DynamicObject dynamicObject = invoicePlgins.get(billType);
        invoiceMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)dynamicObject.getString("appid"), (String)dynamicObject.getString("servicename"), (String)"getBizBillTicketList", (Object[])new Object[]{billType, billIds});
        LogUtil.printLog(logger, ResManager.loadKDString((String)"findInvoiceJson \u53c2\u6570 {}, {}, \u8fd4\u56de\u503c:{}", (String)"ElecreceiptUtils_0", (String)"fi-aef-common", (Object[])new Object[0]), billType, billIds, invoiceMap);
        return invoiceMap;
    }

    public static HashMap<Long, JSONArray> findExtInvoiceJson(List<Long> voucherIds) {
        PluginProxy pluginProxy = PluginProxy.create(IThirdInvoiceExtService.class, (String)"kd.sdk.fi.aef.extpoint.IThirdInvoiceExtService.getInvoice");
        List extInvoiceMapList = pluginProxy.callReplace(p -> p.getInvoice(voucherIds));
        HashMap<Long, JSONArray> result = new HashMap<Long, JSONArray>(16);
        if (extInvoiceMapList != null) {
            for (HashMap extInvoiceMap : extInvoiceMapList) {
                result.putAll(extInvoiceMap);
            }
        }
        LogUtil.printLog(logger, ResManager.loadKDString((String)"findExtInvoiceJson \u53c2\u6570 {}, {}, \u8fd4\u56de\u503c:{}", (String)"ElecreceiptUtils_1", (String)"fi-aef-common", (Object[])new Object[0]), "gl_voucher", voucherIds, result);
        return result;
    }

    public static Map<Long, List<JSONObject>> findReceiptJson(String billType, Set<Long> billIds, Map<String, DynamicObject> receiptPlgins, String pageId) {
        HashMap<Long, List<JSONObject>> receiptMap = new HashMap(16);
        DynamicObject dynamicObject = receiptPlgins.get(billType);
        if ("bei_elecstatement".equals(billType)) {
            receiptMap = (Map)DispatchServiceHelper.invokeBizService((String)"tmc", (String)dynamicObject.getString("appid"), (String)dynamicObject.getString("servicename"), (String)"getBizBillTicketList", (Object[])new Object[]{billType, billIds});
            LogUtil.printLog(logger, ResManager.loadKDString((String)"findReceiptJson \u53c2\u6570 {}, {}, \u8fd4\u56de\u503c:{}", (String)"ElecreceiptUtils_2", (String)"fi-aef-common", (Object[])new Object[0]), billType, billIds, receiptMap);
        } else {
            receiptMap = (Map)DispatchServiceHelper.invokeBizService((String)"tmc", (String)dynamicObject.getString("appid"), (String)dynamicObject.getString("servicename"), (String)"getBizBillTicketList", (Object[])new Object[]{billType + "_pageId=" + pageId, billIds});
            LogUtil.printLog(logger, ResManager.loadKDString((String)"findReceiptJson \u53c2\u6570 {}, {}, \u8fd4\u56de\u503c:{}", (String)"ElecreceiptUtils_2", (String)"fi-aef-common", (Object[])new Object[0]), billType + "_pageId=" + pageId, billIds, receiptMap);
        }
        return receiptMap;
    }

    public static Map<Long, List<JSONObject>> findReceiptJson(String billType, Set<Long> billIds, String pageId) {
        HashMap<Long, List<JSONObject>> receiptMap = new HashMap(16);
        receiptMap = (Map)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"ElecBillArchive", (String)"getBizBillTicketList", (Object[])new Object[]{billType + "_pageId=" + pageId, billIds});
        LogUtil.printLog(logger, ResManager.loadKDString((String)"findReceiptJson \u53c2\u6570 {}, {}, \u8fd4\u56de\u503c:{}", (String)"ElecreceiptUtils_2", (String)"fi-aef-common", (Object[])new Object[0]), billType + "_pageId=" + pageId, billIds, receiptMap);
        return receiptMap;
    }

    public static List<Map<String, Object>> findTaxcDeclareTempFile(Long orgId, String startDate, String endDate, String templateType, String nsrxxFilter) {
        String result = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"ArchiveService", (String)"createDeclareTempFile", (Object[])new Object[]{orgId, startDate, endDate, templateType, nsrxxFilter});
        List resultList = StringUtils.isNotEmpty((CharSequence)result) ? SerializationUtils.fromJsonStringToList((String)result, Map.class) : Collections.emptyList();
        LogUtil.printLog(logger, ResManager.loadKDString((String)"findTaxcDeclareTempFile \u53c2\u6570orgId:{},startDate:{},endDate:{},templateType:{},nsrxxFilter:{} \u8fd4\u56de\u503c:{}", (String)"ElecreceiptUtils_3", (String)"fi-aef-common", (Object[])new Object[0]), orgId, startDate, endDate, templateType, nsrxxFilter, result);
        return resultList;
    }

    public static void callBillWriteBack(String archiveType, String billType, Set<Long> needArchiveIds) {
        Map<String, String> plugins = ElecreceiptUtils.getWriteBackPlugins();
        String plugin = plugins.get(billType);
        if (StringUtils.isNotEmpty((CharSequence)plugin)) {
            String[] arrs = plugin.split("-");
            try {
                String result = (String)DispatchServiceHelper.invokeBizService((String)arrs[0], (String)arrs[1], (String)arrs[2], (String)"writeBack", (Object[])new Object[]{archiveType, billType, needArchiveIds});
                LogUtil.printLog(logger, ResManager.loadKDString((String)"callBillWriteBack \u53c2\u6570archiveType:{},billType:{},needArchiveIds:{},\u8fd4\u56de\u503c:{}", (String)"ElecreceiptUtils_4", (String)"fi-aef-common", (Object[])new Object[0]), archiveType, billType, needArchiveIds, result);
                Map map = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                if (!map.get("code").equals("0000")) {
                    logger.error(ResManager.loadKDString((String)"callBillWriteBack \u53cd\u5199\u5931\u8d25archiveType:{},billType:{},needArchiveIds:{},\u8fd4\u56de\u503c:{}", (String)"ElecreceiptUtils_5", (String)"fi-aef-common", (Object[])new Object[0]), new Object[]{archiveType, billType, needArchiveIds, result});
                }
            }
            catch (KDException e) {
                logger.error(ResManager.loadKDString((String)"callBillWriteBack \u53cd\u5199\u5f02\u5e38archiveType:{},billType:{},needArchiveIds:{}, {}", (String)"ElecreceiptUtils_6", (String)"fi-aef-common", (Object[])new Object[0]), new Object[]{archiveType, billType, needArchiveIds, e});
            }
        }
    }

    private static Map<String, String> getWriteBackPlugins() {
        HashMap<String, String> plugins = new HashMap<String, String>(16);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"aef_archivewriteconfig", (String)"billentity.id,writebackplugin,couldid,appid", null);
        for (DynamicObject obj : objects) {
            String billKey;
            String plugin = obj.getString("writebackplugin");
            String couldid = obj.getString("couldid");
            String appid = obj.getString("appid");
            if (!StringUtils.isNotEmpty((CharSequence)plugin) || !StringUtils.isNotEmpty((CharSequence)(billKey = obj.getString("billentity.id")))) continue;
            plugins.put(billKey, couldid + "-" + appid + "-" + plugin);
        }
        return plugins;
    }
}

