/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.common.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FieldMappingUtil {
    private static final Set<String> HAVE_PERIOD_FIELD_BILL_SET = new HashSet<String>(Arrays.asList("cas_balanceadjust", "cas_bankstatement"));

    public static String getPeriodFiledByBill(String billType) {
        String periodField = null;
        QFilter qFilter = new QFilter("billtype", "=", (Object)billType);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"aef_fieldmapping", (QFilter[])qFilter.toArray());
        if (Objects.nonNull(dynamicObject)) {
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)dynamicObject.get("entryentity");
            for (DynamicObject dyn : dynamicObjectCollection) {
                if (!"period".equals(dyn.getString("xmlfiled"))) continue;
                periodField = dyn.getString("fieldnumber");
            }
        } else {
            periodField = HAVE_PERIOD_FIELD_BILL_SET.contains(billType) ? "period" : "";
        }
        return periodField;
    }
}

