/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.common.util;

import api.VoucherFileUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.api.PrintContext;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.servicehelper.print.NotePrintService;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.util.DateUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    private static final Log logger = LogFactory.getLog(FileUtils.class);
    private static final String elecDir = "elecDir";
    private static final String xbrlDir = "xbrlDir";

    public static byte[] downLoadAnyUrl(String urlstr) throws IOException {
        byte[] data = null;
        data = urlstr.startsWith("http") ? (urlstr.contains("configKey=") ? FileUtils.downLoadFileFromUrl(urlstr) : FileUtils.downLoadFromUrl(urlstr)) : FileUtils.downLoadHttpsFile(urlstr);
        return data;
    }

    public static byte[] downLoadFromPrintUrl(String url) throws IOException {
        InputStream inputStream = BosPrintServiceHelper.getFileInputStream((String)url);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)bos);
        }
        finally {
            FileUtils.closeInputStreamQuietly(inputStream);
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] downLoadFromUrl(String urlstr) throws IOException {
        URL url = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        url = new URL(urlstr);
        DataInputStream dataInputStream = new DataInputStream(url.openStream());
        try {
            IOUtils.copy((InputStream)dataInputStream, (OutputStream)bos);
        }
        finally {
            FileUtils.closeInputStreamQuietly(dataInputStream);
        }
        return bos.toByteArray();
    }

    public static String getElecLastDir() {
        String lastDir = FileUtils.getSecondLastDir() + File.separator + elecDir;
        File file = FileUtils.getFile(lastDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        return lastDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getElecFile(String urlstr) {
        File file = FileUtils.getFile(urlstr);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FileInputStream dataInputStream = null;
        try {
            dataInputStream = new FileInputStream(file);
            IOUtils.copy((InputStream)dataInputStream, (OutputStream)bos);
        }
        catch (Exception e) {
            try {
                logger.error((Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.closeInputStreamQuietly(dataInputStream);
                throw throwable;
            }
            FileUtils.closeInputStreamQuietly(dataInputStream);
        }
        FileUtils.closeInputStreamQuietly(dataInputStream);
        return bos.toByteArray();
    }

    public static String extractElecXBRL(String ofdFilePath, String ticketType, String uniqueCode) {
        String date = DateUtil.format(new Date(), "yyyyMMdd");
        String fullPath = FileUtils.getElecLastDir() + File.separator + ticketType + "_" + date + "_" + uniqueCode + ".xml";
        try {
            if (ofdFilePath.endsWith(".ofd")) {
                VoucherFileUtil.extractXBRLFromOFD((String)ofdFilePath, (String)fullPath);
            } else if (ofdFilePath.endsWith(".pdf")) {
                VoucherFileUtil.extractXBRLFromPDF((String)ofdFilePath, (String)fullPath);
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89e3\u6790xbrl\u6587\u4ef6\u5931\u8d25{%s}\u3002", (String)"FileUtils_0", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        return fullPath;
    }

    public static String getPoolDir() {
        String property = ConfigurationUtil.getString((String)"user.home");
        String dirPath = property + File.separator + "ARCHIVEPOOL" + File.separator + RequestContext.get().getAccountId() + RequestContext.get().getCurrUserId();
        File file = FileUtils.getFile(dirPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return dirPath;
    }

    public static String getPoolXbrlDir(String pageId) {
        String dirPath = FileUtils.getPoolDir() + File.separator + xbrlDir + File.separator + pageId;
        File file = FileUtils.getFile(dirPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return dirPath;
    }

    public static String getLastXbrlDir() {
        return FileUtils.getSecondLastDir();
    }

    public static void zipSpecFile(String dirPath) {
        String zipName = dirPath + ".zip";
        File zipFile = FileUtils.getFile(zipName);
        File zipDir = FileUtils.getFile(dirPath);
        File[] fileList = zipDir.listFiles();
        if (null != fileList && fileList.length > 0) {
            try {
                FileUtils.zipFiles(fileList, zipFile);
            }
            catch (Exception e) {
                logger.error("\u6587\u4ef6\u538b\u7f29\u5931\u8d25", (Throwable)e);
            }
        } else {
            logger.info(String.format("\u538b\u7f29\u7684\u76ee\u6807\u6587\u4ef6\u5939\u4e3a\u7a7a\uff0c%s", dirPath));
        }
        FileUtils.deleteFile(dirPath);
    }

    public static Map<String, String> exportNew(String socialcreditcode) {
        HashMap<String, String> exportResult = new HashMap<String, String>();
        String zipFilePath = FileUtils.getXbrlTempPath(socialcreditcode);
        File zipFile = FileUtils.getFile(zipFilePath);
        String zipDirPath = FileUtils.getSecondLastDir();
        File zipDir = FileUtils.getFile(zipDirPath);
        File[] fileList = zipDir.listFiles();
        if (null == fileList || fileList.length == 0) {
            logger.info(String.format("\u5bfc\u51fa\u7684\u6587\u4ef6\u4e3a\u7a7a\uff0c%s", zipDirPath));
            FileUtils.deleteFile(zipDirPath);
            return exportResult;
        }
        try {
            FileUtils.zipFiles(fileList, zipFile);
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u538b\u7f29\u5931\u8d25", (Throwable)e);
        }
        if (zipFile.exists()) {
            exportResult.put("fileName", zipFile.getPath());
        }
        FileUtils.deleteFile(zipDirPath);
        logger.info("\u6587\u4ef6\u538b\u7f29\u7ed3\u679c{}", (Object)SerializationUtils.toJsonString(exportResult));
        return exportResult;
    }

    private static void zipFiles(File[] srcFiles, File zipFile) {
        if (!zipFile.exists()) {
            try {
                if (!zipFile.createNewFile()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u6587\u4ef6\u51fa\u9519\uff0c\u6587\u4ef6%s\u4e0d\u5408\u6cd5\u3002", (String)"FileUtils_3", (String)"fi-aef-common", (Object[])new Object[0]), zipFile.getAbsolutePath()));
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
             ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);){
            for (File srcFile : srcFiles) {
                try (FileInputStream fileInputStream = new FileInputStream(srcFile);){
                    int len;
                    ZipEntry zipEntry = new ZipEntry(srcFile.getName());
                    zipOutputStream.putNextEntry(zipEntry);
                    byte[] buffer = new byte[1024];
                    while ((len = fileInputStream.read(buffer)) > 0) {
                        zipOutputStream.write(buffer, 0, len);
                    }
                    zipOutputStream.closeEntry();
                }
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    private static String getXbrlTempPath(String socialcreditcode) {
        String property = ConfigurationUtil.getString((String)"user.home");
        String dirPath = property + File.separator + "AEFDOWNLOAD";
        File file = FileUtils.getFile(dirPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return dirPath + File.separator + "receiver_" + socialcreditcode + "_" + System.currentTimeMillis() + ".zip";
    }

    private static void zipFile(String[] files, ZipOutputStream out, String dirName) {
        try {
            for (String fileName : files) {
                File file = FileUtils.getFile(fileName);
                String path = file.getAbsolutePath();
                if (file.isDirectory()) {
                    File[] listFiles = file.listFiles();
                    if (null == listFiles) continue;
                    String[] tempFiles = new String[listFiles.length];
                    int i = 0;
                    for (File tempFile : listFiles) {
                        tempFiles[i++] = tempFile.getAbsolutePath();
                    }
                    FileUtils.zipFile(tempFiles, out, dirName);
                    continue;
                }
                int t = -1;
                if (path.contains(dirName)) {
                    t = path.indexOf(dirName);
                }
                if (t == -1) {
                    return;
                }
                path = path.substring(t);
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                    ZipEntry entry = new ZipEntry(path);
                    entry.setMethod(8);
                    out.putNextEntry(entry);
                    int n = 0;
                    byte[] buf = new byte[1024];
                    while ((n = in.read(buf)) != -1) {
                        out.write(buf, 0, n);
                    }
                    out.closeEntry();
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private static String getSecondLastDir() {
        String property = ConfigurationUtil.getString((String)"user.home");
        String dirPath = property + File.separator + "AEFDOWNLOAD" + File.separator + RequestContext.get().getAccountId() + RequestContext.get().getCurrUserId();
        File file = FileUtils.getFile(dirPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return dirPath;
    }

    public static String getXbrlWriteDir(String path) {
        File file = FileUtils.getFile(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return path;
    }

    public static void extractXBRL(String ofdFilePath, String xbrlPath) {
        try {
            if (ofdFilePath.endsWith(".ofd")) {
                VoucherFileUtil.extractXBRLFromOFD((String)ofdFilePath, (String)xbrlPath);
            } else if (ofdFilePath.endsWith(".pdf")) {
                VoucherFileUtil.extractXBRLFromPDF((String)ofdFilePath, (String)xbrlPath);
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89e3\u6790xbrl\u6587\u4ef6\u5931\u8d25{%s}\u3002", (String)"FileUtils_0", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
    }

    public static Map<String, String> exportPool(String socialCreditCode, String pageId) {
        HashMap<String, String> exportResult = new HashMap<String, String>();
        String zipFilePath = FileUtils.getPoolDir() + File.separator + "receiver_" + socialCreditCode + "_" + System.currentTimeMillis() + ".zip";
        File zipFile = FileUtils.getFile(zipFilePath);
        String zipDirPath = FileUtils.getPoolXbrlDir(pageId);
        File zipDir = FileUtils.getFile(zipDirPath);
        File[] fileList = zipDir.listFiles();
        if (null == fileList || fileList.length == 0) {
            logger.info(String.format("\u5bfc\u51fa\u7684\u6587\u4ef6\u4e3a\u7a7a\uff0c%s", zipDirPath));
            FileUtils.deleteFile(zipDirPath);
            return exportResult;
        }
        try {
            FileUtils.zipFiles(fileList, zipFile);
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u538b\u7f29\u5931\u8d25", (Throwable)e);
        }
        if (zipFile.exists()) {
            exportResult.put("fileName", zipFile.getPath());
        }
        FileUtils.deleteFile(zipDirPath);
        logger.info("\u6587\u4ef6\u538b\u7f29\u7ed3\u679c{}", (Object)SerializationUtils.toJsonString(exportResult));
        return exportResult;
    }

    public static void deleteFile(String deletePath) {
        File file = FileUtils.getFile(deletePath);
        if (file.exists()) {
            FileUtils.deleteKd(file);
        }
    }

    public static void deleteKd(File file) {
        if (!file.isDirectory()) {
            if (!file.delete()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u539f\u6587\u4ef6%s\u65e0\u6cd5\u5220\u9664\u3002", (String)"FileUtils_1", (String)"fi-aef-common", (Object[])new Object[0]), file.getAbsolutePath()));
            }
        } else if (file.isDirectory()) {
            File[] fileList;
            for (File delfile : fileList = file.listFiles()) {
                if (!delfile.isDirectory()) {
                    if (delfile.delete()) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u539f\u6587\u4ef6%s\u65e0\u6cd5\u5220\u9664\u3002", (String)"FileUtils_1", (String)"fi-aef-common", (Object[])new Object[0]), file.getAbsolutePath()));
                }
                if (!delfile.isDirectory()) continue;
                FileUtils.deleteKd(delfile);
            }
            if (!file.delete()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u539f\u6587\u4ef6%s\u65e0\u6cd5\u5220\u9664\u3002", (String)"FileUtils_1", (String)"fi-aef-common", (Object[])new Object[0]), file.getAbsolutePath()));
            }
        }
    }

    public static void writeToFile(byte[] data, String fileName) {
        if (null == data) {
            logger.error("writeToFile\u4f20\u5165\u7684\u5b57\u8282\u6570\u7ec4\u4e3anull");
            return;
        }
        try (FileOutputStream fos = new FileOutputStream(FileUtils.getFile(fileName));){
            fos.write(data);
            fos.flush();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u6587\u4ef6\u51fa\u9519\u3002", (String)"FileUtils_2", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
    }

    public static byte[] json2Xbrl(String json, String configId) {
        logger.info("json2Xbrl\u53c2\u6570[json\uff1a{}\uff0cconfigId\uff1a{}]", (Object)json, (Object)configId);
        byte[] xbrlBytes = null;
        try {
            String xbrlStr = VoucherFileUtil.json2Xbrl((String)json, (String)configId);
            if (null != xbrlStr) {
                xbrlBytes = xbrlStr.getBytes("UTF-8");
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89e3\u6790xbrl\u6587\u4ef6\u5931\u8d25{%s}\u3002", (String)"FileUtils_0", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        return xbrlBytes;
    }

    public static String saveAsUrl(InputStream in, String fileName) {
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, in, 5000);
    }

    public static String saveAsUrl(byte[] bytes, String fileName) {
        return CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, bytes, 300000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] downLoadFileFromUrl(String urlstr) throws IOException {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream inputStream = cache.getInputStream(urlstr);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)bos);
        }
        finally {
            FileUtils.closeInputStreamQuietly(inputStream);
            FileUtils.closeOutputStreamQuietly(bos);
        }
        return bos.toByteArray();
    }

    public static byte[] downLoadHttpsFile(String attachUrl) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        attachmentFileService.download(attachUrl, (OutputStream)outStream, null);
        return outStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getNewPrintByte(String pageId, String formId, String templateId, List<Object> pkIds, String printType) {
        PrintWork work = new PrintWork();
        work.setPageId(pageId);
        work.setPrintLang(PrintContext.get().getLang());
        work.setExpType("1");
        PrintTask task = new PrintTask();
        task.setFormId(formId);
        task.setPageId(pageId);
        task.setPrintType(printType);
        task.setTplId(templateId);
        task.setPkIds(pkIds);
        work.add(task);
        ArrayList<String> urls = new ArrayList<String>(2);
        PrtAttach prtAttach = BosPrintServiceHelper.execPrint((PrintWork)work);
        List attachDetails = prtAttach.getAttachDetail();
        for (PrtAttach.AttachDetail attachDetail : attachDetails) {
            String xString = attachDetail.getFilePath();
            urls.add(xString);
        }
        try {
            if (urls.size() > 0) {
                InputStream inputStream = BosPrintServiceHelper.getFileInputStream((String)((String)urls.get(0)));
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    IOUtils.copy((InputStream)inputStream, (OutputStream)bos);
                }
                finally {
                    FileUtils.closeInputStreamQuietly(inputStream);
                }
                return bos.toByteArray();
            }
            return null;
        }
        catch (Exception e) {
            String message = String.format(ResManager.loadKDString((String)"%1$s\u83b7\u53d6\u65b0\u6253\u5370\u6a21\u677f\u7684pdf\u5931\u8d25\uff1a%2$s", (String)"ArchiveOpService_9", (String)"fi-aef-opplugin", (Object[])new Object[0]), formId, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new KDBizException(message);
        }
    }

    private static String getNewPrintUrl(String pageId, String formId, String templateId, List<Object> pkIds, String printType) {
        PrintWork work = new PrintWork();
        work.setPageId(pageId);
        work.setPrintLang(PrintContext.get().getLang());
        work.setExpType("1");
        PrintTask task = new PrintTask();
        task.setFormId(formId);
        task.setPageId(pageId);
        task.setPrintType(printType);
        task.setTplId(templateId);
        task.setPkIds(pkIds);
        work.add(task);
        ArrayList<String> urls = new ArrayList<String>(2);
        PrtAttach prtAttach = BosPrintServiceHelper.execPrint((PrintWork)work);
        List attachDetails = prtAttach.getAttachDetail();
        for (PrtAttach.AttachDetail attachDetail : attachDetails) {
            String xString = attachDetail.getFilePath();
            urls.add(xString);
        }
        return urls.size() == 0 ? null : (String)urls.get(0);
    }

    public static byte[] getPrintByte(String pageId, String formId, String templateId, List<Object> pkIds, String printType, int type) {
        byte[] returnBytes = null;
        try {
            if (type == 0) {
                logger.error("\u53c2\u6570pageId:{},formId\uff1a{},pkIds\uff1a{},templateId\uff1a{} \u53d6\u4e0d\u5230\u6253\u5370\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u662f\u5426\u88ab\u7981\u7528\u3002", new Object[]{pageId, formId, pkIds, templateId});
            }
            if (type == 1) {
                NotePrintService printService = new NotePrintService();
                if (pkIds == null) {
                    Object object = new Object();
                    pkIds = new ArrayList<Object>(1);
                    pkIds.add(object);
                }
                logger.info("\u65e7\u6a21\u677f\u53c2\u6570pageId:{},formId\uff1a{},pkIds\uff1a{},templateId\uff1a{}", new Object[]{pageId, formId, pkIds, templateId});
                returnBytes = printService.createSinglePdf(pageId, formId, templateId, pkIds.get(0));
                logger.info("\u65e7\u6a21\u677f\u53c2\u6570pageId:{},formId\uff1a{},pkIds\uff1a{},templateId\uff1a{},\u8fd4\u56de\u503c\uff1a{}", new Object[]{pageId, formId, pkIds, templateId, returnBytes == null ? "null" : Integer.valueOf(returnBytes.length)});
            }
            if (type == 2) {
                logger.info("\u65b0\u6a21\u677f\u53c2\u6570pageId:{},formId\uff1a{},pkIds\uff1a{},templateId\uff1a{},\u8fd4\u56de\u503c\uff1a{}", new Object[]{pageId, formId, pkIds, templateId});
                returnBytes = FileUtils.getNewPrintByte(pageId, formId, templateId, pkIds, printType);
                logger.info("\u65b0\u6a21\u677f\u53c2\u6570pageId:{},formId\uff1a{},pkIds\uff1a{},templateId\uff1a{},\u8fd4\u56de\u503c\uff1a{}", new Object[]{pageId, formId, pkIds, templateId, returnBytes == null ? "null" : Integer.valueOf(returnBytes.length)});
            }
        }
        catch (Exception e) {
            String string = String.format(ResManager.loadKDString((String)"\u6a21\u677f\u53c2\u6570[formId\uff1a%1$s\uff0cpkIds\uff1a%2$s\uff0ctemplateId\uff1a%3$s]", (String)"FileUtils_4", (String)"fi-aef-common", (Object[])new Object[0]), formId, pkIds, templateId);
            logger.error(string + "\u3002printerror:" + e);
            throw e;
        }
        return returnBytes;
    }

    public static String getPrintUrl(String pageId, String formId, String templateId, List<Object> pkIds, String printType, int type) {
        String returnUrl = null;
        try {
            if (type == 0) {
                logger.error("\u53c2\u6570pageId:{},formId\uff1a{},pkIds\uff1a{},templateId\uff1a{} \u53d6\u4e0d\u5230\u6253\u5370\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u6a21\u677f\u662f\u5426\u88ab\u7981\u7528\u3002", new Object[]{pageId, formId, pkIds, templateId});
            }
            if (type == 1) {
                NotePrintService printService = new NotePrintService();
                if (pkIds == null) {
                    Object object = new Object();
                    pkIds = new ArrayList<Object>(1);
                    pkIds.add(object);
                }
                logger.info("\u65e7\u6a21\u677f\u53c2\u6570pageId:{},formId\uff1a{},pkIds\uff1a{},templateId\uff1a{}", new Object[]{pageId, formId, pkIds, templateId});
                byte[] returnBytes = printService.createSinglePdf(pageId, formId, templateId, pkIds.get(0));
                returnUrl = FileUtils.saveAsUrl(returnBytes, pkIds.get(0) + ".pdf");
                logger.info("\u65e7\u6a21\u677f\u53c2\u6570pageId:{},formId\uff1a{},pkIds\uff1a{},templateId\uff1a{},\u8fd4\u56de\u503c\uff1a{}", new Object[]{pageId, formId, pkIds, templateId, returnUrl});
            }
            if (type == 2) {
                logger.info("\u65b0\u6a21\u677f\u53c2\u6570pageId:{},formId\uff1a{},pkIds\uff1a{},templateId\uff1a{},\u8fd4\u56de\u503c\uff1a{}", new Object[]{pageId, formId, pkIds, templateId});
                returnUrl = FileUtils.getNewPrintUrl(pageId, formId, templateId, pkIds, printType);
                logger.info("\u65b0\u6a21\u677f\u53c2\u6570pageId:{},formId\uff1a{},pkIds\uff1a{},templateId\uff1a{},\u8fd4\u56de\u503c\uff1a{}", new Object[]{pageId, formId, pkIds, templateId, returnUrl});
            }
        }
        catch (Exception e) {
            String string = String.format(ResManager.loadKDString((String)"\u6a21\u677f\u53c2\u6570[formId\uff1a%1$s\uff0cpkIds\uff1a%2$s\uff0ctemplateId\uff1a%3$s]", (String)"FileUtils_4", (String)"fi-aef-common", (Object[])new Object[0]), formId, pkIds, templateId);
            logger.error(string + "\u3002printerror:" + e);
            throw e;
        }
        return returnUrl;
    }

    public static void closeOutputStreamQuietly(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeInputStreamQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static File getFile(String path) {
        return new File(FilenameUtils.getFullPath((String)path) + FilenameUtils.getName((String)path));
    }
}

