/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.common.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.entity.Attach;
import kd.fi.aef.entity.BillInfo;
import org.dom4j.Element;

public class JDomB9Utils {
    public static Element addChildAndName(Element parent, String childElementName, String text) {
        Element child = parent.addElement(childElementName);
        child.setText(text);
        return child;
    }

    public static Element addChildAndName(Element parent, String childElementName) {
        Element child = parent.addElement(childElementName);
        return child;
    }

    public static void addFiles(Element filelist, String fileNodeName, List<Attach> attaches, String voucherId, String fileName) {
        Element mainfile = filelist.addElement(fileNodeName);
        JDomB9Utils.addChildAndName(mainfile, "name", fileName);
        JDomB9Utils.addChildAndName(mainfile, "srcname", fileName);
        if (attaches == null || attaches.isEmpty()) {
            return;
        }
        for (Attach attach : attaches) {
            String name = attach.getFileName();
            Element file = filelist.addElement(fileNodeName);
            JDomB9Utils.addChildAndName(file, "name", voucherId + "_" + attach.getFileSize() + "_" + name);
            JDomB9Utils.addChildAndName(file, "srcname", name);
        }
    }

    public static void addChildAndNameForRefbills(Element refbilllist, String refbillNodeName, Map<String, Set<Long>> refBillMap, Set<String> refBillTypes) {
        if (refBillMap == null || refBillMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Set<Long>> entry : refBillMap.entrySet()) {
            if (refBillTypes == null || !refBillTypes.contains(entry.getKey())) continue;
            for (Long billid : entry.getValue()) {
                if (billid == 0L) continue;
                Element refbill = refbilllist.addElement(refbillNodeName);
                String billType = entry.getKey();
                if ("ap_finapbill".equals(billType)) {
                    JDomB9Utils.addChildAndName(refbill, "billid", "ap_invoice_" + billid);
                } else {
                    JDomB9Utils.addChildAndName(refbill, "billid", billType + "_" + billid);
                }
                JDomB9Utils.addChildAndName(refbill, "doctype", "srcVoucher");
            }
        }
    }

    public static void addFaChildAndName(Element datalist, DataSet set, Map<Long, String> billFileNameMap, Map<Long, List<Attach>> attachMap, Set<Long> errIds) {
        int i = 0;
        for (Row row : set) {
            ++i;
            Long billId = row.getLong("id");
            if (errIds != null && errIds.size() > 0 && errIds.contains(billId)) continue;
            Element data = JDomB9Utils.addChildAndName(datalist, "data");
            JDomB9Utils.addChildAndName(data, "id", i + "");
            JDomB9Utils.addChildAndName(data, "billid", row.getString("id"));
            JDomB9Utils.addChildAndName(data, "period", CreateXmlUtil.dealPeriodNumber(row.getString("periodnumber")));
            JDomB9Utils.addChildAndName(data, "voucherorgnumber", row.getString("orgnumber"));
            JDomB9Utils.addChildAndName(data, "voucherorgname", row.getString("orgname"));
            JDomB9Utils.addChildAndName(data, "assetcode", row.getString("assetcode") == null ? "" : row.getString("assetcode"));
            JDomB9Utils.addChildAndName(data, "assetname", row.getString("assetname") == null ? "" : row.getString("assetname"));
            JDomB9Utils.addChildAndName(data, "assettype", row.getString("assettype") == null ? "" : row.getString("assettype"));
            JDomB9Utils.addChildAndName(data, "usedept", row.getString("usedept") == null ? "" : row.getString("usedept"));
            JDomB9Utils.addChildAndName(data, "usestarttime", row.getString("usestarttime") == null ? "" : DateUtil.getTimeStr(row.getDate("usestarttime")));
            JDomB9Utils.addChildAndName(data, "depreciation", row.getString("depreciation") == null ? "" : row.getString("depreciation"));
            JDomB9Utils.addChildAndName(data, "originalvalue", row.getString("originalvalue") == null ? "" : row.getString("originalvalue"));
            JDomB9Utils.addChildAndName(data, "currency", row.getString("currency") == null ? "" : row.getString("currency"));
            Element filelist = JDomB9Utils.addChildAndName(data, "file-list");
            Element file = JDomB9Utils.addChildAndName(filelist, "file");
            String fileName = billFileNameMap.get(billId);
            JDomB9Utils.addChildAndName(file, "name", fileName);
            JDomB9Utils.addChildAndName(file, "srcname", fileName);
            List<Attach> attaches = attachMap.get(billId);
            if (attaches == null) continue;
            for (Attach attachfile : attaches) {
                Element attach = filelist.addElement("file");
                JDomB9Utils.addChildAndName(attach, "name", billId + "_" + attachfile.getFileName());
                JDomB9Utils.addChildAndName(attach, "srcname", attachfile.getFileName());
            }
        }
    }

    public static void addChildAndNameForRefbills(Element refbilllist, String refbill, Set<Long> ids) {
        for (Long billid : ids) {
            Element refbillNode = refbilllist.addElement(refbill);
            JDomB9Utils.addChildAndName(refbillNode, "billid", "gl_voucher" + billid);
            JDomB9Utils.addChildAndName(refbillNode, "doctype", "voucher");
        }
    }

    public static void addChildAndNameForRefbills(Element refbilllist, String refbill, Set<Long> ids, Map<Long, BillInfo> voucherInfoMap) {
        for (Long billid : ids) {
            Element refbillNode = refbilllist.addElement(refbill);
            JDomB9Utils.addChildAndName(refbillNode, "billid", "gl_voucher" + billid);
            JDomB9Utils.addChildAndName(refbillNode, "vouchernum", voucherInfoMap.get(billid) == null ? "" : voucherInfoMap.get(billid).getBillNo());
            JDomB9Utils.addChildAndName(refbillNode, "vouchertype", voucherInfoMap.get(billid) == null || voucherInfoMap.get(billid).getFieldMap() == null ? "" : voucherInfoMap.get(billid).getFieldMap().get("vouchertypename"));
            JDomB9Utils.addChildAndName(refbillNode, "doctype", "voucher");
        }
    }

    public static void addData(Element datalist, List<Map<String, String>> xmlList, boolean isSub) {
        int i = 0;
        for (Map<String, String> map : xmlList) {
            Element data = JDomB9Utils.addChildAndName(datalist, "data");
            JDomB9Utils.addChildAndName(data, "id", ++i + "");
            JDomB9Utils.addChildAndName(data, "billid", map.get("billid"));
            JDomB9Utils.addChildAndName(data, "period", map.get("period"));
            JDomB9Utils.addChildAndName(data, "voucherorgnumber", map.get("voucherorgnumber"));
            JDomB9Utils.addChildAndName(data, "voucherorgname", map.get("voucherorgname"));
            JDomB9Utils.addChildAndName(data, "currency", ResManager.loadKDString((String)"\u6240\u6709\u5e01\u522b", (String)"JDomB9Utils_1", (String)"fi-aef-common", (Object[])new Object[0]));
            if (isSub) {
                JDomB9Utils.addChildAndName(data, "subjno", map.get("subjno"));
                JDomB9Utils.addChildAndName(data, "subj", map.get("subj"));
            } else {
                Element jelinelist = JDomB9Utils.addChildAndName(data, "jeline-list");
                Element jeline = JDomB9Utils.addChildAndName(jelinelist, "jeline");
                JDomB9Utils.addChildAndName(jeline, "subjno", map.get("subjno") == null ? "" : map.get("subjno"));
                JDomB9Utils.addChildAndName(jeline, "subj", map.get("subj") == null ? "" : map.get("subj"));
            }
            Element filelist = JDomB9Utils.addChildAndName(data, "file-list");
            Element file = JDomB9Utils.addChildAndName(filelist, "file");
            JDomB9Utils.addChildAndName(file, "name", map.get("file"));
            JDomB9Utils.addChildAndName(file, "srcname", map.get("file"));
        }
    }
}

