/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.common.util;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.SysParamConfig;

public class MutexRequireUtil {
    private static Log logger = LogFactory.getLog(MutexRequireUtil.class);
    private static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static SimpleDateFormat timesdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String MUTEX_DATAOBJID = "dataObjId";
    private static final String MUTEX_GROUPID = "groupId";
    private static final String MUTEX_ENTITYKEY = "entityKey";
    private static final String MUTEX_OPERATIONKEY = "operationKey";
    private static final String MUTEX_ISSTRICT = "isStrict";
    private static final String FIARCHIVE = "fi_archive";

    public static Set<Long> requireMutex(String entityKey, Set<Long> billids) {
        int locktime = SysParamConfig.getInt("locktime", 30);
        HashSet<Long> lockIDs = new HashSet<Long>();
        if (billids.size() == 0) {
            return lockIDs;
        }
        boolean isStrict = true;
        String netGroupId = "ArchiveOpService";
        ArrayList mutexRequireList = new ArrayList(billids.size());
        for (Long l : billids) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>(8);
            requireParam.put(MUTEX_DATAOBJID, l.toString());
            requireParam.put(MUTEX_GROUPID, netGroupId);
            requireParam.put(MUTEX_ENTITYKEY, entityKey);
            requireParam.put(MUTEX_OPERATIONKEY, FIARCHIVE);
            requireParam.put(MUTEX_ISSTRICT, isStrict);
            mutexRequireList.add(requireParam);
        }
        try {
            Throwable throwable = null;
            try (DataMutex dataMutex = DataMutex.create();){
                Map mutexResult = dataMutex.batchrequire(mutexRequireList);
                long now = System.currentTimeMillis();
                HashMap<Long, String> userName = new HashMap<Long, String>(2);
                ArrayList<Long> failIDs = new ArrayList<Long>(8);
                for (Map.Entry mutexItem : mutexResult.entrySet()) {
                    String string = (String)mutexItem.getKey();
                    Boolean ret = (Boolean)mutexItem.getValue();
                    Long ID = 0L;
                    ID = Long.valueOf(string);
                    if (ret.booleanValue()) {
                        lockIDs.add(ID);
                        continue;
                    }
                    failIDs.add(ID);
                }
                HashSet<Long> toReleaseSet = new HashSet<Long>(8);
                for (Long l : failIDs) {
                    Map lockInfo = dataMutex.getLockInfo(l.toString(), netGroupId, entityKey);
                    StringBuilder sb = new StringBuilder();
                    if (lockInfo != null) {
                        Long userid = Long.valueOf((String)lockInfo.get("userid"));
                        String timeStr = (String)lockInfo.get("lockedTime");
                        long timeL = 0L;
                        if (timeStr != null && now - (timeL = Long.parseLong(timeStr)) > (long)(locktime * 60 * 1000)) {
                            LogUtil.printLog(logger, ResManager.loadKDString((String)"\u5f52\u6863\u9501\u9501\u5b9a\u8d85\u8fc70.5\u5c0f\u65f6{}\uff0c\u81ea\u52a8\u89e3\u9501\uff0c\u5355\u636eID\uff1a{}", (String)"MutexRequireUtil_0", (String)"fi-aef-common", (Object[])new Object[0]), entityKey, l);
                            toReleaseSet.add(l);
                            continue;
                        }
                        sb.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u7528\u6237", (String)"MutexRequireUtil_10", (String)"fi-ai-mservice", (Object[])new Object[0]));
                        String uName = userName.computeIfAbsent(userid, uid -> {
                            DynamicObject userObj = BusinessDataServiceHelper.loadSingle((Object)uid, (String)"bos_user");
                            if (userObj != null) {
                                return userObj.getString("name");
                            }
                            return "";
                        });
                        sb.append(uName);
                        if (timeL != 0L) {
                            sb.append(ResManager.loadKDString((String)"\u5728", (String)"MutexRequireUtil_1", (String)"fi-ai-mservice", (Object[])new Object[0])).append(timesdf.format(new Date(timeL)));
                        }
                        sb.append(ResManager.loadKDString((String)"\u9501\u5b9a", (String)"MutexRequireUtil_2", (String)"fi-ai-mservice", (Object[])new Object[0]));
                    } else {
                        sb.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u7528\u6237\u9501\u5b9a", (String)"MutexRequireUtil_3", (String)"fi-ai-mservice", (Object[])new Object[0]));
                    }
                    logger.info(sb.toString());
                }
                if (toReleaseSet.size() > 0) {
                    MutexRequireUtil.batchRelease(entityKey, toReleaseSet);
                    mutexRequireList = new ArrayList(toReleaseSet.size());
                    for (Long l : toReleaseSet) {
                        HashMap<String, Object> requireParam = new HashMap<String, Object>(8);
                        requireParam.put(MUTEX_DATAOBJID, l.toString());
                        requireParam.put(MUTEX_GROUPID, netGroupId);
                        requireParam.put(MUTEX_ENTITYKEY, entityKey);
                        requireParam.put(MUTEX_OPERATIONKEY, FIARCHIVE);
                        requireParam.put(MUTEX_ISSTRICT, isStrict);
                        mutexRequireList.add(requireParam);
                    }
                    mutexResult = dataMutex.batchrequire(mutexRequireList);
                    for (Map.Entry entry : mutexResult.entrySet()) {
                        String objId = (String)entry.getKey();
                        Boolean ret = (Boolean)entry.getValue();
                        Long ID = 0L;
                        ID = Long.valueOf(objId);
                        if (ret.booleanValue()) {
                            lockIDs.add(ID);
                            continue;
                        }
                        Map lockInfo = dataMutex.getLockInfo(objId, netGroupId, entityKey);
                        StringBuilder sb = new StringBuilder();
                        if (lockInfo != null) {
                            Long userid = Long.valueOf((String)lockInfo.get("userid"));
                            String timeStr = (String)lockInfo.get("lockedTime");
                            long timeL = 0L;
                            if (timeStr != null) {
                                timeL = Long.parseLong(timeStr);
                            }
                            sb.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u7528\u6237", (String)"MutexRequireUtil_10", (String)"fi-aef-common", (Object[])new Object[0]));
                            String uName = userName.computeIfAbsent(userid, uid -> {
                                DynamicObject userObj = BusinessDataServiceHelper.loadSingle((Object)uid, (String)"bos_user");
                                if (userObj != null) {
                                    return userObj.getString("name");
                                }
                                return "";
                            });
                            sb.append(uName);
                            if (timeL != 0L) {
                                sb.append(ResManager.loadKDString((String)"\u5728", (String)"MutexRequireUtil_1", (String)"fi-aef-common", (Object[])new Object[0])).append(timesdf.format(new Date(timeL)));
                            }
                            sb.append(ResManager.loadKDString((String)"\u9501\u5b9a", (String)"MutexRequireUtil_2", (String)"fi-aef-common", (Object[])new Object[0]));
                        } else {
                            sb.append(ResManager.loadKDString((String)"\u8be5\u5bf9\u8c61\u88ab\u7528\u6237\u9501\u5b9a", (String)"MutexRequireUtil_3", (String)"fi-aef-common", (Object[])new Object[0]));
                        }
                        logger.info(sb.toString());
                    }
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            MutexRequireUtil.batchRelease(entityKey, lockIDs);
            ErrorCode errorCode = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"MutexRequireUtil_4", (String)"fi-aef-common", (Object[])new Object[0]), e.getMessage()));
            throw new KDException((Throwable)e, errorCode, new Object[0]);
        }
        return lockIDs;
    }

    public static Set<Object> requireMutex(Set<Object> billids, String entityKey) {
        HashSet<Long> bills = new HashSet<Long>(billids.size());
        for (Object o : billids) {
            bills.add(Long.valueOf(o.toString()));
        }
        return MutexRequireUtil.requireMutex(entityKey, bills).stream().collect(Collectors.toSet());
    }

    public static void batchRelease(String entityNumber, Set<Long> lockIDs) {
        String netGroupId = "ArchiveOpService";
        if (!lockIDs.isEmpty()) {
            ArrayList mutexRequireList = new ArrayList(lockIDs.size());
            for (Long lockID : lockIDs) {
                HashMap<String, String> requireParam = new HashMap<String, String>(8);
                requireParam.put(MUTEX_DATAOBJID, lockID.toString());
                requireParam.put(MUTEX_GROUPID, netGroupId);
                requireParam.put(MUTEX_ENTITYKEY, entityNumber);
                requireParam.put(MUTEX_OPERATIONKEY, FIARCHIVE);
                mutexRequireList.add(requireParam);
            }
            try (DataMutex dataMutex = DataMutex.create();){
                Map releaseResult = dataMutex.batchRelease(mutexRequireList);
                for (Map.Entry releaseItem : releaseResult.entrySet()) {
                    boolean releaseRet = (Boolean)releaseItem.getValue();
                    String objId = (String)releaseItem.getKey();
                    if (releaseRet) continue;
                    LogUtil.printLog(logger, ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61{}\u4e92\u65a5\u9501\u5931\u8d25", (String)"MutexRequireUtil_11", (String)"fi-aef-common", (Object[])new Object[0]), objId);
                }
            }
            catch (IOException e) {
                throw new KDException((Throwable)e, new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u91ca\u653e\u6570\u636e\u5bf9\u8c61\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"MutexRequireUtil_5", (String)"fi-aef-common", (Object[])new Object[0]), e.getMessage())), new Object[0]);
            }
        }
    }
}

