/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.common.util;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.util.SysParamConfig;

public class RptArchiveUtil {
    private static final Log logger = LogFactory.getLog(RptArchiveUtil.class);

    public static String toBase64(byte[] bytes) {
        if (bytes != null && bytes.length > 0) {
            return Base64.getEncoder().encodeToString(bytes);
        }
        return "";
    }

    public static void saveRptrecords(String className, List<DynamicObject> dynamicObjects, List<String> uniqueKey) {
        Map<String, String> uniqueKey2NewBatchCodeMap = dynamicObjects.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("uniquekey"), dynamicObject -> dynamicObject.getString("batchcode")));
        try (TXHandle tx = TX.requiresNew((String)className);){
            boolean b = SysParamConfig.getBoolean("needwritebackstatus", false);
            try {
                DynamicObject[] records = BusinessDataServiceHelper.load((String)"aef_acelre_rpt", (String)"wayid,reason,filingid,fexetime,type,uniquekey,status,batchcode", (QFilter[])new QFilter[]{new QFilter("uniquekey", "in", uniqueKey)});
                ArrayList<String> uniqueKeys = new ArrayList<String>(16);
                if (records.length > 0) {
                    for (DynamicObject record : records) {
                        String uniquekey;
                        String newBatchCode;
                        record.set("wayid_id", (Object)((DynamicObject)dynamicObjects.get(0)).getLong("wayid"));
                        record.set("reason", (Object)"");
                        record.set("type", (Object)Character.valueOf('1'));
                        record.set("filingid_id", (Object)UserServiceHelper.getCurrentUserId());
                        record.set("fexetime", (Object)new Date());
                        if (b) {
                            record.set("status", (Object)"2");
                        }
                        if (StringUtils.isNotEmpty((CharSequence)(newBatchCode = uniqueKey2NewBatchCodeMap.get(uniquekey = record.getString("uniquekey"))))) {
                            record.set("batchcode", (Object)newBatchCode);
                        }
                        uniqueKeys.add(record.getString("uniquekey"));
                    }
                    SaveServiceHelper.save((DynamicObject[])records);
                }
                if ((dynamicObjects = dynamicObjects.stream().filter(DynamicObject2 -> !uniqueKeys.contains(DynamicObject2.getString("uniquekey"))).collect(Collectors.toList())).size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", (String)"AbstractArchiveLogicUnit_13", (String)"fi-aef-common", (Object[])new Object[0]), className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }

    public static void updateRptrecords(String className, List<DynamicObject> dynamicObjects, List<String> uniqueKey, String reason) {
        try (TXHandle tx = TX.requiresNew((String)className);){
            boolean b = SysParamConfig.getBoolean("needwritebackstatus", false);
            try {
                DynamicObject[] records;
                for (DynamicObject record : records = BusinessDataServiceHelper.load((String)"aef_acelre_rpt", (String)"reason,filingid,fexetime,type,status", (QFilter[])new QFilter[]{new QFilter("uniquekey", "in", uniqueKey)})) {
                    record.set("reason", (Object)reason);
                    record.set("type", (Object)Character.valueOf('2'));
                    record.set("filingid_id", (Object)UserServiceHelper.getCurrentUserId());
                    record.set("fexetime", (Object)new Date());
                    if (!b) continue;
                    record.set("status", (Object)"2");
                }
                SaveServiceHelper.save((DynamicObject[])records);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", (String)"AbstractArchiveLogicUnit_13", (String)"fi-aef-common", (Object[])new Object[0]), className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }

    public static Map<String, String> getRptGetOrgMap(Map<String, Long> rptOrglMap) {
        Collection<Long> pkIds = rptOrglMap.values();
        HashMap<String, String> returnMap = new HashMap<String, String>(16);
        HashMap<Long, String> orgMap = new HashMap<Long, String>(16);
        QFilter idFilter = new QFilter("id", "in", pkIds);
        String fields = "id, number, name";
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)fields, (QFilter[])new QFilter[]{idFilter}, null);
        for (DynamicObject object : dys) {
            orgMap.put(object.getLong("id"), object.getString("name") + "_" + object.getString("number"));
        }
        rptOrglMap.forEach((key, pkId) -> {
            if (orgMap.containsKey(pkId)) {
                returnMap.put((String)key, (String)orgMap.get(pkId));
            }
        });
        return returnMap;
    }

    public static Map<String, String> getRptGetNameMap(Map<String, Long> rptNameMap) {
        Collection<Long> pkIds = rptNameMap.values();
        HashMap<String, String> returnMap = new HashMap<String, String>(16);
        HashMap<Long, String> modelMap = new HashMap<Long, String>(16);
        QFilter idFilter = new QFilter("id", "in", pkIds);
        String fields = "id, name";
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_templateentity", (String)fields, (QFilter[])new QFilter[]{idFilter}, null);
        for (DynamicObject object : dys) {
            modelMap.put(object.getLong("id"), object.getString("name"));
        }
        rptNameMap.forEach((key, pkId) -> {
            if (modelMap.containsKey(pkId)) {
                returnMap.put((String)key, (String)modelMap.get(pkId));
            }
        });
        return returnMap;
    }

    public static Set<String> getHasArchivedKeys(String uploadWay, long bcmscene, long bcmfy, Set<Long> periods) {
        HashSet<String> uniKeys = new HashSet<String>(16);
        QFilter qFilter = new QFilter("uploadWay", "=", (Object)uploadWay);
        QFilter qFilter1 = new QFilter("type", "=", (Object)"1");
        QFilter qFilter2 = new QFilter("bcmscene", "=", (Object)bcmscene);
        QFilter qFilter3 = new QFilter("bcmfy", "=", (Object)bcmfy);
        QFilter qFilter4 = new QFilter("bcmperiod", "in", periods);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ArchiveReportFormByFpyLogicUnit", (String)"aef_acelre_rpt", (String)"uniquekey", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2, qFilter3, qFilter4}, null);){
            for (Row row : dataSet) {
                uniKeys.add(row.getString("uniquekey"));
            }
        }
        return uniKeys;
    }
}

