/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.elec.util;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.aef.common.util.LogUtil;

public class XbrlArchieveUtil {
    private static final String SEQNO = "seqNo";
    private static final String COSTCOMPANY = "costcompany";
    private static final Log logger = LogFactory.getLog(XbrlArchieveUtil.class);
    public static final Set<String> NEED_FIND_VOICEINFO_TICKETTYPRS = new HashSet<String>(Arrays.asList("atr_receiver", "rai_receiver", "inv_ord_receiver", "inv_spcl_receiver", "inv_tlf_receiver", "einv_ord_receiver", "einv_spcl_receiver", "efi", "ntrev_gpm_receiver"));

    public static Map<String, JSONObject> getSeqNoAndJson(Map<Long, List<JSONObject>> billInvoice) {
        Map<String, Object> seqNoAndJsonObject = new HashMap<String, JSONObject>(16);
        if (billInvoice.size() == 0) {
            return seqNoAndJsonObject;
        }
        Map<String, Map<Long, Set<String>>> ticketTypeAndSeqNos = XbrlArchieveUtil.getTicketTypeAndSeqNos(billInvoice.values());
        seqNoAndJsonObject = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"er", (String)"erGetBizBillInfoImpl", (String)"getSeqNoAndJson", (Object[])new Object[]{ticketTypeAndSeqNos});
        LogUtil.printLog(logger, ResManager.loadKDString((String)"getSeqNoAndJson \u53c2\u6570 {},\u8fd4\u56de\u503c:{}", (String)"XbrlArchieveUtil_0", (String)"fi-aef-common", (Object[])new Object[0]), ticketTypeAndSeqNos, seqNoAndJsonObject);
        return seqNoAndJsonObject;
    }

    private static Map<String, Map<Long, Set<String>>> getTicketTypeAndSeqNos(Collection<List<JSONObject>> values) {
        HashMap<String, Map<Long, Set<String>>> ticketTypeAndSeqNos = new HashMap<String, Map<Long, Set<String>>>(values.size());
        for (List<JSONObject> list : values) {
            for (JSONObject jsonObject : list) {
                String seqNo = jsonObject.getString(SEQNO);
                Long costcompany = jsonObject.getLong(COSTCOMPANY);
                String tickettype = jsonObject.getString("tickettype");
                if (StringUtils.isEmpty((String)seqNo)) continue;
                ticketTypeAndSeqNos.computeIfAbsent(tickettype, value -> new HashMap()).computeIfAbsent(costcompany, value -> new HashSet()).add(seqNo);
            }
        }
        return ticketTypeAndSeqNos;
    }
}

