/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.aef.entity.PrintIdandType;
import kd.fi.aef.entity.PrintTemplate;
import kd.fi.aef.entity.SchemeEntry;

public class ArchiveSchemeHelper {
    private static final Log log = LogFactory.getLog(ArchiveSchemeHelper.class);

    public static DynamicObjectCollection getArchiveSchemeEntry(Long id) {
        if (id == null || id == 0L) {
            return null;
        }
        String entityName = "aef_archivescheme";
        DynamicObject archiveScheme = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName);
        return archiveScheme.getDynamicObjectCollection("entryentity");
    }

    public static DataSet getArchiveBill(Set<Long> archiveOrgs, SchemeEntry scheme) {
        String billtype = scheme.getBillType();
        String json = scheme.getArchiverange();
        QFilter customFilter = null;
        if (StringUtils.isNotEmpty((String)json)) {
            customFilter = ArchiveSchemeHelper.getCustomQFilter(billtype, json);
        }
        DataSet billSet = ArchiveSchemeHelper.querydata(billtype, customFilter, archiveOrgs);
        return billSet;
    }

    public static DataSet getArchiveBill(Set<Long> archiveOrgs, DynamicObject arcSchemeEntryRow) {
        if (arcSchemeEntryRow == null) {
            return null;
        }
        String archivetype = arcSchemeEntryRow.getString("archivetype");
        if ("finance".equals(archivetype)) {
            return null;
        }
        String billtype = arcSchemeEntryRow.getString("billtype.number");
        String archiverange = arcSchemeEntryRow.getString("archiverange");
        String json = arcSchemeEntryRow.getString("archiverangejson");
        QFilter customFilter = null;
        if (StringUtils.isNotEmpty((String)archiverange) && StringUtils.isNotEmpty((String)json)) {
            customFilter = ArchiveSchemeHelper.getCustomQFilter(billtype, json);
        }
        return ArchiveSchemeHelper.querydata(billtype, customFilter, archiveOrgs);
    }

    public static QFilter getCustomQFilter(String entityNumber, String jsonStr) {
        FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)jsonStr, FilterCondition.class);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterBuilder filBuilder = new FilterBuilder(entityType, fc);
        filBuilder.buildFilter(false);
        return filBuilder.getFilterObject().getQFilter();
    }

    private static DataSet querydata(String entityName, QFilter qfilter, Set<Long> archiveOrgs) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(qfilter);
        BillEntityType bet = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityName);
        String mainOrg = bet.getMainOrg();
        if (StringUtils.isEmpty((String)mainOrg)) {
            log.info(ArchiveSchemeHelper.class + ".querydata()->\u5355\u636e\uff1a" + entityName + "\u627e\u4e0d\u5230\u5355\u636e\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u5b57\u6bb5");
            return null;
        }
        qFilters.add(new QFilter(mainOrg, "in", archiveOrgs));
        String algoKey = ArchiveSchemeHelper.class + ".querydata()." + entityName;
        String selectFields = "id";
        DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), null);
        return ds;
    }

    public static Set<Long> queryHasArchivedBill(Set<Long> archiveOrgs, String billtype) {
        String algoKey = ArchiveSchemeHelper.class + ".queryHasArchivedBill";
        String entityName = "aef_acelre";
        QFilter billFliter = new QFilter("billtype", "=", (Object)billtype);
        QFilter orgFilter = null;
        if (archiveOrgs != null) {
            orgFilter = new QFilter("org", "in", archiveOrgs);
        }
        HashSet<Long> idSet = new HashSet<Long>();
        try (DataSet hasArchivedBill = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"billid", (QFilter[])new QFilter[]{billFliter, orgFilter}, null, (int)1000000);){
            for (Row row : hasArchivedBill) {
                idSet.add(row.getLong("billid"));
            }
        }
        return idSet;
    }

    public static Map<Long, PrintIdandType> getBillIdAndPrintId(List<PrintTemplate> printTemplates, String billType, Set<Long> billIds) {
        HashMap<Long, PrintIdandType> getTemplateMap = new HashMap<Long, PrintIdandType>(16);
        PrintIdandType defaultpt = new PrintIdandType();
        for (PrintTemplate printTemplate : printTemplates) {
            String templateNumber = printTemplate.getTemplateNumber();
            if (StringUtils.isBlank((String)printTemplate.getExpressjson())) {
                defaultpt.setPrintId(ArchiveSchemeHelper.queryPrintId(templateNumber, printTemplate.getPrintType()));
                defaultpt.setPrintType(printTemplate.getPrintType());
                continue;
            }
            QFilter idFilter = new QFilter("id", "in", billIds);
            QFilter rangeFilter = ArchiveSchemeHelper.getCustomQFilter(billType, printTemplate.getExpressjson());
            List ids = QueryServiceHelper.queryPrimaryKeys((String)billType, (QFilter[])new QFilter[]{idFilter, rangeFilter}, null, (int)-1);
            if (ids.size() > 0) {
                for (Object id : ids) {
                    PrintIdandType printIdandType = new PrintIdandType();
                    printIdandType.setPrintId(ArchiveSchemeHelper.queryPrintId(templateNumber, printTemplate.getPrintType()));
                    printIdandType.setPrintType(printTemplate.getPrintType());
                    getTemplateMap.put(Long.valueOf(id.toString()), printIdandType);
                }
            }
            billIds.removeAll(ids);
        }
        if (billIds.size() > 0 && StringUtils.isNotEmpty((String)defaultpt.getPrintId())) {
            for (Long billId : billIds) {
                getTemplateMap.put(billId, defaultpt);
            }
        }
        return getTemplateMap;
    }

    public static String queryPrintId(String printSample, int printType) {
        if (printType == 1) {
            return MetadataDao.getIdByNumber((String)printSample, (MetaCategory)MetaCategory.Form);
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_print_meta", (String)"number, id", (QFilter[])new QFilter("number", "=", (Object)printSample).toArray());
        if (null != dynamicObject) {
            return dynamicObject.get("id").toString();
        }
        return "";
    }

    public static List<PrintTemplate> getTemplateStatusMap(List<PrintTemplate> refPrintTemplates) {
        List allList = refPrintTemplates.stream().map(PrintTemplate::getTemplateNumber).collect(Collectors.toList());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ArrayList<String> oldList = new ArrayList<String>();
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter1 = new QFilter("printtplid.number", "in", allList);
        DynamicObjectCollection printsamples = QueryServiceHelper.query((String)"bas_manageprinttpl", (String)"printtplid.number,enable", (QFilter[])new QFilter[]{qFilter, qFilter1});
        for (DynamicObject printsample : printsamples) {
            oldList.add(printsample.getString("printtplid.number"));
            map.put(printsample.getString("printtplid.number"), 1);
        }
        allList.removeAll(oldList);
        QFilter qFilter2 = new QFilter("printtplid.number", "in", allList);
        DynamicObjectCollection newPrintsamples = QueryServiceHelper.query((String)"bos_manageprinttpl", (String)"printtplid.number,enable", (QFilter[])new QFilter[]{qFilter, qFilter2});
        for (DynamicObject printsample : newPrintsamples) {
            if (map.containsKey(printsample.getString("printtplid.number"))) continue;
            map.put(printsample.getString("printtplid.number"), 2);
        }
        for (PrintTemplate printTemplate : refPrintTemplates) {
            if (!map.containsKey(printTemplate.getTemplateNumber())) continue;
            printTemplate.setPrintType((Integer)map.get(printTemplate.getTemplateNumber()));
        }
        return refPrintTemplates;
    }
}

