/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.helper;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.cache.PageCache;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;

public class ReportPrintUtil
implements AutoCloseable {
    private String pageId;
    private static Log logger = LogFactory.getLog(ReportPrintUtil.class);

    public String simulateReportSearch(String formId, Map<String, Object> params) {
        ReportFilter filter;
        FormConfig config = FormMetadataCache.getFormConfig((String)formId);
        ReportView view = null;
        if (this.pageId == null) {
            ReportShowParameter report = new ReportShowParameter();
            report.beginInit();
            report.setFormId(formId);
            report.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            report.setFormConfig(config);
            report.setCustomParam("bos_reportConcurrencyQueryLimit", (Object)"false");
            this.pageId = report.getPageId();
            Iterator<Map.Entry<String, Object>> reportJson = FormShowParameter.toJsonString((FormShowParameter)report);
            report.endInit();
            view = (ReportView)report.createView();
            PageCache page = new PageCache(this.pageId);
            view.addService(IPageCache.class, (Object)page);
            page.put(FormShowParameter.class.getSimpleName(), reportJson);
            view.initialize((FormShowParameter)report);
        } else {
            view = (ReportView)SessionManager.getCurrent().getView(this.pageId);
        }
        IDataModel model = view.getModel();
        model.createNewData();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if ("isAsynQuery".equals(entry.getKey())) continue;
            if ("gl_rpt_subledger".equals(formId) && "org".equals(entry.getKey())) {
                model.setValue("orgs", (Object)new Long[]{(Long)entry.getValue()});
            }
            model.setValue((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (!"account".equals(entry.getKey())) continue;
            model.setValue(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (!"startperiod".equals(entry.getKey()) && !"endperiod".equals(entry.getKey())) continue;
            model.setValue(entry.getKey(), entry.getValue());
        }
        Boolean isAsynQuery = (Boolean)params.get("isAsynQuery");
        if (isAsynQuery != null && isAsynQuery.booleanValue()) {
            filter = (ReportFilter)view.getControl("reportfilterap");
            filter.search();
            ReportList list = view.getReportList();
            list.setAsynQuery(isAsynQuery.booleanValue());
            ReportQueryParam param = view.getQueryParam();
            DynamicObjectCollection accountColl = (DynamicObjectCollection)param.getFilter().getValue("account");
            if (accountColl != null && accountColl.isEmpty()) {
                accountColl = null;
            }
            list.submitTask(param, (Object)accountColl);
        } else {
            filter = (ReportFilter)view.getControl("reportfilterap");
            filter.search();
        }
        ReportListModel listModel = (ReportListModel)view.getReportList().getReportModel();
        if (listModel.getRowCount() < 1) {
            logger.error("simulateReport\u53c2\u6570formId\uff1a{},params\uff1a{},\u8fd4\u56de\u503cpageid\uff1a{}", new Object[]{formId, params, this.pageId});
            return null;
        }
        logger.info("simulateReport\u53c2\u6570formId\uff1a{},params\uff1a{},\u8fd4\u56de\u503cpageid\uff1a{}", new Object[]{formId, params, this.pageId});
        return this.pageId;
    }

    @Override
    public void close() {
        try {
            ReportView view = (ReportView)SessionManager.getCurrent().getView(this.pageId);
            if (view != null) {
                FormController controller = new FormController((IFormView)view);
                controller.release(new LinkedHashMap());
            }
        }
        catch (Exception e) {
            logger.error("pageId:" + this.pageId + " release error." + e.getMessage());
        }
    }
}

