/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.common;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.fi.aef.common.util.JudgeBillType;
import kd.fi.aef.common.util.SysParamConfig;
import kd.fi.aef.constant.BillType;
import kd.fi.aef.entity.ArchiveLogInfo;
import kd.fi.aef.logic.model.Bill;

public class ArchiveRecordUtils {
    public static DynamicObject getArhieveRecordDynamicObject(String billType, String application, Long schemeId, Bill bill, Long userId, Date date, String uploadway, String optype, String reason, Date billbizdate, String uniquekey, String batchCode) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"aef_acelre");
        DynamicObject temp = (DynamicObject)type.createInstance();
        temp.set("billtype", (Object)billType);
        temp.set("application", (Object)application);
        temp.set("wayid", (Object)schemeId);
        if (null != bill) {
            temp.set("billno", (Object)bill.getBillNo());
            temp.set("billid", bill.getBillId());
            temp.set("org", (Object)bill.getOrgId());
            if (JudgeBillType.isFinaceBill(billType) || "cas_bankstatement".equals(billType) || "cas_balanceadjust".equals(billType)) {
                temp.set("filingperiod", (Object)bill.getPeriodId());
                if ("gl_voucher".equals(billType)) {
                    temp.set("booktype", (Object)bill.getBookTypeId());
                }
            }
        }
        temp.set("batchcode", (Object)batchCode);
        temp.set("uploadway", (Object)uploadway);
        temp.set("type", (Object)optype);
        temp.set("reason", (Object)reason);
        temp.set("billbizdate", (Object)billbizdate);
        temp.set("uniquekey", (Object)uniquekey);
        if (SysParamConfig.getBoolean("needwritebackstatus", false)) {
            temp.set("status", (Object)"2");
        }
        temp.set("billstatus", (Object)"C");
        temp.set("filingid", (Object)userId);
        temp.set("creator", (Object)userId);
        temp.set("auditor", (Object)userId);
        temp.set("modifier", (Object)userId);
        temp.set("fexetime", (Object)date);
        temp.set("createtime", (Object)date);
        temp.set("modifytime", (Object)date);
        return temp;
    }

    public static DynamicObject getArhieveRecordRptDynamicObject(String billType, String appId, String schemeId, Map<String, Object> map, Date date, String uploadway, Long billId, Long userId, String optype, String reason, Date billbizdate, String uniquekey) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"aef_acelre");
        DynamicObject temp = (DynamicObject)type.createInstance();
        temp.set("billtype", (Object)billType);
        temp.set("application", (Object)appId);
        temp.set("wayid", (Object)Long.valueOf(schemeId));
        temp.set("org", map.get("org"));
        temp.set("filingperiod", map.get("endperiod"));
        temp.set("billno", (Object)BillType.getBillTypeDesc(billType));
        temp.set("billid", (Object)billId);
        temp.set("uploadway", (Object)uploadway);
        temp.set("type", (Object)optype);
        temp.set("reason", (Object)reason);
        temp.set("billbizdate", (Object)billbizdate);
        temp.set("uniquekey", (Object)uniquekey);
        temp.set("billstatus", (Object)"C");
        temp.set("filingid", (Object)userId);
        temp.set("creator", (Object)userId);
        temp.set("auditor", (Object)userId);
        temp.set("modifier", (Object)userId);
        temp.set("fexetime", (Object)date);
        temp.set("createtime", (Object)date);
        temp.set("modifytime", (Object)date);
        return temp;
    }

    public static DynamicObject getGlRptDynamicObject(String billType, String accountNumber, String appId, String schemeId, Map<String, Object> map, Date date, String uploadway, Long billId, Long userId, String optype, String reason, Date billbizdate, String uniquekey, String batchcode, Long booktypeId) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"aef_acelre");
        DynamicObject temp = (DynamicObject)type.createInstance();
        temp.set("billtype", (Object)billType);
        temp.set("application", (Object)appId);
        temp.set("wayid", (Object)Long.valueOf(schemeId));
        temp.set("org", map.get("org"));
        temp.set("filingperiod", map.get("endperiod"));
        temp.set("billno", (Object)accountNumber);
        temp.set("billid", (Object)billId);
        temp.set("uploadway", (Object)uploadway);
        temp.set("type", (Object)optype);
        temp.set("reason", (Object)reason);
        temp.set("billbizdate", (Object)billbizdate);
        temp.set("uniquekey", (Object)uniquekey);
        temp.set("batchcode", (Object)batchcode);
        temp.set("booktype", (Object)booktypeId);
        if (SysParamConfig.getBoolean("needwritebackstatus", false)) {
            temp.set("status", (Object)"2");
        }
        temp.set("billstatus", (Object)"C");
        temp.set("filingid", (Object)userId);
        temp.set("creator", (Object)userId);
        temp.set("auditor", (Object)userId);
        temp.set("modifier", (Object)userId);
        temp.set("fexetime", (Object)date);
        temp.set("createtime", (Object)date);
        temp.set("modifytime", (Object)date);
        return temp;
    }

    public static DynamicObject getArhieveDynamicObject(ArchiveLogInfo archiveLogInfo) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"aef_acelre_tax");
        DynamicObject temp = (DynamicObject)type.createInstance();
        temp.set("billtype", (Object)archiveLogInfo.getBilltype());
        temp.set("application", (Object)archiveLogInfo.getApplication());
        temp.set("wayid", (Object)archiveLogInfo.getSchemeId());
        temp.set("billno", (Object)archiveLogInfo.getBillno());
        temp.set("billid", (Object)archiveLogInfo.getBillid());
        temp.set("org", (Object)archiveLogInfo.getOrgId());
        temp.set("batchcode", (Object)archiveLogInfo.getBatchCode());
        temp.set("uploadway", (Object)archiveLogInfo.getUploadway());
        temp.set("type", (Object)archiveLogInfo.getType());
        temp.set("reason", (Object)archiveLogInfo.getReason());
        temp.set("billbizdate", (Object)archiveLogInfo.getBillbizdate());
        temp.set("group", (Object)archiveLogInfo.getGroupId());
        temp.set("otherdata_tag", (Object)archiveLogInfo.getOtherdata());
        temp.set("filingperiod", (Object)archiveLogInfo.getPeriod());
        temp.set("taxarchivedata", (Object)archiveLogInfo.getTaxarchivedata());
        temp.set("group", (Object)archiveLogInfo.getGroupId());
        temp.set("skssqq", (Object)archiveLogInfo.getSkssqq());
        temp.set("skssqz", (Object)archiveLogInfo.getSkssqz());
        if (SysParamConfig.getBoolean("needwritebackstatus", false)) {
            temp.set("status", (Object)"2");
        }
        temp.set("billstatus", (Object)"C");
        temp.set("filingid", (Object)archiveLogInfo.getUserId());
        temp.set("creator", (Object)archiveLogInfo.getUserId());
        temp.set("auditor", (Object)archiveLogInfo.getUserId());
        temp.set("modifier", (Object)archiveLogInfo.getUserId());
        temp.set("fexetime", (Object)archiveLogInfo.getDate());
        temp.set("createtime", (Object)archiveLogInfo.getDate());
        temp.set("modifytime", (Object)archiveLogInfo.getDate());
        return temp;
    }
}

