/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.common;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BeanUtils {
    private static final Log LOGGER = LogFactory.getLog(BeanUtils.class);

    BeanUtils() {
    }

    public static Class<?> getBeanClass(String type) throws ClassNotFoundException {
        if (type != null && !type.isEmpty()) {
            try {
                return Class.forName(type.trim());
            }
            catch (ClassNotFoundException var2) {
                LOGGER.error("{}. not find.", (Object)type.trim());
                throw var2;
            }
        }
        return null;
    }

    public static <T> T getNewBean(String clz) throws Exception {
        try {
            Class<?> tp = BeanUtils.getBeanClass(clz.trim());
            if (tp != null) {
                Object ins = tp.newInstance();
                return (T)ins;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize type {}. {}", (Object)clz, (Object)e);
            throw e;
        }
    }
}

