/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.common;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.aef.common.util.DowJonesVideoImp;
import kd.fi.aef.common.util.JudgeBillType;
import kd.fi.aef.entity.ArchiveInfo;
import kd.fi.aef.entity.FileInfo;
import kd.fi.aef.exception.BillNotExistException;
import kd.fi.aef.exception.CannotConnectToSysException;
import kd.fi.aef.logic.common.OperationResultUtils;
import kd.fi.aef.logic.model.FileUploadItem;

public class DOWJONESUtils {
    public static ArchiveInfo convertArchiveInfo(FileUploadItem fileUploadItem) {
        if (fileUploadItem != null) {
            ArchiveInfo archiveInfo = new ArchiveInfo();
            String billType = fileUploadItem.getBillType();
            Long billId = fileUploadItem.getBillId();
            archiveInfo.setBill(billType);
            archiveInfo.setBillid(billId);
            archiveInfo.setBillDowsId(DOWJONESUtils.getBillDowsId(fileUploadItem));
            FileInfo pdfInfo = new FileInfo(billType + billId + ".pdf", fileUploadItem.getFileBytes());
            archiveInfo.setPdfInfo(pdfInfo);
            return archiveInfo;
        }
        return null;
    }

    public static String getBillDowsId(FileUploadItem fileUploadItem) {
        return fileUploadItem.getBillType() + fileUploadItem.getBillId();
    }

    public static OperationResult deleteImagesByDowJones(List<Long> idList, OperationResult result, MainEntityType billEntityType) {
        String billTypeValue = billEntityType.getName();
        boolean isRpt = "aef_acelre_rpt".equals(billTypeValue);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])idList.toArray(new Long[0]), (DynamicObjectType)billEntityType);
        result.setBillCount(result.getBillCount() + dynamicObjects.length);
        idList.clear();
        for (int i = 0; i < dynamicObjects.length; ++i) {
            OperateErrorInfo error;
            Long billid = dynamicObjects[i].getLong("billid");
            String billType = isRpt ? dynamicObjects[i].getString("billtype") : dynamicObjects[i].getDynamicObject("billtype").getString("number");
            try {
                boolean flag = DowJonesVideoImp.deleteBillInfo(billType, billid);
                if (flag) {
                    idList.add(dynamicObjects[i].getLong("id"));
                    continue;
                }
                result.setSuccess(false);
                error = OperationResultUtils.createOperateErrorInfo(dynamicObjects[i].getString("billno"));
                result.addErrorInfo(error);
                DeleteServiceHelper.delete((String)"aef_acelre", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
                continue;
            }
            catch (BillNotExistException be) {
                if (JudgeBillType.isFinaceRpt(billType)) {
                    idList.add(dynamicObjects[i].getLong("id"));
                    continue;
                }
                result.setSuccess(false);
                error = OperationResultUtils.createOperateErrorInfo(dynamicObjects[i].getString("billno"));
                result.addErrorInfo(error);
                continue;
            }
            catch (CannotConnectToSysException e) {
                result.setSuccess(false);
                error = OperationResultUtils.createOperateErrorInfo(dynamicObjects[i].getString("billno"));
                result.addErrorInfo(error);
            }
        }
        DeleteServiceHelper.delete((String)"aef_acelre", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
        return result;
    }
}

