/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.OpenApiSdkUtil;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.ArchivePageEngin;
import kd.fi.aef.common.util.FpyOperateUtil;
import kd.fi.aef.common.util.ImageServerUtil;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.MD5;
import kd.fi.aef.common.util.SplitDataUtil;
import kd.fi.aef.common.util.SysParamConfig;
import kd.fi.aef.entity.ArchiveResult;
import kd.fi.aef.entity.SchemeEntry;
import kd.fi.aef.logic.common.OperationResultUtils;
import kd.fi.aef.logic.engine.ArchiveEngineImpl;
import kd.fi.aef.logic.model.FileUploadItem;
import kd.fi.aef.logic.output.Result;

public class FPYUtils {
    private static final Log logger = LogFactory.getLog(FPYUtils.class);
    private static final String ERRCODE = "errcode";
    private static final String DESCRIPTION = "description";
    private static final String DATA = "data";
    public static final long lIMIT_SIZE = 0xA00000L;
    private static String SUCCESS_CODE = "0000";

    public static Tuple<String, String> initialURL() {
        String uploadUrl = "";
        String noticeUrl = "";
        DynamicObject imageConfig = QueryServiceHelper.queryOne((String)"aef_serviceconfig", (String)"id,serviceip,serviceport,username,password,uploadway,requestway", null);
        String message = "";
        if (imageConfig == null) {
            message = ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u5f52\u6863\u670d\u52a1\u5668\u3002", (String)"FPYUtils_0", (String)"fi-aef-common", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        String token = FpyOperateUtil.getAppToken(imageConfig);
        if (StringUtils.isEmpty((CharSequence)token)) {
            message = ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u7968\u4e91\u6388\u6743access_token\u5931\u8d25\u3002", (String)"FPYUtils_1", (String)"fi-aef-common", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        ThreeTuple<String, String, String> url = FpyOperateUtil.getURL(imageConfig, token);
        uploadUrl = (String)url.item1;
        noticeUrl = (String)url.item2;
        return new Tuple((Object)uploadUrl, (Object)noticeUrl);
    }

    public static ThreeTuple<String, String, String> initialURL3() {
        DynamicObject imageConfig = QueryServiceHelper.queryOne((String)"aef_serviceconfig", (String)"id,serviceip,serviceport,username,password,uploadway,requestway", null);
        String message = "";
        if (imageConfig == null) {
            message = ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u5f52\u6863\u670d\u52a1\u5668\u3002", (String)"FPYUtils_0", (String)"fi-aef-common", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        String token = FpyOperateUtil.getAppToken(imageConfig);
        if (StringUtils.isEmpty((CharSequence)token)) {
            message = ResManager.loadKDString((String)"\u83b7\u53d6\u53d1\u7968\u4e91\u6388\u6743access_token\u5931\u8d25\u3002", (String)"FPYUtils_1", (String)"fi-aef-common", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        return FpyOperateUtil.getURL(imageConfig, token);
    }

    public static Result reverse(String uploadDeleteUrl, FileUploadItem fileUploadItem) {
        Result returnResult = new Result();
        returnResult.setSucceed(true);
        HashMap<String, Object> map = new HashMap<String, Object>(7);
        map.put("accountBookNo", fileUploadItem.getAccountBookNo());
        map.put("accountBookName", fileUploadItem.getAccountBookName());
        map.put("institutionIssuesNo", fileUploadItem.getInstitutionIssuesNo());
        map.put("institutionIssuesName", fileUploadItem.getInstitutionIssuesName());
        map.put("period", fileUploadItem.getPeriod());
        map.put("billids", fileUploadItem.getBillidsMap().keySet().stream().map(key -> key.split("\\.")[1]).collect(Collectors.joining(",")));
        map.put("businessType", fileUploadItem.getBusinessType());
        map.put("archivist", fileUploadItem.getArchivist());
        map.put("dataSource", fileUploadItem.getDataSource());
        logger.info("\u4e0a\u4f20\u6587\u4ef6\u5165\u53c2\uff1a{}", (Object)new JSONObject(map).toJSONString());
        boolean isFpyEafc = uploadDeleteUrl.contains("eafc_collect");
        boolean isOnlyDeployed = uploadDeleteUrl.contains("access_token");
        if (isFpyEafc && !isOnlyDeployed) {
            map.put("filebase64", fileUploadItem.getFilebase64());
            OpenApiResult apiResult = OpenApiSdkUtil.invoke((String)uploadDeleteUrl, map);
            if (apiResult.isStatus()) {
                apiResult.setErrorCode("0000");
            }
            returnResult.setSucceed(apiResult.isStatus());
            returnResult.setErrorCcode(apiResult.getErrorCode());
            returnResult.setErrorMessage(apiResult.getMessage());
            returnResult.setData(apiResult.getData());
            return returnResult;
        }
        String responseContent = "";
        String code = "";
        String description = "";
        try {
            if (SysParamConfig.getBoolean("archivetoxinghan", false)) {
                Map paramMap = (Map)DispatchServiceHelper.invokeBizService((String)"eafc", (String)"eafc_collect", (String)"FileHandleService", (String)"isRepeatArchive", (Object[])new Object[]{map});
                logger.info("reverse result {}", (Object)paramMap);
                responseContent = JSONObject.toJSONString((Object)paramMap);
            } else {
                Object object = FpyOperateUtil.sendHttpByApic("fi-aef-delete", "POST", uploadDeleteUrl, new HashMap<String, Object>(map));
                responseContent = object.toString();
                responseContent = responseContent.replaceAll("\"errorCode\":\"0\"", "\"errorCode\":\"0000\"");
                responseContent = responseContent.replaceAll("\"errorCode\"", "\"errcode\"");
                responseContent = responseContent.replaceAll("\"message\"", "\"description\"");
            }
        }
        catch (Exception e) {
            code = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u53cd\u5f52\u6863\u7684\u63a5\u53e3\u5f02\u5e38\uff1a%s", (String)"FPYUtils_20", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            logger.error(code);
            returnResult.setSucceed(false);
            returnResult.setErrorCcode(code);
            returnResult.setErrorMessage(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        if (returnResult.isSucceed() && StringUtils.isNotEmpty((CharSequence)responseContent)) {
            Map responseMap = (Map)SerializationUtils.fromJsonString((String)responseContent, Map.class);
            code = responseMap.get(ERRCODE) + "";
            description = responseMap.get(DESCRIPTION) + "";
            if (!"0000".equals(code)) {
                returnResult.setSucceed(false);
                String message = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u53cd\u5f52\u6863\u7684\u63a5\u53e3\u8fd4\u56de\u7684\u9519\u8bef\u4fe1\u606f\u662f:%s", (String)"FPYUtils_21", (String)"fi-aef-common", (Object[])new Object[0]), responseMap);
                logger.error(message);
                returnResult.setErrorCcode(code);
                returnResult.setErrorMessage(description);
                returnResult.setData(responseMap.get(DATA));
            }
        }
        return returnResult;
    }

    public static Result noticeArchive(String uploadNoticeUrl, FileUploadItem fileUploadItem) {
        Result returnResult = new Result();
        returnResult.setSucceed(true);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("archivesCode", (Object)fileUploadItem.getArchivesCode());
        jsonObject.put("accountBookNo", (Object)fileUploadItem.getAccountBookNo());
        jsonObject.put("accountBookName", (Object)fileUploadItem.getAccountBookName());
        jsonObject.put("institutionIssuesNo", (Object)fileUploadItem.getInstitutionIssuesNo());
        jsonObject.put("institutionIssuesName", (Object)fileUploadItem.getInstitutionIssuesName());
        jsonObject.put("period", (Object)fileUploadItem.getPeriod());
        jsonObject.put("batchNumber", (Object)fileUploadItem.getBatchCode());
        jsonObject.put("businessType", (Object)fileUploadItem.getBusinessType());
        jsonObject.put("archivist", (Object)fileUploadItem.getArchivist());
        jsonObject.put("dataSource", (Object)fileUploadItem.getDataSource());
        logger.info("\u901a\u77e5\u5f52\u6863\u5165\u53c2\uff1a{}", (Object)jsonObject.toJSONString());
        boolean isFpyEafc = uploadNoticeUrl.contains("eafc_collect");
        boolean isOnlyDeployed = uploadNoticeUrl.contains("access_token");
        if (isFpyEafc && !isOnlyDeployed) {
            jsonObject.put("filebase64", (Object)fileUploadItem.getFilebase64());
            OpenApiResult apiResult = OpenApiSdkUtil.invoke((String)uploadNoticeUrl, new HashMap(jsonObject));
            if (apiResult.isStatus()) {
                apiResult.setErrorCode("0000");
            }
            returnResult.setSucceed(apiResult.isStatus());
            returnResult.setErrorCcode(apiResult.getErrorCode());
            returnResult.setErrorMessage(apiResult.getMessage());
            return returnResult;
        }
        String responseContent = "";
        String code = "";
        String description = "";
        try {
            if (SysParamConfig.getBoolean("archivetoxinghan", false)) {
                Map paramMap = (Map)DispatchServiceHelper.invokeBizService((String)"eafc", (String)"eafc_collect", (String)"FileHandleService", (String)"startAnalysis", (Object[])new Object[]{jsonObject});
                logger.info("notice result {}", (Object)paramMap);
                responseContent = JSONObject.toJSONString((Object)paramMap);
            } else {
                Object object = FpyOperateUtil.sendHttpByApic("fi-aef-notice", "POST", uploadNoticeUrl, new HashMap<String, Object>((Map<String, Object>)jsonObject));
                responseContent = object.toString();
                responseContent = responseContent.replaceAll("\"errorCode\":\"0\"", "\"errorCode\":\"0000\"");
                responseContent = responseContent.replaceAll("\"errorCode\"", "\"errcode\"");
                responseContent = responseContent.replaceAll("\"message\"", "\"description\"");
            }
        }
        catch (Exception e) {
            code = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u901a\u77e5\u5f52\u6863\u7684\u63a5\u53e3\u5f02\u5e38\uff1a%s", (String)"FPYUtils_2", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            logger.error(code);
            returnResult.setSucceed(false);
            returnResult.setErrorCcode(code);
            returnResult.setErrorMessage(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        if (returnResult.isSucceed() && StringUtils.isNotEmpty((CharSequence)responseContent)) {
            Map map = (Map)SerializationUtils.fromJsonString((String)responseContent, Map.class);
            code = map.get(ERRCODE) + "";
            description = map.get(DESCRIPTION) + "";
            if (!"0000".equals(code)) {
                returnResult.setSucceed(false);
                String message = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u901a\u77e5\u5f52\u6863\u7684\u63a5\u53e3\u8fd4\u56de\u7684\u9519\u8bef\u4fe1\u606f\u662f:%s", (String)"FPYUtils_3", (String)"fi-aef-common", (Object[])new Object[0]), map);
                logger.error(message);
                returnResult.setErrorCcode(code);
                returnResult.setErrorMessage(description);
            }
        }
        return returnResult;
    }

    public static Result upload(String uploadUrl, FileUploadItem fileUploadItem) {
        Result returnResult = new Result();
        returnResult.setSucceed(true);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("archivesCode", (Object)fileUploadItem.getArchivesCode());
        jsonObject.put("accountBookNo", (Object)fileUploadItem.getAccountBookNo());
        jsonObject.put("accountBookName", (Object)fileUploadItem.getAccountBookName());
        jsonObject.put("institutionIssuesNo", (Object)fileUploadItem.getInstitutionIssuesNo());
        jsonObject.put("institutionIssuesName", (Object)fileUploadItem.getInstitutionIssuesName());
        jsonObject.put("period", (Object)fileUploadItem.getPeriod());
        jsonObject.put("batchNumber", (Object)fileUploadItem.getBatchCode());
        jsonObject.put("businessType", (Object)fileUploadItem.getBusinessType());
        jsonObject.put("fileName", (Object)fileUploadItem.getFileName());
        logger.info("\u4e0a\u4f20\u6587\u4ef6\u5165\u53c2\uff1a{}", (Object)jsonObject.toJSONString());
        long fileLength = 0L;
        if (null != fileUploadItem.getFileBytes()) {
            fileLength = fileUploadItem.getFileBytes().length;
        } else if (null != fileUploadItem.getFilebase64()) {
            fileLength = FpyOperateUtil.imageSize(fileUploadItem.getFilebase64());
        }
        boolean isFpyEafc = uploadUrl.contains("eafc_collect");
        boolean isOnlyDeployed = uploadUrl.contains("access_token");
        if (isFpyEafc && !isOnlyDeployed) {
            if (StringUtils.isNotEmpty((CharSequence)fileUploadItem.getFilePath())) {
                jsonObject.put("filePath", (Object)fileUploadItem.getFilePath());
            } else {
                jsonObject.put("filebase64", (Object)fileUploadItem.getFilebase64());
            }
            OpenApiResult apiResult = OpenApiSdkUtil.invoke((String)uploadUrl, new HashMap(jsonObject));
            if (apiResult.isStatus()) {
                apiResult.setErrorCode("0000");
            }
            returnResult.setSucceed(apiResult.isStatus());
            returnResult.setErrorCcode(apiResult.getErrorCode());
            returnResult.setErrorMessage(apiResult.getMessage());
            return returnResult;
        }
        if (SysParamConfig.getBoolean("archivetoxinghan", false)) {
            jsonObject.put("filebase64", (Object)fileUploadItem.getFilebase64());
            Map paramMap = (Map)DispatchServiceHelper.invokeBizService((String)"eafc", (String)"eafc_collect", (String)"FileHandleService", (String)"upload", (Object[])new Object[]{jsonObject});
            logger.info(String.format(ResManager.loadKDString((String)"fileName\uff1a%1$s\uff0cfileSize:%2$s\uff0caccountBookName\uff1a%3$s\u672c\u6b21\u5f52\u6863HTTP POST \u8fd4\u56de\u503c:--%4$s", (String)"FpyOperateUtil_1", (String)"fi-aef-common", (Object[])new Object[0]), fileUploadItem.getFileName(), fileLength, fileUploadItem.getAccountBookName(), JSONObject.toJSONString((Object)paramMap)));
            FPYUtils.getFPYResult(returnResult, JSONObject.toJSONString((Object)paramMap));
            return returnResult;
        }
        if (fileLength <= 0xA00000L || isFpyEafc) {
            if (isFpyEafc && StringUtils.isNotEmpty((CharSequence)fileUploadItem.getFilePath())) {
                jsonObject.put("filePath", (Object)fileUploadItem.getFilePath());
            } else {
                jsonObject.put("filebase64", (Object)fileUploadItem.getFilebase64());
            }
            String responseContent = "";
            try {
                Object object = FpyOperateUtil.sendHttpByApic("fi-aef-uploadFile", "POST", uploadUrl, new HashMap<String, Object>((Map<String, Object>)jsonObject));
                responseContent = object.toString();
                responseContent = responseContent.replaceAll("\"errorCode\":\"0\"", "\"errorCode\":\"0000\"");
                responseContent = responseContent.replaceAll("\"errorCode\"", "\"errcode\"");
                responseContent = responseContent.replaceAll("\"message\"", "\"description\"");
            }
            catch (Exception e) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u5f71\u50cf\u5230\u53d1\u7968\u4e91\u670d\u52a1\u5668\u5f02\u5e38\uff1a%s", (String)"FPYUtils_4", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                logger.error(errorMsg);
                throw new KDBizException(errorMsg);
            }
            if (StringUtils.isNotEmpty((CharSequence)responseContent)) {
                logger.info(String.format(ResManager.loadKDString((String)"fileName\uff1a%1$s\uff0cfileSize:%2$s\uff0caccountBookName\uff1a%3$s\u672c\u6b21\u5f52\u6863HTTP POST \u8fd4\u56de\u503c:--%4$s", (String)"FPYUtils_5", (String)"fi-aef-common", (Object[])new Object[0]), fileUploadItem.getFileName(), fileLength, fileUploadItem.getAccountBookName(), responseContent));
                FPYUtils.getFPYResult(returnResult, responseContent);
            }
        } else if (fileLength > 0xA00000L) {
            String toUploadchunkUrl = uploadUrl.replace("/auth/file/upload", "/auth/toUploadchunk");
            String mergeFileUrl = uploadUrl.replace("/auth/file/upload", "/auth/mergeFile");
            String getuploadIdUrl = uploadUrl.replace("/auth/file/upload", "/auth/start/getuploadId");
            jsonObject.put("fileMd5", (Object)fileUploadItem.getFileMD5());
            JSONObject result1 = FpyOperateUtil.getuploadId(getuploadIdUrl, jsonObject);
            if (null != result1) {
                LogUtil.printLog(logger, ResManager.loadKDString((String)"\u83b7\u53d6\u4e0a\u4f20\u8bf7\u6c42\u5b8c\u6210\uff0c\u5f00\u59cb\u8bf7\u6c42\u5206\u5757\u4e0a\u4f20", (String)"FPYUtils_7", (String)"fi-aef-common", (Object[])new Object[0]));
                byte[] fileBytes = fileUploadItem.getFileBytes();
                logger.info(String.format(ResManager.loadKDString((String)"fileName\uff1a%1$s\uff0cfileSize:%2$s\uff0caccountBookName\uff1a%3$s\u5927\u6587\u4ef6\u4e0a\u4f20\u63a5\u53e3\u53c2\u6570:--%4$s", (String)"FPYUtils_6", (String)"fi-aef-common", (Object[])new Object[0]), fileUploadItem.getFileName(), fileLength, fileUploadItem.getAccountBookName(), fileBytes.length));
                Result upResult = FPYUtils.toUploadChunk(result1, fileBytes, fileUploadItem.getFileMD5(), toUploadchunkUrl, fileUploadItem.getFileName());
                if (upResult.isSucceed()) {
                    LogUtil.printLog(logger, ResManager.loadKDString((String)"\u5206\u5757\u4e0a\u4f20\u5b8c\u6210\uff0c\u5f00\u59cb\u5408\u5e76\u6587\u4ef6", (String)"FPYUtils_8", (String)"fi-aef-common", (Object[])new Object[0]));
                    String responseContent = FpyOperateUtil.toMergeFile(mergeFileUrl, fileUploadItem.getFileMD5(), result1);
                    logger.info(String.format(ResManager.loadKDString((String)"fileName\uff1a%1$s\uff0cfileSize:%2$s\uff0caccountBookName\uff1a%3$s\u672c\u6b21\u5f52\u6863HTTP POST \u8fd4\u56de\u503c:--%4$s", (String)"FpyOperateUtil_1", (String)"fi-aef-common", (Object[])new Object[0]), fileUploadItem.getFileName(), fileLength, fileUploadItem.getAccountBookName(), responseContent));
                    FPYUtils.getFPYResult(returnResult, responseContent);
                } else {
                    returnResult = upResult;
                }
            }
        }
        return returnResult;
    }

    private static void getFPYResult(Result returnResult, String responseContent) {
        Map map = (Map)SerializationUtils.fromJsonString((String)responseContent, Map.class);
        String code = map.get(ERRCODE) + "";
        String description = map.get(DESCRIPTION) + "";
        if (!SUCCESS_CODE.equalsIgnoreCase(code)) {
            returnResult.setSucceed(false);
            returnResult.setErrorMessage(description);
            returnResult.setErrorCcode(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result toUploadChunk(JSONObject jsonObject, byte[] fileBytes, String fileMD5, String toUploadchunkUrl, String fileName) {
        Result returnResult = new Result();
        returnResult.setSucceed(true);
        FileInputStream is = null;
        Integer chunkSize = 10;
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            Integer chunkSizeByte = chunkSize * 1024 * 1024;
            int length = fileBytes.length;
            double aa = (double)length / (double)chunkSizeByte.intValue();
            int chunkTotal = (int)Math.ceil(aa);
            params.put("total", chunkTotal);
            params.put("uploadId", jsonObject.getString("uploadId"));
            params.put("chunkSize", chunkSizeByte);
            params.put("fileMd5", fileMD5);
            byte[] byt = new byte[chunkSizeByte.intValue()];
            for (int i = 0; i < chunkTotal; ++i) {
                int from = i * chunkSizeByte;
                int to = from + chunkSizeByte;
                if (to > length) {
                    to = length;
                    params.put("chunkSize", to - from);
                    byt = new byte[to - from];
                    byt = Arrays.copyOfRange(fileBytes, from, to);
                } else {
                    byt = Arrays.copyOfRange(fileBytes, from, to);
                }
                params.put("current", i + 1);
                params.put("bytes", byt);
                ByteBuffer wrap = ByteBuffer.wrap(byt);
                params.put("chunkMd5", MD5.getMD5(wrap));
                String responseContent = FpyOperateUtil.sendHttpByApic("fi-aef-uploadFile", "POST", toUploadchunkUrl, params).toString();
                logger.info("\u6587\u4ef6{}\u5206\u5757\u603b\u6570\u662f{}\uff0c\u7b2c{}\u5206\u5757\u4e0a\u4f20\u6210\u529f", new Object[]{fileName, chunkTotal, i + 1});
                JSONObject jsonResult = JSON.parseObject((String)responseContent);
                if ("0000".equals(jsonResult.getString(ERRCODE))) continue;
                logger.error("\u5206\u6bb5\u4e0a\u4f20\u51fa\u9519{}", (Object)responseContent);
                returnResult.setSucceed(false);
                returnResult.setErrorMessage(responseContent);
                Result result = returnResult;
                return result;
            }
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u5206\u7247\u6587\u4ef6\u5f02\u5e38\uff0c\u5206\u5757\u53c2\u6570\uff1a{}", params, (Object)e);
            returnResult.setSucceed(false);
            returnResult.setErrorMessage(e.getMessage());
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error("\u6d41\u5173\u95ed\u5f02\u5e38");
                }
            }
        }
        return returnResult;
    }

    public static OperationResult reversalByFPY(List<Long> idList, OperationResult result, MainEntityType billEntityType, OperateOption option, ThreadPool threadPoolCash) {
        String billType = billEntityType.getName();
        DynamicObject imageDynamicObject = ImageServerUtil.getImageDynamicObject();
        if (imageDynamicObject == null) {
            OperationResult operationResult = OperationResultUtils.createErrorResult(ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u5f52\u6863\u670d\u52a1\u5668\u3002", (String)"FPYUtils_9", (String)"fi-aef-common", (Object[])new Object[0]));
            return operationResult;
        }
        result = "aef_acelre_rpt".equals(billType) ? FPYUtils.deleteRptByFpy(idList, result, imageDynamicObject, option, threadPoolCash) : ("aef_acelre_tax".equals(billType) ? FPYUtils.deleteTaxByFpy(idList, result, imageDynamicObject, option, threadPoolCash) : FPYUtils.deleteImagesByFpy(idList, result, imageDynamicObject, option, threadPoolCash));
        return result;
    }

    private static OperationResult deleteTaxByFpy(List<Long> idList, OperationResult result, DynamicObject imageConfig, OperateOption operateOption, ThreadPool threadPoolCash) {
        result.setBillCount(result.getBillCount() + idList.size());
        OperateOption option = FPYUtils.buildOption(imageConfig, operateOption);
        option.setVariableValue("isReverse", "2");
        option.setVariableValue("batchCode", UUID.randomUUID().toString());
        option.setVariableValue("archivetype", "tax");
        option.setVariableValue("traceId", TraceIdUtil.getCurrentTraceIdString());
        List<Object> schemes = new ArrayList(100);
        try {
            schemes = SplitDataUtil.splitReverseTax(idList);
        }
        catch (Exception e) {
            result.setSuccess(false);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u5207\u5206\u53cd\u5f52\u6863\u65b9\u6848\u5931\u8d25\uff1a%s", (String)"FPYUtils_10", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            OperateErrorInfo operateErrorInfo = OperationResultUtils.createOperateErrorInfo(errorMsg);
            result.addErrorInfo(operateErrorInfo);
            logger.error((Throwable)e);
            logger.error(errorMsg);
            return result;
        }
        ArrayList<Future> resultList = new ArrayList<Future>(schemes.size());
        for (SchemeEntry schemeEntry : schemes) {
            Future future = threadPoolCash.submit((Callable)new ArchivePageEngin(schemeEntry, option));
            resultList.add(future);
        }
        result.setSuccess(true);
        for (Future future : resultList) {
            OperateErrorInfo errorInfo;
            try {
                if (!((ArchiveResult)future.get()).getIsSuccess().booleanValue()) {
                    result.setSuccess(false);
                    if (((ArchiveResult)future.get()).getErrorMessages().size() > 0) {
                        for (String errorMessage : ((ArchiveResult)future.get()).getErrorMessages()) {
                            errorInfo = new OperateErrorInfo();
                            errorInfo.setLevel(ErrorLevel.Error);
                            errorInfo.setMessage(errorMessage);
                            result.addErrorInfo(errorInfo);
                        }
                        result.getSuccessPkIds().addAll(((ArchiveResult)future.get()).getSuccessPkIds());
                        continue;
                    }
                    OperateErrorInfo errorInfo2 = new OperateErrorInfo();
                    errorInfo2.setLevel(ErrorLevel.Error);
                    errorInfo2.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u53cd\u5f52\u6863\u5931\u8d25\u3002", (String)"FPYUtils_11", (String)"fi-aef-common", (Object[])new Object[0]), ((ArchiveResult)future.get()).getBillTypes().toString()));
                    result.addErrorInfo(errorInfo2);
                    continue;
                }
                result.getSuccessPkIds().addAll(((ArchiveResult)future.get()).getSuccessPkIds());
            }
            catch (Exception e) {
                result.setSuccess(false);
                String errorMsg = String.format(ResManager.loadKDString((String)"\u53cd\u5f52\u6863\u5931\u8d25\uff1a%s", (String)"FPYUtils_12", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                errorInfo = OperationResultUtils.createOperateErrorInfo(errorMsg);
                result.addErrorInfo(errorInfo);
                logger.error((Throwable)e);
                logger.error(errorMsg);
                return result;
            }
        }
        return result;
    }

    private static OperationResult deleteRptByFpy(List<Long> idList, OperationResult result, DynamicObject imageConfig, OperateOption operateOption, ThreadPool threadPoolCash) {
        result.setBillCount(result.getBillCount() + idList.size());
        OperateOption option = FPYUtils.buildOption(imageConfig, operateOption);
        option.setVariableValue("isReverse", "2");
        option.setVariableValue("batchCode", UUID.randomUUID().toString());
        option.setVariableValue("traceId", TraceIdUtil.getCurrentTraceIdString());
        List<Object> schemes = new ArrayList(100);
        try {
            schemes = SplitDataUtil.splitReverseRpt(idList);
        }
        catch (Exception e) {
            result.setSuccess(false);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u62a5\u8868\u5207\u5206\u53cd\u5f52\u6863\u65b9\u6848\u5931\u8d25\uff1a%s", (String)"FPYUtils_13", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            OperateErrorInfo operateErrorInfo = OperationResultUtils.createOperateErrorInfo(errorMsg);
            result.addErrorInfo(operateErrorInfo);
            logger.error((Throwable)e);
            logger.error(errorMsg);
            return result;
        }
        ArrayList<Future> resultList = new ArrayList<Future>(schemes.size());
        for (SchemeEntry schemeEntry : schemes) {
            Future future = threadPoolCash.submit((Callable)new ArchiveEngineImpl(schemeEntry, option));
            resultList.add(future);
        }
        result.setSuccess(true);
        for (Future future : resultList) {
            OperateErrorInfo errorInfo;
            try {
                if (!((ArchiveResult)future.get()).getIsSuccess().booleanValue()) {
                    result.setSuccess(false);
                    if (((ArchiveResult)future.get()).getErrorMessages().size() > 0) {
                        for (String errorMessage : ((ArchiveResult)future.get()).getErrorMessages()) {
                            errorInfo = new OperateErrorInfo();
                            errorInfo.setLevel(ErrorLevel.Error);
                            errorInfo.setMessage(errorMessage);
                            result.addErrorInfo(errorInfo);
                        }
                        result.getSuccessPkIds().addAll(((ArchiveResult)future.get()).getSuccessPkIds());
                        continue;
                    }
                    OperateErrorInfo errorInfo2 = new OperateErrorInfo();
                    errorInfo2.setLevel(ErrorLevel.Error);
                    errorInfo2.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u53cd\u5f52\u6863\u5931\u8d25\u3002", (String)"FPYUtils_14", (String)"fi-aef-common", (Object[])new Object[0]), ((ArchiveResult)future.get()).getBillTypes().toString()));
                    result.addErrorInfo(errorInfo2);
                    continue;
                }
                result.getSuccessPkIds().addAll(((ArchiveResult)future.get()).getSuccessPkIds());
            }
            catch (Exception e) {
                result.setSuccess(false);
                String errorMsg = String.format(ResManager.loadKDString((String)"\u53cd\u5f52\u6863\u5931\u8d25\uff1a%s", (String)"FPYUtils_15", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                errorInfo = OperationResultUtils.createOperateErrorInfo(errorMsg);
                result.addErrorInfo(errorInfo);
                logger.error((Throwable)e);
                logger.error(errorMsg);
                return result;
            }
        }
        return result;
    }

    private static OperateOption buildOption(DynamicObject imageConfig, OperateOption option) {
        String token = FpyOperateUtil.getAppToken(imageConfig);
        if (StringUtils.isEmpty((CharSequence)token)) {
            String message = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5f52\u6863\u670d\u52a1\u5668\u914d\u7f6e\u6216\u8005\u7f51\u7edc\u3002", (String)"FPYUtils_16", (String)"fi-aef-common", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        String uploadway = imageConfig.getString("uploadway");
        String serviceip = imageConfig.getString("serviceip");
        String serviceport = imageConfig.getString("serviceport");
        String requestway = imageConfig.getString("requestway");
        ThreeTuple<String, String, String> url = FpyOperateUtil.getURL(imageConfig, token);
        String uploadurl = (String)url.item1;
        String noticeurl = (String)url.item2;
        String deleteurl = (String)url.item3;
        option.setVariableValue("fpyUploadUrl", uploadurl);
        option.setVariableValue("fpyNoticeUrl", noticeurl);
        option.setVariableValue("fpyDeleteUrl", deleteurl);
        option.setVariableValue("archivesCode", imageConfig.getString("username"));
        option.setVariableValue("uploadway", uploadway);
        return option;
    }

    private static OperationResult deleteImagesByFpy(List<Long> idList, OperationResult result, DynamicObject imageConfig, OperateOption operateOption, ThreadPool threadPoolCash) {
        result.setBillCount(result.getBillCount() + idList.size());
        OperateOption option = FPYUtils.buildOption(imageConfig, operateOption);
        option.setVariableValue("isReverse", "2");
        option.setVariableValue("batchCode", UUID.randomUUID().toString());
        option.setVariableValue("traceId", TraceIdUtil.getCurrentTraceIdString());
        boolean issplitbookstr = SysParamConfig.getBoolean("issplitbook", true);
        option.setVariableValue("issplitbook", Boolean.toString(issplitbookstr));
        boolean isSupportGeneralledgerNew = SysParamConfig.getBoolean("support_gl_rpt_generalledger_new", false);
        option.setVariableValue("support_gl_rpt_generalledger_new", Boolean.toString(isSupportGeneralledgerNew));
        List<Object> schemes = new ArrayList(100);
        try {
            schemes = SplitDataUtil.splitReverseFilingData(idList, option);
        }
        catch (Exception e) {
            result.setSuccess(false);
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5207\u5206\u53cd\u5f52\u6863\u65b9\u6848\u5931\u8d25\uff1a%s", (String)"FPYUtils_17", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            OperateErrorInfo operateErrorInfo = OperationResultUtils.createOperateErrorInfo(errorMsg);
            result.addErrorInfo(operateErrorInfo);
            logger.error((Throwable)e);
            logger.error(errorMsg);
            return result;
        }
        ArrayList<Future> resultList = new ArrayList<Future>(schemes.size());
        for (SchemeEntry schemeEntry : schemes) {
            Future future = threadPoolCash.submit((Callable)new ArchiveEngineImpl(schemeEntry, option));
            resultList.add(future);
        }
        result.setSuccess(true);
        for (Future future : resultList) {
            OperateErrorInfo errorInfo;
            try {
                if (!((ArchiveResult)future.get()).getIsSuccess().booleanValue()) {
                    result.setSuccess(false);
                    if (((ArchiveResult)future.get()).getErrorMessages().size() > 0) {
                        for (String errorMessage : ((ArchiveResult)future.get()).getErrorMessages()) {
                            errorInfo = new OperateErrorInfo();
                            errorInfo.setLevel(ErrorLevel.Error);
                            errorInfo.setMessage(errorMessage);
                            result.addErrorInfo(errorInfo);
                        }
                        result.getSuccessPkIds().addAll(((ArchiveResult)future.get()).getSuccessPkIds());
                        continue;
                    }
                    OperateErrorInfo errorInfo2 = new OperateErrorInfo();
                    errorInfo2.setLevel(ErrorLevel.Error);
                    errorInfo2.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u53cd\u5f52\u6863\u5931\u8d25\u3002", (String)"FPYUtils_18", (String)"fi-aef-common", (Object[])new Object[0]), ((ArchiveResult)future.get()).getBillTypes().toString()));
                    result.addErrorInfo(errorInfo2);
                    continue;
                }
                result.getSuccessPkIds().addAll(((ArchiveResult)future.get()).getSuccessPkIds());
            }
            catch (Exception e) {
                result.setSuccess(false);
                String errorMsg = String.format(ResManager.loadKDString((String)"\u53cd\u5f52\u6863\u5931\u8d25\uff1a%s", (String)"FPYUtils_19", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                errorInfo = OperationResultUtils.createOperateErrorInfo(errorMsg);
                result.addErrorInfo(errorInfo);
                logger.error((Throwable)e);
                logger.error(errorMsg);
                return result;
            }
        }
        return result;
    }
}

