/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.aef.common.ArchiveContext;
import kd.fi.aef.common.util.ArchiveUtil;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.common.util.ElecreceiptUtils;
import kd.fi.aef.common.util.JDomB9Utils;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.SysParamConfig;
import kd.fi.aef.entity.BillInfo;
import kd.fi.aef.entity.FileDesc;
import kd.fi.aef.logic.model.Attach;
import kd.fi.aef.logic.model.Bill;
import kd.sdk.fi.gl.voucher.VoucherQuerySDK;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;

public class FPYXmlUtils {
    private static final Log logger = LogFactory.getLog(FPYXmlUtils.class);

    public static String createCommonBillXml(ArchiveContext context, List<Bill> list, Map<Object, FileDesc> billFileMap, String billName, Map<?, List<Attach>> attachMap, Map<String, Object> imageMap, String billType, String flag, Set<?> fillingIds) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName(docinfo, "header");
        JDomB9Utils.addChildAndName(header, "doctype", "srcVoucher");
        JDomB9Utils.addChildAndName(header, "creater", FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName(header, "time", FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName(header, "rearchflag", flag);
        JDomB9Utils.addChildAndName(header, "desc", billName);
        Element datalist = JDomB9Utils.addChildAndName(docinfo, "data-list");
        int i = 0;
        String invoiceStr = SysParamConfig.get("hasinvoicebill");
        List<Object> sysList = new ArrayList(3);
        if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceStr)) {
            sysList = Arrays.asList(invoiceStr.split(","));
        }
        String idField = ArchiveUtil.getFieldName(billType, "id");
        for (Bill bill : list) {
            Map numbermap;
            if (context.getNeedArchiveIds() != null && context.getNeedArchiveIds().size() > 0 && !context.getNeedArchiveIds().contains(bill.getBillId())) continue;
            Element data = JDomB9Utils.addChildAndName(datalist, "data");
            JDomB9Utils.addChildAndName(data, "id", ++i + "");
            if ("er_tripreimbursebill".equals(billType) || "er_dailyreimbursebill".equals(billType) || "ap_finapbill".equals(billType) || "er_publicreimbursebill".equals(billType) || "ap_invoice".equals(billType) || sysList.contains(billType)) {
                if ("A".equals(imageMap.get("enable"))) {
                    JDomB9Utils.addChildAndName(data, "isFPYBill", "true");
                } else {
                    JDomB9Utils.addChildAndName(data, "isFPYBill", "false");
                }
            }
            if ("ap_finapbill".equals(billType)) {
                JDomB9Utils.addChildAndName(data, "billid", "ap_invoice_" + bill.getBillId());
            } else {
                JDomB9Utils.addChildAndName(data, "billid", billType + "_" + bill.getBillId());
            }
            Map<String, Object> field2ValueMap = bill.getField2ValueMap();
            if (field2ValueMap.size() > 0) {
                field2ValueMap.forEach((xmlFiled, value) -> {
                    if (!xmlFiled.equals(idField)) {
                        JDomB9Utils.addChildAndName(data, xmlFiled, value.toString());
                    }
                });
            }
            JDomB9Utils.addChildAndName(data, "billtype", billName);
            boolean existEntity = fillingIds.contains(bill.getBillId());
            JDomB9Utils.addChildAndName(data, "existEntity", String.valueOf(existEntity));
            Object billId = bill.getBillId();
            Element filelist = JDomB9Utils.addChildAndName(data, "file-list");
            Element file = JDomB9Utils.addChildAndName(filelist, "file");
            String name = billFileMap.get(billId).getName();
            JDomB9Utils.addChildAndName(file, "name", name);
            JDomB9Utils.addChildAndName(file, "srcname", name);
            List<Attach> attaches = attachMap.get(billId);
            if (attaches != null) {
                for (Attach attachfile : attaches) {
                    Element attach = filelist.addElement("file");
                    JDomB9Utils.addChildAndName(attach, "name", billId + "_" + attachfile.getFileName());
                    JDomB9Utils.addChildAndName(attach, "srcname", attachfile.getFileName());
                }
            }
            if ((numbermap = (Map)imageMap.get("numbermap")) == null || numbermap.size() <= 0 || numbermap.get(billType) == null || ((Map)numbermap.get(billType)).get(billId) == null || ((List)((Map)numbermap.get(billType)).get(billId)).size() <= 0) continue;
            Element imagesys = JDomB9Utils.addChildAndName(data, "imagesys");
            JDomB9Utils.addChildAndName(imagesys, "imagesystype", imageMap.get("imagesystype") == null ? "null" : (String)imageMap.get("imagesystype"));
            JDomB9Utils.addChildAndName(imagesys, "imagesysip", imageMap.get("imagesysip") == null ? "null" : (String)imageMap.get("imagesysip"));
            JDomB9Utils.addChildAndName(imagesys, "imagesysport", imageMap.get("imagesysport") == null ? "null" : (String)imageMap.get("imagesysport"));
            Element imagelist = JDomB9Utils.addChildAndName(data, "image-list");
            List imagenumbers = (List)((Map)numbermap.get(billType)).get(billId);
            for (String imagenumber : imagenumbers) {
                Element image = JDomB9Utils.addChildAndName(imagelist, "image");
                JDomB9Utils.addChildAndName(image, "imagenumber", imagenumber);
            }
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createTaxBillXml(List<Bill> list, Map<Object, FileDesc> billFileMap, Map<Long, List<Attach>> attachMap, Map<String, Object> extMap) {
        Element attach;
        List<Attach> attaches;
        String name;
        Element file;
        Element filelist;
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName(docinfo, "header");
        JDomB9Utils.addChildAndName(header, "doctype", "taxReport");
        JDomB9Utils.addChildAndName(header, "creater", FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName(header, "time", FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName(header, "rearchflag", (String)extMap.get("flag"));
        JDomB9Utils.addChildAndName(header, "desc", (String)extMap.get("billname"));
        Element datalist = JDomB9Utils.addChildAndName(docinfo, "data-list");
        int i = 0;
        if ("bill".equals(extMap.get("taxarchivedata"))) {
            Set needArchiveIds = (Set)extMap.get("needArchiveIds");
            for (Bill bill : list) {
                if (needArchiveIds != null && needArchiveIds.size() > 0 && !needArchiveIds.contains(bill.getBillId())) continue;
                Element data = JDomB9Utils.addChildAndName(datalist, "data");
                JDomB9Utils.addChildAndName(data, "id", ++i + "");
                JDomB9Utils.addChildAndName(data, "billid", extMap.get("billtype") + "_" + bill.getBillId());
                JDomB9Utils.addChildAndName(data, "period", DateUtil.getShortStr(bill.getDate()));
                JDomB9Utils.addChildAndName(data, "type", (String)extMap.get("billname"));
                JDomB9Utils.addChildAndName(data, "taxcode", "");
                JDomB9Utils.addChildAndName(data, "taxname", "");
                JDomB9Utils.addChildAndName(data, "voucherorgnumber", bill.getOrgNo());
                JDomB9Utils.addChildAndName(data, "voucherorgname", bill.getOrgName());
                JDomB9Utils.addChildAndName(data, "taxnumber", "");
                JDomB9Utils.addChildAndName(data, "taxtimestart", DateUtil.getTimeStr(bill.getDate()));
                JDomB9Utils.addChildAndName(data, "taxtimeend", DateUtil.getTimeStr(bill.getDate()));
                JDomB9Utils.addChildAndName(data, "groupname", (String)extMap.get("groupname"));
                Long billId = (Long)bill.getBillId();
                filelist = JDomB9Utils.addChildAndName(data, "file-list");
                file = JDomB9Utils.addChildAndName(filelist, "file");
                name = billFileMap.get(billId).getName();
                JDomB9Utils.addChildAndName(file, "name", name);
                JDomB9Utils.addChildAndName(file, "srcname", name);
                attaches = attachMap.get(billId);
                if (attaches == null) continue;
                for (Attach attachfile : attaches) {
                    attach = filelist.addElement("file");
                    JDomB9Utils.addChildAndName(attach, "name", billId + "_" + attachfile.getFileName());
                    JDomB9Utils.addChildAndName(attach, "srcname", attachfile.getFileName());
                }
            }
        }
        if ("tccit".equals((String)extMap.get("taxarchivedata"))) {
            List declareList = (List)extMap.get("declareList");
            for (Map map : declareList) {
                Long billId = (Long)map.get("id");
                Element data = JDomB9Utils.addChildAndName(datalist, "data");
                JDomB9Utils.addChildAndName(data, "id", ++i + "");
                JDomB9Utils.addChildAndName(data, "billid", extMap.get("billtype") + "_" + billId);
                JDomB9Utils.addChildAndName(data, "period", (String)map.get("period"));
                JDomB9Utils.addChildAndName(data, "type", (String)extMap.get("billname"));
                JDomB9Utils.addChildAndName(data, "taxcode", (String)map.get("taxcode"));
                JDomB9Utils.addChildAndName(data, "taxname", (String)map.get("taxname"));
                JDomB9Utils.addChildAndName(data, "voucherorgname", (String)map.get("taxpayername"));
                JDomB9Utils.addChildAndName(data, "voucherorgnumber", (String)map.get("taxnumber"));
                JDomB9Utils.addChildAndName(data, "taxnumber", (String)map.get("taxnumber"));
                JDomB9Utils.addChildAndName(data, "taxtimestart", (String)map.get("startdate"));
                JDomB9Utils.addChildAndName(data, "taxtimeend", (String)map.get("enddate"));
                JDomB9Utils.addChildAndName(data, "groupname", (String)extMap.get("groupname"));
                filelist = JDomB9Utils.addChildAndName(data, "file-list");
                file = JDomB9Utils.addChildAndName(filelist, "file");
                name = billFileMap.get(billId).getName();
                JDomB9Utils.addChildAndName(file, "name", name);
                JDomB9Utils.addChildAndName(file, "srcname", name);
                attaches = attachMap.get(billId);
                if (attaches == null) continue;
                for (Attach attachfile : attaches) {
                    attach = filelist.addElement("file");
                    JDomB9Utils.addChildAndName(attach, "name", billId + "_" + attachfile.getFileName());
                    JDomB9Utils.addChildAndName(attach, "srcname", attachfile.getFileName());
                }
            }
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createBatchVoucherXml(String xmlDesc, List<Bill> billList, Map<Long, List<Attach>> attachMap, Map<Long, Map<String, Set<Long>>> linkUpBills, Map<Object, FileDesc> voucherFileMap, Set<String> refBillTypes, String flag, Map<Long, Set<String>> voucherInvoiceMap) {
        return FPYXmlUtils.createBatchVoucherXml(xmlDesc, billList, attachMap, linkUpBills, voucherFileMap, refBillTypes, flag, voucherInvoiceMap, new HashMap<Long, JSONArray>());
    }

    public static String createBatchVoucherXml(String xmlDesc, List<Bill> billList, Map<Long, List<Attach>> attachMap, Map<Long, Map<String, Set<Long>>> linkUpBills, Map<Object, FileDesc> voucherFileMap, Set<String> refBillTypes, String flag, Map<Long, Set<String>> voucherInvoiceMap, HashMap<Long, JSONArray> extInvoiceMap) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName(docinfo, "header");
        JDomB9Utils.addChildAndName(header, "doctype", "voucher");
        JDomB9Utils.addChildAndName(header, "creater", FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName(header, "time", FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName(header, "rearchflag", flag);
        JDomB9Utils.addChildAndName(header, "desc", xmlDesc);
        HashMap<Long, List> entryMap = new HashMap<Long, List>(16);
        if (SysParamConfig.getBoolean("archiveentry", false)) {
            try (DataSet dataSet = VoucherQuerySDK.queryByIds(billList.stream().map(bill -> Long.parseLong(bill.getBillId().toString())).collect(Collectors.toSet()), null, (String)"id, entries.account.number accountcode,entries.account.name accountname, entries.edescription desc, entries.debitlocal dr, entries.creditlocal cr, entries.assgrp.display accountdimensions", null);){
                for (Row row : dataSet) {
                    List eneityList = entryMap.computeIfAbsent(row.getLong("id"), value -> new ArrayList());
                    LinkedHashMap<String, String> eneityMap = new LinkedHashMap<String, String>(16);
                    eneityMap.put("accountcode", row.getString("accountcode"));
                    eneityMap.put("accountname", row.getString("accountname"));
                    eneityMap.put("desc", row.getString("desc"));
                    eneityMap.put("accountdimensions", row.getString("accountdimensions"));
                    eneityMap.put("dr", row.getString("dr"));
                    eneityMap.put("cr", row.getString("cr"));
                    eneityList.add(eneityMap);
                }
            }
        }
        Element datalist = JDomB9Utils.addChildAndName(docinfo, "data-list");
        int i = 0;
        for (Bill bill2 : billList) {
            ++i;
            Long id = (Long)bill2.getBillId();
            Map<String, Set<Long>> refBillMap = linkUpBills.get(id);
            List<Attach> attaches = attachMap.get(id);
            Element data = JDomB9Utils.addChildAndName(datalist, "data");
            Map<String, Object> field2ValueMap = bill2.getField2ValueMap();
            JDomB9Utils.addChildAndName(data, "id", i + "");
            for (Map.Entry<String, Object> entry : field2ValueMap.entrySet()) {
                String field = entry.getKey();
                Object value2 = entry.getValue();
                JDomB9Utils.addChildAndName(data, field, Objects.isNull(value2) ? "" : value2.toString());
            }
            Element jelinelist = JDomB9Utils.addChildAndName(data, "jeline-list");
            if (entryMap.get(id) != null && ((List)entryMap.get(id)).size() > 0) {
                List list = (List)entryMap.get(id);
                for (Map map : list) {
                    Element jeline = JDomB9Utils.addChildAndName(jelinelist, "jeline");
                    JDomB9Utils.addChildAndName(jeline, "accountcode", (String)map.get("accountcode"));
                    JDomB9Utils.addChildAndName(jeline, "accountname", (String)map.get("accountname"));
                    JDomB9Utils.addChildAndName(jeline, "desc", (String)map.get("desc"));
                    JDomB9Utils.addChildAndName(jeline, "accountdimensions", (String)map.get("accountdimensions"));
                    JDomB9Utils.addChildAndName(jeline, "costcenter");
                    JDomB9Utils.addChildAndName(jeline, "dr", (String)map.get("dr"));
                    JDomB9Utils.addChildAndName(jeline, "cr", (String)map.get("cr"));
                }
            } else {
                Element jeline = JDomB9Utils.addChildAndName(jelinelist, "jeline");
                JDomB9Utils.addChildAndName(jeline, "accountcode");
                JDomB9Utils.addChildAndName(jeline, "accountname");
                JDomB9Utils.addChildAndName(jeline, "desc", bill2.getDesc());
                JDomB9Utils.addChildAndName(jeline, "costcenter");
                JDomB9Utils.addChildAndName(jeline, "dr");
                JDomB9Utils.addChildAndName(jeline, "cr");
            }
            Element refbilllist = JDomB9Utils.addChildAndName(data, "refbill-list");
            JDomB9Utils.addChildAndNameForRefbills(refbilllist, "refbill", refBillMap, refBillTypes);
            Element filelist = JDomB9Utils.addChildAndName(data, "file-list");
            String fileName = voucherFileMap.get(id).getName();
            FPYXmlUtils.addFiles(filelist, "file", attaches, id.toString(), fileName);
            if (voucherInvoiceMap != null && voucherInvoiceMap.size() > 0 && voucherInvoiceMap.get(id) != null && voucherInvoiceMap.get(id).size() > 0) {
                Element invoicesys = JDomB9Utils.addChildAndName(data, "invoicesys");
                JDomB9Utils.addChildAndName(invoicesys, "invoicesystype", "FPY");
                JDomB9Utils.addChildAndName(invoicesys, "invoicesysip");
                JDomB9Utils.addChildAndName(invoicesys, "invoicesysport");
                Element invoicelist = JDomB9Utils.addChildAndName(data, "invoice-list");
                for (String seqNo : voucherInvoiceMap.get(id)) {
                    Element invoice = invoicelist.addElement("invoice");
                    JDomB9Utils.addChildAndName(invoice, "serialNo", seqNo);
                    JDomB9Utils.addChildAndName(invoice, "invoiceno");
                    JDomB9Utils.addChildAndName(invoice, "invoicecode");
                    JDomB9Utils.addChildAndName(invoice, "downloadurl");
                }
            }
            if (extInvoiceMap.size() <= 0) continue;
            Element invoicelist = JDomB9Utils.addChildAndName(data, "invoice-list");
            if (extInvoiceMap.get(id) == null || extInvoiceMap.get(id).size() <= 0) continue;
            JSONArray array = extInvoiceMap.get(id);
            for (Object object : array) {
                JSONObject json = (JSONObject)object;
                Element invoice = invoicelist.addElement("invoice");
                for (Map.Entry entry : json.entrySet()) {
                    String fieldKey = (String)entry.getKey();
                    String fieldVal = entry.getValue().toString();
                    JDomB9Utils.addChildAndName(invoice, fieldKey, fieldVal);
                }
            }
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createBatchVoucherXml(String xmlDesc, DataSet xmlSet, Map<Long, List<Attach>> attachMap, Map<Long, Map<String, Set<Long>>> linkUpBills, Map<Object, FileDesc> voucherFileMap, Set<String> refBillTypes, String flag, Map<Long, Set<String>> voucherInvoiceMap) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName(docinfo, "header");
        JDomB9Utils.addChildAndName(header, "doctype", "voucher");
        JDomB9Utils.addChildAndName(header, "creater", FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName(header, "time", FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName(header, "rearchflag", flag);
        JDomB9Utils.addChildAndName(header, "desc", xmlDesc);
        Element datalist = JDomB9Utils.addChildAndName(docinfo, "data-list");
        int i = 0;
        for (Row row : xmlSet) {
            Long id = row.getLong("id");
            Map<String, Set<Long>> refBillMap = linkUpBills.get(id);
            List<Attach> attaches = attachMap.get(id);
            Element data = JDomB9Utils.addChildAndName(datalist, "data");
            JDomB9Utils.addChildAndName(data, "id", ++i + "");
            JDomB9Utils.addChildAndName(data, "billid", "gl_voucher" + id.toString());
            JDomB9Utils.addChildAndName(data, "voucherorgnumber", row.getString("orgnumber"));
            JDomB9Utils.addChildAndName(data, "voucherorgname", row.getString("orgname"));
            JDomB9Utils.addChildAndName(data, "period", FPYXmlUtils.dealPeriodNumber(row.getString("periodnumber")));
            JDomB9Utils.addChildAndName(data, "vouchernum", row.getString("billno"));
            JDomB9Utils.addChildAndName(data, "attachnum", row.getString("attachment"));
            JDomB9Utils.addChildAndName(data, "vouchertype", row.getString("vouchertypename"));
            JDomB9Utils.addChildAndName(data, "currency", row.getString("localcurnumber"));
            JDomB9Utils.addChildAndName(data, "totaldebitloc", row.getString("debitlocamount"));
            JDomB9Utils.addChildAndName(data, "totalcreditloc", row.getString("creditlocamount"));
            JDomB9Utils.addChildAndName(data, "auditing", row.getString("auditorname"));
            JDomB9Utils.addChildAndName(data, "creater", row.getString("creatorname"));
            JDomB9Utils.addChildAndName(data, "accountdate", row.getDate("accountdate") == null ? "" : DateUtil.getTimeStr(row.getDate("accountdate")));
            JDomB9Utils.addChildAndName(data, "posting_date", row.getDate("posting_date") == null ? "" : DateUtil.getTimeStr(row.getDate("posting_date")));
            Element jelinelist = JDomB9Utils.addChildAndName(data, "jeline-list");
            Element jeline = JDomB9Utils.addChildAndName(jelinelist, "jeline");
            JDomB9Utils.addChildAndName(jeline, "accountcode");
            JDomB9Utils.addChildAndName(jeline, "accountname");
            JDomB9Utils.addChildAndName(jeline, "desc", row.getString("vdescription"));
            JDomB9Utils.addChildAndName(jeline, "costcenter");
            JDomB9Utils.addChildAndName(jeline, "dr");
            JDomB9Utils.addChildAndName(jeline, "cr");
            Element refbilllist = JDomB9Utils.addChildAndName(data, "refbill-list");
            JDomB9Utils.addChildAndNameForRefbills(refbilllist, "refbill", refBillMap, refBillTypes);
            Element filelist = JDomB9Utils.addChildAndName(data, "file-list");
            String fileName = voucherFileMap.get(id).getName();
            FPYXmlUtils.addFiles(filelist, "file", attaches, id.toString(), fileName);
            if (voucherInvoiceMap == null || voucherInvoiceMap.size() <= 0 || voucherInvoiceMap.get(id) == null || voucherInvoiceMap.get(id).size() <= 0) continue;
            Element invoicesys = JDomB9Utils.addChildAndName(data, "invoicesys");
            JDomB9Utils.addChildAndName(invoicesys, "invoicesystype", "FPY");
            JDomB9Utils.addChildAndName(invoicesys, "invoicesysip");
            JDomB9Utils.addChildAndName(invoicesys, "invoicesysport");
            Element invoicelist = JDomB9Utils.addChildAndName(data, "invoice-list");
            for (String seqNo : voucherInvoiceMap.get(id)) {
                Element invoice = invoicelist.addElement("invoice");
                JDomB9Utils.addChildAndName(invoice, "serialNo", seqNo);
                JDomB9Utils.addChildAndName(invoice, "invoiceno");
                JDomB9Utils.addChildAndName(invoice, "invoicecode");
                JDomB9Utils.addChildAndName(invoice, "downloadurl");
            }
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createVoucherRefBillXml(Map<String, List<BillInfo>> linkUpBillInfos, Map<String, Map<Long, Set<Long>>> billAndRefvoucherIds, Map<Long, List<Attach>> refAttachMap, Map<String, Object> imageMap, String accountBookNo, String accountBookName, String period, String flag, Map<String, Set<Object>> errRefBills, Map<Long, BillInfo> voucherInfoMap) {
        HashMap<String, String> billTypeAndNameMap = new HashMap<String, String>();
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName(docinfo, "header");
        JDomB9Utils.addChildAndName(header, "doctype", "srcVoucher");
        JDomB9Utils.addChildAndName(header, "creater", FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName(header, "time", FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName(header, "rearchflag", flag);
        JDomB9Utils.addChildAndName(header, "desc");
        Element datalist = JDomB9Utils.addChildAndName(docinfo, "data-list");
        int i = 0;
        String invoiceStr = SysParamConfig.get("hasinvoicebill");
        List<Object> sysList = new ArrayList(3);
        if (kd.bos.util.StringUtils.isNotEmpty((String)invoiceStr)) {
            sysList = Arrays.asList(invoiceStr.split(","));
        }
        for (Map.Entry<String, List<BillInfo>> linkUpBillInfo : linkUpBillInfos.entrySet()) {
            String billType = linkUpBillInfo.getKey();
            String idField = ArchiveUtil.getFieldName(billType, "id");
            DynamicObjectCollection fileds = ArchiveUtil.getXmlfileds(billType);
            if (!billTypeAndNameMap.containsKey(billType)) {
                String billTypeName = EntityMetadataCache.getDataEntityType((String)billType).getDisplayName().toString();
                billTypeAndNameMap.put(billType, billTypeName);
            }
            List<BillInfo> list = linkUpBillInfo.getValue();
            for (BillInfo billInfo : list) {
                Map numbermap;
                List<Attach> attaches;
                ++i;
                if (errRefBills != null && errRefBills.get(billType) != null && errRefBills.get(billType).size() > 0 && errRefBills.get(billType).contains(billInfo.getBillId())) continue;
                Element data = JDomB9Utils.addChildAndName(datalist, "data");
                JDomB9Utils.addChildAndName(data, "id", i + "");
                if ("er_tripreimbursebill".equals(billType) || "er_dailyreimbursebill".equals(billType) || "ap_finapbill".equals(billType) || "er_publicreimbursebill".equals(billType) || "ap_invoice".equals(billType) || sysList.contains(billType)) {
                    if ("A".equals(imageMap.get("enable"))) {
                        JDomB9Utils.addChildAndName(data, "isFPYBill", "true");
                    } else {
                        JDomB9Utils.addChildAndName(data, "isFPYBill", "false");
                    }
                }
                if ("ap_finapbill".equals(billType)) {
                    JDomB9Utils.addChildAndName(data, "billid", "ap_invoice_" + billInfo.getBillId().toString());
                } else {
                    JDomB9Utils.addChildAndName(data, "billid", billType + "_" + billInfo.getBillId().toString());
                }
                if (fileds.size() > 0) {
                    Map<String, String> fieldMap = billInfo.getFieldMap();
                    for (DynamicObject filed : fileds) {
                        String xmlfiled = filed.getString("xmlfiled");
                        if (xmlfiled.equals(idField)) continue;
                        JDomB9Utils.addChildAndName(data, filed.getString("xmlfiled"), fieldMap.get(filed.getString("xmlfiled")));
                    }
                } else {
                    JDomB9Utils.addChildAndName(data, "billcode", billInfo.getBillNo());
                    JDomB9Utils.addChildAndName(data, "voucherorgnumber", accountBookNo);
                    JDomB9Utils.addChildAndName(data, "voucherorgname", accountBookName);
                }
                JDomB9Utils.addChildAndName(data, "billtype", (String)billTypeAndNameMap.get(billType));
                JDomB9Utils.addChildAndName(data, "period", FPYXmlUtils.dealPeriodNumber(period));
                Element refbilllist = JDomB9Utils.addChildAndName(data, "refbill-list");
                Long billId = Long.valueOf(billInfo.getBillId().toString());
                if (billAndRefvoucherIds.get(billType) == null) continue;
                Set<Long> ids = billAndRefvoucherIds.get(billType).get(billId);
                if (ids != null && !ids.isEmpty()) {
                    JDomB9Utils.addChildAndNameForRefbills(refbilllist, "refbill", ids, voucherInfoMap);
                }
                Element filelist = JDomB9Utils.addChildAndName(data, "file-list");
                Element file = JDomB9Utils.addChildAndName(filelist, "file");
                String name = billType + "_" + billInfo.getBillId().toString() + ".pdf";
                JDomB9Utils.addChildAndName(file, "name", name);
                JDomB9Utils.addChildAndName(file, "srcname", name);
                if (refAttachMap != null && refAttachMap.size() > 0 && (attaches = refAttachMap.get(billId)) != null) {
                    for (Attach attachfile : attaches) {
                        Element attach = filelist.addElement("file");
                        JDomB9Utils.addChildAndName(attach, "name", billId + "_" + attachfile.getFileName());
                        JDomB9Utils.addChildAndName(attach, "srcname", attachfile.getFileName());
                    }
                }
                if ((numbermap = (Map)imageMap.get("numbermap")) == null || numbermap.size() <= 0 || numbermap.get(billType) == null || ((Map)numbermap.get(billType)).get(billId) == null || ((List)((Map)numbermap.get(billType)).get(billId)).size() <= 0) continue;
                Element imagesys = JDomB9Utils.addChildAndName(data, "imagesys");
                JDomB9Utils.addChildAndName(imagesys, "imagesystype", imageMap.get("imagesystype") == null ? "null" : (String)imageMap.get("imagesystype"));
                JDomB9Utils.addChildAndName(imagesys, "imagesysip", imageMap.get("imagesysip") == null ? "null" : (String)imageMap.get("imagesysip"));
                JDomB9Utils.addChildAndName(imagesys, "imagesysport", imageMap.get("imagesysport") == null ? "null" : (String)imageMap.get("imagesysport"));
                Element imagelist = JDomB9Utils.addChildAndName(data, "image-list");
                List imagenumbers = (List)((Map)numbermap.get(billType)).get(billId);
                for (String imagenumber : imagenumbers) {
                    Element image = JDomB9Utils.addChildAndName(imagelist, "image");
                    JDomB9Utils.addChildAndName(image, "imagenumber", imagenumber);
                }
            }
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createCasRptXml(String desc, List<Map<String, String>> xmlList, String flag) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName(docinfo, "header");
        JDomB9Utils.addChildAndName(header, "doctype", "voucher");
        JDomB9Utils.addChildAndName(header, "creater", FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName(header, "time", FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName(header, "rearchflag", flag);
        JDomB9Utils.addChildAndName(header, "desc", desc);
        Element datalist = JDomB9Utils.addChildAndName(docinfo, "data-list");
        JDomB9Utils.addData(datalist, xmlList, Boolean.TRUE);
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createGeneralledgerXml(String desc, List<Map<String, String>> xmlList, String flag) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName(docinfo, "header");
        JDomB9Utils.addChildAndName(header, "doctype", "ledger");
        JDomB9Utils.addChildAndName(header, "creater", FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName(header, "time", FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName(header, "rearchflag", flag);
        JDomB9Utils.addChildAndName(header, "desc", desc);
        Element datalist = JDomB9Utils.addChildAndName(docinfo, "data-list");
        JDomB9Utils.addData(datalist, xmlList, Boolean.FALSE);
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createSubledgerXml(String desc, List<Map<String, String>> xmlInfos, String flag) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName(docinfo, "header");
        JDomB9Utils.addChildAndName(header, "doctype", "detailb");
        JDomB9Utils.addChildAndName(header, "creater", FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName(header, "time", FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName(header, "rearchflag", flag);
        JDomB9Utils.addChildAndName(header, "desc", desc);
        Element datalist = JDomB9Utils.addChildAndName(docinfo, "data-list");
        JDomB9Utils.addData(datalist, xmlInfos, Boolean.TRUE);
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createSubledgerXml(String desc, List<Map<String, String>> xmlInfos, String flag, boolean isSub) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName(docinfo, "header");
        JDomB9Utils.addChildAndName(header, "doctype", isSub ? "detailb" : "ledger");
        JDomB9Utils.addChildAndName(header, "creater", FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName(header, "time", FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName(header, "rearchflag", flag);
        JDomB9Utils.addChildAndName(header, "desc", desc);
        Element datalist = JDomB9Utils.addChildAndName(docinfo, "data-list");
        JDomB9Utils.addData(datalist, xmlInfos, isSub);
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createElecreceiptXml(Map<Long, DynamicObject> receiptDys, Map<String, Set<Long>> refBilltypeAndIds, Map<String, Map<Long, Set<Long>>> receiptIdMap, Map<String, Object> imageMap, Map<String, Map<Long, Set<Long>>> billAndRefvoucherIds, String flag, Map<Long, String> recIdUrlMap) {
        HashMap<String, String> billTypeAndNameMap = new HashMap<String, String>();
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName(docinfo, "header");
        JDomB9Utils.addChildAndName(header, "doctype", "bankReturn");
        JDomB9Utils.addChildAndName(header, "creater", FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName(header, "time", FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName(header, "rearchflag", flag);
        JDomB9Utils.addChildAndName(header, "desc", ResManager.loadKDString((String)"CAS\u7535\u5b50\u56de\u5355", (String)"FPYXmlUtils_0", (String)"fi-aef-common", (Object[])new Object[0]));
        Element datalist = JDomB9Utils.addChildAndName(docinfo, "data-list");
        for (Map.Entry<String, Set<Long>> billReceipt : refBilltypeAndIds.entrySet()) {
            String billType = billReceipt.getKey();
            if (!billTypeAndNameMap.containsKey(billType)) {
                String billTypeName = EntityMetadataCache.getDataEntityType((String)billType).getDisplayName().toString();
                billTypeAndNameMap.put(billType, billTypeName);
            }
            Set<Long> billList = billReceipt.getValue();
            for (Long billId : billList) {
                Set<Object> receiptIds = new HashSet();
                if (receiptIdMap.containsKey(billType)) {
                    receiptIds = receiptIdMap.get(billType).get(billId);
                }
                if (receiptIds == null || receiptIds.size() <= 0) continue;
                for (Long receiptId : receiptIds) {
                    Map numbermap;
                    Element data = JDomB9Utils.addChildAndName(datalist, "data");
                    DynamicObject dyo = receiptDys.get(receiptId);
                    if (dyo != null) {
                        JDomB9Utils.addChildAndName(data, "billid", dyo.get("id").toString());
                        JDomB9Utils.addChildAndName(data, "tradeid", dyo.get("tradeid").toString());
                        JDomB9Utils.addChildAndName(data, "payeeaccount", dyo.get("payeeaccount") == null ? "null" : dyo.get("payeeaccount").toString());
                        JDomB9Utils.addChildAndName(data, "payeename", dyo.get("payeename") == null ? "null" : dyo.get("payeename").toString());
                        JDomB9Utils.addChildAndName(data, "payeebank", dyo.get("payeebank") == null ? "null" : dyo.get("payeebank").toString());
                        JDomB9Utils.addChildAndName(data, "paymentaccount", dyo.get("paymentaccount") == null ? "null" : dyo.get("paymentaccount").toString());
                        JDomB9Utils.addChildAndName(data, "paymentname", dyo.get("paymentname") == null ? "null" : dyo.get("paymentname").toString());
                        JDomB9Utils.addChildAndName(data, "paymentbank", dyo.get("paymentbank") == null ? "null" : dyo.get("paymentbank").toString());
                        JDomB9Utils.addChildAndName(data, "tradedate", dyo.get("tradedate") == null ? "null" : dyo.get("tradedate").toString());
                        JDomB9Utils.addChildAndName(data, "currency", dyo.get("currency") == null ? "null" : dyo.get("currency").toString());
                        JDomB9Utils.addChildAndName(data, "amount", dyo.get("amount") == null ? "null" : dyo.get("amount").toString());
                        JDomB9Utils.addChildAndName(data, "postscript", dyo.get("postscript") == null ? "null" : dyo.get("postscript").toString());
                        JDomB9Utils.addChildAndName(data, "ismainbill", "true");
                    }
                    Element refbilllist = JDomB9Utils.addChildAndName(data, "refbill-list");
                    Set<Long> ids = billAndRefvoucherIds.get(billType).get(billId);
                    if (ids != null && !ids.isEmpty()) {
                        JDomB9Utils.addChildAndNameForRefbills(refbilllist, "refbill", ids);
                    }
                    if (imageMap != null && (numbermap = (Map)imageMap.get("numbermap")) != null && numbermap.size() > 0 && numbermap.get(billType) != null && ((Map)numbermap.get(billType)).get(billId) != null && ((List)((Map)numbermap.get(billType)).get(billId)).size() > 0) {
                        Element imagesys = JDomB9Utils.addChildAndName(data, "imagesys");
                        JDomB9Utils.addChildAndName(imagesys, "imagesystype", imageMap.get("imagesystype") == null ? "null" : (String)imageMap.get("imagesystype"));
                        JDomB9Utils.addChildAndName(imagesys, "imagesysip", imageMap.get("imagesysip") == null ? "null" : (String)imageMap.get("imagesysip"));
                        JDomB9Utils.addChildAndName(imagesys, "imagesysport", imageMap.get("imagesysport") == null ? "null" : (String)imageMap.get("imagesysport"));
                        Element imagelist = JDomB9Utils.addChildAndName(data, "image-list");
                        List imagenumbers = (List)((Map)numbermap.get(billType)).get(billId);
                        for (String imagenumber : imagenumbers) {
                            Element image = JDomB9Utils.addChildAndName(imagelist, "image");
                            JDomB9Utils.addChildAndName(image, "imagenumber", imagenumber);
                        }
                    }
                    Element filelist = JDomB9Utils.addChildAndName(data, "file-list");
                    if (recIdUrlMap != null && recIdUrlMap.size() > 0) {
                        Element urlFile = JDomB9Utils.addChildAndName(filelist, "file");
                        JDomB9Utils.addChildAndName(urlFile, "name", ElecreceiptUtils.getFileName(recIdUrlMap.get(receiptId)));
                        JDomB9Utils.addChildAndName(urlFile, "srcname", ElecreceiptUtils.getFileName(recIdUrlMap.get(receiptId)));
                    }
                    JDomB9Utils.addChildAndName(data, "year", FPYXmlUtils.getTimeStr().substring(0, 4));
                }
            }
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createMRptXml(Map<String, String> rptUrlMap, Map<String, String> rptGetNameMap, Map<String, String> rptGetOrgMap, String flag, String bcmfyName, String bcmperiodName) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName(docinfo, "header");
        JDomB9Utils.addChildAndName(header, "doctype", "monthReport");
        JDomB9Utils.addChildAndName(header, "creater", FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName(header, "time", FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName(header, "rearchflag", flag);
        JDomB9Utils.addChildAndName(header, "desc", ResManager.loadKDString((String)"\u6708\u5ea6\u8d22\u52a1\u62a5\u544a", (String)"FPYXmlUtils_1", (String)"fi-aef-common", (Object[])new Object[0]));
        Element datalist = JDomB9Utils.addChildAndName(docinfo, "data-list");
        for (Map.Entry<String, String> rptAllUrlMap : rptUrlMap.entrySet()) {
            String rptAllUrlKey = rptAllUrlMap.getKey();
            String allUrl = rptAllUrlMap.getValue();
            Element data = JDomB9Utils.addChildAndName(datalist, "data");
            JDomB9Utils.addChildAndName(data, "id", "rpt_" + rptAllUrlKey.split("_")[2]);
            JDomB9Utils.addChildAndName(data, "billid", rptAllUrlKey.split("_")[2]);
            JDomB9Utils.addChildAndName(data, "voucherorgnumber", rptGetOrgMap.get(rptAllUrlKey) == null ? "null" : rptGetOrgMap.get(rptAllUrlKey).split("_")[0]);
            JDomB9Utils.addChildAndName(data, "voucherorgname", rptGetOrgMap.get(rptAllUrlKey) == null ? "null" : rptGetOrgMap.get(rptAllUrlKey).split("_")[1]);
            JDomB9Utils.addChildAndName(data, "reporttype", rptGetNameMap.get(rptAllUrlKey) == null ? "null" : rptGetNameMap.get(rptAllUrlKey));
            JDomB9Utils.addChildAndName(data, "period", FPYXmlUtils.bulidRptPeriod(bcmfyName, bcmperiodName));
            Element filelist = JDomB9Utils.addChildAndName(data, "file-list");
            Element urlFile = JDomB9Utils.addChildAndName(filelist, "file");
            JDomB9Utils.addChildAndName(urlFile, "name", rptAllUrlKey + ".pdf");
            JDomB9Utils.addChildAndName(urlFile, "srcname", rptAllUrlKey + ".pdf");
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createQRptXml(Map<String, String> rptUrlMap, Map<String, String> rptGetNameMap, Map<String, String> rptGetOrgMap, String flag, String bcmfyName, String bcmperiodName) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName(docinfo, "header");
        JDomB9Utils.addChildAndName(header, "doctype", "monthReport");
        JDomB9Utils.addChildAndName(header, "creater", FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName(header, "time", FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName(header, "rearchflag", flag);
        JDomB9Utils.addChildAndName(header, "desc", ResManager.loadKDString((String)"\u5b63\u5ea6\u8d22\u52a1\u62a5\u544a", (String)"FPYXmlUtils_2", (String)"fi-aef-common", (Object[])new Object[0]));
        Element datalist = JDomB9Utils.addChildAndName(docinfo, "data-list");
        for (Map.Entry<String, String> rptAllUrlMap : rptUrlMap.entrySet()) {
            String rptAllUrlKey = rptAllUrlMap.getKey();
            String allUrl = rptAllUrlMap.getValue();
            Element data = JDomB9Utils.addChildAndName(datalist, "data");
            JDomB9Utils.addChildAndName(data, "id", "rpt_" + rptAllUrlKey.split("_")[2]);
            JDomB9Utils.addChildAndName(data, "billid", rptAllUrlKey.split("_")[2]);
            JDomB9Utils.addChildAndName(data, "voucherorgnumber", rptGetOrgMap.get(rptAllUrlKey) == null ? "null" : rptGetOrgMap.get(rptAllUrlKey).split("_")[0]);
            JDomB9Utils.addChildAndName(data, "voucherorgname", rptGetOrgMap.get(rptAllUrlKey) == null ? "null" : rptGetOrgMap.get(rptAllUrlKey).split("_")[1]);
            JDomB9Utils.addChildAndName(data, "reporttype", rptGetNameMap.get(rptAllUrlKey) == null ? "null" : rptGetNameMap.get(rptAllUrlKey));
            JDomB9Utils.addChildAndName(data, "period", FPYXmlUtils.bulidRptPeriod(bcmfyName, bcmperiodName));
            Element filelist = JDomB9Utils.addChildAndName(data, "file-list");
            Element urlFile = JDomB9Utils.addChildAndName(filelist, "file");
            JDomB9Utils.addChildAndName(urlFile, "name", rptAllUrlKey + ".pdf");
            JDomB9Utils.addChildAndName(urlFile, "srcname", rptAllUrlKey + ".pdf");
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createARptXml(Map<String, String> rptUrlMap, Map<String, String> rptGetNameMap, Map<String, String> rptGetOrgMap, String flag, String bcmfyName, String bcmperiodName) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName(docinfo, "header");
        JDomB9Utils.addChildAndName(header, "doctype", "monthReport");
        JDomB9Utils.addChildAndName(header, "creater", FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName(header, "time", FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName(header, "rearchflag", flag);
        JDomB9Utils.addChildAndName(header, "desc", ResManager.loadKDString((String)"\u5e74\u5ea6\u8d22\u52a1\u62a5\u544a", (String)"FPYXmlUtils_3", (String)"fi-aef-common", (Object[])new Object[0]));
        Element datalist = JDomB9Utils.addChildAndName(docinfo, "data-list");
        for (Map.Entry<String, String> rptAllUrlMap : rptUrlMap.entrySet()) {
            String rptAllUrlKey = rptAllUrlMap.getKey();
            String allUrl = rptAllUrlMap.getValue();
            Element data = JDomB9Utils.addChildAndName(datalist, "data");
            JDomB9Utils.addChildAndName(data, "id", "rpt_" + rptAllUrlKey.split("_")[2]);
            JDomB9Utils.addChildAndName(data, "billid", rptAllUrlKey.split("_")[2]);
            JDomB9Utils.addChildAndName(data, "voucherorgnumber", rptGetOrgMap.get(rptAllUrlKey) == null ? "null" : rptGetOrgMap.get(rptAllUrlKey).split("_")[0]);
            JDomB9Utils.addChildAndName(data, "voucherorgname", rptGetOrgMap.get(rptAllUrlKey) == null ? "null" : rptGetOrgMap.get(rptAllUrlKey).split("_")[1]);
            JDomB9Utils.addChildAndName(data, "reporttype", rptGetNameMap.get(rptAllUrlKey) == null ? "null" : rptGetNameMap.get(rptAllUrlKey));
            JDomB9Utils.addChildAndName(data, "period", FPYXmlUtils.bulidRptPeriod(bcmfyName, bcmperiodName));
            JDomB9Utils.addChildAndName(data, "year", bcmfyName.substring(0, 4));
            JDomB9Utils.addChildAndName(data, "barcode", "001");
            Element filelist = JDomB9Utils.addChildAndName(data, "file-list");
            Element urlFile = JDomB9Utils.addChildAndName(filelist, "file");
            JDomB9Utils.addChildAndName(urlFile, "name", rptAllUrlKey + ".pdf");
            JDomB9Utils.addChildAndName(urlFile, "srcname", rptAllUrlKey + ".pdf");
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    public static String createElecXml(DataSet set, Map<Long, String> billFileNameMap, String billName, Map<Long, List<Attach>> attachMap, String billType, Map<Long, List<DynamicObject>> entryRows, String flag) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName(docinfo, "header");
        JDomB9Utils.addChildAndName(header, "doctype", "elecstatement");
        JDomB9Utils.addChildAndName(header, "creater", FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName(header, "time", FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName(header, "rearchflag", flag);
        JDomB9Utils.addChildAndName(header, "desc", billName);
        Element datalist = JDomB9Utils.addChildAndName(docinfo, "data-list");
        for (Row row : set) {
            Long billId = row.getLong("id");
            List<DynamicObject> entrys = entryRows.get(billId);
            HashSet<String> tradetypeSet = new HashSet<String>(2);
            BigDecimal debitBigDecimal = BigDecimal.ZERO;
            BigDecimal creditBigDecimal = BigDecimal.ZERO;
            int debitnum = 0;
            int creditnum = 0;
            FPYXmlUtils.getDecimalValue(debitBigDecimal, creditBigDecimal, debitnum, creditnum, entrys, tradetypeSet);
            String tradetypeString = ResManager.loadKDString((String)"\u5168\u90e8", (String)"FPYXmlUtils_4", (String)"fi-aef-common", (Object[])new Object[0]);
            if (tradetypeSet.size() == 1) {
                tradetypeString = "0".equals(tradetypeSet.iterator().next()) ? ResManager.loadKDString((String)"\u501f", (String)"FPYXmlUtils_5", (String)"fi-aef-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d37", (String)"FPYXmlUtils_6", (String)"fi-aef-common", (Object[])new Object[0]);
            }
            Element data = JDomB9Utils.addChildAndName(datalist, "data");
            JDomB9Utils.addChildAndName(data, "billid", row.getString("id"));
            JDomB9Utils.addChildAndName(data, "accountdate", DateUtil.getShortStr(row.getDate("period")));
            JDomB9Utils.addChildAndName(data, "tradetype", tradetypeString);
            JDomB9Utils.addChildAndName(data, "period", DateUtil.getShortStr(row.getDate("period")));
            JDomB9Utils.addChildAndName(data, "accountname", row.getString("accountname"));
            JDomB9Utils.addChildAndName(data, "accountno", row.getString("accountno"));
            JDomB9Utils.addChildAndName(data, "currency", row.getString("currency"));
            JDomB9Utils.addChildAndName(data, "debitamount", debitBigDecimal.toString());
            JDomB9Utils.addChildAndName(data, "creditamount", creditBigDecimal.toString());
            JDomB9Utils.addChildAndName(data, "debitnum", debitnum + "");
            JDomB9Utils.addChildAndName(data, "creditnum", creditnum + "");
            Element jlinelist = JDomB9Utils.addChildAndName(data, "jeline-list");
            if (entrys.size() > 0) {
                for (DynamicObject dyn : entrys) {
                    Element jline = jlinelist.addElement("jeline");
                    JDomB9Utils.addChildAndName(jline, "accounttime", dyn.getString("accounttime") == null ? "" : dyn.getString("accounttime"));
                    tradetypeString = dyn.getString("tradetype");
                    JDomB9Utils.addChildAndName(jline, "tradetype", tradetypeString == null ? "" : tradetypeString);
                    JDomB9Utils.addChildAndName(jline, "amount", "0".equals(tradetypeString) ? (dyn.getString("debitamount") == null ? "0" : dyn.getString("debitamount")) : (dyn.getString("creditamount") == null ? "0" : dyn.getString("creditamount")));
                    JDomB9Utils.addChildAndName(jline, "accountbalance", dyn.getString("accountbalance") == null ? "0" : dyn.getString("accountbalance"));
                    JDomB9Utils.addChildAndName(jline, "oppositeaccount", dyn.getString("oppositeaccount") == null ? "" : dyn.getString("oppositeaccount"));
                    JDomB9Utils.addChildAndName(jline, "oppositename", dyn.getString("oppositename") == null ? "" : dyn.getString("oppositename"));
                    JDomB9Utils.addChildAndName(jline, "abstract", dyn.getString("abstract") == null ? "" : dyn.getString("abstract"));
                    JDomB9Utils.addChildAndName(jline, "voucherNum", dyn.getString("voucherNum") == null ? "" : dyn.getString("voucherNum"));
                    JDomB9Utils.addChildAndName(jline, "tradeid", dyn.getString("tradeid") == null ? "" : dyn.getString("tradeid"));
                }
            }
            Element filelist = JDomB9Utils.addChildAndName(data, "file-list");
            Element file = JDomB9Utils.addChildAndName(filelist, "file");
            String name = billFileNameMap.get(billId);
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = "";
            }
            JDomB9Utils.addChildAndName(file, "name", name);
            JDomB9Utils.addChildAndName(file, "srcname", name);
            List<Attach> attaches = attachMap.get(billId);
            if (attaches == null) continue;
            for (Attach attachfile : attaches) {
                Element attach = filelist.addElement("file");
                JDomB9Utils.addChildAndName(attach, "name", billId + "_" + attachfile.getFileName());
                JDomB9Utils.addChildAndName(attach, "srcname", attachfile.getFileName());
            }
        }
        return FPYXmlUtils.toBase64Str(document);
    }

    private static void getDecimalValue(BigDecimal debitBigDecimal, BigDecimal creditBigDecimal, int debitnum, int creditnum, List<DynamicObject> entrys, Set<String> tradetypeSet) {
        for (DynamicObject dynamicObject : entrys) {
            tradetypeSet.add(dynamicObject.getString("tradetype"));
            if ("0".equals(dynamicObject.getString("tradetype"))) {
                ++debitnum;
            } else {
                ++creditnum;
            }
            debitBigDecimal = debitBigDecimal.add(dynamicObject.getBigDecimal("debitamount") == null ? BigDecimal.ZERO : dynamicObject.getBigDecimal("debitamount"));
            creditBigDecimal = creditBigDecimal.add(dynamicObject.getBigDecimal("creditamount") == null ? BigDecimal.ZERO : dynamicObject.getBigDecimal("creditamount"));
        }
    }

    public static String bulidRptPeriod(String bcmfyName, String bcmperiodName) {
        String string = "";
        if (!StringUtils.isEmpty((CharSequence)bcmfyName) && !StringUtils.isEmpty((CharSequence)bcmperiodName)) {
            String periodString = "";
            periodString = bcmperiodName.length() == 2 ? "0" + bcmperiodName.substring(0, bcmperiodName.length() - 1) : bcmperiodName.substring(0, bcmperiodName.length() - 1);
            string = bcmfyName.substring(0, bcmfyName.length() - 1) + "-" + periodString;
        }
        return string;
    }

    public static String dealPeriodNumber(String periodNumber) {
        if (!StringUtils.isEmpty((CharSequence)periodNumber) && periodNumber.length() == 6) {
            periodNumber = periodNumber.substring(0, 4) + "-" + periodNumber.substring(4, 6);
        }
        return periodNumber;
    }

    public static void addFiles(Element filelist, String fileNodeName, List<Attach> attaches, String voucherId, String fileName) {
        Element mainfile = filelist.addElement(fileNodeName);
        JDomB9Utils.addChildAndName(mainfile, "name", fileName);
        JDomB9Utils.addChildAndName(mainfile, "srcname", fileName);
        if (attaches == null || attaches.isEmpty()) {
            return;
        }
        for (Attach attach : attaches) {
            String name = attach.getFileName();
            Element file = filelist.addElement(fileNodeName);
            JDomB9Utils.addChildAndName(file, "name", voucherId + "_" + name);
            JDomB9Utils.addChildAndName(file, "srcname", name);
        }
    }

    private static String getSysName() {
        return ResManager.loadKDString((String)"\u82cd\u7a79", (String)"FPYXmlUtils_7", (String)"fi-aef-common", (Object[])new Object[0]);
    }

    private static String getTimeStr() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        return simpleDateFormat.format(date);
    }

    private static String getLongTimeStr() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    private static String toBase64Str(Document document) {
        ByteArrayOutputStream byteOut = null;
        XMLWriter xmlWriter = null;
        try {
            byteOut = new ByteArrayOutputStream();
            xmlWriter = new XMLWriter((OutputStream)byteOut);
            xmlWriter.write(document);
            byte[] byteArr = byteOut.toByteArray();
            String string = Base64.getEncoder().encodeToString(byteArr);
            return string;
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"Documen\u8f6c\u5316\u4e3abyte[]\u5931\u8d25\u3002", (String)"CreateXmlUtil_1", (String)"fi-aef-common", (Object[])new Object[0]));
        }
        finally {
            if (byteOut != null) {
                try {
                    byteOut.close();
                }
                catch (IOException e) {
                    LogUtil.printLog(logger, ResManager.loadKDString((String)"\u5173\u95ed\u6d41\u5931\u8d25", (String)"FPYXmlUtils_8", (String)"fi-aef-common", (Object[])new Object[0]));
                }
            }
            if (xmlWriter != null) {
                try {
                    xmlWriter.close();
                }
                catch (IOException e) {
                    LogUtil.printLog(logger, ResManager.loadKDString((String)"\u5173\u95ed\u6d41\u5931\u8d25", (String)"FPYXmlUtils_8", (String)"fi-aef-common", (Object[])new Object[0]));
                }
            }
        }
    }

    public static String createFacardfinXml(ArchiveContext context, List<Bill> list, String desc, Map<Object, FileDesc> billFileMap, Map<Object, List<Attach>> attachMap, String flag, Set<Object> errIds) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName(docinfo, "header");
        JDomB9Utils.addChildAndName(header, "doctype", "assetscard");
        JDomB9Utils.addChildAndName(header, "creater", FPYXmlUtils.getSysName());
        JDomB9Utils.addChildAndName(header, "time", FPYXmlUtils.getLongTimeStr());
        JDomB9Utils.addChildAndName(header, "desc", desc);
        JDomB9Utils.addChildAndName(header, "rearchflag", flag);
        Element datalist = JDomB9Utils.addChildAndName(docinfo, "data-list");
        FPYXmlUtils.addFaChildAndName(datalist, list, billFileMap, attachMap, errIds);
        return FPYXmlUtils.toBase64Str(document);
    }

    private static void addFaChildAndName(Element datalist, List<Bill> list, Map<Object, FileDesc> billFileMap, Map<Object, List<Attach>> attachMap, Set<Object> errIds) {
        int i = 0;
        for (Bill bill : list) {
            ++i;
            Object billId = bill.getBillId();
            if (errIds != null && errIds.size() > 0 && errIds.contains(billId)) continue;
            Element data = JDomB9Utils.addChildAndName(datalist, "data");
            JDomB9Utils.addChildAndName(data, "id", i + "");
            JDomB9Utils.addChildAndName(data, "billid", billId.toString());
            JDomB9Utils.addChildAndName(data, "period", CreateXmlUtil.dealPeriodNumber(bill.getPeriodNumber()));
            JDomB9Utils.addChildAndName(data, "voucherorgnumber", bill.getOrgNo());
            JDomB9Utils.addChildAndName(data, "voucherorgname", bill.getOrgName());
            Map<String, Object> field2ValueMap = bill.getField2ValueMap();
            field2ValueMap.forEach((k, v) -> JDomB9Utils.addChildAndName(data, k, v.toString()));
            Element filelist = JDomB9Utils.addChildAndName(data, "file-list");
            Element file = JDomB9Utils.addChildAndName(filelist, "file");
            String fileName = billFileMap.get(billId).getName();
            JDomB9Utils.addChildAndName(file, "name", fileName);
            JDomB9Utils.addChildAndName(file, "srcname", fileName);
            List<Attach> attaches = null;
            if (attachMap != null) {
                attaches = attachMap.get(billId);
            }
            if (attaches == null) continue;
            for (Attach attachfile : attaches) {
                Element attach = filelist.addElement("file");
                JDomB9Utils.addChildAndName(attach, "name", billId + "_" + attachfile.getFileName());
                JDomB9Utils.addChildAndName(attach, "srcname", attachfile.getFileName());
            }
        }
    }
}

