/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.logic.common.OperationResultUtils;
import kd.fi.aef.logic.model.FileUploadItem;
import kd.fi.aef.logic.output.Result;

public class FTPUtils {
    public static Result upload(FileUploadItem fileUploadItem) {
        Result returnResult = new Result();
        FileService service = FileServiceFactory.getAttachmentFileService();
        FileItem fileItem = FTPUtils.convertFileItem(fileUploadItem);
        if (fileItem != null) {
            String url = service.upload(fileItem);
            returnResult.setSucceed(true);
            returnResult.setUrl(url);
        } else {
            returnResult.setSucceed(false);
            returnResult.setErrorMessage("param fileUploadItem  is null");
        }
        return returnResult;
    }

    private static FileItem convertFileItem(FileUploadItem fileUploadItem) {
        if (fileUploadItem != null) {
            FileItem fileItem = SingleArchiveUtil.getFileItem(RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), fileUploadItem.getFileBytes(), fileUploadItem.getBillName() + fileUploadItem.getBillNo(), fileUploadItem.getBillType());
            return fileItem;
        }
        return null;
    }

    public static OperationResult deleteImagesByFtp(List<Long> idList, OperationResult result, MainEntityType billEntityType) {
        ArrayList<Long> imageList = new ArrayList<Long>();
        result.setBillCount(result.getBillCount() + idList.size());
        QFilter idFilter = new QFilter("id", "in", idList);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ReverseFilingOpService.deleteImagesByFtp", (String)billEntityType.getName(), (String)"id,billno,billid,billtype", (QFilter[])new QFilter[]{idFilter}, null);
        HashMap<String, List> map = new HashMap<String, List>();
        FileService imageService = FileServiceFactory.getAttachmentFileService();
        for (Row row : dataSet) {
            String billType = row.getString("billtype");
            Long billid = row.getLong("billid");
            map.computeIfAbsent(billType, value -> new ArrayList()).add(billid);
        }
        ArrayList<Long> billidlist = new ArrayList<Long>();
        for (Map.Entry entry : map.entrySet()) {
            try {
                QFilter billidFilter = new QFilter("billid", "in", entry.getValue());
                QFilter billTypeFilter = new QFilter("billtype.id", "=", entry.getKey());
                QFilter[] filters = new QFilter[]{billidFilter, billTypeFilter};
                DynamicObjectCollection dyns = QueryServiceHelper.query((String)"aef_archieve_imagepath", (String)"id,billid,imagepath", (QFilter[])filters);
                for (DynamicObject image : dyns) {
                    imageService.delete(image.getString("imagepath"));
                    imageList.add(image.getLong("id"));
                    billidlist.add(image.getLong("billid"));
                }
            }
            catch (Exception e) {
                result.setSuccess(false);
                OperateErrorInfo errorInfo = OperationResultUtils.createOperateErrorInfo(null);
                result.addErrorInfo(errorInfo);
            }
        }
        DeleteServiceHelper.delete((String)"aef_archieve_imagepath", (QFilter[])new QFilter[]{new QFilter("id", "in", imageList)});
        DeleteServiceHelper.delete((String)billEntityType.getName(), (QFilter[])new QFilter[]{new QFilter("billid", "in", billidlist)});
        return result;
    }
}

