/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class GXFTPUtil {
    private static final Log LOGGER = LogFactory.getLog(GXFTPUtil.class);
    private static final String BASE_PATH = "ftp/";
    private static String localCharset = "GBK";
    private static String serverCharset = "ISO-8859-1";
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final String OPTS_UTF8 = "OPTS UTF8";
    private static final int BUFFER_SIZE = 0x400000;
    private FTPClient ftpClient = new FTPClient();

    public GXFTPUtil(String address, int port, String username, String password) {
        try {
            this.ftpClient.connect(address, port);
            this.ftpClient.login(username, password);
            this.ftpClient.setFileType(2);
            int reply = this.ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.closeConnect();
                LOGGER.error("FTP Connect error ");
            }
        }
        catch (Exception e) {
            LOGGER.error("FTP login error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadLocalFile(String ftpPath, String savePath, String fileName) {
        boolean flag = false;
        if (this.ftpClient != null) {
            File file = new File(FilenameUtils.getName((String)savePath));
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                this.ftpClient.setBufferSize(0x400000);
                if (FTPReply.isPositiveCompletion((int)this.ftpClient.sendCommand(OPTS_UTF8, "ON"))) {
                    localCharset = CHARSET_UTF8;
                }
                this.ftpClient.setControlEncoding(localCharset);
                this.ftpClient.setFileType(2);
                String path = this.changeEncoding(BASE_PATH + ftpPath);
                this.ftpClient.enterLocalPassiveMode();
                flag = this.ftpClient.storeFile(new String(fileName.getBytes(localCharset), serverCharset), (InputStream)fis);
            }
            catch (Exception e) {
                LOGGER.error("upload FTP failed", (Throwable)e);
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    IOUtils.closeQuietly((InputStream)fis);
                }
                catch (IOException e) {
                    LOGGER.error((Throwable)e);
                }
                this.closeConnect();
            }
        }
        return flag;
    }

    public boolean uploadString(String ftpPath, InputStream fis, String fileName) throws Exception {
        boolean flag = false;
        if (this.ftpClient != null) {
            this.ftpClient.setBufferSize(0x400000);
            if (FTPReply.isPositiveCompletion((int)this.ftpClient.sendCommand(OPTS_UTF8, "ON"))) {
                localCharset = CHARSET_UTF8;
            }
            this.ftpClient.setControlEncoding(localCharset);
            this.ftpClient.setFileType(2);
            String path = this.changeEncoding(ftpPath);
            LOGGER.info("archive ftpPath:" + path);
            if (!this.ftpClient.changeWorkingDirectory(path)) {
                this.createFtpDir(path);
            }
            this.ftpClient.enterLocalPassiveMode();
            flag = this.ftpClient.storeFile(new String(fileName.getBytes(localCharset), serverCharset), fis);
        }
        return flag;
    }

    public final void closeConnect() {
        if (this.ftpClient != null && this.ftpClient.isConnected()) {
            try {
                this.ftpClient.logout();
                this.ftpClient.disconnect();
            }
            catch (IOException e) {
                LOGGER.error("close FTP error", (Throwable)e);
            }
        }
    }

    private String changeEncoding(String ftpPath) {
        String directory = null;
        try {
            if (FTPReply.isPositiveCompletion((int)this.ftpClient.sendCommand(OPTS_UTF8, "ON"))) {
                localCharset = CHARSET_UTF8;
            }
            if (ftpPath.equals(new String(ftpPath.getBytes("ISO-8859-1"), "ISO-8859-1"))) {
                return ftpPath;
            }
            if (!FTPReply.isPositiveCompletion((int)this.ftpClient.sendCommand(OPTS_UTF8, "ON")) && ftpPath.equals(new String(ftpPath.getBytes("utf-8"), "utf-8"))) {
                ftpPath = new String(ftpPath.getBytes("utf-8"), serverCharset);
                return ftpPath;
            }
            directory = new String(ftpPath.getBytes(localCharset), serverCharset);
        }
        catch (Exception e) {
            LOGGER.error("path change error", (Throwable)e);
        }
        return directory;
    }

    public boolean createFtpDir(String path) throws IOException {
        this.ftpClient.makeDirectory(path);
        List<String> list = GXFTPUtil.getPathList(path);
        for (int i = 0; i < list.size(); ++i) {
            if (this.ftpClient.changeWorkingDirectory(list.get(i)) || this.ftpClient.makeDirectory(list.get(i))) continue;
            LOGGER.error("create dir fail --> " + list.get(i));
            return false;
        }
        return this.ftpClient.changeWorkingDirectory(path);
    }

    public static List<String> getPathList(String path) {
        String[] dirs = path.split("/");
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder s = new StringBuilder();
        for (String str : dirs) {
            if ("".equals(str)) continue;
            s.append("/").append(str);
            list.add(s.toString());
        }
        return list;
    }
}

