/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.common;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.common.util.SysParamConfig;
import kd.fi.aef.logic.common.GXFTPUtil;
import kd.fi.aef.logic.common.GXXmlParseUtil;
import kd.fi.aef.logic.common.GXXmlUtils;
import kd.fi.aef.logic.common.OperationResultUtils;
import kd.fi.aef.logic.model.FileUploadItem;
import kd.fi.aef.logic.output.Result;

public class GXUtils {
    private static final Log logger = LogFactory.getLog(GXUtils.class);

    public static Result upload(GXFTPUtil ftpUtil, FileUploadItem fileUploadItem) {
        Result returnResult = new Result();
        ByteArrayInputStream in = new ByteArrayInputStream(fileUploadItem.getFileBytes());
        String dir = fileUploadItem.getCustomString();
        try {
            boolean b = ftpUtil.uploadString(dir, in, fileUploadItem.getFileName());
            if (b) {
                returnResult.setSucceed(true);
            } else {
                returnResult.setSucceed(false);
                returnResult.setErrorMessage("upload file failed :" + fileUploadItem.getFileName());
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            returnResult.setSucceed(false);
            returnResult.setErrorMessage(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return returnResult;
    }

    public static Result noticeArchive(GXFTPUtil ftpUtil, FileUploadItem fileUploadItem) {
        Result returnResult = new Result();
        ByteArrayInputStream in1 = new ByteArrayInputStream("UploadEnd".getBytes());
        ByteArrayInputStream in2 = new ByteArrayInputStream("ProcEnd".getBytes());
        String dir = fileUploadItem.getCustomString();
        try {
            boolean b = ftpUtil.uploadString(dir, in1, "UploadEnd.txt");
            boolean c = ftpUtil.uploadString(dir, in2, "ProcEnd.txt");
            if (!b || !c) {
                returnResult.setSucceed(false);
                returnResult.setErrorMessage("upload file failed :" + fileUploadItem.getFileName());
                return returnResult;
            }
            String xml = GXXmlUtils.getArchiveXmlString(fileUploadItem);
            String returnData = GXXmlParseUtil.invoke(xml);
            if ("0".equals(GXXmlParseUtil.getResultMsg(returnData))) {
                returnResult.setSucceed(true);
                return returnResult;
            }
            logger.error("notice file failed :" + returnData);
            returnResult.setSucceed(false);
            returnResult.setErrorMessage("notice file failed :" + returnData);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            returnResult.setSucceed(false);
            returnResult.setErrorMessage(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            return returnResult;
        }
        return returnResult;
    }

    public static OperationResult deleteImagesByGX(List<Long> idList, OperationResult result, MainEntityType billEntityType) {
        HashMap<String, Object> extMap = new HashMap<String, Object>(4);
        result.setBillCount(result.getBillCount() + idList.size());
        QFilter idFilter = new QFilter("id", "in", idList);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ReverseFilingOpService.deleteImagesByFtp", (String)billEntityType.getName(), (String)"id,billno,billid,billtype,org.name,org.number", (QFilter[])new QFilter[]{idFilter}, null);
        HashMap<String, List> map = new HashMap<String, List>();
        for (Row row : dataSet) {
            extMap.put("orgname", row.getString("org.name"));
            extMap.put("orgnumber", row.getString("org.number"));
            String billType = row.getString("billtype");
            Long billid = row.getLong("billid");
            map.computeIfAbsent(billType, value -> new ArrayList()).add(billid);
        }
        DynamicObject userDyn = QueryServiceHelper.queryOne((String)"bos_user", (String)"name,number", (QFilter[])new QFilter("id", "=", (Object)Long.parseLong(RequestContext.get().getUserId())).toArray());
        extMap.put("name", userDyn.getString("name"));
        extMap.put("number", userDyn.getString("number"));
        for (Map.Entry entry : map.entrySet()) {
            extMap.put("billtype", entry.getKey());
            extMap.put("billids", entry.getValue());
            String xml = GXXmlUtils.getReveralXmlString(extMap);
            try {
                String returnData = GXXmlParseUtil.invoke(xml);
                if ("0".equals(GXXmlParseUtil.getResultMsg(returnData))) continue;
                result.setSuccess(false);
                OperateErrorInfo errorInfo = OperationResultUtils.createOperateErrorInfo((String)entry.getKey());
                errorInfo.setMessage(errorInfo.getMessage() + returnData);
                logger.error("deleteImagesByGX failed :" + returnData);
                result.addErrorInfo(errorInfo);
                return result;
            }
            catch (Exception e) {
                result.setSuccess(false);
                OperateErrorInfo errorInfo = OperationResultUtils.createOperateErrorInfo((String)entry.getKey());
                errorInfo.setMessage(errorInfo.getMessage() + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                result.addErrorInfo(errorInfo);
                logger.error("deleteImagesByGX failed :" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                return result;
            }
        }
        DeleteServiceHelper.delete((String)billEntityType.getName(), (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
        return result;
    }

    public static String getFtpPath(String billType) {
        String gxarchivefilepath = SysParamConfig.get("gxarchivefilepath");
        if (StringUtils.isNotBlank((CharSequence)gxarchivefilepath)) {
            return File.separator + gxarchivefilepath + File.separator + billType + File.separator + DateUtil.getDateString(new Date(), "yyyy/MM/dd/HHmmssSSS");
        }
        return File.separator + billType + File.separator + DateUtil.getDateString(new Date(), "yyyy/MM/dd/HHmmssSSS");
    }
}

