/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.common.util.JDomB9Utils;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.MD5;
import kd.fi.aef.common.util.SysParamConfig;
import kd.fi.aef.entity.FileDesc;
import kd.fi.aef.logic.model.FileUploadItem;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;

public class GXXmlUtils {
    private static final Log logger = LogFactory.getLog(GXXmlUtils.class);

    public static byte[] createBatchVoucherXml(DataSet xmlSet, Map<Object, FileDesc> billFileMap, Map<String, Object> otherData, Map<Long, List<Map<String, String>>> voucherentry) {
        Document document = DocumentHelper.createDocument();
        Element docinfo = document.addElement("docinfo");
        Element header = JDomB9Utils.addChildAndName(docinfo, "header");
        JDomB9Utils.addChildAndName(header, "doctype", (String)otherData.get("billType"));
        JDomB9Utils.addChildAndName(header, "creater", GXXmlUtils.getSysName());
        JDomB9Utils.addChildAndName(header, "time", GXXmlUtils.getTimeStr());
        JDomB9Utils.addChildAndName(header, "desc", (String)otherData.get("xmlDesc"));
        Element datalist = JDomB9Utils.addChildAndName(docinfo, "data");
        Map linkUpBills = (Map)otherData.get("linkUpBills");
        Map xbrlDescMap = (Map)otherData.get("xbrlDescMap");
        int i = 0;
        for (Row row : xmlSet) {
            Long id = row.getLong("vouchertoken");
            Map refBillMap = (Map)linkUpBills.get(id);
            Element data = JDomB9Utils.addChildAndName(datalist, "voucher");
            JDomB9Utils.addChildAndName(data, "id", ++i + "");
            JDomB9Utils.addChildAndName(data, "billid", "gl_voucher" + id.toString());
            JDomB9Utils.addChildAndName(data, "branchcode", row.getString("branchcode"));
            JDomB9Utils.addChildAndName(data, "voucherbr", row.getString("voucherbr"));
            JDomB9Utils.addChildAndName(data, "voucherper", GXXmlUtils.dealPeriodNumber(row.getString("periodnumber")));
            JDomB9Utils.addChildAndName(data, "voucherdate", DateUtil.getTimeStr(row.getDate("accountdate")).substring(0, 4));
            JDomB9Utils.addChildAndName(data, "accountdate", DateUtil.getTimeStr(row.getDate("accountdate")));
            JDomB9Utils.addChildAndName(data, "vouchernum", row.getString("vouchernum"));
            JDomB9Utils.addChildAndName(data, "vouchertype", row.getString("vouchertype"));
            JDomB9Utils.addChildAndName(data, "totalamount", row.getBigDecimal("debitlocamount").toString());
            JDomB9Utils.addChildAndName(data, "currency", row.getString("currency"));
            JDomB9Utils.addChildAndName(data, "vouchertoken", row.getString("vouchertoken"));
            String barcode = id.toString();
            if (StringUtils.isNotEmpty((CharSequence)row.getString("description")) && ("8".equals(row.getString("sourcetype")) || "ai".equals(row.getString("sourcesys")))) {
                barcode = row.getString("description");
            }
            JDomB9Utils.addChildAndName(data, "barcode", barcode);
            JDomB9Utils.addChildAndName(data, "approval", row.getString("approval") == null ? "null" : row.getString("approval"));
            JDomB9Utils.addChildAndName(data, "review");
            JDomB9Utils.addChildAndName(data, "posting", row.getDate("posting") == null ? "" : DateUtil.getTimeStr(row.getDate("posting")));
            JDomB9Utils.addChildAndName(data, "cashier");
            JDomB9Utils.addChildAndName(data, "touching", row.getString("touching"));
            JDomB9Utils.addChildAndName(data, "preparer");
            JDomB9Utils.addChildAndName(data, "documentattachednum", row.getString("documentattachednum"));
            JDomB9Utils.addChildAndName(data, "billcodes");
            JDomB9Utils.addChildAndName(data, "voucherdesc", row.getString("voucherdesc"));
            JDomB9Utils.addChildAndName(data, "isxbrl", "1");
            Element relationjelines = JDomB9Utils.addChildAndName(data, "relationjelines");
            GXXmlUtils.addChildAndNameForRefbills(relationjelines, "relationjeline", refBillMap, (Set)otherData.get("refBillTypes"));
            Element voucherjelines = JDomB9Utils.addChildAndName(data, "voucherjelines");
            List<Map<String, String>> voucherentryList = voucherentry.get(id);
            GXXmlUtils.addChildForEntry(voucherjelines, "voucherjeline", voucherentryList);
            Element xbrlfilelist = JDomB9Utils.addChildAndName(data, "xbrlfilelist");
            if (xbrlDescMap.size() > 0 && ((List)xbrlDescMap.get(id)).size() > 0) {
                List xbrls = (List)xbrlDescMap.get(id);
                GXXmlUtils.addChildAndNameForXbrls(xbrlfilelist, "xbrlfile", xbrls);
            }
            Element filelist = JDomB9Utils.addChildAndName(data, "filelist");
            Element file = JDomB9Utils.addChildAndName(filelist, "file");
            FileDesc fileDesc = billFileMap.get(id);
            JDomB9Utils.addChildAndName(file, "name", fileDesc.getName());
            JDomB9Utils.addChildAndName(file, "srcname", fileDesc.getName());
            JDomB9Utils.addChildAndName(file, "md5", fileDesc.getMd5());
            JDomB9Utils.addChildAndName(file, "ext", fileDesc.getExt());
            JDomB9Utils.addChildAndName(file, "filesize", fileDesc.getFilesize().toString());
            JDomB9Utils.addChildAndName(file, "isencryp", "0");
            Element splines = JDomB9Utils.addChildAndName(data, "splines");
            Element spline = JDomB9Utils.addChildAndName(splines, "spline");
            JDomB9Utils.addChildAndName(spline, "activityname", ResManager.loadKDString((String)"\u5f52\u6863", (String)"GXXmlUtils_0", (String)"fi-aef-common", (Object[])new Object[0]));
            JDomB9Utils.addChildAndName(spline, "content", ResManager.loadKDString((String)"\u5f52\u6863", (String)"GXXmlUtils_0", (String)"fi-aef-common", (Object[])new Object[0]));
            JDomB9Utils.addChildAndName(spline, "createtime", DateUtil.getDateString(new Date(), "yyyy-MM-dd HH:mm:ss"));
            JDomB9Utils.addChildAndName(spline, "useraccount", RequestContext.get().getUserId());
            JDomB9Utils.addChildAndName(spline, "username", RequestContext.get().getUserName());
            JDomB9Utils.addChildAndName(spline, "departcode");
            JDomB9Utils.addChildAndName(spline, "departname");
        }
        String archivekey = SysParamConfig.get("gxerparchivekey") == null ? "XinghanArch" : SysParamConfig.get("gxerparchivekey");
        JDomB9Utils.addChildAndName(header, "summary", MD5.digest(MD5.digest(datalist.asXML() + archivekey)));
        return GXXmlUtils.tobytes(document);
    }

    public static String getArchiveXmlString(FileUploadItem fileUploadItem) {
        String archivekey = SysParamConfig.get("gxerparchivekey") == null ? "XinghanArch" : SysParamConfig.get("gxerparchivekey");
        String date = DateUtil.getDateString(new Date(), "yyyyMMddHHmmss");
        Document document = DocumentHelper.createDocument();
        Element params = document.addElement("params");
        Element safety = JDomB9Utils.addChildAndName(params, "safety");
        JDomB9Utils.addChildAndName(safety, "clientcode", "XINGHAN");
        JDomB9Utils.addChildAndName(safety, "servicecode", "SIIT");
        JDomB9Utils.addChildAndName(safety, "time", date);
        JDomB9Utils.addChildAndName(safety, "ticket", MD5.digest(date + "XINGHAN" + archivekey));
        Element serverbody = JDomB9Utils.addChildAndName(params, "serverbody");
        JDomB9Utils.addChildAndName(serverbody, "servername", "tellCanParsing");
        Element services = JDomB9Utils.addChildAndName(serverbody, "services");
        Element service = JDomB9Utils.addChildAndName(services, "service");
        JDomB9Utils.addChildAndName(service, "serviceid");
        JDomB9Utils.addChildAndName(service, "filepath", fileUploadItem.getCustomString());
        JDomB9Utils.addChildAndName(service, "filename", "Info.xml");
        JDomB9Utils.addChildAndName(service, "filenumber", "1");
        JDomB9Utils.addChildAndName(service, "priority", "0");
        JDomB9Utils.addChildAndName(service, "doctype", fileUploadItem.getBillType());
        return document.asXML();
    }

    public static String getReveralXmlString(Map<String, Object> extMap) {
        String archivekey = SysParamConfig.get("gxerparchivekey") == null ? "XinghanArch" : SysParamConfig.get("gxerparchivekey");
        String date = DateUtil.getDateString(new Date(), "yyyyMMddHHmmss");
        Document document = DocumentHelper.createDocument();
        Element params = document.addElement("params");
        Element safety = JDomB9Utils.addChildAndName(params, "safety");
        JDomB9Utils.addChildAndName(safety, "clientcode", "XINGHAN");
        JDomB9Utils.addChildAndName(safety, "servicecode", "SIIT");
        JDomB9Utils.addChildAndName(safety, "time", date);
        JDomB9Utils.addChildAndName(safety, "ticket", MD5.digest(date + "XINGHAN" + archivekey));
        Element serverbody = JDomB9Utils.addChildAndName(params, "serverbody");
        JDomB9Utils.addChildAndName(serverbody, "servername", "sendReArchive");
        Element services = JDomB9Utils.addChildAndName(serverbody, "services");
        Element service = JDomB9Utils.addChildAndName(services, "service");
        JDomB9Utils.addChildAndName(service, "serviceid");
        JDomB9Utils.addChildAndName(service, "retype", (String)extMap.get("billtype"));
        JDomB9Utils.addChildAndName(service, "voucherper");
        JDomB9Utils.addChildAndName(service, "branchcode", (String)extMap.get("orgnumber"));
        JDomB9Utils.addChildAndName(service, "branchname", (String)extMap.get("orgname"));
        JDomB9Utils.addChildAndName(service, "opname", (String)extMap.get("name"));
        JDomB9Utils.addChildAndName(service, "opcode", (String)extMap.get("number"));
        JDomB9Utils.addChildAndName(service, "opreson", ResManager.loadKDString((String)"\u53cd\u5f52\u6863", (String)"GXXmlUtils_1", (String)"fi-aef-common", (Object[])new Object[0]));
        List billids = (List)extMap.get("billids");
        Element numbers = JDomB9Utils.addChildAndName(service, "numbers");
        for (Long billid : billids) {
            Element number = JDomB9Utils.addChildAndName(numbers, "number");
            JDomB9Utils.addChildAndName(number, "voucherid", Long.toString(billid));
        }
        return document.asXML();
    }

    private static String getSysName() {
        return ResManager.loadKDString((String)"\u82cd\u7a79", (String)"CreateXmlUtil_0", (String)"fi-aef-common", (Object[])new Object[0]);
    }

    private static String getTimeStr() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        return simpleDateFormat.format(date);
    }

    private static String dealPeriodNumber(String periodNumber) {
        if (!StringUtils.isEmpty((CharSequence)periodNumber) && periodNumber.length() >= 6) {
            periodNumber = periodNumber.substring(0, 4) + periodNumber.substring(4, 6);
        }
        return periodNumber;
    }

    private static void addChildAndNameForRefbills(Element relationjelines, String refbillNodeName, Map<String, Set<Long>> refBillMap, Set<String> refBillTypes) {
        if (refBillMap == null || refBillMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Set<Long>> entry : refBillMap.entrySet()) {
            if (refBillTypes == null || !refBillTypes.contains(entry.getKey())) continue;
            for (Long billid : entry.getValue()) {
                if (billid == 0L) continue;
                Element refbill = relationjelines.addElement(refbillNodeName);
                String billType = entry.getKey();
                JDomB9Utils.addChildAndName(refbill, "billid", Long.toString(billid));
                JDomB9Utils.addChildAndName(refbill, "billtype", billType);
            }
        }
    }

    private static void addChildAndNameForXbrls(Element xbrlfilelist, String xbrlfile, List<FileDesc> xbrls) {
        for (FileDesc fileDesc : xbrls) {
            Element xbrl = xbrlfilelist.addElement(xbrlfile);
            JDomB9Utils.addChildAndName(xbrl, "name", fileDesc.getName());
            JDomB9Utils.addChildAndName(xbrl, "srcname", fileDesc.getName());
            JDomB9Utils.addChildAndName(xbrl, "md5", fileDesc.getMd5());
            JDomB9Utils.addChildAndName(xbrl, "ext", fileDesc.getExt());
            JDomB9Utils.addChildAndName(xbrl, "filesize", fileDesc.getFilesize().toString());
            JDomB9Utils.addChildAndName(xbrl, "isencryp", "0");
        }
    }

    private static void addChildForEntry(Element voucherjelines, String voucherjeline, List<Map<String, String>> voucherentryList) {
        if (voucherentryList != null && voucherentryList.size() > 0) {
            for (int i = 0; i < voucherentryList.size(); ++i) {
                Map<String, String> entryMap = voucherentryList.get(i);
                Element entry = voucherjelines.addElement(voucherjeline);
                JDomB9Utils.addChildAndName(entry, "linenum", i + 1 + "");
                JDomB9Utils.addChildAndName(entry, "summary", entryMap.get("summary"));
                JDomB9Utils.addChildAndName(entry, "accountsubjects", entryMap.get("accountsubjects"));
                JDomB9Utils.addChildAndName(entry, "cur", entryMap.get("cur"));
                JDomB9Utils.addChildAndName(entry, "focur");
                JDomB9Utils.addChildAndName(entry, "attr1");
                JDomB9Utils.addChildAndName(entry, "debit", entryMap.get("debit"));
                JDomB9Utils.addChildAndName(entry, "credit", entryMap.get("credit"));
                JDomB9Utils.addChildAndName(entry, "zfial");
                JDomB9Utils.addChildAndName(entry, "debitorcredit", entryMap.get("debitorcredit"));
                JDomB9Utils.addChildAndName(entry, "ledgername", entryMap.get("ledgername"));
                JDomB9Utils.addChildAndName(entry, "detailname", entryMap.get("detailname"));
                JDomB9Utils.addChildAndName(entry, "recordedamount", entryMap.get("recordedamount"));
            }
        }
    }

    private static byte[] tobytes(Document document) {
        ByteArrayOutputStream byteOut = null;
        XMLWriter xmlWriter = null;
        try {
            byteOut = new ByteArrayOutputStream();
            xmlWriter = new XMLWriter((OutputStream)byteOut);
            xmlWriter.write(document);
            byte[] byArray = byteOut.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"Documen\u8f6c\u5316\u4e3abyte[]\u5931\u8d25\u3002", (String)"CreateXmlUtil_1", (String)"fi-aef-common", (Object[])new Object[0]));
        }
        finally {
            if (byteOut != null) {
                try {
                    byteOut.close();
                }
                catch (IOException e) {
                    LogUtil.printLog(logger, ResManager.loadKDString((String)"\u5173\u95ed\u6d41\u5931\u8d25", (String)"FPYXmlUtils_8", (String)"fi-aef-common", (Object[])new Object[0]));
                }
            }
            if (xmlWriter != null) {
                try {
                    xmlWriter.close();
                }
                catch (IOException e) {
                    LogUtil.printLog(logger, ResManager.loadKDString((String)"\u5173\u95ed\u6d41\u5931\u8d25", (String)"FPYXmlUtils_8", (String)"fi-aef-common", (Object[])new Object[0]));
                }
            }
        }
    }
}

