/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.common;

import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.aef.common.util.SysParamConfig;
import kd.fi.aef.logic.model.Attach;
import kd.fi.aef.logic.output.IDocumentServerHandler;
import kd.fi.aef.logic.proxy.DocumentServerProxy;

public class LogicUtils {
    private static IDocumentServerHandler getDocumentServer(String key) throws Exception {
        return DocumentServerProxy.getDocumentServer(key);
    }

    public static IDocumentServerHandler getDocumentServerByUploadWay(String uploadWay) throws Exception {
        IDocumentServerHandler documentServerHandler;
        if ("4".equals(uploadWay)) {
            DocumentServerProxy.registerThirdPlugin(RequestContext.get().getAccountId() + uploadWay, SysParamConfig.get("ext_handleimpl_path"));
        }
        if ((documentServerHandler = LogicUtils.getDocumentServer(uploadWay)) == null && (documentServerHandler = LogicUtils.getDocumentServer(RequestContext.get().getAccountId() + uploadWay)) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u6587\u6863\u5904\u7406\u5668\u83b7\u53d6\u5931\u8d25\u3002", (String)"LogicUtils_0", (String)"fi-aef-common", (Object[])new Object[0]));
        }
        return documentServerHandler;
    }

    public static String queryPrintId(String printSample, int printType) {
        if (printType == 1) {
            return MetadataDao.getIdByNumber((String)printSample, (MetaCategory)MetaCategory.Form);
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_print_meta", (String)"number, id", (QFilter[])new QFilter("number", "=", (Object)printSample).toArray());
        if (null != dynamicObject) {
            return dynamicObject.get("id").toString();
        }
        return "";
    }

    public static Set<?> getFilingIds(String billType, Set<?> ids) {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(3);
        qfilters.add(new QFilter("billtype", "=", (Object)billType));
        qfilters.add(new QFilter("billid", "in", ids));
        qfilters.add(new QFilter("filingstatus", "=", (Object)"1"));
        String algoKey = "kd.fi.aef.common.util.SingleArchiveUtil.getFilingIds";
        HashSet<Long> idSet = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"gl_filingdata", (String)"billid", (QFilter[])qfilters.toArray(new QFilter[0]), null);){
            for (Row row : dataSet) {
                Long id = row.getLong("billid");
                idSet.add(id);
            }
        }
        return idSet;
    }

    public static Map<String, Map<Object, List<String>>> getImageNumberMap(String billType, Set<Object> ids) {
        HashMap<String, Map<Object, List<String>>> map = new HashMap<String, Map<Object, List<String>>>(16);
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(16);
        qfilters.add(new QFilter("billtype", "=", (Object)billType));
        qfilters.add(new QFilter("billid", "in", ids.parallelStream().map(x -> String.valueOf(x)).collect(Collectors.toSet())));
        String algoKey = "kd.fi.aef.common.util.SingleArchiveUtil.getImageNumberMap";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"task_billimagemap", (String)"billid,billtype,imagenumber", (QFilter[])qfilters.toArray(new QFilter[0]), (String)"billid");){
            for (Row row : dataSet) {
                Long id = row.getLong("billid");
                String billtype = row.getString("billtype");
                Map imageNumberMap = map.computeIfAbsent(billtype, value -> new HashMap());
                List imageNumbers = imageNumberMap.computeIfAbsent(id, value -> new ArrayList());
                imageNumbers.add(row.getString("imagenumber"));
            }
        }
        return map;
    }

    public static Map<Long, List<Attach>> getIdAndAttacheFiles(String billType, Set<?> ids, String attachtabJson) {
        HashMap<Long, List<Attach>> map = new HashMap<Long, List<Attach>>();
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        if (StringUtils.isNotBlank((CharSequence)attachtabJson)) {
            Map attachtabmap = (Map)SerializationUtils.fromJsonString((String)attachtabJson, Map.class);
            qfilters.add(new QFilter("fattachmentpanel", "in", attachtabmap.keySet()));
        }
        qfilters.add(new QFilter("fbilltype", "=", (Object)billType));
        qfilters.add(new QFilter("finterid", "in", ids.parallelStream().map(x -> String.valueOf(x)).collect(Collectors.toSet())));
        String algoKey = "kd.fi.aef.common.util.SingleArchiveUtil.getIdAndAttaches";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bos_attachment", (String)"fextname,fbilltype,ffileid,finterid,fattachmentname", (QFilter[])qfilters.toArray(new QFilter[0]), (String)"finterid");){
            for (Row row : dataSet) {
                Long id = row.getLong("finterid");
                Attach attach = new Attach();
                attach.setBillId(row.getString("finterid"));
                attach.setBillType(billType);
                attach.setExtName(row.getString("fextname"));
                attach.setFileName(row.getString("fattachmentname"));
                attach.setUrl(row.getString("ffileid"));
                map.computeIfAbsent(id, value -> new ArrayList()).add(attach);
            }
        }
        return map;
    }

    public static String toBase64(byte[] bytes) {
        if (bytes != null && bytes.length > 0) {
            return Base64.getEncoder().encodeToString(bytes);
        }
        return "";
    }

    public static String getBillName(String billType) {
        String billName = "";
        billName = "aef_rpt".equals(billType) ? ResManager.loadKDString((String)"\u5408\u5e76\u62a5\u8868", (String)"LogicUtils_1", (String)"fi-aef-common", (Object[])new Object[0]) : EntityMetadataCache.getDataEntityType((String)billType).getDisplayName().toString();
        return billName;
    }

    public static String getFlag(String isReverse) {
        return "2".equals(isReverse) ? "delete" : "addnew";
    }

    public static Map<String, Object> getImgConfig(Map<String, Map<Object, List<String>>> imageNumberMap) {
        HashMap<String, Object> imageMap = new HashMap<String, Object>();
        QFilter imageFilter1 = new QFilter("number", "=", (Object)"FPY");
        DynamicObject imagedyo = BusinessDataServiceHelper.loadSingleFromCache((String)"bas_imageconfig", (String)"number,imagesystermip,imageport,enable", (QFilter[])new QFilter[]{imageFilter1});
        QFilter voiceFilter2 = new QFilter("client_id", "!=", (Object)"");
        if (QueryServiceHelper.exists((String)"er_bd_kdinvoicecloudcfg", (QFilter[])voiceFilter2.toArray()) || QueryServiceHelper.exists((String)"er_bd_kdinvoicecloudcfgct", (QFilter[])voiceFilter2.toArray())) {
            imageMap.put("enable", "A");
        }
        if (imagedyo != null) {
            imageMap.put("numbermap", imageNumberMap);
            imageMap.put("imagesystype", imagedyo.getString("number"));
            imageMap.put("imagesysip", imagedyo.getString("imagesystermip"));
            imageMap.put("imagesysport", imagedyo.getString("imageport"));
        }
        return imageMap;
    }
}

