/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.common;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.util.SysParamConfig;

public class ReversalUtils {
    private static final Log logger = LogFactory.getLog(ReversalUtils.class);

    public static void updateRecordToReserve(String className, Set<Long> ids, String billType, String reverseReason, String batchCode, String tablename) {
        try (TXHandle tx = TX.requiresNew((String)className);){
            boolean b = SysParamConfig.getBoolean("needwritebackstatus", false);
            try {
                DynamicObject[] records;
                for (DynamicObject record : records = BusinessDataServiceHelper.load((String)tablename, (String)"reason,filingid,fexetime,type,batchcode,status", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)billType), new QFilter("billid", "in", ids)})) {
                    record.set("reason", (Object)reverseReason);
                    record.set("type", (Object)Character.valueOf('2'));
                    record.set("filingid_id", (Object)UserServiceHelper.getCurrentUserId());
                    record.set("fexetime", (Object)new Date());
                    record.set("batchcode", (Object)batchCode);
                    if (!b) continue;
                    record.set("status", (Object)"2");
                }
                SaveServiceHelper.save((DynamicObject[])records);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", (String)"AbstractArchiveLogicUnit_13", (String)"fi-aef-common", (Object[])new Object[0]), className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }

    public static void deleteInvoice(Map<String, Set<DynamicObject>> vatInvoiceMap, Set<Long> buildXbrlVoucherIds) {
        if (vatInvoiceMap.size() > 0) {
            for (Map.Entry<String, Set<DynamicObject>> entry : vatInvoiceMap.entrySet()) {
                String billType = entry.getKey();
                Set<DynamicObject> dynamicObjects = entry.getValue();
                if (dynamicObjects == null || dynamicObjects.size() <= 0) continue;
                HashSet<Long> idSet = new HashSet<Long>(buildXbrlVoucherIds.size());
                QFilter idFilter = new QFilter("directvoucherid", "in", buildXbrlVoucherIds);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AbstractArchiveLogicUnit.deleteInvoice", (String)billType, (String)"id", (QFilter[])idFilter.toArray(), null);){
                    for (Row row : dataSet) {
                        idSet.add(row.getLong("id"));
                    }
                }
                OperationServiceHelper.executeOperate((String)"delete", (String)billType, (Object[])idSet.toArray(), (OperateOption)OperateOption.create());
            }
        }
    }

    public static void updateRptrecords(String className, List<DynamicObject> dynamicObjects, List<String> uniqueKeys, String reason) {
        try (TXHandle tx = TX.requiresNew((String)className);){
            try {
                DynamicObject[] records;
                for (DynamicObject record : records = BusinessDataServiceHelper.load((String)"aef_acelre_rpt", (String)"reason,filingid,fexetime,type", (QFilter[])new QFilter[]{new QFilter("uniquekey", "in", uniqueKeys)})) {
                    record.set("reason", (Object)reason);
                    record.set("type", (Object)Character.valueOf('2'));
                    record.set("filingid_id", (Object)UserServiceHelper.getCurrentUserId());
                    record.set("fexetime", (Object)new Date());
                }
                SaveServiceHelper.save((DynamicObject[])records);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", (String)"AbstractArchiveLogicUnit_13", (String)"fi-aef-common", (Object[])new Object[0]), className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }

    public static void updateRptRecordToReserve(String className, List<String> uniqueKeys, String billType, String reverseReason, String batchcode) {
        try (TXHandle tx = TX.requiresNew((String)className);){
            boolean b = SysParamConfig.getBoolean("needwritebackstatus", false);
            try {
                DynamicObject[] records;
                for (DynamicObject record : records = BusinessDataServiceHelper.load((String)"aef_acelre", (String)"reason,filingid,fexetime,type,batchcode,status", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)billType), new QFilter("uniquekey", "in", uniqueKeys)})) {
                    record.set("reason", (Object)reverseReason);
                    record.set("type", (Object)Character.valueOf('2'));
                    record.set("filingid_id", (Object)UserServiceHelper.getCurrentUserId());
                    record.set("fexetime", (Object)new Date());
                    record.set("batchcode", (Object)batchcode);
                    if (!b) continue;
                    record.set("status", (Object)"2");
                }
                SaveServiceHelper.save((DynamicObject[])records);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", (String)"AbstractArchiveLogicUnit_13", (String)"fi-aef-common", (Object[])new Object[0]), className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }
}

