/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.util.SysParamConfig;

public class SaveArchiveUtils {
    private static final Log logger = LogFactory.getLog(SaveArchiveUtils.class);

    public static void saveDynamicObjects(String className, List<DynamicObject> dynamicObjects, String billName, Set<Long> ids, String billType, String tablename) {
        try (TXHandle tx = TX.requiresNew((String)className);){
            try {
                boolean b = SysParamConfig.getBoolean("needwritebackstatus", false);
                if (tablename.equals("aef_acelre_tax")) {
                    DynamicObject[] records = BusinessDataServiceHelper.load((String)tablename, (String)"wayid,reason,filingid,fexetime,type,billid,batchcode,group,billno,status", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)billType), new QFilter("billid", "in", ids)});
                    ArrayList<Long> billids = new ArrayList<Long>(16);
                    if (records.length > 0) {
                        for (DynamicObject record : records) {
                            Long billid = record.getLong("billid");
                            List dyns = dynamicObjects.stream().filter(dynamicObject -> dynamicObject.getLong("billid") == billid.longValue()).collect(Collectors.toList());
                            record.set("reason", (Object)"");
                            record.set("type", (Object)Character.valueOf('1'));
                            record.set("wayid", (Object)(dyns != null && dyns.size() > 0 ? ((DynamicObject)dyns.get(0)).getLong("wayid") : ((DynamicObject)dynamicObjects.get(0)).getLong("wayid")));
                            record.set("batchcode", (Object)(dyns != null && dyns.size() > 0 ? ((DynamicObject)dyns.get(0)).getString("batchcode") : ((DynamicObject)dynamicObjects.get(0)).getString("batchcode")));
                            record.set("filingid", (Object)UserServiceHelper.getCurrentUserId());
                            record.set("fexetime", (Object)new Date());
                            record.set("group", (Object)(dyns != null && dyns.size() > 0 ? ((DynamicObject)dyns.get(0)).getLong("group") : ((DynamicObject)dynamicObjects.get(0)).getLong("group")));
                            if (dyns != null && dyns.size() > 0) {
                                record.set("billno", (Object)((DynamicObject)dyns.get(0)).getString("billno"));
                            }
                            if (b) {
                                record.set("status", (Object)"2");
                            }
                            billids.add(billid);
                        }
                        SaveServiceHelper.save((DynamicObject[])records);
                    }
                    if ((dynamicObjects = dynamicObjects.stream().filter(DynamicObject2 -> !billids.contains(DynamicObject2.getLong("billid"))).collect(Collectors.toList())).size() > 0) {
                        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
                    }
                } else {
                    DynamicObject[] records = BusinessDataServiceHelper.load((String)tablename, (String)"wayid,reason,filingid,fexetime,type,billid,batchcode,booktype,billno,status", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)billType), new QFilter("billid", "in", ids)});
                    ArrayList<Long> billids = new ArrayList<Long>(16);
                    if (records.length > 0) {
                        for (DynamicObject record : records) {
                            Long billid = record.getLong("billid");
                            List dyns = dynamicObjects.stream().filter(dynamicObject -> dynamicObject.getLong("billid") == billid.longValue()).collect(Collectors.toList());
                            record.set("reason", (Object)"");
                            record.set("booktype", (Object)(dyns != null && dyns.size() > 0 ? ((DynamicObject)dyns.get(0)).getLong("booktype") : ((DynamicObject)dynamicObjects.get(0)).getLong("booktype")));
                            record.set("type", (Object)Character.valueOf('1'));
                            record.set("wayid_id", (Object)(dyns != null && dyns.size() > 0 ? ((DynamicObject)dyns.get(0)).getLong("wayid") : ((DynamicObject)dynamicObjects.get(0)).getLong("wayid")));
                            record.set("batchcode", (Object)(dyns != null && dyns.size() > 0 ? ((DynamicObject)dyns.get(0)).getString("batchcode") : ((DynamicObject)dynamicObjects.get(0)).getString("batchcode")));
                            record.set("filingid_id", (Object)UserServiceHelper.getCurrentUserId());
                            record.set("fexetime", (Object)new Date());
                            if (dyns != null && dyns.size() > 0) {
                                record.set("billno", (Object)((DynamicObject)dyns.get(0)).getString("billno"));
                            }
                            if (b) {
                                record.set("status", (Object)"2");
                            }
                            billids.add(record.getLong("billid"));
                        }
                        SaveServiceHelper.save((DynamicObject[])records);
                    }
                    if ((dynamicObjects = dynamicObjects.stream().filter(DynamicObject2 -> !billids.contains(DynamicObject2.getLong("billid"))).collect(Collectors.toList())).size() > 0) {
                        SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
                    }
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%3$s}\u3002", className, billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%3$s}\u3002", (String)"AbstractArchiveLogicUnit_9", (String)"fi-aef-common", (Object[])new Object[0]), className, billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }

    public static void updateRecordToReserve(String className, Set<Long> ids, String billType, String reverseReason, String batchCode) {
        try (TXHandle tx = TX.requiresNew((String)className);){
            try {
                DynamicObject[] records;
                for (DynamicObject record : records = BusinessDataServiceHelper.load((String)"aef_acelre", (String)"reason,filingid,fexetime,type,batchcode", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)billType), new QFilter("billid", "in", ids)})) {
                    record.set("reason", (Object)reverseReason);
                    record.set("type", (Object)Character.valueOf('2'));
                    record.set("filingid_id", (Object)UserServiceHelper.getCurrentUserId());
                    record.set("fexetime", (Object)new Date());
                    record.set("batchcode", (Object)batchCode);
                }
                SaveServiceHelper.save((DynamicObject[])records);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25{%3$s}", (String)"AbstractArchiveLogicUnit_13", (String)"fi-aef-common", (Object[])new Object[0]), className, null, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }

    public static DynamicObject getBillPathDynamicObject(String url, String billType, int imageType, Object billId, Long userId, String filename, Date date) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"aef_archieve_imagepath");
        DynamicObject temp = (DynamicObject)type.createInstance();
        temp.set("billid", billId);
        temp.set("imagetype", (Object)imageType);
        temp.set("imagepath", (Object)url);
        temp.set("billtype", (Object)billType);
        temp.set("filename", (Object)filename);
        temp.set("archievetime", (Object)date);
        temp.set("archieveid", (Object)userId);
        return temp;
    }

    public static void saveInvoice(Map<String, Set<DynamicObject>> vatInvoiceMap) {
        if (vatInvoiceMap.size() > 0) {
            for (Map.Entry<String, Set<DynamicObject>> entry : vatInvoiceMap.entrySet()) {
                Set<DynamicObject> dynamicObjects = entry.getValue();
                if (dynamicObjects == null || dynamicObjects.size() <= 0) continue;
                SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
            }
        }
    }

    public static void deleteInvoice(Map<String, Set<DynamicObject>> vatInvoiceMap, Set<Long> buildXbrlVoucherIds) {
        if (vatInvoiceMap.size() > 0) {
            for (Map.Entry<String, Set<DynamicObject>> entry : vatInvoiceMap.entrySet()) {
                String billType = entry.getKey();
                Set<DynamicObject> dynamicObjects = entry.getValue();
                if (dynamicObjects == null || dynamicObjects.size() <= 0) continue;
                HashSet<Long> idSet = new HashSet<Long>(buildXbrlVoucherIds.size());
                QFilter idFilter = new QFilter("directvoucherid", "in", buildXbrlVoucherIds);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AbstractArchiveLogicUnit.deleteInvoice", (String)billType, (String)"id", (QFilter[])idFilter.toArray(), null);){
                    for (Row row : dataSet) {
                        idSet.add(row.getLong("id"));
                    }
                }
                OperationServiceHelper.executeOperate((String)"delete", (String)billType, (Object[])idSet.toArray(), (OperateOption)OperateOption.create());
            }
        }
    }

    public static void batchSaveSubObjects(String className, List<DynamicObject> dynamicObjects, String billType, String billName, List<String> uniqueKeys) {
        try (TXHandle tx = TX.requiresNew((String)className);){
            try {
                ArrayList<String> hasArchiveuniquekeys = new ArrayList<String>(2);
                boolean b = SysParamConfig.getBoolean("needwritebackstatus", false);
                DynamicObject[] records = BusinessDataServiceHelper.load((String)"aef_acelre", (String)"wayid,reason,filingid,fexetime,type,status,uniquekey", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)billType), new QFilter("uniquekey", "in", uniqueKeys)});
                if (records.length > 0) {
                    for (DynamicObject record : records) {
                        record.set("reason", (Object)"");
                        record.set("type", (Object)Character.valueOf('1'));
                        record.set("wayid_id", (Object)dynamicObjects.get(0).getLong("wayid"));
                        record.set("filingid_id", (Object)UserServiceHelper.getCurrentUserId());
                        record.set("fexetime", (Object)new Date());
                        if (b) {
                            record.set("status", (Object)"2");
                        }
                        hasArchiveuniquekeys.add(record.getString("uniquekey"));
                    }
                    SaveServiceHelper.save((DynamicObject[])records);
                }
                ArrayList<DynamicObject> saveDyns = new ArrayList<DynamicObject>(2);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    if (hasArchiveuniquekeys.contains(dynamicObject.getString("uniquekey"))) continue;
                    saveDyns.add(dynamicObject);
                }
                SaveServiceHelper.save((DynamicObject[])saveDyns.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%3$s}\u3002", className, billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%3$s}\u3002", (String)"AbstractArchiveLogicUnit_9", (String)"fi-aef-common", (Object[])new Object[0]), className, billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }

    public static void batchSaveReportObjects(String className, List<DynamicObject> dynamicObjects, String billType, String billName, List<String> uniqueKeys) {
        try (TXHandle tx = TX.requiresNew((String)className);){
            try {
                boolean b = SysParamConfig.getBoolean("needwritebackstatus", false);
                DynamicObject[] records = BusinessDataServiceHelper.load((String)"aef_acelre", (String)"wayid,reason,filingid,fexetime,type,status", (QFilter[])new QFilter[]{new QFilter("billtype", "=", (Object)billType), new QFilter("uniquekey", "in", uniqueKeys)});
                if (records.length > 0) {
                    for (DynamicObject record : records) {
                        record.set("reason", (Object)"");
                        record.set("type", (Object)Character.valueOf('1'));
                        record.set("wayid_id", (Object)dynamicObjects.get(0).getLong("wayid"));
                        record.set("filingid_id", (Object)UserServiceHelper.getCurrentUserId());
                        record.set("fexetime", (Object)new Date());
                        if (!b) continue;
                        record.set("status", (Object)"2");
                    }
                    SaveServiceHelper.save((DynamicObject[])records);
                } else {
                    SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%3$s}\u3002", className, billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"[%1$s]%2$s\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%3$s}\u3002", (String)"AbstractArchiveLogicUnit_9", (String)"fi-aef-common", (Object[])new Object[0]), className, billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
    }
}

