/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.datainput.impl;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.ArchiveContext;
import kd.fi.aef.common.util.AefUtil;
import kd.fi.aef.common.util.ArchiveUtil;
import kd.fi.aef.common.util.ContextUtil;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.common.util.ElecreceiptUtils;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.FpyOperateUtil;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.common.util.SysParamConfig;
import kd.fi.aef.elec.util.ElecConfigUtil;
import kd.fi.aef.elec.util.XbrlArchieveUtil;
import kd.fi.aef.entity.BillInfo;
import kd.fi.aef.entity.FileDesc;
import kd.fi.aef.entity.PrintIdandType;
import kd.fi.aef.entity.PrintTemplate;
import kd.fi.aef.entity.Printsample;
import kd.fi.aef.entity.Task;
import kd.fi.aef.helper.ArchiveSchemeHelper;
import kd.fi.aef.helper.QueryFinanceBillHelper;
import kd.fi.aef.logic.AbstractArchiveLogicUnit;
import kd.fi.aef.logic.ContextData;
import kd.fi.aef.logic.common.LogicUtils;
import kd.fi.aef.logic.datainput.DataProvider;
import kd.fi.aef.logic.enums.DescriptType;
import kd.fi.aef.logic.model.Attach;
import kd.fi.aef.logic.model.FileUploadItem;
import kd.fi.aef.logic.output.IDocumentServerHandler;
import kd.fi.aef.logic.unit.ArchiveVoucherLogicUnit;

public class DefaultVoucherDataProvider
extends DataProvider {
    private static final String SELECT_FIELDS = "id,billno,org.id org,org.number orgnumber,org.name orgname,period.id period,period.number periodnumber,period.name periodname,attachment,vouchertype.name vouchertypename,localcur.number localcurnumber,vdescription,booktype.id booktypeid,booktype.number booktypenumber,booktype.name booktypename,creator.name creatorname,auditor.name auditorname,debitlocamount,creditlocamount,bookeddate accountdate,posttime posting_date";
    private static final Log logger = LogFactory.getLog(DefaultVoucherDataProvider.class);
    private static final String CLASS_NAME = "DefaultVoucherDataProvider";
    private static final String SEQNO = "seqNo";
    private static final String INFORMATIONOFACCOUNTINGDOCUMENTSTUPLE = "InformationOfAccountingDocumentsTuple";
    private Set<Long> ids;
    private String period;
    private String periodname;
    private String accountBookNo;
    private String accountBookName;
    private String billType;
    protected String billName;
    private FileUploadItem fileUploadItem;
    private String pageId;
    private String isReverse;
    private boolean isxbrlpilot;
    Set<String> refBillTypes = new HashSet<String>();
    private Map<Long, Map<String, Set<Long>>> linkUpBills;
    private Map<Long, Set<String>> voucherInvoiceMap = new HashMap<Long, Set<String>>(16);
    private Map<String, Map<Long, List<String>>> imageNumberMap = new HashMap<String, Map<Long, List<String>>>();
    private Map<String, Object> imageMap = new HashMap<String, Object>();
    private Map<Long, List<Attach>> xbrlFileMap = new HashMap<Long, List<Attach>>(16);
    private Map<Long, List<FileDesc>> xbrlDescMap = new HashMap<Long, List<FileDesc>>(16);
    private Map<Long, List<Attach>> refAttachMap = new HashMap<Long, List<Attach>>(16);
    private Map<String, Set<String>> VATBillTypes = new HashMap<String, Set<String>>(16);
    private Set<String> isreceiptSet = new HashSet<String>(16);
    Map<String, Set<Long>> isreceiptBilltypeAndIds = new HashMap<String, Set<Long>>();
    private Map<String, String> refBillTempInfo = new HashMap<String, String>(16);
    private Map<String, Printsample> refBillAllInfo = new HashMap<String, Printsample>(16);
    Map<String, Set<Long>> refBilltypeAndIds = new HashMap<String, Set<Long>>(16);
    Map<String, Map<Long, Set<Long>>> billAndRefvoucherIds = new HashMap<String, Map<Long, Set<Long>>>(16);
    private Map<Long, BillInfo> voucherInfoMap = new HashMap<Long, BillInfo>(16);
    private Map<Long, JSONObject> voucherHeadJson = new HashMap<Long, JSONObject>(16);
    private Map<Long, JSONObject> voucherJson = new HashMap<Long, JSONObject>(16);
    private Map<String, Set<DynamicObject>> vatInvoiceMap = new HashMap<String, Set<DynamicObject>>(16);
    private List<DynamicObject> errDyns = new ArrayList<DynamicObject>(16);
    private AbstractArchiveLogicUnit archiveLogicUnit;
    private ArchiveContext context;
    private IDocumentServerHandler documentServerHandler;
    private ContextData contextData;

    @Override
    public void initProvider(ArchiveContext archiveContext, ContextData cond, ArchiveVoucherLogicUnit archiveVoucherLogicUnit, IDocumentServerHandler handler) {
        this.archiveLogicUnit = archiveVoucherLogicUnit;
        this.context = archiveContext;
        this.contextData = cond;
        this.documentServerHandler = handler;
        this.isReverse = this.context.getIsReverse();
        if ("2".equals(this.isReverse)) {
            this.context.setPageId(Task.createTaskId());
        }
        this.isxbrlpilot = this.context.getIsxbrlpilot();
        this.pageId = this.context.getPageId();
        this.billType = this.context.getBillType();
        this.ids = this.context.getIds();
        QFilter idFilter = new QFilter("id", "=", (Object)this.ids.iterator().next());
        DynamicObject dyn = QueryServiceHelper.queryOne((String)this.billType, (String)SELECT_FIELDS, (QFilter[])new QFilter[]{idFilter});
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)this.billType, (String)SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", this.ids)});
        dyns.forEach(one -> {
            Long billId = one.getLong("id");
            String billNo = one.getString("billno");
            BillInfo voucherInfo = new BillInfo();
            voucherInfo.setBillId(billId);
            voucherInfo.setBillNo(billNo);
            voucherInfo.setFieldMap(Collections.singletonMap("vouchertypename", one.getString("vouchertypename")));
            this.voucherInfoMap.put(billId, voucherInfo);
        });
        this.billName = EntityMetadataCache.getDataEntityType((String)this.billType).getDisplayName().toString();
        this.accountBookNo = dyn.getString("orgnumber");
        this.accountBookName = dyn.getString("orgname");
        if (this.context.isSplitBook() && this.context.isAws()) {
            this.accountBookNo = this.accountBookNo + dyn.getString("booktypenumber");
            this.accountBookName = this.accountBookName + dyn.getString("booktypename");
        }
        String institutionIssuesNo = "gl_" + dyn.getString("booktypenumber");
        String institutionIssuesName = dyn.getString("booktypename");
        this.period = DateUtil.format(DateUtil.stringToDate(dyn.getString("periodnumber"), "yyyyMM"), "yyyy-MM");
        this.periodname = dyn.getString("periodname");
        this.fileUploadItem = new FileUploadItem(this.context.getArchivesCode(), this.accountBookNo, this.accountBookName, this.period, this.context.getBatchcode(), 1, null, null, institutionIssuesNo, institutionIssuesName);
        this.VATBillTypes = ElecConfigUtil.getVATBillTypes();
        this.isreceiptSet = ElecConfigUtil.ALL_REC_BILL;
        this.refBillTempInfo = this.context.getRefBillTempInfo();
        this.refBillAllInfo = this.context.getRefBillAllInfo();
        this.linkUpBills = AefUtil.getLinkUpBills(this.context.getIds());
        if (this.refBillTempInfo != null && !this.refBillTempInfo.isEmpty()) {
            this.refBillTypes = this.refBillTempInfo.keySet();
        }
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u51ed\u8bc1\u914d\u7f6e\u7684\u7684\u5173\u8054\u5355\u636e\u6709:{}", (String)"DefaultVoucherDataProvider_0", (String)"fi-aef-common", (Object[])new Object[0]), String.join((CharSequence)",", this.refBillTypes));
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\u51ed\u8bc1\u7684\u6240\u6709\u4e0a\u4e0b\u6e38\u5355\u636e\u6709:{}", (String)"DefaultVoucherDataProvider_1", (String)"fi-aef-common", (Object[])new Object[0]), this.linkUpBills);
        this.isreceiptBilltypeAndIds = ArchiveUtil.getRefBilltypeAndIds(this.linkUpBills, this.isreceiptSet);
        this.refBilltypeAndIds = ArchiveUtil.getRefBilltypeAndIds(this.linkUpBills, this.refBillTypes);
        this.billAndRefvoucherIds = ArchiveUtil.getBillAndRefvoucherIds(this.refBillTypes, this.linkUpBills);
        this.contextData.getVoucherOutputData().setFileUploadItem(this.fileUploadItem);
        this.contextData.getOtherData().put("isreceiptBilltypeAndIds", this.isreceiptBilltypeAndIds);
    }

    @Override
    public void endProvider(ArchiveContext context, ContextData contextData) {
        if (this.errDyns.size() > 0) {
            LogUtil.saveErrorLog(this.errDyns);
        }
        if (context.getNeedArchiveIds().size() == 0) {
            context.setNeedArchiveIds(new HashSet<Long>());
            return;
        }
        contextData.setOtherData(new HashMap<String, Object>());
        contextData.getOtherData().put("errDyns", this.errDyns);
        String xmlDesc = String.format(ResManager.loadKDString((String)"%s\u8fc7\u8d26\u51ed\u8bc1", (String)"DefaultVoucherDataProvider_2", (String)"fi-aef-common", (Object[])new Object[0]), this.accountBookName + this.periodname);
        String desc = context.getBillType() + "_" + this.accountBookNo + "_" + this.period + "_" + context.getBatchcode() + ".xml";
        contextData.getOtherData().put("desc", desc);
        contextData.getOtherData().put("xmlDesc", xmlDesc);
        contextData.getOtherData().put("isxbrl", context.getIsxbrlpilot());
        contextData.getOtherData().put("xbrlFileMap", this.xbrlFileMap);
        contextData.getOtherData().put("xbrlDescMap", this.xbrlDescMap);
        contextData.getOtherData().put("linkUpBills", this.linkUpBills);
        contextData.getOtherData().put("refBillTypes", this.refBillTypes);
        contextData.getOtherData().put("refBilltypeAndIds", this.refBilltypeAndIds);
        contextData.getOtherData().put("billAndRefvoucherIds", this.billAndRefvoucherIds);
        contextData.getOtherData().put("flag", LogicUtils.getFlag(context.getIsReverse()));
        contextData.getOtherData().put("voucherInvoiceMap", this.voucherInvoiceMap);
        contextData.getOtherData().put("refBillAllInfo", this.refBillAllInfo);
        contextData.getOtherData().put("vatInvoiceMap", this.vatInvoiceMap);
    }

    @Override
    public void archiveReferenceBills(ArchiveContext context) {
        HashMap<String, Set> errRefBills = new HashMap<String, Set>(16);
        Map<String, List<BillInfo>> linkUpBillInfos = this.getLinkUpBillInfos(this.refBilltypeAndIds);
        if ("1".equals(this.isReverse)) {
            for (Map.Entry<String, List<BillInfo>> linkUpBillInfo : linkUpBillInfos.entrySet()) {
                String billtype = linkUpBillInfo.getKey();
                List<BillInfo> list = linkUpBillInfo.getValue();
                String isNeedRefAttachFile = this.refBillAllInfo.get(billtype) == null ? "0" : this.refBillAllInfo.get(billtype).getIsNeedRefAttachFile();
                Map<Object, Object> billAttachMap = new HashMap();
                if ("1".equals(isNeedRefAttachFile)) {
                    billAttachMap = this.getIdAndAttacheFiles(billtype, this.refBilltypeAndIds.get(billtype), null);
                }
                Map<String, Map<Long, List<String>>> imageMap = SingleArchiveUtil.getImageNumberMap(billtype, this.refBilltypeAndIds.get(billtype));
                this.imageNumberMap.putAll(imageMap);
                String refPrintNumber = this.refBillTempInfo.get(billtype);
                PrintIdandType oldPrintIdandType = null;
                Map<Object, Object> refPrintIdAndTypeMap = new HashMap(16);
                if (StringUtils.isNotBlank((CharSequence)refPrintNumber)) {
                    String refPrintId = MetadataDao.getIdByNumber((String)refPrintNumber, (MetaCategory)MetaCategory.Form);
                    oldPrintIdandType = new PrintIdandType();
                    if (StringUtils.isNotBlank((CharSequence)refPrintId)) {
                        oldPrintIdandType.setPrintId(refPrintId);
                        oldPrintIdandType.setPrintType(1);
                    } else {
                        refPrintId = ArchiveSchemeHelper.queryPrintId(refPrintNumber, 2);
                        oldPrintIdandType.setPrintId(refPrintId);
                        oldPrintIdandType.setPrintType(2);
                    }
                } else {
                    Printsample printsample = this.refBillAllInfo.get(billtype);
                    List<PrintTemplate> refPrintTemplates = SerializationUtils.fromJsonStringToList((String)printsample.getPrintTemplateJson(), PrintTemplate.class);
                    refPrintTemplates = ArchiveSchemeHelper.getTemplateStatusMap(refPrintTemplates);
                    HashSet<Long> refBillIds = new HashSet<Long>(16);
                    for (BillInfo billInfo : list) {
                        refBillIds.add(Long.parseLong(billInfo.getBillId().toString()));
                    }
                    refPrintIdAndTypeMap = ArchiveSchemeHelper.getBillIdAndPrintId(refPrintTemplates, billtype, refBillIds);
                }
                for (BillInfo billInfo : list) {
                    String string;
                    Long vId;
                    Object errVids;
                    String pdfUrl = null;
                    ArrayList<Object> pks = new ArrayList<Object>(2);
                    pks.add(billInfo.getBillId());
                    try {
                        if (oldPrintIdandType != null) {
                            pdfUrl = FileUtils.getPrintUrl(this.pageId, billtype, oldPrintIdandType.getPrintId(), pks, "billForm", oldPrintIdandType.getPrintType());
                        } else if (StringUtils.isNotBlank((Object)refPrintIdAndTypeMap.get(billInfo.getBillId()))) {
                            PrintIdandType refPrintIdandType = (PrintIdandType)refPrintIdAndTypeMap.get(billInfo.getBillId());
                            pdfUrl = FileUtils.getPrintUrl(this.pageId, billtype, refPrintIdandType.getPrintId(), pks, "billForm", refPrintIdandType.getPrintType());
                        } else {
                            Set<Long> errVids2 = this.billAndRefvoucherIds.get(billtype).get(billInfo.getBillId());
                            for (Long l : errVids2) {
                                context.getNeedArchiveIds().remove(l);
                                String string2 = String.format(ResManager.loadKDString((String)"%1$s\uff0c%2$s\uff0c\u5173\u8054\u5355\u636e : %3$s \u627e\u4e0d\u5230\u9002\u7528\u7684\u6253\u5370\u6a21\u677f\u3002", (String)"DefaultVoucherDataProvider_7", (String)"fi-aef-common", (Object[])new Object[0]), this.billType, billInfo.getBillId(), billInfo.getBillNo());
                                this.errDyns.add(LogUtil.generateArchiveErrorLog(billtype, l, context.getSchemeId(), this.isReverse, TraceIdUtil.getCurrentTraceIdString(), string2));
                            }
                            errRefBills.computeIfAbsent(billtype, value -> new HashSet()).add(billInfo.getBillId());
                            continue;
                        }
                        this.fileUploadItem.setBusinessType(3);
                        this.fileUploadItem.setFileName(billtype + "_" + billInfo.getBillId() + ".pdf");
                        this.archiveLogicUnit.setPrintFileRelatedInfo(this.fileUploadItem, pdfUrl, null);
                        this.archiveLogicUnit.uploadFile(this.fileUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                    }
                    catch (Exception e) {
                        errVids = this.billAndRefvoucherIds.get(billtype).get(billInfo.getBillId());
                        Iterator<Long> iterator = errVids.iterator();
                        while (iterator.hasNext()) {
                            vId = iterator.next();
                            logger.error("archiveReferenceBills :", (Throwable)e);
                            context.getNeedArchiveIds().remove(vId);
                            string = String.format(ResManager.loadKDString((String)"\u6a21\u677f\u53c2\u6570[formId\uff1a%1$s\uff0cpkIds\uff1a%2$s],\u5f02\u5e38 {%3$s}", (String)"DefaultVoucherDataProvider_8", (String)"fi-aef-common", (Object[])new Object[0]), billtype, pks, e);
                            this.errDyns.add(LogUtil.generateArchiveErrorLog(billtype, vId, context.getSchemeId(), this.isReverse, TraceIdUtil.getCurrentTraceIdString(), string));
                        }
                        errRefBills.computeIfAbsent(billtype, value -> new HashSet()).add(billInfo.getBillId());
                        continue;
                    }
                    if (!"1".equals(isNeedRefAttachFile)) continue;
                    try {
                        List billAttaches = (List)billAttachMap.get(billInfo.getBillId());
                        if (billAttaches == null || billAttaches.size() <= 0) continue;
                        this.refAttachMap.put(Long.valueOf(billInfo.getBillId().toString()), billAttaches);
                        for (Attach attach : billAttaches) {
                            String url = attach.getUrl();
                            LogUtil.printLog(logger, ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e{}:{},\u9644\u4ef6url:{}", (String)"DefaultVoucherDataProvider_5", (String)"fi-aef-common", (Object[])new Object[0]), billtype, billInfo.getBillId(), url);
                            this.fileUploadItem.setFileName(billInfo.getBillId() + "_" + attach.getFileName());
                            this.fileUploadItem.setBusinessType(4);
                            this.fileUploadItem.setFilePath(url);
                            this.archiveLogicUnit.setAttachmentsRelatedInfo(this.fileUploadItem, url, null);
                            this.archiveLogicUnit.uploadFile(this.fileUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                        }
                    }
                    catch (Exception e) {
                        errVids = this.billAndRefvoucherIds.get(billtype).get(billInfo.getBillId());
                        Iterator<Long> iterator = errVids.iterator();
                        while (iterator.hasNext()) {
                            vId = iterator.next();
                            context.getNeedArchiveIds().remove(vId);
                            string = String.format(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e\uff1a%1$s\uff0c%2$s \u9644\u4ef6\u4e0a\u4f20\u5931\u8d25,\u5f02\u5e38 {%3$s}", (String)"DefaultVoucherDataProvider_4", (String)"fi-aef-common", (Object[])new Object[0]), billtype, billInfo.getBillId(), e.getMessage());
                            this.errDyns.add(LogUtil.generateArchiveErrorLog(billtype, vId, context.getSchemeId(), this.isReverse, TraceIdUtil.getCurrentTraceIdString(), string));
                        }
                        errRefBills.computeIfAbsent(billtype, value -> new HashSet()).add(billInfo.getBillId());
                    }
                }
            }
        }
        Map<String, Object> imageMap = this.getImgConfig(this.imageNumberMap);
        HashMap<String, Object> otherData = new HashMap<String, Object>(16);
        otherData.put("linkUpBillInfos", linkUpBillInfos);
        otherData.put("billAndRefvoucherIds", this.billAndRefvoucherIds);
        otherData.put("refAttachMap", this.refAttachMap);
        otherData.put("imageMap", imageMap);
        otherData.put("accountBookNo", this.accountBookNo);
        otherData.put("accountBookName", this.accountBookName);
        otherData.put("period", this.period);
        otherData.put("flag", LogicUtils.getFlag(context.getIsReverse()));
        otherData.put("errRefBills", errRefBills);
        otherData.put("voucherInfoMap", this.voucherInfoMap);
        this.archiveLogicUnit.getContextData().setOtherData(otherData);
        FileUploadItem fileUploadItem = this.documentServerHandler.generateDescriptFile(context, this.archiveLogicUnit.getContextData(), DescriptType.VOUCHER_REF);
        this.archiveLogicUnit.uploadFile(fileUploadItem, this.billName, CLASS_NAME, Boolean.TRUE);
    }

    @Override
    public void archiveReceipt(ArchiveContext context) {
        Map<String, Map<Long, Set<Long>>> billAndRefvoucherIds = ArchiveUtil.getBillAndRefvoucherIds(this.isreceiptSet, this.linkUpBills);
        HashMap<Long, String> recIdUrlMap = new HashMap<Long, String>(16);
        HashMap<String, Map> receiptIdMap = new HashMap<String, Map>(16);
        if (!this.isreceiptBilltypeAndIds.isEmpty()) {
            LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5f52\u6863\u56de\u5355\u7684\u5173\u8054\u5355\u636e\u6709:{}", (String)"DefaultVoucherDataProvider_6", (String)"fi-aef-common", (Object[])new Object[0]), this.isreceiptBilltypeAndIds);
            for (Map.Entry<String, Set<Long>> sentry : this.isreceiptBilltypeAndIds.entrySet()) {
                String refbillType = sentry.getKey();
                Map<Long, List<JSONObject>> billreceipt = ElecreceiptUtils.findReceiptJson(refbillType, sentry.getValue(), this.pageId);
                if (billreceipt == null || billreceipt.size() <= 0) continue;
                for (Map.Entry<Long, List<JSONObject>> entry : billreceipt.entrySet()) {
                    if (entry.getValue().size() <= 0) continue;
                    for (JSONObject sourcejson : entry.getValue()) {
                        JSONObject json = new JSONObject(new LinkedHashMap());
                        json.putAll((Map)sourcejson);
                        String url = json.getString("url");
                        recIdUrlMap.put(json.getLong("receiptId"), url);
                        receiptIdMap.computeIfAbsent(refbillType, value -> new HashMap()).computeIfAbsent(entry.getKey(), value -> new HashSet()).add(json.getLong("receiptId"));
                        if (!"1".equals(this.isReverse) || !StringUtils.isNotBlank((CharSequence)url)) continue;
                        try {
                            if (url.startsWith("http")) {
                                this.fileUploadItem.setFileName("RECEIPT_" + json.getLong("receiptId") + ".pdf");
                                this.fileUploadItem.setBusinessType(13);
                                this.archiveLogicUnit.setAnyFileRelatedInfo(this.fileUploadItem, url);
                                this.archiveLogicUnit.uploadFile(this.fileUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                                recIdUrlMap.put(json.getLong("receiptId"), "RECEIPT_" + json.getLong("receiptId") + ".pdf");
                                continue;
                            }
                            this.fileUploadItem.setFileName(ElecreceiptUtils.getFileName(url));
                            this.fileUploadItem.setBusinessType(13);
                            this.archiveLogicUnit.setAnyFileRelatedInfo(this.fileUploadItem, url);
                            this.archiveLogicUnit.uploadFile(this.fileUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                        }
                        catch (IOException e) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u56de\u5355\u6587\u4ef6\u5931\u8d25{%s}", (String)"DefaultVoucherDataProvider_9", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                        }
                    }
                }
            }
        }
        Set<Long> receiptIdSet = recIdUrlMap.keySet();
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\u7684\u6240\u6709\u7535\u5b50\u56de\u5355id\u6709:{}", (String)"DefaultVoucherDataProvider_10", (String)"fi-aef-common", (Object[])new Object[0]), receiptIdSet.toString());
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\u7684\u6240\u6709\u7535\u5b50\u56de\u5355url\u6709:{}", (String)"DefaultVoucherDataProvider_11", (String)"fi-aef-common", (Object[])new Object[0]), recIdUrlMap);
        Map<Long, DynamicObject> receiptDys = ElecreceiptUtils.findReceiptDataSet(receiptIdSet);
        if (receiptDys.size() > 0) {
            this.archiveLogicUnit.getContextData().setOtherData(Collections.emptyMap());
            HashMap<String, Object> otherData = new HashMap<String, Object>(16);
            otherData.put("receiptDys", receiptDys);
            otherData.put("isreceiptBilltypeAndIds", this.isreceiptBilltypeAndIds);
            otherData.put("receiptIdMap", receiptIdMap);
            otherData.put("imageMap", this.imageMap);
            otherData.put("billAndRefvoucherIds", billAndRefvoucherIds);
            otherData.put("flag", LogicUtils.getFlag(context.getIsReverse()));
            otherData.put("recIdUrlMap", recIdUrlMap);
            otherData.put("accountBookNo", this.accountBookNo);
            otherData.put("accountBookName", this.accountBookName);
            otherData.put("period", this.period);
            this.archiveLogicUnit.getContextData().setOtherData(otherData);
            FileUploadItem fileUploadItem = this.documentServerHandler.generateDescriptFile(context, this.archiveLogicUnit.getContextData(), DescriptType.RECEIPT_TYPE);
            this.archiveLogicUnit.uploadFile(fileUploadItem, this.billName, CLASS_NAME, Boolean.TRUE);
        }
    }

    @Override
    public void archiveXbrl(ArchiveContext context) {
        Map<String, DynamicObject> invoicePlgins = ArchiveUtil.getTypeWithInvoice();
        HashSet<String> isinvoiceSet = new HashSet(16);
        if (this.VATBillTypes.containsKey("isinvoice")) {
            isinvoiceSet = this.VATBillTypes.get("isinvoice");
        }
        if ("2".equals(this.isReverse)) {
            context.setNeedArchiveIds(new HashSet<Long>(this.ids));
        }
        this.voucherJson = ArchiveUtil.getVoucherJson(this.ids, this.voucherHeadJson);
        Map<String, Set<Long>> invoiceBilltypeAndIds = ArchiveUtil.getRefBilltypeAndIds(this.linkUpBills, isinvoiceSet);
        Map<String, Map<Long, String>> invoicebillNos = ArchiveUtil.getBillNos(invoiceBilltypeAndIds);
        Map<String, Map<Long, Set<Long>>> billAndRefvoucherIds = ArchiveUtil.getBillAndRefvoucherIds(isinvoiceSet, this.linkUpBills);
        HashSet buildXbrlVoucherIds = new HashSet(16);
        billAndRefvoucherIds.forEach((key, value) -> {
            Map getIdmap = value;
            getIdmap.forEach((billid, voucherIds) -> buildXbrlVoucherIds.addAll(voucherIds));
        });
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5f52\u6863xbrl\u7684\u51ed\u8bc1\u6709:{}", (String)"DefaultVoucherDataProvider_12", (String)"fi-aef-common", (Object[])new Object[0]), billAndRefvoucherIds);
        if (!invoiceBilltypeAndIds.isEmpty()) {
            LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5f52\u6863\u53d1\u7968xbrl\u7684\u5173\u8054\u5355\u636e\u6709:{}", (String)"DefaultVoucherDataProvider_13", (String)"fi-aef-common", (Object[])new Object[0]), invoiceBilltypeAndIds);
            for (Map.Entry<String, Set<Long>> sentry : invoiceBilltypeAndIds.entrySet()) {
                String refbillType = sentry.getKey();
                Map<Long, List<Long>> dapVoucher = this.getDapRelation(sentry.getKey(), sentry.getValue());
                Map<Long, List<JSONObject>> billInvoice = ElecreceiptUtils.findInvoiceJson(refbillType, sentry.getValue(), invoicePlgins);
                if (billInvoice == null || billInvoice.size() <= 0) continue;
                Map<String, JSONObject> seqNoAndJson = XbrlArchieveUtil.getSeqNoAndJson(billInvoice);
                for (Map.Entry<Long, List<JSONObject>> entry : billInvoice.entrySet()) {
                    if (entry.getValue().size() <= 0) continue;
                    for (JSONObject sourcejson : entry.getValue()) {
                        byte[] xbrlData;
                        if (SysParamConfig.getBoolean("ischeckxbrlurl", true) && StringUtils.isBlank((CharSequence)sourcejson.getString("xbrlUrl"))) continue;
                        JSONObject json = new JSONObject(new LinkedHashMap());
                        json.putAll((Map)sourcejson);
                        String uniqueKey = json.getString(SEQNO);
                        String tickettype = json.getString("tickettype");
                        if (XbrlArchieveUtil.NEED_FIND_VOICEINFO_TICKETTYPRS.contains(tickettype)) {
                            if (!seqNoAndJson.containsKey(uniqueKey)) continue;
                            json.putAll((Map)seqNoAndJson.get(uniqueKey));
                        }
                        JSONObject vJson = new JSONObject(new LinkedHashMap());
                        Set<Long> vids = billAndRefvoucherIds.get(refbillType).get(entry.getKey());
                        ArrayList<Long> vList = new ArrayList<Long>(16);
                        vList.addAll(vids);
                        Long pkId = 0L;
                        if (dapVoucher.get(entry.getKey()) != null) {
                            List<Long> dapList = dapVoucher.get(entry.getKey());
                            dapList.retainAll(vList);
                            if (dapList.size() > 0) {
                                pkId = dapList.get(0);
                            }
                        } else {
                            pkId = (Long)vList.get(0);
                        }
                        vJson.put(INFORMATIONOFACCOUNTINGDOCUMENTSTUPLE, (Object)this.voucherJson.get(pkId));
                        json.putAll((Map)this.voucherHeadJson.get(pkId));
                        json.putAll((Map)vJson);
                        json.put("sourcebillno", (Object)invoicebillNos.get(refbillType).get(entry.getKey()));
                        ArchiveUtil.setDefaultJson(json, this.period);
                        this.voucherInvoiceMap.computeIfAbsent(pkId, Value -> new HashSet()).add(uniqueKey);
                        if ("1".equals(this.isReverse) && (xbrlData = FileUtils.json2Xbrl(json.toJSONString(), tickettype)).length > 0) {
                            this.fileUploadItem.setFilebase64(this.toBase64(xbrlData));
                            this.fileUploadItem.setFileName(pkId + "_" + ContextUtil.createXBRLFilename(tickettype, json));
                            this.fileUploadItem.setBusinessType(2);
                            String md5 = FpyOperateUtil.fileMD5(xbrlData);
                            this.fileUploadItem.setFileMD5(md5);
                            this.fileUploadItem.setFileBytes(xbrlData);
                            this.fileUploadItem.setFilePath(null);
                            this.archiveLogicUnit.uploadFile(this.fileUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                            FileDesc fileDesc = new FileDesc(ContextUtil.createXBRLFilename(tickettype, json), md5, "xml", xbrlData.length);
                            this.xbrlDescMap.computeIfAbsent(pkId, value -> new ArrayList()).add(fileDesc);
                        }
                        List attachs = this.xbrlFileMap.computeIfAbsent(pkId, value -> new ArrayList());
                        Attach attach = new Attach();
                        attach.setFileName(ContextUtil.createXBRLFilename(tickettype, json));
                        attachs.add(attach);
                        context.getNeedArchiveIds().add(pkId);
                        SingleArchiveUtil.insertInvoicePool(this.vatInvoiceMap, json, tickettype, pkId, this.voucherJson, refbillType, entry.getKey());
                    }
                }
            }
        }
        this.isreceiptSet = this.VATBillTypes.get("isreceipt");
        this.isreceiptBilltypeAndIds = ArchiveUtil.getRefBilltypeAndIds(this.linkUpBills, this.isreceiptSet);
        this.archiveXbrlReceipt(this.isreceiptBilltypeAndIds);
    }

    private void archiveXbrlReceipt(Map<String, Set<Long>> isreceiptBilltypeAndIds) {
        Map<String, Map<Long, String>> isreceiptbillNos = ArchiveUtil.getBillNos(isreceiptBilltypeAndIds);
        Map<String, Map<Long, Set<Long>>> billAndRefvoucherIds = ArchiveUtil.getBillAndRefvoucherIds(this.isreceiptSet, this.linkUpBills);
        LogUtil.printLog(logger, ResManager.loadKDString((String)"\u672c\u6b21\u9700\u8981\u5f52\u6863xbrl\u56de\u5355\u7684\u5173\u8054\u5355\u636e\u6709:{}", (String)"DefaultVoucherDataProvider_14", (String)"fi-aef-common", (Object[])new Object[0]), isreceiptBilltypeAndIds);
        Map<String, DynamicObject> receiptPlgins = ArchiveUtil.getTypeWithReceipt();
        HashMap<String, Map> receiptIdMap = new HashMap<String, Map>(16);
        if (!isreceiptBilltypeAndIds.isEmpty() && receiptPlgins.size() > 0) {
            for (Map.Entry<String, Set<Long>> sentry : isreceiptBilltypeAndIds.entrySet()) {
                String refbillType = sentry.getKey();
                Map<Long, List<Long>> dapVoucher = this.getDapRelation(sentry.getKey(), sentry.getValue());
                Map<Long, List<JSONObject>> billreceipt = ElecreceiptUtils.findReceiptJson(refbillType, sentry.getValue(), receiptPlgins, this.pageId);
                if (billreceipt == null || billreceipt.size() <= 0) continue;
                for (Map.Entry<Long, List<JSONObject>> entry : billreceipt.entrySet()) {
                    if (entry.getValue().size() <= 0) continue;
                    for (JSONObject sourcejson : entry.getValue()) {
                        JSONObject json = new JSONObject(new LinkedHashMap());
                        json.putAll((Map)sourcejson);
                        Set<Long> vids = billAndRefvoucherIds.get(refbillType).get(entry.getKey());
                        ArrayList<Long> vList = new ArrayList<Long>(16);
                        vList.addAll(vids);
                        Long pkId = 0L;
                        if (dapVoucher.get(entry.getKey()) != null) {
                            List<Long> dapList = dapVoucher.get(entry.getKey());
                            dapList.retainAll(vList);
                            if (dapList.size() > 0) {
                                pkId = dapList.get(0);
                            }
                        } else {
                            pkId = (Long)vList.get(0);
                        }
                        String url = json.getString("url");
                        receiptIdMap.computeIfAbsent(refbillType, value -> new HashMap()).computeIfAbsent(entry.getKey(), value -> new HashSet()).add(json.getLong("receiptId"));
                        if ("1".equals(this.isReverse) && StringUtils.isNotBlank((CharSequence)url)) {
                            try {
                                byte[] pdfData = FileUtils.downLoadHttpsFile(url);
                                if (this.isxbrlpilot && pdfData != null && pdfData.length > 0 && (url.endsWith(".ofd") || url.endsWith(".pdf"))) {
                                    String fullUrl = FileUtils.getElecLastDir() + File.separator + ElecreceiptUtils.getFileName(url);
                                    FileUtils.writeToFile(pdfData, fullUrl);
                                    String issuerUrl = FileUtils.extractElecXBRL(fullUrl, "bker_issuer", json.getString(SEQNO));
                                    byte[] issuerData = FileUtils.getElecFile(issuerUrl);
                                    if (issuerData != null && issuerData.length > 0) {
                                        String fileName = pkId + "_" + ContextUtil.createXBRLFilename("bker_receiver", json).replace("receiver", "issuer");
                                        String md5 = FpyOperateUtil.fileMD5(issuerData);
                                        this.fileUploadItem.setFilebase64(this.toBase64(issuerData));
                                        this.fileUploadItem.setFileName(fileName);
                                        this.fileUploadItem.setBusinessType(2);
                                        this.fileUploadItem.setFileMD5(md5);
                                        this.fileUploadItem.setFileBytes(issuerData);
                                        this.fileUploadItem.setFilePath(null);
                                        this.archiveLogicUnit.uploadFile(this.fileUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                                        FileUtils.deleteFile(fullUrl);
                                        FileUtils.deleteFile(issuerUrl);
                                        FileDesc fileDesc = new FileDesc(fileName, md5, "xml", issuerData.length);
                                        this.xbrlDescMap.computeIfAbsent(pkId, value -> new ArrayList()).add(fileDesc);
                                    }
                                }
                            }
                            catch (Exception e) {
                                logger.error("receipt url :" + url + " :" + e);
                            }
                        }
                        JSONObject vJson = new JSONObject(new LinkedHashMap());
                        vJson.put(INFORMATIONOFACCOUNTINGDOCUMENTSTUPLE, (Object)this.voucherJson.get(pkId));
                        json.putAll((Map)this.voucherHeadJson.get(pkId));
                        json.putAll((Map)vJson);
                        ArchiveUtil.setDefaultJson(json, this.period);
                        json.put("sourcebillno", (Object)isreceiptbillNos.get(refbillType).get(entry.getKey()));
                        json.put("tickettype", (Object)"bker_receiver");
                        byte[] xbrlData = FileUtils.json2Xbrl(json.toJSONString(), "bker_receiver");
                        if (xbrlData.length > 0 && "1".equals(this.isReverse)) {
                            String fileName = pkId + "_" + ContextUtil.createXBRLFilename("bker_receiver", json);
                            String md5 = FpyOperateUtil.fileMD5(xbrlData);
                            this.fileUploadItem.setFilebase64(this.toBase64(xbrlData));
                            this.fileUploadItem.setFileName(fileName);
                            this.fileUploadItem.setBusinessType(2);
                            this.fileUploadItem.setFileMD5(md5);
                            this.fileUploadItem.setFileBytes(xbrlData);
                            this.fileUploadItem.setFilePath(null);
                            this.archiveLogicUnit.uploadFile(this.fileUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                            FileDesc fileDesc = new FileDesc(fileName, md5, "xml", xbrlData.length);
                            this.xbrlDescMap.computeIfAbsent(pkId, value -> new ArrayList()).add(fileDesc);
                        }
                        List attachs = this.xbrlFileMap.computeIfAbsent(pkId, value -> new ArrayList());
                        Attach attach = new Attach();
                        attach.setFileName(ContextUtil.createXBRLFilename("bker_receiver", json));
                        attachs.add(attach);
                        Attach attach2 = new Attach();
                        attach2.setFileName(ContextUtil.createXBRLFilename("bker_receiver", json).replace("receiver", "issuer"));
                        attachs.add(attach2);
                        this.context.getNeedArchiveIds().add(pkId);
                        SingleArchiveUtil.insertInvoicePool(this.vatInvoiceMap, json, "bker_receiver", pkId, this.voucherJson, refbillType, entry.getKey());
                    }
                }
            }
        }
    }

    private Map<String, List<BillInfo>> getLinkUpBillInfos(Map<String, Set<Long>> refBilltypeAndIds) {
        HashMap<String, List<BillInfo>> map = new HashMap<String, List<BillInfo>>();
        String algoKey = this.getClass().getName() + "getLinkUpBillInfos";
        for (Map.Entry<String, Set<Long>> refBilltype : refBilltypeAndIds.entrySet()) {
            String billType = refBilltype.getKey();
            String selectFields = ArchiveUtil.getSelectFields(billType, null);
            DynamicObjectCollection dynamicObjectCollection = ArchiveUtil.getXmlfileds(billType);
            String idField = ArchiveUtil.getFieldName(billType, "id");
            String billNoField = ArchiveUtil.getFieldName(billType, QueryFinanceBillHelper.getBillNo(billType));
            DataSet set = QueryServiceHelper.queryDataSet((String)algoKey, (String)billType, (String)selectFields, (QFilter[])new QFilter("id", "in", refBilltype.getValue()).toArray(), null);
            Throwable throwable = null;
            try {
                if (set == null) continue;
                for (Row row : set) {
                    BillInfo billInfo = new BillInfo();
                    billInfo.setBillId(row.getLong(idField));
                    billInfo.setBillNo(row.getString(billNoField));
                    HashMap<String, String> fieldMap = new HashMap<String, String>(16);
                    for (DynamicObject dyn : dynamicObjectCollection) {
                        fieldMap.put(dyn.getString("xmlfiled"), ArchiveUtil.getFieldValue(row, dyn));
                    }
                    billInfo.setFieldMap(fieldMap);
                    map.computeIfAbsent(billType, value -> new ArrayList()).add(billInfo);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (set == null) continue;
                if (throwable != null) {
                    try {
                        set.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                set.close();
            }
        }
        return map;
    }

    protected Map<Long, List<Long>> getDapRelation(String billtype, Set<Long> billids) {
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(16);
        QFilter qFilter = new QFilter("billtype", "=", (Object)billtype);
        QFilter qFilter1 = new QFilter("sourcebillid", "in", this.ids);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.aef.logicunit.fpy.getDapRelation", (String)"ai_daptracker", (String)"voucherid,billtype,sourcebillid", (QFilter[])new QFilter[]{qFilter, qFilter1}, null);){
            for (Row row : dataSet) {
                Long vourcherId = row.getLong("voucherid");
                Long sourcebillid = row.getLong("sourcebillid");
                resultMap.computeIfAbsent(sourcebillid, value -> new ArrayList()).add(vourcherId);
            }
        }
        return resultMap;
    }

    protected String toBase64(byte[] bytes) {
        if (bytes != null && bytes.length > 0) {
            return Base64.getEncoder().encodeToString(bytes);
        }
        return "";
    }

    protected String queryPrintId(String printSample, int printType) {
        if (printType == 1) {
            return MetadataDao.getIdByNumber((String)printSample, (MetaCategory)MetaCategory.Form);
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_print_meta", (String)"number, id", (QFilter[])new QFilter("number", "=", (Object)printSample).toArray());
        if (null != dynamicObject) {
            return dynamicObject.get("id").toString();
        }
        return "";
    }

    private Map<String, Object> getImgConfig(Map<String, Map<Long, List<String>>> imageNumberMap) {
        HashMap<String, Object> imageMap = new HashMap<String, Object>();
        QFilter imageFilter1 = new QFilter("number", "=", (Object)"FPY");
        DynamicObject imagedyo = BusinessDataServiceHelper.loadSingleFromCache((String)"bas_imageconfig", (String)"number,imagesystermip,imageport,enable", (QFilter[])new QFilter[]{imageFilter1});
        QFilter voiceFilter2 = new QFilter("client_id", "!=", (Object)"");
        if (QueryServiceHelper.exists((String)"er_bd_kdinvoicecloudcfg", (QFilter[])voiceFilter2.toArray()) || QueryServiceHelper.exists((String)"er_bd_kdinvoicecloudcfgct", (QFilter[])voiceFilter2.toArray())) {
            imageMap.put("enable", "A");
        }
        if (imagedyo != null) {
            imageMap.put("numbermap", imageNumberMap);
            imageMap.put("imagesystype", imagedyo.getString("number"));
            imageMap.put("imagesysip", imagedyo.getString("imagesystermip"));
            imageMap.put("imagesysport", imagedyo.getString("imageport"));
        }
        return imageMap;
    }
}

