/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.cache.CacheHelper;
import kd.fi.aef.cache.CacheModule;
import kd.fi.aef.cache.DistributeCache;
import kd.fi.aef.common.ArchiveContext;
import kd.fi.aef.common.util.ElecreceiptUtils;
import kd.fi.aef.common.util.JudgeBillType;
import kd.fi.aef.common.util.SysParamConfig;
import kd.fi.aef.entity.ArchiveResult;
import kd.fi.aef.entity.SchemeEntry;
import kd.fi.aef.logic.AbstractArchiveLogicUnit;
import kd.fi.aef.logic.unit.ArchiveCasReportLogicUnit;
import kd.fi.aef.logic.unit.ArchiveCommonBillLogicUnit;
import kd.fi.aef.logic.unit.ArchiveFacardfinLogicUnit;
import kd.fi.aef.logic.unit.ArchiveGeneralledgerLogicUnit;
import kd.fi.aef.logic.unit.ArchiveGeneralledgerLogicUnitNew;
import kd.fi.aef.logic.unit.ArchiveReportFormLogicUnit;
import kd.fi.aef.logic.unit.ArchiveSubledgerLogicUnit;
import kd.fi.aef.logic.unit.ArchiveTaxBillLogicUnit;
import kd.fi.aef.logic.unit.ArchiveVoucherLogicUnit;
import kd.fi.aef.logic.unit.ElecstatementWithVATinvoice;

public class ArchiveEngineImpl
implements Callable<ArchiveResult> {
    private static final Log logger = LogFactory.getLog(ArchiveEngineImpl.class);
    private DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.archive);
    private SchemeEntry scheme;
    private OperateOption option;
    private ArchiveResult archiveResult = new ArchiveResult();
    protected ArchiveContext context;

    public ArchiveEngineImpl(SchemeEntry scheme, OperateOption option) {
        this.scheme = scheme;
        this.option = option;
        this.context = new ArchiveContext(scheme);
        if (option.containsVariable("isMergeRptArchiveCheckAuth")) {
            String variableValue = option.getVariableValue("isMergeRptArchiveCheckAuth");
            this.context.setMergeRptArchiveCheckAuth(Boolean.parseBoolean(variableValue));
        }
        if (option.containsVariable("serviceip")) {
            this.context.setServiceIp(option.getVariableValue("serviceip"));
        }
        if (option.containsVariable("serviceport")) {
            this.context.setPort(option.getVariableValue("serviceport"));
        }
        if (option.containsVariable("issplitbook")) {
            this.context.setSplitBook(Boolean.parseBoolean(option.getVariableValue("issplitbook")));
        }
        if (option.containsVariable("support_gl_rpt_generalledger_new")) {
            this.context.setSupportGeneralledgerNew(Boolean.parseBoolean(option.getVariableValue("support_gl_rpt_generalledger_new")));
        }
        this.context.setUploadWay(option.getVariableValue("uploadway"));
        if (!SysParamConfig.getBoolean("archivetoxinghan", false) && "3".equals(option.getVariableValue("uploadway"))) {
            this.context.setAws(Boolean.TRUE);
        }
        if (option.containsVariable("archivetype") && "reportform".equals(option.getVariableValue("archivetype"))) {
            this.context.setBcmscene(Long.parseLong(option.getVariableValue("bcmscene")));
            this.context.setBcmfy(Long.parseLong(option.getVariableValue("bcmfy")));
            this.context.setBcmperiodJson(option.getVariableValue("bcmperiod"));
            this.context.setBcmsceneType(option.getVariableValue("bcmsceneType"));
            this.context.setBcmfyName(option.getVariableValue("bcmfyName"));
            this.context.setClientFullContextPath(RequestContext.get().getClientFullContextPath());
        }
        this.context.setArchivesCode(option.getVariableValue("archivesCode"));
        this.context.setPassword(option.getVariableValue("password"));
        this.context.setServiceIp(option.getVariableValue("serviceip"));
        this.context.setPort(option.getVariableValue("serviceport"));
        this.context.setIsReverse(option.getVariableValue("isReverse"));
        this.context.setBatchcode(UUID.randomUUID().toString());
        if ("2".equals(option.getVariableValue("isReverse")) && option.containsVariable("reason")) {
            this.context.setReverseReason(option.getVariableValue("reason"));
        }
        if ("gl_voucher".equals(scheme.getBillType())) {
            this.context.setRefBillTempInfo(scheme.getRefBillTempInfo());
            this.context.setRefBillAllInfo(scheme.getRefBillAllInfo());
        }
        if (JudgeBillType.isFinaceRpt(scheme.getBillType())) {
            if (option.containsVariable("booktype")) {
                this.context.setBooktypeId(Long.parseLong(option.getVariableValue("booktype")));
            } else {
                this.context.setBooktypeId(scheme.getBookTypeId());
            }
        }
        if (option.containsVariable("isxbrlpilot") || "true".equals(scheme.getIsxbrlpilot())) {
            this.context.setIsxbrlpilot(true);
        } else {
            this.context.setIsxbrlpilot(false);
        }
    }

    @Override
    public ArchiveResult call() throws Exception {
        AbstractArchiveLogicUnit logicUnit = this.getLogicUnit();
        boolean archieve = "1".equals(this.option.getVariableValue("isReverse"));
        TraceIdUtil.setCurrentTraceId((String)this.option.getVariableValue("traceId"));
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(this.context.getBillType());
        logger.info("billType : {}", (Object)this.context.getBillType());
        this.archiveResult.setBillTypes(list);
        try {
            if (logicUnit != null) {
                logicUnit.doAction(this.context);
            }
            if (archieve) {
                int count;
                String key = this.scheme.getPageId() + "hasarchievecount";
                String countString = this.cache.get(this.scheme.getPageId() + "hasarchievecount");
                int n = count = countString == null ? 0 : Integer.parseInt(countString);
                if (JudgeBillType.isFinaceRpt(this.scheme.getBillType())) {
                    this.cache.put(key, count + 1 + "");
                } else if (!JudgeBillType.isRptFrom(this.scheme.getBillType())) {
                    logger.info("scheme.getBillType() : {} size: {} ", (Object)this.scheme.getBillType(), (Object)this.context.getNeedArchiveIds().size());
                    this.cache.put(key, count + this.context.getNeedArchiveIds().size() + "");
                }
            }
            if (JudgeBillType.isBill(this.scheme.getBillType()) && null != this.context.getNeedArchiveIds() && !this.context.getNeedArchiveIds().isEmpty()) {
                ElecreceiptUtils.callBillWriteBack(archieve ? "1" : "0", this.context.getBillType(), this.context.getNeedArchiveIds());
            }
            this.archiveResult.setIsSuccess(Boolean.TRUE);
            this.archiveResult.setSuccessPkIds((List<Long>)(this.context.getNeedArchiveIds() != null ? new ArrayList<Long>(this.context.getNeedArchiveIds()) : new ArrayList()));
        }
        catch (Exception e) {
            if (e instanceof KDBizException && ((KDBizException)((Object)e)).getArgs().length > 0) {
                Object[] errorMaps = ((KDBizException)((Object)e)).getArgs();
                Set errorIds = Arrays.stream(errorMaps).map(errorMap -> Long.valueOf(((Map)errorMap).get("errorId").toString())).collect(Collectors.toSet());
                List<String> errorMessages = Arrays.stream(errorMaps).map(errorMap -> ((Map)errorMap).get("errorMessage").toString()).collect(Collectors.toList());
                HashSet<Long> ids = this.context.getNeedArchiveIds() != null ? new HashSet<Long>(this.context.getNeedArchiveIds()) : new HashSet();
                ids.removeAll(errorIds);
                this.archiveResult.setSuccessPkIds(new ArrayList<Long>(ids));
                this.archiveResult.setErrorMessages(errorMessages);
            }
            this.archiveResult.setIsSuccess(Boolean.FALSE);
            String errorMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            if (archieve) {
                if (e instanceof KDBizException) {
                    this.cache.put(this.scheme.getPageId() + "errorMsg", e.getMessage());
                } else {
                    this.cache.put(this.scheme.getPageId() + "errorMsg", ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
                this.cache.put(this.scheme.getPageId() + "isSuccess", "false");
            }
            logger.error("\u6267\u884c\u903b\u8f91\u5355\u5143\u5931\u8d25:" + errorMsg);
        }
        return this.archiveResult;
    }

    private AbstractArchiveLogicUnit getLogicUnit() {
        String archieveType;
        String string = archieveType = this.option.containsVariable("archivetype") ? this.option.getVariableValue("archivetype") : null;
        if ("tax".equals(archieveType)) {
            return new ArchiveTaxBillLogicUnit();
        }
        if ("gl_voucher".equals(this.context.getBillType())) {
            return new ArchiveVoucherLogicUnit();
        }
        if ("gl_rpt_generalledger".equals(this.context.getBillType())) {
            if (this.context.isSupportGeneralledgerNew()) {
                return new ArchiveGeneralledgerLogicUnitNew();
            }
            return new ArchiveGeneralledgerLogicUnit();
        }
        if ("gl_rpt_subledger".equals(this.context.getBillType())) {
            return new ArchiveSubledgerLogicUnit();
        }
        if ("fa_card_fin".equals(this.context.getBillType())) {
            return new ArchiveFacardfinLogicUnit();
        }
        if ("aef_rpt".equals(this.context.getBillType())) {
            return new ArchiveReportFormLogicUnit();
        }
        if ("cas_bankjournalformrpt".equals(this.context.getBillType()) || "cas_cashjournalformrpt".equals(this.context.getBillType())) {
            return new ArchiveCasReportLogicUnit();
        }
        if ("bei_elecstatement".equals(this.context.getBillType())) {
            if (this.option.containsVariable("isxbrlpilot") || "true".equals(this.scheme.getIsxbrlpilot())) {
                return new ElecstatementWithVATinvoice();
            }
            return new ArchiveCommonBillLogicUnit();
        }
        return new ArchiveCommonBillLogicUnit();
    }
}

