/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.output.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.util.StringUtils;
import kd.fi.aef.common.util.DowJonesVideoImp;
import kd.fi.aef.entity.ArchiveInfo;
import kd.fi.aef.entity.FileInfo;
import kd.fi.aef.logic.common.DOWJONESUtils;
import kd.fi.aef.logic.model.FileUploadItem;
import kd.fi.aef.logic.output.IDocumentServerHandler;
import kd.fi.aef.logic.output.Result;

public class DOWJONESDocumentServerHndler
implements IDocumentServerHandler {
    Map<String, ArchiveInfo> allMap = new HashMap<String, ArchiveInfo>();
    String uploadUrl;

    @Override
    public void initServer() {
        DynamicObject imageConfig = QueryServiceHelper.queryOne((String)"aef_serviceconfig", (String)"id,serviceip,serviceport,username,password,uploadway,requestway", null);
        String message = "";
        if (imageConfig == null) {
            message = ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u5f52\u6863\u670d\u52a1\u5668\u3002", (String)"ArchiveOpService_4", (String)"fi-aef-opplugin", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        String serviceip = imageConfig.getString("serviceip");
        String serviceport = imageConfig.getString("serviceport");
        this.uploadUrl = DowJonesVideoImp.getServiceUrl("/services/UploadAttachment.ashx", serviceip, serviceport);
        if (StringUtils.isEmpty((String)this.uploadUrl)) {
            message = ResManager.loadKDString((String)"\u9053\u53ef\u7ef4\u65af\u670d\u52a1\u5668\u8def\u5f84\u4e3a\u7a7a\u3002", (String)"ArchiveOpService_5", (String)"fi-aef-opplugin", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
    }

    @Override
    public Result uploadFile(FileUploadItem uploadData) {
        Result result = new Result();
        result.setSucceed(true);
        if (uploadData != null) {
            String DowjonesId = DOWJONESUtils.getBillDowsId(uploadData);
            ArchiveInfo archiveInfo = this.allMap.get(DowjonesId);
            if (archiveInfo != null) {
                if (archiveInfo.getAttachInfo() == null) {
                    ArrayList<FileInfo> attachFiles = new ArrayList<FileInfo>();
                    archiveInfo.setAttachInfo(attachFiles);
                }
                archiveInfo.getAttachInfo().add(new FileInfo(uploadData.getFileName(), uploadData.getFileBytes()));
            } else {
                archiveInfo = DOWJONESUtils.convertArchiveInfo(uploadData);
                this.allMap.put(DowjonesId, archiveInfo);
            }
        }
        return result;
    }

    @Override
    public void handleBatchUpload() {
        if (this.allMap.size() > 0) {
            for (Map.Entry<String, ArchiveInfo> entry : this.allMap.entrySet()) {
                DowJonesVideoImp.PushFileToDowJones(this.uploadUrl, entry.getValue());
            }
        }
    }

    @Override
    public OperationResult executeReveral(List<Long> idList, OperationResult result, MainEntityType billEntityType, OperateOption option, ThreadPool threadPoolCash) {
        return DOWJONESUtils.deleteImagesByDowJones(idList, result, billEntityType);
    }
}

