/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.output.impl;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.fi.aef.common.ArchiveContext;
import kd.fi.aef.common.util.BusinessTypeUtils;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.DateUtil;
import kd.fi.aef.common.util.ElecreceiptUtils;
import kd.fi.aef.common.util.FpyOperateUtil;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.entity.BillInfo;
import kd.fi.aef.entity.FileDesc;
import kd.fi.aef.helper.QueryFinanceBillHelper;
import kd.fi.aef.logic.ContextData;
import kd.fi.aef.logic.common.FPYUtils;
import kd.fi.aef.logic.common.FPYXmlUtils;
import kd.fi.aef.logic.common.LogicUtils;
import kd.fi.aef.logic.datainput.DataProviderFactory;
import kd.fi.aef.logic.enums.DescriptType;
import kd.fi.aef.logic.model.Attach;
import kd.fi.aef.logic.model.Bill;
import kd.fi.aef.logic.model.FileUploadItem;
import kd.fi.aef.logic.output.IDocumentServerHandler;
import kd.fi.aef.logic.output.Result;
import kd.fi.aef.logic.output.model.CasRptOutputData;
import kd.fi.aef.logic.output.model.CommonBillOutputData;
import kd.fi.aef.logic.output.model.GeneralledgerOutputData;
import kd.fi.aef.logic.output.model.ReportFormOutputData;
import kd.fi.aef.logic.output.model.SubledgerOutputData;

public class FPYDocumentServerHandler
implements IDocumentServerHandler {
    private static final Log logger = LogFactory.getLog(FPYDocumentServerHandler.class);
    private static final String DATASOURCE = "cangqiong";
    String uploadUrl = "";
    String noticeUrl = "";
    String deleteUrl = "";

    @Override
    public void initServer() {
        ThreeTuple<String, String, String> returnValue = FPYUtils.initialURL3();
        this.uploadUrl = (String)returnValue.item1;
        this.noticeUrl = (String)returnValue.item2;
        this.deleteUrl = (String)returnValue.item3;
    }

    @Override
    public boolean isXbrlPoint(ArchiveContext context) {
        return context.getIsxbrlpilot();
    }

    @Override
    public Result reverse(FileUploadItem uploadData) {
        uploadData.setArchivist(RequestContext.get().getUserName());
        uploadData.setDataSource(DATASOURCE);
        return FPYUtils.reverse(this.deleteUrl, uploadData);
    }

    @Override
    public Result sendNotice(FileUploadItem uploadData) {
        uploadData.setArchivist(RequestContext.get().getUserName());
        uploadData.setDataSource(DATASOURCE);
        return FPYUtils.noticeArchive(this.noticeUrl, uploadData);
    }

    @Override
    public Result uploadFile(FileUploadItem uploadData) {
        return FPYUtils.upload(this.uploadUrl, uploadData);
    }

    @Override
    public FileUploadItem generateDescriptFile(ArchiveContext context, ContextData data, DescriptType descriptType) {
        switch (descriptType) {
            case COMMON_BILL: {
                return this.generateCommonBillXMLFile(context, data);
            }
            case VOUCHER: {
                return this.generateVoucherXMLFile(context, data);
            }
            case VOUCHER_REF: {
                return this.generateVoucherRefXMLFile(context, data);
            }
            case RECEIPT_TYPE: {
                return this.generateReceiptXMLFile(context, data);
            }
            case FA_CARD: {
                return this.generateFacardXMLFile(context, data);
            }
            case GENERAL_LEDGER: {
                return this.generateGeneralXMLFile(context, data);
            }
            case SUBSIDIARY_LEDGER: {
                return this.generateSubsidiaryXMLFile(context, data);
            }
            case CAS_CASHJOURNALFORMRPT: 
            case CAS_BANKJOURNALFORMRPT: {
                return this.generateCasRptXMLFile(context, data);
            }
            case REPORT_FORM: {
                return this.generateMRptXMLFile(context, data);
            }
            case TAX_DATA: {
                return this.generateTaxXMLFile(context, data);
            }
            case ELEC_DATA: {
                return this.generateElecXMLFile(context, data);
            }
        }
        return null;
    }

    private FileUploadItem generateCasRptXMLFile(ArchiveContext context, ContextData ContextData2) {
        String xmlStr;
        CasRptOutputData outputData = ContextData2.getCasRptOutputData();
        String billName = LogicUtils.getBillName(context.getBillType());
        try {
            xmlStr = FPYXmlUtils.createCasRptXml(outputData.getDesc(), outputData.getXmlInfos(), outputData.getFlag());
        }
        catch (Exception e) {
            logger.error(String.format("\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}", context.getBillType(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", (String)"FPYDocumentServerHandler_2", (String)"fi-aef-common", (Object[])new Object[0]), context.getBillType(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        FileUploadItem fileUploadItem = outputData.getFileUploadItem();
        fileUploadItem.setFilebase64(xmlStr);
        fileUploadItem.setBatchCode(context.getBatchcode());
        fileUploadItem.setFileName(outputData.getDesc() + ".xml");
        fileUploadItem.setFileMD5(FpyOperateUtil.fileMD5(Base64.getDecoder().decode(xmlStr)));
        fileUploadItem.setBillidsMap(this.getGeneralBillidsMap(outputData.getXmlInfos(), billName));
        return fileUploadItem;
    }

    private FileUploadItem generateCommonBillXMLFile(ArchiveContext context, ContextData contextData) {
        Map<?, List<Attach>> attachMap = contextData.getCommonBillOutputData().getAttachMap();
        List<Bill> billList = contextData.getCommonBillOutputData().getBillList();
        Map<Object, FileDesc> billFileMap = contextData.getCommonBillOutputData().getBillFileMap();
        Map<String, Object> imageMap = contextData.getCommonBillOutputData().getImageMap();
        String flag = LogicUtils.getFlag(context.getIsReverse());
        String billName = LogicUtils.getBillName(context.getBillType());
        FileUploadItem fileUploadItem = contextData.getCommonBillOutputData().getFileUploadItem();
        Set<?> filingIds = DataProviderFactory.getCurrentDataProvider().getFilingIds(context.getBillType(), context.getIds());
        Bill bill = billList.get(0);
        String orgName = bill.getOrgName();
        String dateStr = DateUtil.getShortStr(bill.getDate());
        String xmlstr = "";
        try {
            xmlstr = FPYXmlUtils.createCommonBillXml(context, billList, billFileMap, billName, attachMap, imageMap, context.getBillType(), flag, filingIds);
        }
        catch (Exception e) {
            logger.error(String.format("\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", (String)"FPYDocumentServerHandler_0", (String)"fi-aef-common", (Object[])new Object[0]), billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        String desc = String.format(ResManager.loadKDString((String)"%s\u5355\u636e", (String)"FPYDocumentServerHandler_1", (String)"fi-aef-common", (Object[])new Object[0]), orgName + dateStr);
        fileUploadItem.setBatchCode(context.getBatchcode());
        fileUploadItem.setFilebase64(xmlstr);
        fileUploadItem.setBusinessType(BusinessTypeUtils.getBusinessType(context.getBillType(), false));
        fileUploadItem.setFileName(desc + context.getBatchcode() + ".xml");
        fileUploadItem.setFileMD5(FpyOperateUtil.fileMD5(Base64.getDecoder().decode(xmlstr)));
        fileUploadItem.setBillidsMap(this.getCommonBillidsMap(billList, context.getBillType(), billName));
        return fileUploadItem;
    }

    private Map<String, String> getCommonBillidsMap(List<Bill> billList, String billType, String billName) {
        return billList.stream().collect(Collectors.toMap(bill -> bill.getBillId() + "." + ("ap_finapbill".equals(billType) ? "ap_invoice" : billType) + "_" + bill.getBillId().toString(), bill -> billName + bill.getBillNo()));
    }

    private FileUploadItem generateSubsidiaryXMLFile(ArchiveContext context, ContextData ContextData2) {
        SubledgerOutputData outputData = ContextData2.getSubledgerOutputData();
        String billName = LogicUtils.getBillName(context.getBillType());
        String xmlstr = "";
        try {
            xmlstr = FPYXmlUtils.createSubledgerXml(outputData.getXmlDesc(), outputData.getXmlInfos(), outputData.getFlag(), "gl_rpt_subledger".equals(context.getBillType()));
        }
        catch (Exception e) {
            logger.error(String.format("\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}", outputData.getBillName(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", (String)"FPYDocumentServerHandler_2", (String)"fi-aef-common", (Object[])new Object[0]), outputData.getBillName(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        FileUploadItem fileUploadItem = outputData.getFileUploadItem();
        fileUploadItem.setFilebase64(xmlstr);
        fileUploadItem.setBatchCode(context.getBatchcode());
        fileUploadItem.setFileName(outputData.getXmlFileDesc() + ".xml");
        fileUploadItem.setFileMD5(FpyOperateUtil.fileMD5(Base64.getDecoder().decode(xmlstr)));
        fileUploadItem.setBillidsMap(this.getSubsidiaryBillidsMap(outputData.getXmlInfos(), billName));
        return fileUploadItem;
    }

    private Map<String, String> getSubsidiaryBillidsMap(List<Map<String, String>> xmlList, String billName) {
        HashMap<String, String> billidsMap = new HashMap<String, String>(xmlList.size());
        for (Map<String, String> map : xmlList) {
            billidsMap.put(map.get("billid") + "." + map.get("billid"), map.get("voucherorgname") + map.get("periodname") + billName + map.get("subjno"));
        }
        return billidsMap;
    }

    private FileUploadItem generateGeneralXMLFile(ArchiveContext context, ContextData datas) {
        GeneralledgerOutputData generalledgerOutputData = datas.getGeneralledgerOutputData();
        FileUploadItem fileUploadItem = generalledgerOutputData.getFileUploadItem();
        String billName = LogicUtils.getBillName(context.getBillType());
        String xmlstr = "";
        try {
            xmlstr = FPYXmlUtils.createGeneralledgerXml(generalledgerOutputData.getDesc(), generalledgerOutputData.getXmlInfos(), generalledgerOutputData.getFlag());
        }
        catch (Exception e) {
            logger.error(String.format("\u521b\u5efa%1$sxml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", context.getBillType(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", (String)"FPYDocumentServerHandler_2", (String)"fi-aef-common", (Object[])new Object[0]), context.getBillType(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        fileUploadItem.setFilebase64(xmlstr);
        fileUploadItem.setBatchCode(context.getBatchcode());
        fileUploadItem.setFileName(generalledgerOutputData.getDesc() + ".xml");
        fileUploadItem.setFileBytes(Base64.getDecoder().decode(xmlstr));
        fileUploadItem.setFileMD5(FpyOperateUtil.fileMD5(Base64.getDecoder().decode(xmlstr)));
        fileUploadItem.setBillidsMap(this.getGeneralBillidsMap(generalledgerOutputData.getXmlInfos(), billName));
        return fileUploadItem;
    }

    private Map<String, String> getGeneralBillidsMap(List<Map<String, String>> xmlList, String billName) {
        HashMap<String, String> billidsMap = new HashMap<String, String>(xmlList.size());
        for (Map<String, String> map : xmlList) {
            billidsMap.put(map.get("billid") + "." + map.get("billid"), map.get("voucherorgname") + map.get("periodname") + billName);
        }
        return billidsMap;
    }

    private FileUploadItem generateFacardXMLFile(ArchiveContext context, ContextData ContextData2) {
        Map<Object, List<Attach>> attachMap = ContextData2.getFacardOutputData().getAttachMap();
        List<Bill> billList = ContextData2.getFacardOutputData().getBillList();
        Map<Object, FileDesc> billFileMap = ContextData2.getFacardOutputData().getBillFileMap();
        Set<Object> errIds = ContextData2.getFacardOutputData().getErrIds();
        String billName = ContextData2.getFacardOutputData().getBillName();
        String flag = LogicUtils.getFlag(context.getIsReverse());
        String description = ContextData2.getFacardOutputData().getDescription();
        String xmlFileName = ContextData2.getFacardOutputData().getXmlFileName();
        String xmlstr = "";
        try {
            xmlstr = FPYXmlUtils.createFacardfinXml(context, billList, description, billFileMap, attachMap, flag, errIds);
        }
        catch (Exception e) {
            logger.error(String.format("\u521b\u5efa%1$s\u7684\u5173\u8054\u5355\u636exml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684\u5173\u8054\u5355\u636exml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", (String)"FPYDocumentServerHandler_3", (String)"fi-aef-common", (Object[])new Object[0]), billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        FileUploadItem fileUploadItem = ContextData2.getFacardOutputData().getFileUploadItem();
        fileUploadItem.setFilebase64(xmlstr);
        fileUploadItem.setBusinessType(7);
        fileUploadItem.setBatchCode(context.getBatchcode());
        fileUploadItem.setFileName(xmlFileName + context.getBatchcode() + ".xml");
        fileUploadItem.setFileBytes(Base64.getDecoder().decode(xmlstr));
        fileUploadItem.setFileMD5(FpyOperateUtil.fileMD5(Base64.getDecoder().decode(xmlstr)));
        fileUploadItem.setBillidsMap(this.getFacardBillidsMap(billList, billName));
        return fileUploadItem;
    }

    private Map<String, String> getFacardBillidsMap(List<Bill> billList, String billName) {
        return billList.stream().collect(Collectors.toMap(bill -> bill.getBillId() + "." + bill.getBillId().toString(), bill -> billName + bill.getBillNo()));
    }

    private FileUploadItem generateReceiptXMLFile(ArchiveContext context, ContextData datas) {
        Map<String, Object> otherData = datas.getOtherData();
        FileUploadItem fileUploadItem = datas.getVoucherOutputData().getFileUploadItem();
        Map receiptDys = (Map)otherData.get("receiptDys");
        Map isreceiptBilltypeAndIds = (Map)otherData.get("isreceiptBilltypeAndIds");
        Map receiptIdMap = (Map)otherData.get("receiptIdMap");
        Map imageMap = (Map)otherData.get("imageMap");
        Map billAndRefvoucherIds = (Map)otherData.get("billAndRefvoucherIds");
        String flag = (String)otherData.get("flag");
        Map recIdUrlMap = (Map)otherData.get("recIdUrlMap");
        String period = (String)otherData.get("period");
        String accountBookNo = (String)otherData.get("accountBookNo");
        String billName = LogicUtils.getBillName("bei_elecreceipt");
        try {
            String xmlstr = "";
            xmlstr = FPYXmlUtils.createElecreceiptXml(receiptDys, isreceiptBilltypeAndIds, receiptIdMap, imageMap, billAndRefvoucherIds, flag, recIdUrlMap);
            String desc = "bankReturn_" + accountBookNo + "_" + period + "_" + context.getBatchcode() + ".xml";
            fileUploadItem.setFilebase64(xmlstr);
            fileUploadItem.setBusinessType(13);
            fileUploadItem.setFileName(desc);
            fileUploadItem.setFileMD5(FpyOperateUtil.fileMD5(Base64.getDecoder().decode(xmlstr)));
            fileUploadItem.setFileBytes(Base64.getDecoder().decode(xmlstr));
            fileUploadItem.setBatchCode(context.getBatchcode());
            fileUploadItem.setFileMD5(FpyOperateUtil.fileMD5(Base64.getDecoder().decode(xmlstr)));
            fileUploadItem.setBillidsMap(this.getReceiptBillidsMap(receiptDys, isreceiptBilltypeAndIds, receiptIdMap, billName));
        }
        catch (Exception e) {
            logger.error(String.format("\u521b\u5efa\u7535\u5b50\u56de\u5355\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}", ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7535\u5b50\u56de\u5355\u7684xml\u63cf\u8ff0\u5931\u8d25,%2$s\u3002", (String)"FPYDocumentServerHandler_5", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        return fileUploadItem;
    }

    private Map<String, String> getReceiptBillidsMap(Map<Long, DynamicObject> receiptDys, Map<String, Set<Long>> refBilltypeAndIds, Map<String, Map<Long, Set<Long>>> receiptIdMap, String billName) {
        HashMap<String, String> billidsMap = new HashMap<String, String>(16);
        for (Map.Entry<String, Set<Long>> billReceipt : refBilltypeAndIds.entrySet()) {
            String billType = billReceipt.getKey();
            Set<Long> billList = billReceipt.getValue();
            for (Long billId : billList) {
                Set<Object> receiptIds = new HashSet();
                if (receiptIdMap.containsKey(billType)) {
                    receiptIds = receiptIdMap.get(billType).get(billId);
                }
                if (receiptIds == null || receiptIds.size() <= 0) continue;
                for (Long receiptId : receiptIds) {
                    DynamicObject dyo = receiptDys.get(receiptId);
                    if (dyo == null) continue;
                    billidsMap.put(dyo.get("id") + "." + dyo.get("id").toString(), billName + dyo.getString("receiptno"));
                }
            }
        }
        return billidsMap;
    }

    private FileUploadItem generateVoucherRefXMLFile(ArchiveContext context, ContextData datas) {
        FileUploadItem fileUploadItem = datas.getVoucherOutputData().getFileUploadItem();
        Map<String, Object> otherData = datas.getOtherData();
        Map linkUpBillInfos = (Map)otherData.get("linkUpBillInfos");
        Map billAndRefvoucherIds = (Map)otherData.get("billAndRefvoucherIds");
        Map refAttachMap = (Map)otherData.get("refAttachMap");
        Map imageMap = (Map)otherData.get("imageMap");
        String accountBookNo = (String)otherData.get("accountBookNo");
        String accountBookName = (String)otherData.get("accountBookName");
        String period = (String)otherData.get("period");
        String flag = (String)otherData.get("flag");
        Map errRefBills = (Map)otherData.get("errRefBills");
        Map<String, String> billTypeAndNameMap = linkUpBillInfos.keySet().stream().distinct().collect(Collectors.toMap(billType -> billType, LogicUtils::getBillName));
        Map voucherInfoMap = (Map)otherData.get("voucherInfoMap");
        String xmlstr = "";
        try {
            xmlstr = FPYXmlUtils.createVoucherRefBillXml(linkUpBillInfos, billAndRefvoucherIds, refAttachMap, imageMap, accountBookNo, accountBookName, period, flag, errRefBills, voucherInfoMap);
        }
        catch (Exception e) {
            logger.error(String.format("\u521b\u5efa%1$s\u7684\u5173\u8054\u5355\u636exml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", context.getBillType(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684\u5173\u8054\u5355\u636exml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", (String)"FPYDocumentServerHandler_3", (String)"fi-aef-common", (Object[])new Object[0]), context.getBillType(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        String desc = "refbill_" + accountBookNo + "_" + period + "_" + context.getBatchcode() + ".xml";
        fileUploadItem.setFilebase64(xmlstr);
        fileUploadItem.setBusinessType(4);
        fileUploadItem.setFileName(desc);
        fileUploadItem.setFileMD5(FpyOperateUtil.fileMD5(Base64.getDecoder().decode(xmlstr)));
        fileUploadItem.setFileBytes(Base64.getDecoder().decode(xmlstr));
        fileUploadItem.setBatchCode(context.getBatchcode());
        fileUploadItem.setFileMD5(FpyOperateUtil.fileMD5(Base64.getDecoder().decode(xmlstr)));
        fileUploadItem.setBillidsMap(this.getVoucherRefBillidsMap(linkUpBillInfos, errRefBills, billTypeAndNameMap));
        return fileUploadItem;
    }

    private Map<String, String> getVoucherRefBillidsMap(Map<String, List<BillInfo>> linkUpBillInfos, Map<String, Set<Object>> errRefBills, Map<String, String> billTypeAndNameMap) {
        HashMap<String, String> billidsMap = new HashMap<String, String>(16);
        for (Map.Entry<String, List<BillInfo>> linkUpBillInfo : linkUpBillInfos.entrySet()) {
            String billType = linkUpBillInfo.getKey();
            String billName = billTypeAndNameMap.get(billType);
            List<BillInfo> list = linkUpBillInfo.getValue();
            for (BillInfo billInfo : list) {
                if (errRefBills != null && errRefBills.get(billType) != null && errRefBills.get(billType).size() > 0 && errRefBills.get(billType).contains(billInfo.getBillId())) continue;
                if ("ap_finapbill".equals(billType)) {
                    billidsMap.put(billInfo.getBillId() + ".ap_invoice_" + billInfo.getBillId().toString(), billName + billInfo.getBillNo());
                    continue;
                }
                billidsMap.put(billInfo.getBillId() + "." + billType + "_" + billInfo.getBillId().toString(), billName + billInfo.getBillNo());
            }
        }
        return billidsMap;
    }

    private FileUploadItem generateVoucherXMLFile(ArchiveContext context, ContextData datas) {
        FileUploadItem fileUploadItem = datas.getVoucherOutputData().getFileUploadItem();
        List<Bill> billList = datas.getVoucherOutputData().getBillList();
        Set<Long> needArchiveIds = context.getNeedArchiveIds();
        billList = billList.stream().filter(bill -> needArchiveIds.contains((Long)bill.getBillId())).collect(Collectors.toList());
        Map<Long, List<Attach>> attachMap = datas.getVoucherOutputData().getAttachMap();
        Map<String, Object> otherData = datas.getOtherData();
        String xmlDesc = (String)otherData.get("xmlDesc");
        Map xbrlMap = (Map)otherData.get("xbrlFileMap");
        if (!xbrlMap.isEmpty()) {
            attachMap.putAll(xbrlMap);
        }
        Map linkUpBills = (Map)otherData.get("linkUpBills");
        Map<Object, FileDesc> voucherFileMap = datas.getVoucherOutputData().getBillFileMap();
        Set refBillTypes = (Set)otherData.get("refBillTypes");
        String flag = (String)otherData.get("flag");
        Map voucherInvoiceMap = (Map)otherData.get("voucherInvoiceMap");
        String billName = LogicUtils.getBillName(context.getBillType());
        String xmlstr = "";
        try {
            HashMap<Long, JSONArray> extInvoiceMap = ElecreceiptUtils.findExtInvoiceJson(new ArrayList<Long>(needArchiveIds));
            xmlstr = FPYXmlUtils.createBatchVoucherXml(xmlDesc, billList, attachMap, linkUpBills, voucherFileMap, refBillTypes, flag, voucherInvoiceMap, extInvoiceMap);
        }
        catch (Exception e) {
            logger.error(String.format("\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", context.getBillType(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", (String)"FPYDocumentServerHandler_2", (String)"fi-aef-common", (Object[])new Object[0]), context.getBillType(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        fileUploadItem.setFilebase64(xmlstr);
        fileUploadItem.setBusinessType(1);
        fileUploadItem.setFileName((String)otherData.get("desc"));
        fileUploadItem.setFileMD5(FpyOperateUtil.fileMD5(Base64.getDecoder().decode(xmlstr)));
        fileUploadItem.setFileBytes(Base64.getDecoder().decode(xmlstr));
        fileUploadItem.setBatchCode(context.getBatchcode());
        fileUploadItem.setFileMD5(FpyOperateUtil.fileMD5(Base64.getDecoder().decode(xmlstr)));
        fileUploadItem.setBillidsMap(this.getVoucherBillIdsMap(billList, billName));
        return fileUploadItem;
    }

    private Map<String, String> getVoucherBillIdsMap(List<Bill> billList, String billName) {
        HashMap<String, String> billIdsMap = new HashMap<String, String>(16);
        for (Bill bill : billList) {
            Long id = (Long)bill.getBillId();
            billIdsMap.put(id + "." + "gl_voucher" + id.toString(), billName + bill.getBillNo());
        }
        return billIdsMap;
    }

    private FileUploadItem generateMRptXMLFile(ArchiveContext context, ContextData datas) {
        ReportFormOutputData outputData = datas.getReportFormOutputData();
        Map<String, String> rptGetOrgMap = outputData.getRptGetOrgMap();
        Map<String, String> rptGetNameMap = outputData.getRptGetNameMap();
        Map<String, String> rptUrlMap = outputData.getRptUrlMap();
        FileUploadItem fileUploadItem = outputData.getFileUploadItem();
        String flag = LogicUtils.getFlag(context.getIsReverse());
        String bcmperiodJson = context.getBcmperiodJson();
        Map bcmPeriodMap = (Map)SerializationUtils.deSerializeFromBase64((String)bcmperiodJson);
        String bcmperiodName = (String)bcmPeriodMap.get(outputData.getBcmperiod());
        String uniqueKey = rptUrlMap.keySet().iterator().next();
        String base64 = "";
        String bcmsceneType = context.getBcmsceneType();
        String bcmfyName = context.getBcmfyName();
        int fpyBusinessType = 0;
        Map<Long, String> rptTypeMap = outputData.getRptTypeMap();
        String type = rptTypeMap.getOrDefault(outputData.getBcmperiod(), ".pdf");
        switch (bcmsceneType) {
            case "MRpt": {
                fpyBusinessType = 10;
                base64 = CreateXmlUtil.createMRptXml(rptUrlMap, rptGetNameMap, rptGetOrgMap, flag, bcmfyName, bcmperiodName, type);
                break;
            }
            case "QRpt": {
                fpyBusinessType = 11;
                base64 = CreateXmlUtil.createQRptXml(rptUrlMap, rptGetNameMap, rptGetOrgMap, flag, bcmfyName, bcmperiodName, type);
                break;
            }
            case "ARpt": {
                fpyBusinessType = 12;
                base64 = CreateXmlUtil.createARptXml(rptUrlMap, rptGetNameMap, rptGetOrgMap, flag, bcmfyName, bcmperiodName, type);
                break;
            }
        }
        LogUtil.printLog(logger, ResManager.loadKDString((String)"rptGetOrgMap {} rptGetNameMap {}  rptUrlMap {}", (String)"FPYDocumentServerHandler_8", (String)"fi-aef-common", (Object[])new Object[0]), rptGetOrgMap, rptGetNameMap, rptUrlMap);
        fileUploadItem.setAccountBookNo(rptGetOrgMap.get(uniqueKey).split("_")[1]);
        fileUploadItem.setAccountBookName(rptGetOrgMap.get(uniqueKey).split("_")[0]);
        fileUploadItem.setPeriod(CreateXmlUtil.bulidRptPeriod(bcmfyName, bcmperiodName));
        fileUploadItem.setFilebase64(base64);
        fileUploadItem.setBusinessType(fpyBusinessType);
        fileUploadItem.setBatchCode(context.getBatchcode());
        fileUploadItem.setFileBytes(Base64.getDecoder().decode(base64));
        fileUploadItem.setFileMD5(FpyOperateUtil.fileMD5(Base64.getDecoder().decode(base64)));
        fileUploadItem.setFileName(String.format(ResManager.loadKDString((String)"%1$s\u5408\u5e76\u62a5\u8868%2$s", (String)"FPYDocumentServerHandler_9", (String)"fi-aef-common", (Object[])new Object[0]), uniqueKey + "_" + context.getBatchcode(), ".xml"));
        fileUploadItem.setBillidsMap(this.getMRptBillidsMap(rptUrlMap, rptGetNameMap, rptGetOrgMap, bcmfyName, bcmperiodName));
        return fileUploadItem;
    }

    private Map<String, String> getMRptBillidsMap(Map<String, String> rptUrlMap, Map<String, String> rptGetNameMap, Map<String, String> rptGetOrgMap, String bcmfyName, String bcmperiodName) {
        HashMap<String, String> billidsMap = new HashMap<String, String>(16);
        for (Map.Entry<String, String> rptAllUrlMap : rptUrlMap.entrySet()) {
            String rptAllUrlKey = rptAllUrlMap.getKey();
            String allUrl = rptAllUrlMap.getValue();
            if (StringUtils.isBlank((String)allUrl)) continue;
            String billid = rptAllUrlKey.split("_")[2];
            String voucherorgname = rptGetOrgMap.get(rptAllUrlKey) == null ? "null" : rptGetOrgMap.get(rptAllUrlKey).split("_")[0];
            String reporttype = rptGetNameMap.get(rptAllUrlKey) == null ? "null" : rptGetNameMap.get(rptAllUrlKey);
            billidsMap.put(billid + "." + billid, voucherorgname + bcmfyName + bcmperiodName + reporttype);
        }
        return billidsMap;
    }

    private FileUploadItem generateTaxXMLFile(ArchiveContext context, ContextData data) {
        Map<String, Object> otherData = data.getOtherData();
        FileUploadItem fileUploadItem = data.getTaxBillOutputData().getFileUploadItem();
        List billList = data.getTaxBillOutputData().getBillList();
        Map extMap = (Map)otherData.get("extMap");
        String billName = LogicUtils.getBillName(context.getBillType());
        String xmlstr = "";
        try {
            xmlstr = FPYXmlUtils.createTaxBillXml(billList, data.getTaxBillOutputData().getBillFileMap(), data.getTaxBillOutputData().getAttachMap(), extMap);
        }
        catch (Exception e) {
            logger.error(String.format("\u521b\u5efa%1$s\u7a0e\u52a1\u5355\u636exml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", extMap.get("billname"), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", (String)"FPYDocumentServerHandler_2", (String)"fi-aef-common", (Object[])new Object[0]), extMap.get("billname"), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        String desc = String.format(ResManager.loadKDString((String)"%s\u7a0e\u52a1\u5355\u636e", (String)"FPYDocumentServerHandler_11", (String)"fi-aef-common", (Object[])new Object[0]), extMap.get("orgName") + "_" + fileUploadItem.getPeriod() + "_");
        fileUploadItem.setFilebase64(xmlstr);
        fileUploadItem.setBusinessType(16);
        fileUploadItem.setFileName(desc + context.getBatchcode() + ".xml");
        fileUploadItem.setBatchCode(context.getBatchcode());
        fileUploadItem.setFileBytes(Base64.getDecoder().decode(xmlstr));
        fileUploadItem.setFileMD5(FpyOperateUtil.fileMD5(Base64.getDecoder().decode(xmlstr)));
        fileUploadItem.setBillidsMap(this.getTaxBillidsMap(billList, extMap, billName));
        return fileUploadItem;
    }

    private Map<String, String> getTaxBillidsMap(List<Bill> list, Map<String, Object> extMap, String billName) {
        HashMap<String, String> billidsMap = new HashMap<String, String>(16);
        if ("bill".equals(extMap.get("taxarchivedata"))) {
            Set needArchiveIds = (Set)extMap.get("needArchiveIds");
            for (Bill bill : list) {
                if (needArchiveIds != null && needArchiveIds.size() > 0 && !needArchiveIds.contains(bill.getBillId())) continue;
                billidsMap.put(bill.getBillId() + "." + extMap.get("billtype") + "_" + bill.getBillId(), billName + bill.getBillNo());
            }
        }
        if ("tccit".equals((String)extMap.get("taxarchivedata"))) {
            List declareList = (List)extMap.get("declareList");
            for (Map map : declareList) {
                Long billId = (Long)map.get("id");
                billidsMap.put(billId + "." + extMap.get("billtype") + "_" + billId, billName + (String)map.get("billno"));
            }
        }
        return billidsMap;
    }

    private FileUploadItem generateElecXMLFile(ArchiveContext context, ContextData data) {
        CommonBillOutputData commonBillOutputData = data.getCommonBillOutputData();
        List<Bill> billList = commonBillOutputData.getBillList();
        Map<Object, FileDesc> billFileMap = commonBillOutputData.getBillFileMap();
        Map<Long, String> billFileNameMap = billFileMap.entrySet().stream().collect(Collectors.toMap(entry -> (Long)entry.getKey(), entry -> ((FileDesc)entry.getValue()).getName()));
        Map<Long, List<Attach>> attachMap = commonBillOutputData.getAttachMap();
        FileUploadItem fileUploadItem = commonBillOutputData.getFileUploadItem();
        Map<String, Object> otherData = data.getOtherData();
        String flag = (String)otherData.get("flag");
        String billType = context.getBillType();
        String billName = LogicUtils.getBillName(context.getBillType());
        BillEntityType bet = (BillEntityType)EntityMetadataCache.getDataEntityType((String)billType);
        String dateField = context.getDateField();
        QFilter idFilter = new QFilter("id", "in", billList.stream().map(Bill::getBillId).collect(Collectors.toList()));
        String mainOrg = bet.getMainOrg();
        String billnoField = QueryFinanceBillHelper.getBillNo(billType);
        String selectFileds = "id," + dateField + " datefield," + mainOrg + ".id org," + mainOrg + ".number orgnumber," + mainOrg + ".name orgname," + billnoField + " billno,period, currency.number currency, accountbankname accountname, accountbank.number accountno";
        DataSet set = QueryServiceHelper.queryDataSet((String)"ArchiveOpService.excute", (String)billType, (String)selectFileds, (QFilter[])new QFilter[]{idFilter}, null);
        HashMap<Long, List<DynamicObject>> entryRows = new HashMap<Long, List<DynamicObject>>(16);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)billType, (String)"id, entryentity.e_bookdate accounttime, entryentity.e_balancedirection tradetype, entryentity.e_debitamount debitamount, entryentity.e_creditamount creditamount, entryentity.e_acctamount accountbalance,entryentity.e_oppositeacct oppositeaccount, entryentity.e_oppositeacctname oppositename, entryentity.e_remark abstract, entryentity.e_sourcedocumentno voucherNum, entryentity.e_bookjournal tradeid", (QFilter[])new QFilter[]{idFilter});
        for (DynamicObject dynamicObject : dyns) {
            Long pkId = dynamicObject.getLong("id");
            entryRows.computeIfAbsent(pkId, Value -> new ArrayList()).add(dynamicObject);
        }
        String xmlstr = "";
        try {
            xmlstr = FPYXmlUtils.createElecXml(set, billFileNameMap, billName, attachMap, billType, entryRows, flag);
        }
        catch (Exception e) {
            logger.error(String.format("\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", (String)"FPYDocumentServerHandler_2", (String)"fi-aef-common", (Object[])new Object[0]), billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        String desc = String.format(ResManager.loadKDString((String)"%s\u5355\u636e", (String)"FPYDocumentServerHandler_1", (String)"fi-aef-common", (Object[])new Object[0]), fileUploadItem.getAccountBookName() + fileUploadItem.getPeriod());
        fileUploadItem.setFilebase64(xmlstr);
        fileUploadItem.setBusinessType(20);
        fileUploadItem.setFileName(desc + context.getBatchcode() + ".xml");
        fileUploadItem.setBillidsMap(this.getElecBillidsMap(billList, billName));
        return fileUploadItem;
    }

    private Map<String, String> getElecBillidsMap(List<Bill> billList, String billName) {
        HashMap<String, String> billIdsMap = new HashMap<String, String>(16);
        for (Bill bill : billList) {
            Long id = (Long)bill.getBillId();
            billIdsMap.put(id + "." + id.toString(), billName + bill.getBillNo());
        }
        return billIdsMap;
    }

    @Override
    public OperationResult executeReveral(List<Long> idList, OperationResult result, MainEntityType billEntityType, OperateOption option, ThreadPool threadPoolCash) {
        return FPYUtils.reversalByFPY(idList, result, billEntityType, option, threadPoolCash);
    }
}

