/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.output.impl;

import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.ArchiveContext;
import kd.fi.aef.common.util.ArchiveUtil;
import kd.fi.aef.entity.FileDesc;
import kd.fi.aef.logic.ContextData;
import kd.fi.aef.logic.common.GXFTPUtil;
import kd.fi.aef.logic.common.GXUtils;
import kd.fi.aef.logic.common.GXXmlUtils;
import kd.fi.aef.logic.enums.DescriptType;
import kd.fi.aef.logic.model.FileUploadItem;
import kd.fi.aef.logic.output.IDocumentServerHandler;
import kd.fi.aef.logic.output.Result;

public class GXDocumentServerHandler
implements IDocumentServerHandler {
    private static GXFTPUtil ftpUtil;
    private static final Log logger;

    @Override
    public void initServer() {
        DynamicObject imageConfig = QueryServiceHelper.queryOne((String)"aef_serviceconfig", (String)"id,serviceip,serviceport,username,password,uploadway,requestway", null);
        String message = "";
        if (imageConfig == null) {
            message = ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u5f52\u6863\u670d\u52a1\u5668\u3002", (String)"ArchiveOpService_4", (String)"fi-aef-opplugin", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        String serviceip = imageConfig.getString("serviceip");
        int serviceport = imageConfig.getInt("serviceport");
        ftpUtil = new GXFTPUtil(serviceip, serviceport, imageConfig.getString("username"), imageConfig.getString("password"));
    }

    @Override
    public Result uploadFile(FileUploadItem uploadData) {
        if (ftpUtil == null) {
            ftpUtil = new GXFTPUtil("58.250.250.28", 8052, "ftpuser", "ftppass");
        }
        return GXUtils.upload(ftpUtil, uploadData);
    }

    @Override
    public Result sendNotice(FileUploadItem uploadData) {
        return GXUtils.noticeArchive(ftpUtil, uploadData);
    }

    @Override
    public boolean isXbrlPoint(ArchiveContext context) {
        return context.getIsxbrlpilot();
    }

    @Override
    public boolean isNeedSaveArchivePathRecords() {
        return false;
    }

    @Override
    public boolean isNeedArchiveRef() {
        return false;
    }

    @Override
    public boolean isneedattachfile(String isArchieveAttach) {
        return false;
    }

    @Override
    public FileUploadItem generateDescriptFile(ArchiveContext context, ContextData data, DescriptType descriptType) {
        switch (descriptType) {
            case COMMON_BILL: 
            case VOUCHER: {
                return this.generateVoucherXMLFile(context, data);
            }
        }
        return null;
    }

    private FileUploadItem generateVoucherXMLFile(ArchiveContext context, ContextData data) {
        String select = "id vouchertoken, billno vouchernum, org.id org,org.number branchcode, org.name voucherbr, period.number periodnumber, bookeddate accountdate,attachment documentattachednum, vouchertype.name vouchertype, localcur.number currency, debitlocamount, creditlocamount, vdescription voucherdesc, booktype.number booktypenumber, booktype.name booktypename, creator.name touching, auditor.name approval, posttime posting, sourcetype, sourcesys.number sourcesys, description";
        QFilter needArchiveVoucherFilter = new QFilter("id", "in", context.getNeedArchiveIds());
        DataSet needArchiveset = QueryServiceHelper.queryDataSet((String)"FPYDocumentServerHandler.generateVoucherXMLFile", (String)context.getBillType(), (String)select, (QFilter[])new QFilter[]{needArchiveVoucherFilter}, null);
        DataSet xmlSet = needArchiveset.copy();
        Map<Long, List<Map<String, String>>> voucherentry = ArchiveUtil.getVoucherentry(context.getNeedArchiveIds());
        FileUploadItem fileUploadItem = data.getVoucherOutputData().getFileUploadItem();
        Map<Object, FileDesc> billFileMap = data.getVoucherOutputData().getBillFileMap();
        Map<String, Object> otherData = data.getOtherData();
        otherData.put("billType", context.getBillType());
        byte[] xmlbyte = null;
        try {
            xmlbyte = GXXmlUtils.createBatchVoucherXml(xmlSet, billFileMap, otherData, voucherentry);
        }
        catch (Exception e) {
            logger.error(String.format("\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", context.getBillType(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa%1$s\u7684xml\u63cf\u8ff0\u5931\u8d25{%2$s}\u3002", (String)"FPYDocumentServerHandler_2", (String)"fi-aef-common", (Object[])new Object[0]), context.getBillType(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        fileUploadItem.setFilebase64("");
        fileUploadItem.setBusinessType(1);
        fileUploadItem.setFileName("Info.xml");
        fileUploadItem.setFileMD5("");
        fileUploadItem.setFileBytes(xmlbyte);
        return fileUploadItem;
    }

    @Override
    public OperationResult executeReveral(List<Long> idList, OperationResult result, MainEntityType billEntityType, OperateOption option, ThreadPool threadPoolCash) {
        return GXUtils.deleteImagesByGX(idList, result, billEntityType);
    }

    static {
        logger = LogFactory.getLog(GXDocumentServerHandler.class);
    }
}

