/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.unit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.api.PrintContext;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.cache.CacheHelper;
import kd.fi.aef.cache.CacheModule;
import kd.fi.aef.cache.DistributeCache;
import kd.fi.aef.common.ArchiveContext;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.constant.BillType;
import kd.fi.aef.entity.PrintTemplate;
import kd.fi.aef.helper.ArchiveSchemeHelper;
import kd.fi.aef.logic.AbstractArchiveLogicUnit;
import kd.fi.aef.logic.RowResult;
import kd.fi.aef.logic.common.ArchiveRecordUtils;
import kd.fi.aef.logic.common.ReversalUtils;
import kd.fi.aef.logic.common.SaveArchiveUtils;
import kd.fi.aef.logic.enums.DescriptType;
import kd.fi.aef.logic.model.Attach;
import kd.fi.aef.logic.model.FileUploadItem;

public class ArchiveCasReportLogicUnit
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveCasReportLogicUnit.class);
    private DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.archive);
    private static final String CLASS_NAME = "ArchiveCasReportLogicUnit";
    private String periodNumber;
    private String accountBookNo;
    private String accountBookName;
    private String fileName;
    private String desc;
    private String uniqueKey;

    @Override
    protected List<?> prepareListData() {
        Long periodId = this.context.getPeriodId();
        ArrayList<Long> periodList = new ArrayList<Long>();
        periodList.add(periodId);
        return periodList;
    }

    @Override
    protected RowResult handleEachRowForList(Object periodId) {
        RowResult result = new RowResult();
        long orgId = this.context.getOrgId();
        String billType = this.context.getBillType();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)"number,name");
        String orgName = org.getString("name");
        String orgNumber = org.getString("number");
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period", (String)"number,name");
        this.periodNumber = CreateXmlUtil.dealPeriodNumber(period.getString("number"));
        this.accountBookNo = orgNumber;
        this.accountBookName = orgName;
        this.uniqueKey = orgId + "-" + periodId;
        Long uniqueId = orgId + (Long)periodId;
        this.desc = this.context.getBillType() + "_" + orgNumber + "_" + this.periodNumber;
        this.fileName = this.desc + ".pdf";
        String batchCode = this.context.getBatchcode();
        int businessType = this.getBusinessType(billType);
        Set rptDataFileUrlSet = null;
        HashMap<String, Object> requestCasRptParamMap = new HashMap();
        if ("2".equals(this.context.getIsReverse())) {
            this.fileUploadItem = new FileUploadItem(this.context.getArchivesCode(), this.accountBookNo, this.accountBookName, this.periodNumber, batchCode, businessType, this.fileName, null);
        } else {
            requestCasRptParamMap = this.getRequestCasRptParamMap(periodId);
            rptDataFileUrlSet = (Set)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"JournalRptDataService", (String)"getJournalRptDataFileUrl", (Object[])new Object[]{requestCasRptParamMap});
            logger.info("billName: {}, journalRptDataFileUrl: {}", (Object)this.billName, (Object)rptDataFileUrlSet);
            for (String rptDataFileUrl : rptDataFileUrlSet) {
                try {
                    this.fileUploadItem = this.buildPrintFileUploadItem(this.context.getArchivesCode(), this.accountBookNo, this.accountBookName, this.periodNumber, batchCode, businessType, this.fileName, rptDataFileUrl, null);
                }
                catch (IOException e) {
                    logger.error(String.format("\u6839\u636e rptDataFileUrl %1$s \u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25 {%2$s}\u3002", rptDataFileUrl, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e rptDataFileUrl %1$s \u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25 {%2$s}\u3002", (String)"ArchiveCasReportByFpyLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), rptDataFileUrl, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                }
                this.uploadFile(this.fileUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)rptDataFileUrlSet) || "2".equals(this.context.getIsReverse())) {
            ArrayList<Map<String, String>> xmlList = new ArrayList<Map<String, String>>();
            String billId = this.context.getPeriodId() + "";
            HashMap<String, String> xmlMap = new HashMap<String, String>();
            xmlMap.put("billid", billId);
            xmlMap.put("period", this.periodNumber);
            xmlMap.put("voucherorgname", this.accountBookName);
            xmlMap.put("voucherorgnumber", this.accountBookNo);
            xmlMap.put("file", this.fileName);
            xmlMap.put("subjno", "0");
            xmlMap.put("subj", "0");
            xmlList.add(xmlMap);
            this.contextData.getCasRptOutputData().setXmlInfos(xmlList);
            DynamicObject temp = ArchiveRecordUtils.getGlRptDynamicObject(billType, BillType.getBillTypeDesc(billType), this.context.getApplicationId(), this.context.getSchemeId() + "", requestCasRptParamMap, new Date(), this.context.getUploadWay(), uniqueId, this.userId, "1", null, null, this.uniqueKey, batchCode, this.context.getBooktypeId());
            result.setArchiveObject(temp);
        }
        this.context.setNeedArchiveIds(Collections.singleton(Long.parseLong(periodId.toString())));
        return result;
    }

    private Map<String, Object> getRequestCasRptParamMap(Object periodId) {
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        orgIdList.add(this.context.getOrgId());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("formid", this.context.getBillType());
        paramMap.put("queryorgtype", "org");
        List templateList = SerializationUtils.fromJsonStringToList((String)this.context.getPrintTemplatetag(), PrintTemplate.class);
        String print = ArchiveSchemeHelper.queryPrintId(((PrintTemplate)templateList.get(0)).getTemplateNumber(), ((PrintTemplate)templateList.get(0)).getPrintType());
        paramMap.put("templateId", print);
        paramMap.put("printlang", PrintContext.get().getLang());
        paramMap.put("org", orgIdList);
        paramMap.put("iscontainclosed", Boolean.TRUE);
        paramMap.put("datetype", "1");
        paramMap.put("beginperiod", periodId);
        paramMap.put("endperiod", periodId);
        paramMap.put("radiogroup", "1");
        return paramMap;
    }

    @Override
    protected void saveArchiveRecords(ArchiveContext context) {
        if ("1".equals(context.getIsReverse()) && this.contextData.getCasRptOutputData().getXmlInfos().isEmpty()) {
            String hasarchieveCountKey = context.getPageId() + "hasarchievecount";
            String countString = this.cache.get(hasarchieveCountKey);
            int count = countString == null ? 0 : Integer.parseInt(countString);
            this.cache.put(hasarchieveCountKey, count - 1 + "");
            context.setNeedArchiveIds(new HashSet<Long>());
            return;
        }
        this.contextData.getCasRptOutputData().setFileUploadItem(this.fileUploadItem);
        this.contextData.getCasRptOutputData().setFlag(this.flag);
        this.contextData.getCasRptOutputData().setDesc(this.desc);
        this.fileUploadItem = this.getDocumentServerHandler().generateDescriptFile(context, this.contextData, this.getDescriptType(context.getBillType()));
        if (this.fileUploadItem != null) {
            this.uploadFile(this.fileUploadItem, this.billName, this.getClass().getName(), Boolean.TRUE);
        }
        ArrayList<String> uniqueKeys = new ArrayList<String>(2);
        uniqueKeys.add(this.uniqueKey);
        this.noticeArchive(this.fileUploadItem);
        if ("1".equals(context.getIsReverse())) {
            SaveArchiveUtils.batchSaveReportObjects(CLASS_NAME, this.contextData.getArchiveObjects(), context.getBillType(), this.billName, uniqueKeys);
        } else {
            ReversalUtils.updateRptRecordToReserve(CLASS_NAME, uniqueKeys, context.getBillType(), this.context.getReverseReason(), context.getBatchcode());
        }
    }

    private DescriptType getDescriptType(String billType) {
        DescriptType descriptType;
        switch (billType) {
            case "cas_bankjournalformrpt": {
                descriptType = DescriptType.CAS_BANKJOURNALFORMRPT;
                break;
            }
            case "cas_cashjournalformrpt": {
                descriptType = DescriptType.CAS_CASHJOURNALFORMRPT;
                break;
            }
            default: {
                descriptType = null;
            }
        }
        return descriptType;
    }

    private int getBusinessType(String billType) {
        int i;
        switch (billType) {
            case "cas_bankjournalformrpt": {
                i = 17;
                break;
            }
            case "cas_cashjournalformrpt": {
                i = 18;
                break;
            }
            default: {
                i = 0;
            }
        }
        return i;
    }

    @Override
    protected Map<String, ?> prePareMapData() {
        return null;
    }

    @Override
    protected List<Attach> getAttachments(RowResult result, ArchiveContext context) {
        return null;
    }

    @Override
    protected RowResult handleEachRowForMap(Object key, Object value) {
        return null;
    }
}

