/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.unit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.ArchiveContext;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.entity.FileDesc;
import kd.fi.aef.entity.PrintIdandType;
import kd.fi.aef.logic.AbstractArchiveLogicUnit;
import kd.fi.aef.logic.RowResult;
import kd.fi.aef.logic.common.ArchiveRecordUtils;
import kd.fi.aef.logic.common.LoggerUtils;
import kd.fi.aef.logic.common.ReversalUtils;
import kd.fi.aef.logic.common.SaveArchiveUtils;
import kd.fi.aef.logic.datainput.DataProviderFactory;
import kd.fi.aef.logic.enums.DescriptType;
import kd.fi.aef.logic.model.Attach;
import kd.fi.aef.logic.model.Bill;
import kd.fi.aef.logic.model.FileUploadItem;

public class ArchiveFacardfinLogicUnit
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveFacardfinLogicUnit.class);
    private String desc = null;
    private String xmlFileName = null;

    protected Map<String, Object> prePareMapData() {
        return new HashMap<String, Object>();
    }

    @Override
    protected List<?> prepareListData() {
        List<Bill> list = DataProviderFactory.getCurrentDataProvider().getFacardBillData(this.context);
        this.contextData.getFacardOutputData().setBillList(list);
        this.context.setNeedArchiveIds(new HashSet<Long>(this.context.getIds()));
        return list;
    }

    @Override
    protected RowResult handleEachRowForMap(Object key, Object value) {
        return null;
    }

    @Override
    protected RowResult handleEachRowForList(Object obj) {
        RowResult result = new RowResult();
        if (!(obj instanceof Bill)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5339\u914d\u7684\u8c03\u7528", (String)"ArchiveCommonBillLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]));
        }
        Bill bill = (Bill)obj;
        Object billId = bill.getBillId();
        result.setCurrenKey(billId);
        if (StringUtils.isEmpty((CharSequence)this.desc)) {
            this.desc = String.format(ResManager.loadKDString((String)"%s\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247", (String)"ArchiveFacardfinLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), bill.getOrgName() + bill.getBookName() + bill.getPeriodNumber());
        }
        String accountBookNo = bill.getBookNumber();
        String accountBookName = bill.getBookName();
        String institutionIssuesNo = bill.getInstitutionIssuesNo();
        String institutionIssuesName = bill.getInstitutionIssuesName();
        String period = CreateXmlUtil.dealPeriodNumber(bill.getPeriodNumber());
        if (StringUtils.isEmpty((CharSequence)this.xmlFileName)) {
            this.xmlFileName = this.context.getBillType() + "_" + accountBookNo + "_" + period + "_";
        }
        String fileName = this.context.getBillType() + "_" + billId + ".pdf";
        FileDesc fileDesc = new FileDesc(fileName, null, "pdf", null);
        this.billFileMap.put(billId, fileDesc);
        if ("2".equals(this.context.getIsReverse())) {
            this.fileUploadItem = new FileUploadItem(this.context.getArchivesCode(), accountBookNo, accountBookName, period, this.context.getBatchcode(), 7, fileName, null, institutionIssuesNo, institutionIssuesName);
            return result;
        }
        ArrayList<Object> pks = new ArrayList<Object>(2);
        pks.add(billId);
        String pdfUrl = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)this.printId)) {
                pdfUrl = FileUtils.getPrintUrl(this.context.getPageId(), this.context.getBillType(), this.printId, pks, "billForm", this.context.getPrintType());
            } else if (StringUtils.isNotBlank(this.billIdAndPrintIdMap.get(billId))) {
                PrintIdandType printIdandType = (PrintIdandType)this.billIdAndPrintIdMap.get(billId);
                pdfUrl = FileUtils.getPrintUrl(this.context.getPageId(), this.context.getBillType(), printIdandType.getPrintId(), pks, "billForm", printIdandType.getPrintType());
            } else {
                this.context.getNeedArchiveIds().remove(billId);
                String string = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c%2$s \u627e\u4e0d\u5230\u9002\u7528\u7684\u6253\u5370\u6a21\u677f\u3002", (String)"ArchiveFacardfinLogicUnit_1", (String)"fi-aef-common", (Object[])new Object[0]), this.context.getBillType(), bill.getBillNo());
                this.errDyns.add(LogUtil.generateArchiveErrorLog(this.context.getBillType(), Long.valueOf(billId.toString()), this.context.getSchemeId(), this.context.getIsReverse(), TraceIdUtil.getCurrentTraceIdString(), string));
                logger.error(string);
                result.setNeedHandle(false);
                return result;
            }
            this.fileUploadItem = this.buildPrintFileUploadItem(this.context.getArchivesCode(), accountBookNo, accountBookName, period, this.context.getBatchcode(), 7, fileName, pdfUrl, fileDesc, institutionIssuesNo, institutionIssuesName);
        }
        catch (Exception e) {
            this.context.getNeedArchiveIds().remove(billId);
            String string = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s\uff0c%2$s \u5957\u6253\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u5f02\u5e38 {%3$s}", (String)"ArchiveFacardfinLogicUnit_2", (String)"fi-aef-common", (Object[])new Object[0]), this.context.getBillType(), billId, e);
            this.errDyns.add(LoggerUtils.generateArchiveErrorLog(this.context.getBillType(), billId, this.context.getSchemeId(), this.context.getIsReverse(), TraceIdUtil.getCurrentTraceIdString(), string));
            logger.error(this.billName, (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            result.setNeedHandle(false);
            return result;
        }
        this.fileUploadItem.setBillType(this.context.getBillType());
        this.fileUploadItem.setBillId((Long)billId);
        this.uploadFile(this.fileUploadItem, this.billName, this.getClass().getName(), Boolean.FALSE);
        DynamicObject temp = ArchiveRecordUtils.getArhieveRecordDynamicObject(this.context.getBillType(), this.context.getApplicationId(), this.context.getSchemeId(), bill, this.userId, this.currentDate, this.context.getUploadWay(), "1", null, bill.getDate(), null, this.context.getBatchcode());
        result.setArchiveObject(temp);
        return result;
    }

    @Override
    protected List<Attach> getAttachments(RowResult result, ArchiveContext context) {
        if (this.attachMap == null) {
            this.attachMap = DataProviderFactory.getCurrentDataProvider().getIdAndAttacheFiles(context.getBillType(), context.getIds(), null);
            this.contextData.getCommonBillOutputData().setAttachMap(this.attachMap);
        }
        if (result != null && this.attachMap != null) {
            return (List)this.attachMap.get(result.getCurrenKey());
        }
        return new ArrayList<Attach>();
    }

    @Override
    protected void saveArchiveRecords(ArchiveContext context) {
        if (!this.errDyns.isEmpty()) {
            LogUtil.saveErrorLog(this.errDyns);
        }
        if (context.getNeedArchiveIds().size() == 0) {
            context.setNeedArchiveIds(new HashSet<Long>());
            return;
        }
        this.contextData.getFacardOutputData().setBillFileMap(this.billFileMap);
        this.contextData.getFacardOutputData().setFileUploadItem(this.fileUploadItem);
        this.contextData.getFacardOutputData().setDescription(this.desc);
        this.contextData.getFacardOutputData().setBillName(this.billName);
        this.contextData.getFacardOutputData().setXmlFileName(this.xmlFileName);
        this.fileUploadItem = this.getDocumentServerHandler().generateDescriptFile(context, this.contextData, DescriptType.FA_CARD);
        if (this.fileUploadItem != null) {
            this.uploadFile(this.fileUploadItem, this.billName, this.getClass().getName(), Boolean.TRUE);
        }
        String className = this.getClass().getName();
        this.noticeArchive(this.fileUploadItem);
        if ("1".equals(context.getIsReverse())) {
            SaveArchiveUtils.saveDynamicObjects(className, this.contextData.getArchiveObjects(), this.billName, context.getNeedArchiveIds(), context.getBillType(), "aef_acelre");
            this.saveFilePath();
        } else {
            ReversalUtils.updateRecordToReserve(className, context.getNeedArchiveIds(), context.getBillType(), this.context.getReverseReason(), context.getBatchcode(), "aef_acelre");
        }
    }
}

