/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.unit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.ArchiveContext;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.constant.BillType;
import kd.fi.aef.entity.PrintTemplate;
import kd.fi.aef.helper.ArchiveSchemeHelper;
import kd.fi.aef.helper.ReportPrintUtil;
import kd.fi.aef.logic.AbstractArchiveLogicUnit;
import kd.fi.aef.logic.RowResult;
import kd.fi.aef.logic.common.ArchiveRecordUtils;
import kd.fi.aef.logic.common.ReversalUtils;
import kd.fi.aef.logic.common.SaveArchiveUtils;
import kd.fi.aef.logic.enums.DescriptType;
import kd.fi.aef.logic.model.Attach;
import kd.fi.aef.logic.model.FileUploadItem;

public class ArchiveGeneralledgerLogicUnit
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveGeneralledgerLogicUnit.class);
    private static final String CLASS_NAME = "ArchiveGeneralledgerLogicUnit";
    private String periodNumber;
    private String periodName;
    private String accountBookNo;
    private String accountBookName;
    private String fileName;
    private String desc;
    private String uniqueKey;

    @Override
    protected List<?> prepareListData() {
        Long periodId = this.context.getPeriodId();
        ArrayList<Long> periodList = new ArrayList<Long>();
        periodList.add(periodId);
        this.context.setNeedArchiveIds(Collections.singleton(periodId));
        return periodList;
    }

    @Override
    protected RowResult handleEachRowForList(Object obj) {
        RowResult result = new RowResult();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("org", this.context.getOrgId());
        map.put("startperiod", this.context.getPeriodId());
        map.put("endperiod", this.context.getPeriodId());
        map.put("bookType", this.context.getBooktypeId());
        map.put("currency", "allcurrency");
        String batchCode = this.context.getBatchcode();
        map.put("isAsynQuery", Boolean.FALSE);
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)this.context.getOrgId(), (String)"bos_org", (String)"number,name");
        String orgName = org.getString("name");
        String orgNumber = org.getString("number");
        DynamicObject booktype = BusinessDataServiceHelper.loadSingleFromCache((Object)this.context.getBooktypeId(), (String)"bd_accountbookstype", (String)"number,name");
        String booktypeName = booktype.getString("name");
        String booktypeNumber = booktype.getString("number");
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)this.context.getPeriodId(), (String)"bd_period", (String)"number,name");
        this.periodName = period.getString("name");
        this.periodNumber = this.context.isAws() ? CreateXmlUtil.dealPeriodNumber(period.getString("number")) : CreateXmlUtil.dealAdjustmentPeriodNumber(period.getString("number"));
        this.accountBookNo = orgNumber;
        this.accountBookName = orgName;
        if (this.context.isSplitBook() && this.context.isAws()) {
            this.accountBookNo = this.accountBookNo + booktypeNumber;
            this.accountBookName = this.accountBookName + booktypeName;
        }
        String institutionIssuesNo = "gl_" + booktypeNumber;
        this.uniqueKey = this.context.getOrgId() + "-" + this.context.getBooktypeId() + "-" + this.context.getPeriodId();
        Long uniqueid = this.context.getOrgId() + this.context.getBooktypeId() + this.context.getPeriodId();
        this.desc = this.context.getBillType() + "_" + orgNumber + "_" + booktypeNumber + "_" + this.periodNumber;
        this.fileName = this.desc + ".pdf";
        if ("2".equals(this.context.getIsReverse())) {
            this.fileUploadItem = new FileUploadItem(this.context.getArchivesCode(), this.accountBookNo, this.accountBookName, this.periodNumber, batchCode, 8, this.fileName, null, institutionIssuesNo, booktypeName);
        } else {
            ReportPrintUtil reportUtil = new ReportPrintUtil();
            String pageid = reportUtil.simulateReportSearch(this.context.getBillType(), map);
            String pdfUrl = null;
            if (StringUtils.isNotBlank((CharSequence)this.printId)) {
                pdfUrl = FileUtils.getPrintUrl(pageid, this.context.getBillType(), this.printId, null, "report", this.context.getPrintType());
            } else {
                List templateList = SerializationUtils.fromJsonStringToList((String)this.context.getPrintTemplatetag(), PrintTemplate.class);
                String print = ArchiveSchemeHelper.queryPrintId(((PrintTemplate)templateList.get(0)).getTemplateNumber(), ((PrintTemplate)templateList.get(0)).getPrintType());
                pdfUrl = FileUtils.getPrintUrl(pageid, this.context.getBillType(), print, null, "report", ((PrintTemplate)templateList.get(0)).getPrintType());
            }
            try {
                this.fileUploadItem = this.buildPrintFileUploadItem(this.context.getArchivesCode(), this.accountBookNo, this.accountBookName, this.periodNumber, batchCode, 8, this.fileName, pdfUrl, null, institutionIssuesNo, booktypeName);
                this.fileUploadItem.setBillId(uniqueid);
                this.fileUploadItem.setBillType(this.context.getBillType());
                this.uploadFile(this.fileUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
            }
            catch (IOException e) {
                logger.error(String.format("IOException%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}\u3002", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"IOException%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}\u3002", (String)"ArchiveGeneralledgerLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
        }
        DynamicObject temp = ArchiveRecordUtils.getGlRptDynamicObject(this.context.getBillType(), BillType.getBillTypeDesc(this.context.getBillType()), this.context.getApplicationId(), this.context.getSchemeId() + "", map, new Date(), this.context.getUploadWay(), uniqueid, this.userId, "1", null, null, this.uniqueKey, batchCode, this.context.getBooktypeId());
        result.setArchiveObject(temp);
        return result;
    }

    @Override
    protected void saveArchiveRecords(ArchiveContext context) {
        ArrayList<Map<String, String>> xmlList = new ArrayList<Map<String, String>>();
        String billId = context.getPeriodId() + "";
        HashMap<String, String> xmlMap = new HashMap<String, String>();
        xmlMap.put("billid", billId);
        xmlMap.put("period", this.periodNumber);
        xmlMap.put("periodname", this.periodName);
        xmlMap.put("voucherorgname", this.accountBookName);
        xmlMap.put("voucherorgnumber", this.accountBookNo);
        xmlMap.put("file", this.fileName);
        xmlList.add(xmlMap);
        this.contextData.getGeneralledgerOutputData().setFileUploadItem(this.fileUploadItem);
        this.contextData.getGeneralledgerOutputData().setXmlInfos(xmlList);
        this.contextData.getGeneralledgerOutputData().setFlag(this.flag);
        this.contextData.getGeneralledgerOutputData().setDesc(this.desc);
        this.fileUploadItem = this.getDocumentServerHandler().generateDescriptFile(context, this.contextData, DescriptType.GENERAL_LEDGER);
        if (this.fileUploadItem != null) {
            this.uploadFile(this.fileUploadItem, this.billName, this.getClass().getName(), Boolean.TRUE);
        }
        ArrayList<String> uniqueKeys = new ArrayList<String>(2);
        uniqueKeys.add(this.uniqueKey);
        this.noticeArchive(this.fileUploadItem);
        if ("1".equals(context.getIsReverse())) {
            SaveArchiveUtils.batchSaveReportObjects(CLASS_NAME, this.contextData.getArchiveObjects(), context.getBillType(), this.billName, uniqueKeys);
        } else {
            ReversalUtils.updateRptRecordToReserve(CLASS_NAME, uniqueKeys, context.getBillType(), this.context.getReverseReason(), context.getBatchcode());
        }
    }

    protected Map<String, Object> prePareMapData() {
        return new HashMap<String, Object>();
    }

    @Override
    protected RowResult handleEachRowForMap(Object key, Object value) {
        return null;
    }

    @Override
    protected List<Attach> getAttachments(RowResult result, ArchiveContext context) {
        return null;
    }
}

