/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.unit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.ArchiveContext;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.FileUtils;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.entity.PrintTemplate;
import kd.fi.aef.helper.ArchiveSchemeHelper;
import kd.fi.aef.helper.ReportPrintUtil;
import kd.fi.aef.logic.AbstractArchiveLogicUnit;
import kd.fi.aef.logic.RowResult;
import kd.fi.aef.logic.common.ArchiveRecordUtils;
import kd.fi.aef.logic.common.ReversalUtils;
import kd.fi.aef.logic.common.SaveArchiveUtils;
import kd.fi.aef.logic.enums.DescriptType;
import kd.fi.aef.logic.model.Attach;
import kd.fi.aef.logic.model.FileUploadItem;
import kd.fi.aef.logic.output.model.SubledgerOutputData;

public class ArchiveGeneralledgerLogicUnitNew
extends AbstractArchiveLogicUnit {
    private static final String CLASS_NAME = "ArchiveGeneralledgerLogicUnitNew";
    private static final Log logger = LogFactory.getLog(ArchiveGeneralledgerLogicUnitNew.class);

    @Override
    protected List<?> prepareListData() {
        Set<Long> accountIdList;
        SubledgerOutputData outputData = this.contextData.getSubledgerOutputData();
        Long orgId = this.context.getOrgId();
        Long periodId = this.context.getPeriodId();
        Long booktypeId = this.context.getBooktypeId();
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("org", orgId);
        map.put("startperiod", periodId);
        map.put("endperiod", periodId);
        map.put("bookType", booktypeId);
        map.put("currency", "allcurrency");
        if (StringUtils.isNotEmpty((CharSequence)this.context.getArchiverange())) {
            List list = (List)SerializationUtils.deSerializeFromBase64((String)this.context.getArchiverange());
            accountIdList = list.stream().map(Long::parseLong).collect(Collectors.toSet());
        } else {
            accountIdList = SingleArchiveUtil.getAllFirstLevelAccountId(map);
        }
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bd_accountview", (String)"id,name,number", (QFilter[])new QFilter("id", "in", accountIdList).toArray(), (String)"number");
        accountIdList.clear();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)"number,name");
        String orgName = org.getString("name");
        String orgNumber = org.getString("number");
        DynamicObject booktype = BusinessDataServiceHelper.loadSingleFromCache((Object)booktypeId, (String)"bd_accountbookstype", (String)"number,name");
        String booktypeName = booktype.getString("name");
        String booktypeNumber = booktype.getString("number");
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period", (String)"number,name");
        String periodName = period.getString("name");
        String periodNumber = this.context.isAws() ? CreateXmlUtil.dealPeriodNumber(period.getString("number")) : CreateXmlUtil.dealAdjustmentPeriodNumber(period.getString("number"));
        String accountBookNo = orgNumber;
        String accountBookName = orgName;
        if (this.context.isSplitBook() && this.context.isAws()) {
            accountBookNo = accountBookNo + booktypeNumber;
            accountBookName = accountBookName + booktypeName;
        }
        String institutionIssuesNo = "gl_" + booktypeNumber;
        outputData.setInstitutionIssuesNo(institutionIssuesNo);
        outputData.setInstitutionIssuesName(booktypeName);
        outputData.setPeriodName(periodName);
        outputData.setPeriodNumber(periodNumber);
        outputData.setAccountBookNo(accountBookNo);
        outputData.setAccountBookName(accountBookName);
        for (DynamicObject dyn : dyns) {
            accountIdList.add(dyn.getLong("id"));
            outputData.getAccountIdAndName().put(dyn.getLong("id"), dyn.getString("name"));
            outputData.getAccountIdAndNumber().put(dyn.getLong("id"), dyn.getString("number"));
        }
        logger.info("accountIdList :{}", accountIdList);
        if ("2".equals(this.context.getIsReverse())) {
            this.context.setNeedArchiveIds(new HashSet<Long>(accountIdList));
        } else {
            this.context.setNeedArchiveIds(Collections.singleton(periodId));
        }
        return new ArrayList<Long>(accountIdList);
    }

    @Override
    protected RowResult handleEachRowForList(Object obj) {
        String xmlDesc;
        String xmlFileDesc;
        SubledgerOutputData outputData;
        RowResult result;
        block18: {
            result = new RowResult();
            Long accountId = (Long)obj;
            outputData = this.contextData.getSubledgerOutputData();
            Long orgId = this.context.getOrgId();
            Long periodId = this.context.getPeriodId();
            Long booktypeId = this.context.getBooktypeId();
            String uniqueKey = orgId + "-" + booktypeId + "-" + periodId;
            String billType = this.context.getBillType();
            String batchCode = this.context.getBatchcode();
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org", (String)"number,name");
            String orgName = org.getString("name");
            String orgNumber = org.getString("number");
            DynamicObject booktype = BusinessDataServiceHelper.loadSingleFromCache((Object)booktypeId, (String)"bd_accountbookstype", (String)"number,name");
            String booktypeName = booktype.getString("name");
            String booktypeNumber = booktype.getString("number");
            DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period", (String)"number,name");
            String periodName = period.getString("name");
            String periodNumber = this.context.isAws() ? CreateXmlUtil.dealPeriodNumber(period.getString("number")) : CreateXmlUtil.dealAdjustmentPeriodNumber(period.getString("number"));
            xmlFileDesc = "";
            xmlDesc = "";
            xmlFileDesc = billType + "_" + orgNumber + "_" + booktypeNumber + "_" + periodNumber + "_" + batchCode;
            xmlDesc = String.format(ResManager.loadKDString((String)"%s\u603b\u8d26", (String)"ArchiveGeneralledByFpyLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), orgName + booktypeName + periodName);
            HashMap<String, Object> map = new HashMap<String, Object>(10);
            try (ReportPrintUtil reportUtil = new ReportPrintUtil();){
                map.put("isAsynQuery", Boolean.FALSE);
                map.put("org", orgId);
                map.put("startperiod", periodId);
                map.put("endperiod", periodId);
                map.put("bookType", booktypeId);
                map.put("currency", "allcurrency");
                map.put("account", new Long[]{accountId});
                Long uniqueId = orgId + booktypeId + periodId + accountId;
                String pageId = reportUtil.simulateReportSearch(billType, map);
                logger.info("pageId :{} , account :{}", (Object)pageId, (Object)accountId);
                if (pageId == null) break block18;
                String fileName = billType + "_" + orgNumber + "_" + booktypeNumber + "_" + periodNumber + "_" + outputData.getAccountIdAndNumber().get(accountId) + ".pdf";
                if ("2".equals(this.context.getIsReverse())) {
                    this.fileUploadItem = new FileUploadItem(this.context.getArchivesCode(), outputData.getAccountBookNo(), outputData.getAccountBookName(), periodNumber, batchCode, 8, fileName, null, outputData.getInstitutionIssuesNo(), outputData.getInstitutionIssuesName());
                } else {
                    String pdfUrl = null;
                    if (StringUtils.isNotBlank((CharSequence)this.printId)) {
                        pdfUrl = FileUtils.getPrintUrl(pageId, billType, this.printId, null, "report", this.context.getPrintType());
                    } else {
                        List templateList = SerializationUtils.fromJsonStringToList((String)this.context.getPrintTemplatetag(), PrintTemplate.class);
                        String print = ArchiveSchemeHelper.queryPrintId(((PrintTemplate)templateList.get(0)).getTemplateNumber(), ((PrintTemplate)templateList.get(0)).getPrintType());
                        pdfUrl = FileUtils.getPrintUrl(pageId, billType, print, null, "report", ((PrintTemplate)templateList.get(0)).getPrintType());
                    }
                    try {
                        this.fileUploadItem = this.buildPrintFileUploadItem(this.context.getArchivesCode(), outputData.getAccountBookNo(), outputData.getAccountBookName(), periodNumber, batchCode, 8, fileName, pdfUrl, null, outputData.getInstitutionIssuesNo(), outputData.getInstitutionIssuesName());
                        this.fileUploadItem.setBillId(uniqueId);
                        this.fileUploadItem.setBillType(this.context.getBillType());
                        this.uploadFile(this.fileUploadItem, this.billName, CLASS_NAME, Boolean.FALSE);
                    }
                    catch (IOException e) {
                        logger.error(String.format("IOException%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}\u3002", this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"IOException%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}\u3002", (String)"ArchiveGeneralledgerLogicUnitNew_0", (String)"fi-aef-common", (Object[])new Object[0]), this.billName, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                    }
                }
                HashMap<String, String> xmlInfo = new HashMap<String, String>();
                xmlInfo.put("billid", accountId + "");
                xmlInfo.put("period", periodNumber);
                xmlInfo.put("periodname", periodName);
                xmlInfo.put("voucherorgnumber", outputData.getAccountBookNo());
                xmlInfo.put("voucherorgname", outputData.getAccountBookName());
                xmlInfo.put("subjno", outputData.getAccountIdAndNumber().get(accountId));
                xmlInfo.put("subj", outputData.getAccountIdAndName().get(accountId));
                xmlInfo.put("file", fileName);
                outputData.getXmlInfos().add(xmlInfo);
                String uniqueKey2 = uniqueKey + "-" + accountId;
                DynamicObject temp = ArchiveRecordUtils.getGlRptDynamicObject(billType, outputData.getAccountIdAndNumber().get(accountId), this.context.getApplicationId(), this.context.getSchemeId() + "", map, new Date(), this.context.getUploadWay(), uniqueId, this.userId, "1", null, null, uniqueKey2, batchCode, this.context.getBooktypeId());
                this.contextData.getArchiveObjects().add(temp);
                map.remove("account");
            }
        }
        outputData.setBillName(this.billName);
        outputData.setXmlDesc(xmlDesc);
        outputData.setXmlFileDesc(xmlFileDesc);
        return result;
    }

    @Override
    protected void saveArchiveRecords(ArchiveContext context) {
        SubledgerOutputData outputData = this.contextData.getSubledgerOutputData();
        if (outputData.getXmlInfos().isEmpty()) {
            String hasarchieveCountKey = context.getPageId() + "hasarchievecount";
            String countString = this.cache.get(hasarchieveCountKey);
            int count = countString == null ? 0 : Integer.parseInt(countString);
            this.cache.put(hasarchieveCountKey, count - 1 + "");
            context.setNeedArchiveIds(new HashSet<Long>());
            return;
        }
        outputData.setFileUploadItem(this.fileUploadItem);
        outputData.setFlag(this.flag);
        this.fileUploadItem = this.getDocumentServerHandler().generateDescriptFile(context, this.contextData, DescriptType.SUBSIDIARY_LEDGER);
        if (null != this.fileUploadItem) {
            this.uploadFile(this.fileUploadItem, this.billName, this.getClass().getName(), Boolean.TRUE);
        }
        List<DynamicObject> objects = this.contextData.getArchiveObjects();
        this.noticeArchive(this.fileUploadItem);
        if (!objects.isEmpty()) {
            List<String> uniquekeys = objects.stream().map(t -> t.getString("uniquekey")).collect(Collectors.toList());
            if ("1".equals(context.getIsReverse())) {
                SaveArchiveUtils.batchSaveSubObjects(CLASS_NAME, objects, context.getBillType(), this.billName, uniquekeys);
            } else {
                ReversalUtils.updateRptRecordToReserve(CLASS_NAME, uniquekeys, context.getBillType(), this.context.getReverseReason(), context.getBatchcode());
            }
        }
    }

    protected Map<String, Object> prePareMapData() {
        return new HashMap<String, Object>();
    }

    @Override
    protected RowResult handleEachRowForMap(Object key, Object value) {
        return null;
    }

    @Override
    protected List<Attach> getAttachments(RowResult result, ArchiveContext context) {
        return null;
    }
}

