/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.aef.logic.unit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.util.ExceptionUtils;
import kd.fi.aef.common.ArchiveContext;
import kd.fi.aef.common.util.CreateXmlUtil;
import kd.fi.aef.common.util.LogUtil;
import kd.fi.aef.common.util.RptArchiveUtil;
import kd.fi.aef.common.util.SingleArchiveUtil;
import kd.fi.aef.logic.AbstractArchiveLogicUnit;
import kd.fi.aef.logic.RowResult;
import kd.fi.aef.logic.common.ReversalUtils;
import kd.fi.aef.logic.enums.DescriptType;
import kd.fi.aef.logic.model.Attach;
import kd.fi.aef.logic.model.FileUploadItem;
import kd.fi.aef.logic.output.model.ReportFormOutputData;

public class ArchiveReportFormLogicUnit
extends AbstractArchiveLogicUnit {
    private static final Log logger = LogFactory.getLog(ArchiveReportFormLogicUnit.class);
    private static final String CLASS_NAME = "ArchiveReportFormLogicUnit";

    @Override
    protected List<Attach> getAttachments(RowResult result, ArchiveContext context) {
        return null;
    }

    @Override
    protected RowResult handleEachRowForList(Object obj) {
        return null;
    }

    @Override
    protected List<?> prepareListData() {
        return null;
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    protected Map<String, ?> prePareMapData() {
        ReportFormOutputData outputData = this.contextData.getReportFormOutputData();
        String allCountKey = this.context.getPageId() + "allcount";
        String bcmPeriodJson = this.context.getBcmperiodJson();
        Map bcmPeriodMap = (Map)SerializationUtils.deSerializeFromBase64((String)bcmPeriodJson);
        Set<String> hasArchivedKeys = RptArchiveUtil.getHasArchivedKeys(this.context.getUploadWay(), this.context.getBcmscene(), this.context.getBcmfy(), bcmPeriodMap.keySet());
        Map<String, Map> allRptUrlMap = new HashMap(16);
        HashMap<Long, String> rptTypeMap = new HashMap<Long, String>(16);
        for (Map.Entry periodEntry : bcmPeriodMap.entrySet()) {
            Long bcmPeriod = (Long)periodEntry.getKey();
            this.context.setBcmperiod(bcmPeriod);
            if ("1".equals(this.context.getIsReverse())) {
                Map<String, String> rptUrlMap = SingleArchiveUtil.invokeBcmPrintService(this.context);
                String type = rptUrlMap.containsKey("type_0") ? "." + rptUrlMap.remove("type_0") : ".pdf";
                rptTypeMap.put(bcmPeriod, type);
                for (String hasKey : hasArchivedKeys) {
                    rptUrlMap.remove(hasKey);
                }
                if (!rptUrlMap.isEmpty()) {
                    for (Map.Entry entry : rptUrlMap.entrySet()) {
                        String[] keyArr = ((String)entry.getKey()).split("_");
                        outputData.getRptModelMap().put((String)entry.getKey(), Long.parseLong(keyArr[1]));
                        outputData.getRptOrgMap().put((String)entry.getKey(), Long.parseLong(keyArr[0]));
                        Map tempMap = allRptUrlMap.computeIfAbsent(Long.parseLong(keyArr[0]) + "_" + bcmPeriod, value -> new HashMap());
                        outputData.getAllKeys().add((String)entry.getKey());
                        tempMap.put(entry.getKey(), entry.getValue());
                    }
                    if ("1".equals(this.context.getIsReverse())) {
                        String allCountStr = this.cache.get(allCountKey);
                        int allCount = allCountStr == null ? 0 : Integer.parseInt(allCountStr);
                        this.cache.put(allCountKey, allCount + rptUrlMap.size() + "");
                    }
                }
            } else {
                allRptUrlMap = (Map)SerializationUtils.fromJsonString((String)this.context.getArchiverange(), Map.class);
                allRptUrlMap.forEach((key, rptMap) -> {
                    for (Map.Entry entry : rptMap.entrySet()) {
                        String[] keyArr = ((String)entry.getKey()).split("_");
                        outputData.getRptModelMap().put((String)entry.getKey(), Long.parseLong(keyArr[1]));
                        outputData.getRptOrgMap().put((String)entry.getKey(), Long.parseLong(keyArr[0]));
                        outputData.getAllKeys().add((String)entry.getKey());
                    }
                });
            }
            outputData.setRptGetNameMap(RptArchiveUtil.getRptGetNameMap(outputData.getRptModelMap()));
            outputData.setRptGetOrgMap(RptArchiveUtil.getRptGetOrgMap(outputData.getRptOrgMap()));
            outputData.setRptTypeMap(rptTypeMap);
        }
        return allRptUrlMap;
    }

    @Override
    protected RowResult handleEachRowForMap(Object key, Object obj) {
        RowResult result = new RowResult();
        if (!(obj instanceof Map)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5339\u914d\u7684\u8c03\u7528", (String)"ArchiveCommonBillLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]));
        }
        String hasCountkey = this.context.getPageId() + "hasarchievecount";
        String keyStr = (String)key;
        Map rptUrlMap = (Map)obj;
        Long bcmperiod = Long.valueOf(keyStr.split("_")[1]);
        int fpyBusinessType = 0;
        switch (this.context.getBcmsceneType()) {
            case "MRpt": {
                fpyBusinessType = 10;
                break;
            }
            case "QRpt": {
                fpyBusinessType = 11;
                break;
            }
            case "ARpt": {
                fpyBusinessType = 12;
                break;
            }
        }
        this.context.setBatchcode(UUID.randomUUID().toString());
        this.fileUploadItem = new FileUploadItem(this.context.getArchivesCode(), null, null, null, this.context.getBatchcode(), fpyBusinessType, null, null);
        ReportFormOutputData outputData = this.contextData.getReportFormOutputData();
        outputData.setRptUrlMap(rptUrlMap);
        outputData.setBcmperiod(bcmperiod);
        this.contextData.getReportFormOutputData().setFileUploadItem(this.fileUploadItem);
        outputData.getFileUploadItemList().add(this.fileUploadItem);
        FileUploadItem fileUploadItemDesc = this.getDocumentServerHandler().generateDescriptFile(this.context, this.contextData, DescriptType.REPORT_FORM);
        KDBizException kdBizException = null;
        if (null != fileUploadItemDesc) {
            try {
                this.uploadFile(fileUploadItemDesc, this.billName, this.getClass().getName(), Boolean.TRUE);
            }
            catch (KDBizException e) {
                if ("2".equals(this.context.getIsReverse()) && this.isNotNeedUploadFile) {
                    kdBizException = e;
                }
                throw e;
            }
            this.fileUploadItem = fileUploadItemDesc;
        }
        if (kdBizException != null) {
            outputData.getKdBizExceptions().add(kdBizException);
            outputData.getAllKeys().removeAll(rptUrlMap.keySet());
            return result;
        }
        int count = 0;
        String bcmperiodJson = this.context.getBcmperiodJson();
        Map bcmPeriodMap = (Map)SerializationUtils.deSerializeFromBase64((String)bcmperiodJson);
        String uniqueKey = (String)rptUrlMap.keySet().iterator().next();
        String bcmsceneType = this.context.getBcmsceneType();
        String bcmfyName = this.context.getBcmfyName();
        String type = outputData.getRptTypeMap().getOrDefault(bcmperiod, ".pdf");
        for (Map.Entry entry : rptUrlMap.entrySet()) {
            String keyRpt = (String)entry.getKey();
            String url = (String)entry.getValue();
            logger.info("archivereport {}  url {} ", outputData.getRptGetOrgMap(), (Object)url);
            if (StringUtils.isBlank((CharSequence)url)) continue;
            String[] keyArr = keyRpt.split("_");
            DynamicObject temp = SingleArchiveUtil.getRptArhieveRecordDynamicObject(this.context.getSchemeId() + "", this.userId, new Date(), this.context.getUploadWay(), "1", null, null, keyRpt, this.context.getBcmscene(), this.context.getBcmfy(), bcmperiod, this.context.getBatchcode());
            temp.set("billid", (Object)Long.parseLong(keyArr[2]));
            temp.set("billno", (Object)Long.parseLong(keyArr[2]));
            this.contextData.getArchiveObjects().add(temp);
            if (this.context.getNeedArchiveIds() == null) {
                this.context.setNeedArchiveIds(new HashSet<Long>());
            }
            this.context.getNeedArchiveIds().add(Long.parseLong(keyArr[2]));
            try {
                if ("1".equals(this.context.getIsReverse())) {
                    url = UrlService.getDomainContextUrl() + "/" + url;
                    LogUtil.printLog(logger, ResManager.loadKDString((String)"\u5f00\u59cb\u751f\u6210\u5408\u5e76\u62a5\u8868{}\u7684\u4e3b\u6587\u4ef6......url\u4e3a:{}", (String)"ArchiveReportFormLogicUnit_0", (String)"fi-aef-common", (Object[])new Object[0]), outputData.getRptGetOrgMap().get(key), url);
                    this.fileUploadItem.setAccountBookNo(outputData.getRptGetOrgMap().get(uniqueKey).split("_")[1]);
                    this.fileUploadItem.setAccountBookName(outputData.getRptGetOrgMap().get(uniqueKey).split("_")[0]);
                    this.fileUploadItem.setPeriod(CreateXmlUtil.bulidRptPeriod(bcmfyName, (String)bcmPeriodMap.get(bcmperiod)));
                    this.fileUploadItem.setFileName(keyRpt + type);
                    this.fileUploadItem.setBusinessType(fpyBusinessType);
                    this.fileUploadItem.setBillId(Long.parseLong(keyArr[2]));
                    this.fileUploadItem.setBillType(this.context.getBillType());
                    this.setTempFileRelatedInfo(this.fileUploadItem, url, null);
                    this.uploadFile(this.fileUploadItem, bcmsceneType, CLASS_NAME, Boolean.FALSE);
                }
            }
            catch (IOException e) {
                logger.error(String.format("IOException%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}\u3002", bcmsceneType, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"IOException%1$s\u4e0a\u4f20\u81f3\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25{%2$s}\u3002", (String)"ArchiveReportFormLogicUnit_1", (String)"fi-aef-common", (Object[])new Object[0]), bcmsceneType, ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            }
            ++count;
        }
        if ("1".equals(this.context.getIsReverse())) {
            logger.info("\u83b7\u53d6\u5f52\u6863\u6210\u529f\u7684key\uff1a{}", (Object)hasCountkey);
            this.cache.put(hasCountkey, count + "");
            logger.info("\u83b7\u53d6\u5230\u7684\u5df2\u5f52\u6863\u7684\u6570\u91cf\uff1a{}", (Object)count);
        }
        return result;
    }

    @Override
    protected void saveArchiveRecords(ArchiveContext context) {
        ReportFormOutputData outputData = this.contextData.getReportFormOutputData();
        List<DynamicObject> objects = this.contextData.getArchiveObjects();
        List<KDBizException> kdBizExceptions = outputData.getKdBizExceptions();
        if (objects.isEmpty() && kdBizExceptions.size() == 0) {
            return;
        }
        List<FileUploadItem> fileUploadItemList = outputData.getFileUploadItemList();
        if (fileUploadItemList.size() > 0) {
            logger.info("\u4e00\u5171\uff1a{} \u4e2a\u7ec4\u7ec7\u5f52\u6863\u5408\u5e76\u62a5\u8868", (Object)fileUploadItemList.size());
            for (FileUploadItem uploadItem : fileUploadItemList) {
                this.noticeArchive(uploadItem);
            }
        }
        try {
            if ("1".equals(context.getIsReverse())) {
                RptArchiveUtil.saveRptrecords(CLASS_NAME, objects, outputData.getAllKeys());
                this.saveFilePath();
            } else {
                ReversalUtils.updateRptrecords(CLASS_NAME, objects, outputData.getAllKeys(), this.context.getReverseReason());
            }
        }
        catch (Exception e) {
            logger.error(String.format("\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%s}", ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f52\u6863\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25{%s}", (String)"ArchiveReportFormLogicUnit_2", (String)"fi-aef-common", (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
        }
        ArrayList errorMapList = new ArrayList(16);
        for (KDBizException kdBizException : kdBizExceptions) {
            if (kdBizException.getArgs().length <= 0) continue;
            Object[] errorMaps = kdBizException.getArgs();
            errorMapList.addAll(Arrays.stream(errorMaps).collect(Collectors.toList()));
        }
        if (errorMapList.size() > 0) {
            throw new KDBizException(new ErrorCode("ArchiveReportFormLogicUnit_reverse_fail", ResManager.loadKDString((String)"\u53cd\u5f52\u6863\u5931\u8d25", (String)"ArchiveReportFormLogicUnit_3", (String)"fi-aef-common", (Object[])new Object[0])), errorMapList.toArray(new Object[0]));
        }
    }
}

